#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['pyconfs', 'pyconfs.formats', 'pyconfs.readers', 'pyconfs.writers']

package_data = \
{'': ['*']}

install_requires = \
['pyplugs']

extras_require = \
{":python_version < '3.7'": ['importlib_resources'],
 'dev': ['black',
         'bumpversion',
         'flake8',
         'flit',
         'interrogate',
         'isort',
         'mypy',
         'pre-commit'],
 'doc': ['mkdocs'],
 'test': ['black',
          'flake8',
          'interrogate',
          'isort',
          'mypy',
          'pytest',
          'pytest-cov',
          'tox'],
 'toml': ['toml'],
 'yaml': ['PyYAML']}

setup(name='pyconfs',
      version='0.5.5',
      description='PyConfs, unified handling of configuration files for Python',
      author='Geir Arne Hjelle',
      author_email='geirarne@gmail.com',
      url='https://github.com/gahjelle/pyconfs',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>=3.6',
     )
