# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['dumbpm', 'dumbpm.est', 'dumbpm.guess', 'dumbpm.prio', 'dumbpm.shared']

package_data = \
{'': ['*']}

install_requires = \
['numpy', 'pandas', 'scipy']

entry_points = \
{'console_scripts': ['dumbpm = dumbpm.cmd:main']}

setup_kwargs = {
    'name': 'dumbpm',
    'version': '0.7.0',
    'description': 'A pretty dumb PM.',
    'long_description': '# dumbpm\n\n[![PyPI version](https://badge.fury.io/py/dumbpm.svg)](https://badge.fury.io/py/dumbpm)\n[![Continuous Integration](https://github.com/poros/dumbpm/workflows/Continuous%20Integration/badge.svg)](https://github.com/poros/dumbpm/actions)\n[![License](https://img.shields.io/badge/License-Apache%202.0-blue.svg)](https://opensource.org/licenses/Apache-2.0)\n\n* [Installation](#installation)\n* [Prioritize projects](#prioritize-projects)\n  + [Projects format](#projects-format)\n  + [Example](#example)\n* [Estimate project duration](#estimate-project-duration)\n  + [Input format](#input-format)\n  + [Example](#example-1)\n\nA pretty dumb PM.\n\nAt the moment it only does projects prioritization: it is pretty dumb, indeed.\n\nThe whole philosophy behind `dumbpm` is that PMs (project managers, program managers,product managers, people managers, pokemon masters, etc.) all do some tasks that could use some automation, but at the same time this automation should be as dumb as possible. There are so many changing factors that influence such tasks that you better hire a PM (or a team of researchers to do the automation) to do the clever stuff, not a random software on the internet. In addition, if we keep it dumb, people can just read the code and understand what is going on, if they really want to.\n\nIf you have any suggestions for something (but nothing clever!) that you would like `dumbpm` to do for you, open an issue and let me know.\n\n## Installation\n\n```\npip install dumbpm\n```\n\nTested on both Linux and Mac OS. Windows _might_ work.\n\n## Prioritize projects\n\nGiving a table of projects defined as below, it outputs a list of projects in order of priority within the optionally specified budget (prioritization as "data problem").\n\nThe prioritized list is modelled as the exact solution of a [Knapsack Problem](https://en.wikipedia.org/wiki/Knapsack_problem) with the following value function: `norm(norm(value) / (norm(cost) + norm(duration) + norm(risk))) + norm(rigging)`. Pretty dumb, indeed.\n\nIf `--budget` isn\'t specified, the list will simply be sorted by the result of the above value function. Budget is relative to the `cost` parameter.\n\nIf you are expressing `cost` as cost per unit of duration (e.g. developers per week or sprint), you\'ll have to specify the `--cost-per-duration` option, so that `total cost = cost * duration` and `budget` is measured against `total cost` (`duration` will also disappear from the value function not to count it twice).\n\n```bash\n$ dumbpm prioritize --help\nusage: dumbpm prioritize [-h] [--budget [BUDGET]] filename\n\npositional arguments:\n  filename           CSV file with projects definition\n\noptional arguments:\n  -h, --help         show this help message and exit\n  --budget [BUDGET]  Max budget allowed\n  --cost-per-duration  Cost is to be assumed per unit of duration. Budget =\n                       (cost * duration)\n```\n\n### Projects format\n\nProject definition happens in a CSV file with the following structure:\n\n- `Project`: [required] name of the project\n- `Value`: [required] value of the project\n- `Cost`: [required] cost of the project\n- `Duration`: [optional] duration of the project expressed in unit of times\n- `Risk`: [optional] risk of failure of the project\n- `Rigging`: [optional, empty field = 0] arbitrary value used to rig the result (yay, cheating!); the highest the more likely the project to be prioritized (keep in mind that this counts for half of the score of a project)\n- `Alternatives`: [optional, empty field = empty list] comma separated list of projects that are incompatible with this one (e.g. make lunch vs buy lunch)\n\nThere is a bit of slack on the headers of the columns (e.g. `Project`, `Projects`, `project`, etc. are all alright). Notable mentions: `rig` and `rigging` both work; same for `alts` and `alternatives`; `PQ` can be used instead of `cost` if that\'s your thing.\n\n\n| Project                                             | Value | Cost | Duration | Risk | Rigging | Alternatives                                |\n|-----------------------------------------------------|-------|------|----------|------|---------|---------------------------------------------|\n| Buy a better espresso machine                       | 5     | 4    | 2        |1     | 9       |                                             |\n| Buy ambient parfume for the back                    | 1     | 1    | 1        |1     |         |                                             |\n| Find and remove source of bad smell                 | 5     | 2    | 4        |4     | 10      |                                             |\n| Find better coffee vendors                          | 4     | 2    | 6        |3     | 5       |                                             |\n| Buy smart component for roaster                     | 3     | 5    | 2        |3     |         | Build in-house roasting notification system |\n| Introduce a periodical suggestion survey for treats | 3     | 2    | 6        |1     |         |                                             |\n| Buy a more modern sign                              | 3     | 3    | 1        |1     |         |                                             |\n| Contact a designer to re-think the front            | 5     | 5    | 6        |3     |         |                                             |\n| Buy beds for powernaps                              | 1     | 3    | 1        |1     |         |                                             |\n| Import treats from France                           | 2     | 4    | 2        |2     |         |                                             |\n| Build in-house roasting notification system         | 3     | 5    | 6        |5     |         | Buy smart component for roaster             |\n\n\n### Example\n\n```text\n$ cat projects.csv\nProject,Value,Cost,Duration,Rigging,Alternatives\nBuy a better espresso machine,5,4,2,9,\nBuy ambient parfume for the back,1,1,1,,\nFind and remove source of bad smell,5,2,4,10,\nFind better coffee vendors,4,2,6,5,\nBuy smart component for roaster,3,5,2,,Build in-house roasting notification system\nIntroduce a periodical suggestion survey for treats,3,2,6,,\nBuy a more modern sign,3,3,1,,\nContact a designer to re-think the front,5,5,6,,\nBuy beds for powernaps,1,3,1,,\nImport treats from France,2,4,2,,\nBuild in-house roasting notification system,3,5,6,,Buy smart component for roaster\n\n$ dumbpm prioritize projects.csv\n01 Buy ambient parfume for the back\n02 Buy a more modern sign\n03 Find and remove source of bad smell\n04 Buy a better espresso machine\n05 Find better coffee vendors\n06 Buy beds for powernaps\n07 Buy smart component for roaster\n08 Import treats from France\n09 Introduce a periodical suggestion survey for treats\n10 Contact a designer to re-think the front\n\n$ dumbpm prioritize projects.csv --budget 10\n01 Buy ambient parfume for the back\n02 Buy a more modern sign\n03 Find and remove source of bad smell\n04 Buy a better espresso machine\n```\n\n## Estimate project duration without historical data\n\nGiving a list of tasks or milestones the project can be broken into and (best case, expected, worst case) estimates for the duration of such tasks, it outputs an estimate of the project duration in the form of a probability distribution (median, variance, percentiles). You can use these numbers to formulate guesstimates like "I am 75% confident that we will complete the project in 38 weeks". Instead of using a unit of time (e.g. days, weeks), you can instead specify story points for each tasks and so estimate the project size in story point instead of its duration.\n\nThe estimation is based on a [Monte Carlo simulation](https://en.wikipedia.org/wiki/Monte_Carlo_method) of the following equation: `project_duration = sum(duration, over=tasks)`. Tasks duration for each iteration are derived from a [modified-PERT distribution](https://en.wikipedia.org/wiki/PERT_distribution) interpolating the (best case, expected, worst case) estimates for the task. Pretty dumb, indeed.\n\nThe command is called `guesstimate` to highlight that the result of this method should be considered with lower confidence than the one produced by the `estimate` command, which is based on historical data. You can switch to `estimate` after you conclude a few sprints, while relying on `guesstimate` for the initial estimates during the planning period.\n\nIf it is taking too long to perform the estimation on your computer, set `--simulations` to something lower than `100000`.\n\n```bash\n$ dumbpm guesstimate --help\nusage: dumbpm guesstimate [-h] [--simulations [SIMULATIONS]] filename\n\npositional arguments:\n  filename              CSV file with tasks estimates\n\noptional arguments:\n  -h, --help            show this help message and exit\n  --simulations [SIMULATIONS]\n                        Number of simulations to run\n```\n\n### Input format\n\nEstimates for tasks or milestones have to be defined in a CSV file with the following structure:\n\n- `Task`: [required] name of the task (`Milestone` works as header, too)\n- `Best`: [required] best case estimate for the task duration\n- `Expected`: [required] most likely estimate for the task duration\n- `Worst`: [required] worst case estimate for the task duration\n\n\n| Task   | Best | Expected | Worst |\n|--------|------|----------|-------|\n| Task A | 5    | 10       | 20    |\n| Task B | 6    | 12       | 40    |\n| Task C | 1    | 13       | 24    |\n| Task D | 10   | 13       | 15    |\n| Task E | 5    | 7        | 12    |\n| Task F | 12   | 25       | 34    |\n\n### Example\n\n```text\n$ cat tasks.csv\nTask,Best,Expected,Worst\nTask A,5,10,20\nTask B,6,12,40\nTask C,1,13,24\nTask D,10,13,15\nTask E,5,7,12\nTask F,12,25,34\n\n$ dumbpm guesstimate tasks.csv\n            Duration\ncount  100000.000000\nmean        7.761430\nstd         0.993793\nmin         5.000000\n50%         8.000000\n5%         8.000000\n90%         9.000000\n99%        10.000000\nmax        12.000000\n```\n\n## Estimate project duration based on historical data\n\nGiving a list of past sprint velocities and (optionally) a list of scope changes for the project in story points defined as below, it outputs an estimate of the project duration in the form of a probability distribution (median, variance, percentiles). You can use these numbers to formulate guesstimates like "I am 75% confident that we will complete the project in 38 weeks".\n\nPlease note that the estimate is measured in sprints, so you\'ll have to multiply that for the duration of your sprint and project that on your working calendar to account for holidays and anything else which could affect your schedule.\n\nThe estimation is based on a [Monte Carlo simulation](https://en.wikipedia.org/wiki/Monte_Carlo_method) of the following inequation: `scope + sum(scope_change, over=sprints) <= sum(velocity, over=sprints)`. Pretty dumb, indeed.\n\nBy default, velocity and scope change for each iteration are picked at random following a [uniform probability distribution](https://en.wikipedia.org/wiki/Discrete_uniform_distribution) from the provided historical data. If `--normal` is specified, the input will be modelled as [normal distribution](https://en.wikipedia.org/wiki/Normal_distribution) from which velocity and scope changes will be derived.\n\nIf it is taking too long to perform the estimation on your computer, set `--simulations` to something lower than `100000`.\n\n```bash\n$ dumbpm estimate --help\nusage: dumbpm estimate [-h] [--normal] [--simulations [SIMULATIONS]] filename scope\n\npositional arguments:\n  filename              CSV file with velocity and scope change datapoints\n  scope                 Remaining scope in story points for the project\n\noptional arguments:\n  -h, --help            show this help message and exit\n  --normal              Use a normal distribution for the input data\n  --simulations [SIMULATIONS]\n                        Number of simulations to run\n```\n\n### Input format\n\nHistorical data has to be defined in a CSV file with the following structure:\n\n- `Velocity`: [required] velocity for each past sprint\n- `Change`: [optional] project scope change for each past sprint (zero and negative values are allowed)\n\n\n| Velocity | Change |\n|----------|--------|\n| 17       | 5      |\n| 19       | 1      |\n| 10       | 0      |\n| 12       | 0      |\n| 21       | 1      |\n|  7       | -3     |\n| 15       | -2     |\n| 12       | 5      |\n| 12       | 0      |\n| 14       | 2      |\n| 18       | -4     |\n\n\n### Example\n\n```text\n$ cat sprints.csv\nVelocity,Change\n17,5\n19,1\n10,0\n12,0\n21,1\n7,-3\n15,-2\n12,5\n12,0\n14,2\n18,-4\n\n$ dumbpm estimate sprints.csv 100\n            Duration\ncount  100000.000000\nmean        7.761430\nstd         0.993793\nmin         5.000000\n50%         8.000000\n75%         8.000000\n90%         9.000000\n99%        10.000000\nmax        12.000000\n\n$ dumbpm prioritize projects.csv 100 --normal\n           Duration\ncount  100000.00000\nmean        7.75637\nstd         0.99810\nmin         4.00000\n50%         8.00000\n75%         8.00000\n90%         9.00000\n99%        10.00000\nmax        13.00000\n```\n',
    'author': 'Antonio Uccio Verardi',
    'author_email': 'antonio.uccio.verardi@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/poros/dumbpm',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
