import talib._ta_lib as ta
import numpy as np


class Kdj:

    @staticmethod
    def generate(np_high_array, np_low_array, np_close_array, n, m1, m2):

        _np_kdj_array = ta.STOCH(np_high_array,
                                 np_low_array,
                                 np_close_array,
                                 fastk_period=n,
                                 slowk_period=2 * m1 - 1,
                                 slowk_matype=1,
                                 slowd_period=2 * m2 - 1,
                                 slowd_matype=1)

        _result = []

        for _index in range(0, len(np_close_array)):

            _k = _np_kdj_array[0][_index]
            _d = _np_kdj_array[1][_index]

            if np.isnan(_k) or np.isnan(_d):
                _result.append(None)
            else:
                _j = 3 * _k - 2 * _d
                _result.append({"k": _k, "d": _d, "j": _j})

        return _result
