/* automatically generated by rust-bindgen */
#![allow(unknown_lints)]
#![allow(clippy::all)]
use libc::{self, FILE};

pub const CRFSUITE_VERSION: &'static [u8; 7usize] = b"0.12.2\0";
pub const CRFSUITE_COPYRIGHT: &'static [u8; 39usize] = b"Copyright (c) 2007-2013 Naoaki Okazaki\0";

/// Type of a float value.
pub type floatval_t = f64;

pub const CRFSUITE_SUCCESS: _bindgen_ty_1 = 0;
pub const CRFSUITEERR_UNKNOWN: _bindgen_ty_1 = -2147483648;
pub const CRFSUITEERR_OUTOFMEMORY: _bindgen_ty_1 = -2147483647;
pub const CRFSUITEERR_NOTSUPPORTED: _bindgen_ty_1 = -2147483646;
pub const CRFSUITEERR_INCOMPATIBLE: _bindgen_ty_1 = -2147483645;
pub const CRFSUITEERR_INTERNAL_LOGIC: _bindgen_ty_1 = -2147483644;
pub const CRFSUITEERR_OVERFLOW: _bindgen_ty_1 = -2147483643;
pub const CRFSUITEERR_NOTIMPLEMENTED: _bindgen_ty_1 = -2147483642;
pub type _bindgen_ty_1 = libc::c_int;

/// CRFSuite model interface.
pub type crfsuite_model_t = tag_crfsuite_model;
/// CRFSuite trainer interface.
pub type crfsuite_trainer_t = tag_crfsuite_trainer;
/// CRFSuite tagger interface.
pub type crfsuite_tagger_t = tag_crfsuite_tagger;
/// CRFSuite dictionary interface.
pub type crfsuite_dictionary_t = tag_crfsuite_dictionary;
/// CRFSuite parameter interface.
pub type crfsuite_params_t = tag_crfsuite_params;
/// An attribute.
/// An attribute consists of an attribute id with its value.
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct crfsuite_attribute_t {
    /// < Attribute id.
    pub aid: libc::c_int,
    /// < Value of the attribute.
    pub value: floatval_t,
}
/// An item.
/// An item consists of an array of attributes.
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct crfsuite_item_t {
    /// Number of contents associated with the item.
    pub num_contents: libc::c_int,
    /// Maximum number of contents (internal use).
    pub cap_contents: libc::c_int,
    /// Array of the attributes.
    pub contents: *mut crfsuite_attribute_t,
}
/// An instance (sequence of items and labels).
/// An instance consists of a sequence of items and labels.
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct crfsuite_instance_t {
    /// Number of items/labels in the sequence.
    pub num_items: libc::c_int,
    /// Maximum number of items/labels (internal use).
    pub cap_items: libc::c_int,
    /// Array of the item sequence.
    pub items: *mut crfsuite_item_t,
    /// Array of the label sequence.
    pub labels: *mut libc::c_int,
    /// Instance weight.
    pub weight: floatval_t,
    /// Group ID of the instance.
    pub group: libc::c_int,
}
/// A data set.
/// A data set consists of an array of instances and dictionary objects
/// for attributes and labels.
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct crfsuite_data_t {
    /// Number of instances.
    pub num_instances: libc::c_int,
    /// Maximum number of instances (internal use).
    pub cap_instances: libc::c_int,
    /// Array of instances.
    pub instances: *mut crfsuite_instance_t,
    /// Dictionary object for attributes.
    pub attrs: *mut crfsuite_dictionary_t,
    /// Dictionary object for labels.
    pub labels: *mut crfsuite_dictionary_t,
}
/// Label-wise performance values.
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct crfsuite_label_evaluation_t {
    /// Number of correct predictions.
    pub num_correct: libc::c_int,
    /// Number of occurrences of the label in the gold-standard data.
    pub num_observation: libc::c_int,
    /// Number of predictions.
    pub num_model: libc::c_int,
    /// Precision.
    pub precision: floatval_t,
    /// Recall.
    pub recall: floatval_t,
    /// F1 score.
    pub fmeasure: floatval_t,
}
/// An overall performance values.
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct crfsuite_evaluation_t {
    /// Number of labels.
    pub num_labels: libc::c_int,
    /// Array of label-wise evaluations.
    pub tbl: *mut crfsuite_label_evaluation_t,
    /// Number of correctly predicted items.
    pub item_total_correct: libc::c_int,
    /// Total number of items.
    pub item_total_num: libc::c_int,
    /// Total number of occurrences of labels in the gold-standard data.
    pub item_total_observation: libc::c_int,
    /// Total number of predictions.
    pub item_total_model: libc::c_int,
    /// Item-level accuracy.
    pub item_accuracy: floatval_t,
    /// Number of correctly predicted instances.
    pub inst_total_correct: libc::c_int,
    /// Total number of instances.
    pub inst_total_num: libc::c_int,
    /// Instance-level accuracy.
    pub inst_accuracy: floatval_t,
    /// Macro-averaged precision.
    pub macro_precision: floatval_t,
    /// Macro-averaged recall.
    pub macro_recall: floatval_t,
    /// Macro-averaged F1 score.
    pub macro_fmeasure: floatval_t,
}
/// Type of callback function for logging.
///
/// * `user`        Pointer to the user-defined data.
/// * `format`      Format string (compatible with prinf()).
/// * `args`        Optional arguments for the format string.
///
/// Returns int         \c 0 to continue; non-zero to cancel the training.
pub type crfsuite_logging_callback = ::std::option::Option<
    unsafe extern "C" fn(
        user: *mut libc::c_void,
        format: *const libc::c_char,
        args: *mut __va_list_tag,
    ) -> libc::c_int,
>;

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tag_crfsuite_model {
    /// Pointer to the internal data (internal use only).
    pub internal: *mut libc::c_void,
    /// Reference counter (internal use only).
    pub nref: libc::c_int,
    /// Increment the reference counter.
    ///
    /// `model`       The pointer to this model instance.
    ///
    /// Returns the reference count after this increment.
    pub addref:
        ::std::option::Option<unsafe extern "C" fn(model: *mut crfsuite_model_t) -> libc::c_int>,
    /// Decrement the reference counter.
    ///
    /// `model`       The pointer to this model instance.
    ///
    /// Returns the reference count after this operation.
    pub release:
        ::std::option::Option<unsafe extern "C" fn(model: *mut crfsuite_model_t) -> libc::c_int>,
    /// Obtain the pointer to crfsuite_tagger_t interface.
    ///
    /// * `model`       The pointer to this model instance.
    /// * `ptr_tagger`  The pointer that receives a `crfsuite_tagger_t` pointer.
    ///
    /// Returns the status code.
    pub get_tagger: ::std::option::Option<
        unsafe extern "C" fn(
            model: *mut crfsuite_model_t,
            ptr_tagger: *mut *mut crfsuite_tagger_t,
        ) -> libc::c_int,
    >,
    /// Obtain the pointer to crfsuite_dictionary_t interface for labels.
    ///
    /// * `model`       The pointer to this model instance.
    /// * `ptr_labels`  The pointer that receives a crfsuite_dictionary_t pointer.
    ///
    /// Returns the status code.
    pub get_labels: ::std::option::Option<
        unsafe extern "C" fn(
            model: *mut crfsuite_model_t,
            ptr_labels: *mut *mut crfsuite_dictionary_t,
        ) -> libc::c_int,
    >,
    /// Obtain the pointer to crfsuite_dictionary_t interface for attributes.
    ///
    /// * `model`       The pointer to this model instance.
    /// * `ptr_attrs`   The pointer that receives a crfsuite_dictionary_t pointer.
    ///
    /// Returns the status code.
    pub get_attrs: ::std::option::Option<
        unsafe extern "C" fn(
            model: *mut crfsuite_model_t,
            ptr_attrs: *mut *mut crfsuite_dictionary_t,
        ) -> libc::c_int,
    >,
    /// Print the model in human-readable format.
    ///
    /// * `model`       The pointer to this model instance.
    /// * `fpo`         The FILE* pointer.
    ///
    /// Returns the status code.
    pub dump: ::std::option::Option<
        unsafe extern "C" fn(model: *mut crfsuite_model_t, fpo: *mut FILE) -> libc::c_int,
    >,
}
/// CRFSuite trainer interface.
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tag_crfsuite_trainer {
    /// Pointer to the internal data (internal use only).
    pub internal: *mut libc::c_void,
    /// Reference counter (internal use only).
    pub nref: libc::c_int,
    /// Increment the reference counter.
    ///
    /// `trainer`     The pointer to this trainer instance.
    ///
    /// Returns the reference count after this increment.
    pub addref: ::std::option::Option<
        unsafe extern "C" fn(trainer: *mut crfsuite_trainer_t) -> libc::c_int,
    >,
    /// Decrement the reference counter.
    ///
    /// `trainer`     The pointer to this trainer instance.
    ///
    /// Returns the reference count after this operation.
    pub release: ::std::option::Option<
        unsafe extern "C" fn(trainer: *mut crfsuite_trainer_t) -> libc::c_int,
    >,
    /// Obtain the pointer to crfsuite_params_t interface.
    ///
    /// `trainer`     The pointer to this trainer instance.
    ///
    /// Returns crfsuite_params_t*  The pointer to crfsuite_params_t.
    pub params: ::std::option::Option<
        unsafe extern "C" fn(trainer: *mut crfsuite_trainer_t) -> *mut crfsuite_params_t,
    >,
    /// Set the callback function and user-defined data.
    ///
    /// * `trainer`     The pointer to this trainer instance.
    /// * `user`        The pointer to the user-defined data.
    /// * `cbm`         The pointer to the callback function.
    pub set_message_callback: ::std::option::Option<
        unsafe extern "C" fn(
            trainer: *mut crfsuite_trainer_t,
            user: *mut libc::c_void,
            cbm: crfsuite_logging_callback,
        ),
    >,
    /// Start a training process.
    ///
    /// * `trainer`     The pointer to this trainer instance.
    /// * `data`       The poiinter to the data set.
    /// * `filename`    The filename to which the trainer stores the model.
    /// If an empty string is specified, this function
    /// does not sture the model to a file.
    /// * `holdout`     The holdout group.
    ///
    /// Returns the status code.
    pub train: ::std::option::Option<
        unsafe extern "C" fn(
            trainer: *mut crfsuite_trainer_t,
            data: *const crfsuite_data_t,
            filename: *const libc::c_char,
            holdout: libc::c_int,
        ) -> libc::c_int,
    >,
}
/// CRFSuite tagger interface.
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tag_crfsuite_tagger {
    /// Pointer to the internal data (internal use only).
    pub internal: *mut libc::c_void,
    /// Reference counter (internal use only).
    pub nref: libc::c_int,
    /// Increment the reference counter.
    ///
    /// `tagger`      The pointer to this tagger instance.
    ///
    /// Returns the reference count after this increment.
    pub addref:
        ::std::option::Option<unsafe extern "C" fn(tagger: *mut crfsuite_tagger_t) -> libc::c_int>,
    /// Decrement the reference counter.
    ///
    /// `tagger`      The pointer to this tagger instance.
    ///
    /// Returns the reference count after this operation.
    pub release:
        ::std::option::Option<unsafe extern "C" fn(tagger: *mut crfsuite_tagger_t) -> libc::c_int>,
    /// Set an instance to the tagger.
    ///
    /// * `tagger`      The pointer to this tagger instance.
    /// * `inst`        The item sequence to be tagged.
    ///
    /// Returns the status code.
    pub set: ::std::option::Option<
        unsafe extern "C" fn(
            tagger: *mut crfsuite_tagger_t,
            inst: *mut crfsuite_instance_t,
        ) -> libc::c_int,
    >,
    /// Obtain the number of items in the current instance.
    ///
    /// `tagger`      The pointer to this tagger instance.
    ///
    /// Returns the number of items of the instance set by
    /// set() function.
    ///
    /// Returns the status code.
    pub length:
        ::std::option::Option<unsafe extern "C" fn(tagger: *mut crfsuite_tagger_t) -> libc::c_int>,
    /// Find the Viterbi label sequence.
    ///
    /// * `tagger`      The pointer to this tagger instance.
    /// * `labels`      The label array that receives the Viterbi label
    /// * `sequence` The number of elements in the array must
    //  be no smaller than the number of item.
    /// * `ptr_score`   The pointer to a float variable that receives the
    /// score of the Viterbi label sequence.
    ///
    /// Returns the status code.
    pub viterbi: ::std::option::Option<
        unsafe extern "C" fn(
            tagger: *mut crfsuite_tagger_t,
            labels: *mut libc::c_int,
            ptr_score: *mut floatval_t,
        ) -> libc::c_int,
    >,
    /// Compute the score of a label sequence.
    ///
    /// * `tagger`      The pointer to this tagger instance.
    /// * `path`        The label sequence.
    /// * `ptr_score`   The pointer to a float variable that receives the
    /// score of the label sequence.
    ///
    /// Returns the status code.
    pub score: ::std::option::Option<
        unsafe extern "C" fn(
            tagger: *mut crfsuite_tagger_t,
            path: *mut libc::c_int,
            ptr_score: *mut floatval_t,
        ) -> libc::c_int,
    >,
    /// Compute the log of the partition factor (normalization constant).
    ///
    /// * `tagger`      The pointer to this tagger instance.
    /// * `ptr_score`   The pointer to a float variable that receives the
    /// logarithm of the partition factor.
    ///
    /// Returns the status code.
    pub lognorm: ::std::option::Option<
        unsafe extern "C" fn(
            tagger: *mut crfsuite_tagger_t,
            ptr_norm: *mut floatval_t,
        ) -> libc::c_int,
    >,
    /// Compute the marginal probability of a label at a position.
    ///
    /// This function computes P(y_t = l | x), the probability when
    /// y_t is the label (l).
    ///
    /// * `tagger`      The pointer to this tagger instance.
    /// * `l`           The label.
    /// * `t`           The position.
    /// * `ptr_prob`    The pointer to a float variable that receives the
    /// marginal probability.
    ///
    /// Returns the status code.
    pub marginal_point: ::std::option::Option<
        unsafe extern "C" fn(
            tagger: *mut crfsuite_tagger_t,
            l: libc::c_int,
            t: libc::c_int,
            ptr_prob: *mut floatval_t,
        ) -> libc::c_int,
    >,
    /// Compute the marginal probability of a partial label sequence.
    ///
    /// * `tagger`      The pointer to this tagger instance.
    /// * `path`        The partial label sequence.
    /// * `begin`       The start position of the partial label sequence.
    /// * `end`         The last+1 position of the partial label sequence.
    /// * `ptr_prob`    The pointer to a float variable that receives the
    /// marginal probability.
    ///
    /// Returns the status code.
    pub marginal_path: ::std::option::Option<
        unsafe extern "C" fn(
            tagger: *mut crfsuite_tagger_t,
            path: *const libc::c_int,
            begin: libc::c_int,
            end: libc::c_int,
            ptr_prob: *mut floatval_t,
        ) -> libc::c_int,
    >,
}
/// CRFSuite dictionary interface.
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tag_crfsuite_dictionary {
    /// Pointer to the internal data (internal use only).
    pub internal: *mut libc::c_void,
    /// Reference counter (internal use only).
    pub nref: libc::c_int,
    /// Increment the reference counter.
    ///
    /// `dic`         The pointer to this dictionary instance.
    ///
    /// Returns the reference count after this increment.
    pub addref:
        ::std::option::Option<unsafe extern "C" fn(dic: *mut crfsuite_dictionary_t) -> libc::c_int>,
    /// Decrement the reference counter.
    ///
    /// `dic`         The pointer to this dictionary instance.
    ///
    /// Returns the reference count after this operation.
    pub release:
        ::std::option::Option<unsafe extern "C" fn(dic: *mut crfsuite_dictionary_t) -> libc::c_int>,
    /// Assign and obtain the integer ID for the string.
    ///
    /// * `dic`         The pointer to this dictionary instance.
    /// * `str`         The string.
    ///
    /// Returns the ID associated with the string if any,
    /// the new ID otherwise.
    pub get: ::std::option::Option<
        unsafe extern "C" fn(
            dic: *mut crfsuite_dictionary_t,
            str: *const libc::c_char,
        ) -> libc::c_int,
    >,
    /// Obtain the integer ID for the string.
    ///
    /// * `dic`         The pointer to this dictionary instance.
    /// * `str`         The string.
    ///
    /// Returns the ID associated with the string if any,
    /// \c -1 otherwise.
    pub to_id: ::std::option::Option<
        unsafe extern "C" fn(
            dic: *mut crfsuite_dictionary_t,
            str: *const libc::c_char,
        ) -> libc::c_int,
    >,
    /// Obtain the string for the ID.
    ///
    /// * `dic`         The pointer to this dictionary instance.
    /// * `id`          the string ID.
    /// * `pstr`        \c *pstr points to the string associated with
    /// the ID if any, \c NULL otherwise.
    ///
    /// Returns int         \c 0 if the string ID is associated with a string,
    /// \c 1 otherwise.
    pub to_string: ::std::option::Option<
        unsafe extern "C" fn(
            dic: *mut crfsuite_dictionary_t,
            id: libc::c_int,
            pstr: *mut *const libc::c_char,
        ) -> libc::c_int,
    >,
    /// Obtain the number of strings in the dictionary.
    ///
    /// `dic`         The pointer to this dictionary instance.
    ///
    /// Returns the number of strings stored in the dictionary.
    pub num:
        ::std::option::Option<unsafe extern "C" fn(dic: *mut crfsuite_dictionary_t) -> libc::c_int>,
    /// Free the memory block allocated by to_string() function.
    ///
    /// * `dic`         The pointer to this dictionary instance.
    /// * `str`         The pointer to the string whose memory block is
    /// freed.
    pub free: ::std::option::Option<
        unsafe extern "C" fn(dic: *mut crfsuite_dictionary_t, str: *const libc::c_char),
    >,
}
/// CRFSuite parameter interface.
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tag_crfsuite_params {
    /// Pointer to the instance data (internal use only).
    pub internal: *mut libc::c_void,
    /// Reference counter (internal use only).
    pub nref: libc::c_int,
    /// Increment the reference counter.
    ///
    /// `params`      The pointer to this parameter instance.
    ///
    /// Returns the reference count after this increment.
    pub addref:
        ::std::option::Option<unsafe extern "C" fn(params: *mut crfsuite_params_t) -> libc::c_int>,
    /// Decrement the reference counter.
    ///
    /// `params`      The pointer to this parameter instance.
    ///
    /// Returns the reference count after this operation.
    pub release:
        ::std::option::Option<unsafe extern "C" fn(params: *mut crfsuite_params_t) -> libc::c_int>,
    /// Obtain the number of available parameters.
    ///
    /// `params`      The pointer to this parameter instance.
    ///
    /// Returns the number of parameters maintained by this object.
    pub num:
        ::std::option::Option<unsafe extern "C" fn(params: *mut crfsuite_params_t) -> libc::c_int>,
    /// Obtain the name of a parameter.
    ///
    /// * `params`      The pointer to this parameter instance.
    /// * `i`           The parameter index.
    /// * `ptr_name`    *ptr_name points to the parameter name.
    ///
    /// Returns int         \c 0 always.
    pub name: ::std::option::Option<
        unsafe extern "C" fn(
            params: *mut crfsuite_params_t,
            i: libc::c_int,
            ptr_name: *mut *mut libc::c_char,
        ) -> libc::c_int,
    >,
    /// Set a parameter value.
    ///
    /// * `params`      The pointer to this parameter instance.
    /// * `name`        The parameter name.
    /// * `value`       The parameter value in string format.
    ///
    /// Returns int         \c 0 if the parameter is found, \c -1 otherwise.
    pub set: ::std::option::Option<
        unsafe extern "C" fn(
            params: *mut crfsuite_params_t,
            name: *const libc::c_char,
            value: *const libc::c_char,
        ) -> libc::c_int,
    >,
    /// Get a parameter value.
    ///
    /// * `params`      The pointer to this parameter instance.
    /// * `name`        The parameter name.
    /// * `ptr_value`   *ptr_value presents the parameter value in string
    /// format.
    ///
    /// Returns int         \c 0 if the parameter is found, \c -1 otherwise.
    pub get: ::std::option::Option<
        unsafe extern "C" fn(
            params: *mut crfsuite_params_t,
            name: *const libc::c_char,
            ptr_value: *mut *mut libc::c_char,
        ) -> libc::c_int,
    >,
    /// Set an integer value of a parameter.
    ///
    /// * `params`      The pointer to this parameter instance.
    /// * `name`        The parameter name.
    /// * `value`       The parameter value.
    ///
    /// Returns int         \c 0 if the parameter value is set successfully,
    /// \c -1 otherwise (unknown parameter or incompatible
    /// type).
    pub set_int: ::std::option::Option<
        unsafe extern "C" fn(
            params: *mut crfsuite_params_t,
            name: *const libc::c_char,
            value: libc::c_int,
        ) -> libc::c_int,
    >,
    /// Set a float value of a parameter.
    ///
    /// * `params`      The pointer to this parameter instance.
    /// * `name`        The parameter name.
    /// * `value`       The parameter value.
    ///
    /// Returns int         \c 0 if the parameter value is set successfully,
    /// \c -1 otherwise (unknown parameter or incompatible
    /// type).
    pub set_float: ::std::option::Option<
        unsafe extern "C" fn(
            params: *mut crfsuite_params_t,
            name: *const libc::c_char,
            value: floatval_t,
        ) -> libc::c_int,
    >,
    /// Set a string value of a parameter.
    ///
    /// * `params`      The pointer to this parameter instance.
    /// * `name`        The parameter name.
    /// * `value`       The parameter value.
    ///
    /// Returns int         \c 0 if the parameter value is set successfully,
    /// \c -1 otherwise (unknown parameter or incompatible
    /// type).
    pub set_string: ::std::option::Option<
        unsafe extern "C" fn(
            params: *mut crfsuite_params_t,
            name: *const libc::c_char,
            value: *const libc::c_char,
        ) -> libc::c_int,
    >,
    /// Get an integer value of a parameter.
    ///
    /// * `params`      The pointer to this parameter instance.
    /// * `name`        The parameter name.
    /// * `ptr_value`   The pointer to a variable that receives the
    /// integer value.
    ///
    /// Returns int         \c 0 if the parameter value is obtained
    /// successfully, \c -1 otherwise (unknown parameter
    /// or incompatible type).
    pub get_int: ::std::option::Option<
        unsafe extern "C" fn(
            params: *mut crfsuite_params_t,
            name: *const libc::c_char,
            ptr_value: *mut libc::c_int,
        ) -> libc::c_int,
    >,
    /// Get a float value of a parameter.
    ///
    /// * `params`      The pointer to this parameter instance.
    /// * `name`        The parameter name.
    /// * `ptr_value`   The pointer to a variable that receives the
    /// float value.
    ///
    /// Returns int         \c 0 if the parameter value is obtained
    /// successfully, \c -1 otherwise (unknown parameter
    /// or incompatible type).
    pub get_float: ::std::option::Option<
        unsafe extern "C" fn(
            params: *mut crfsuite_params_t,
            name: *const libc::c_char,
            ptr_value: *mut floatval_t,
        ) -> libc::c_int,
    >,
    /// Get a string value of a parameter.
    ///
    /// * `params`      The pointer to this parameter instance.
    /// * `name`        The parameter name.
    /// * `ptr_value`   *ptr_value presents the parameter value.
    ///
    /// Returns int         \c 0 if the parameter value is obtained
    /// successfully, \c -1 otherwise (unknown parameter
    /// or incompatible type).
    pub get_string: ::std::option::Option<
        unsafe extern "C" fn(
            params: *mut crfsuite_params_t,
            name: *const libc::c_char,
            ptr_value: *mut *mut libc::c_char,
        ) -> libc::c_int,
    >,
    /// Get the help message of a parameter.
    ///
    /// * `params`      The pointer to this parameter instance.
    /// * `name`        The parameter name.
    /// * `ptr_type`    The pointer to \c char* to which this function
    /// store the type of the parameter.
    /// * `ptr_help`    The pointer to \c char* to which this function
    /// store the help message of the parameter.
    ///
    /// Returns int         \c 0 if the parameter is found, \c -1 otherwise.
    pub help: ::std::option::Option<
        unsafe extern "C" fn(
            params: *mut crfsuite_params_t,
            name: *const libc::c_char,
            ptr_type: *mut *mut libc::c_char,
            ptr_help: *mut *mut libc::c_char,
        ) -> libc::c_int,
    >,
    /// Free the memory block of a string allocated by this object.
    ///
    /// * `params`      The pointer to this parameter instance.
    /// * `str`         The pointer to the string.
    pub free: ::std::option::Option<
        unsafe extern "C" fn(params: *mut crfsuite_params_t, str: *const libc::c_char),
    >,
}
extern "C" {

    /// Create an instance of an object by an interface identifier.
    ///
    /// * `iid`         The interface identifier.
    /// * `ptr`         The pointer to \c void* that points to the
    /// instance of the object if successful,
    /// *ptr points to \c NULL otherwise.
    ///
    /// Returns int         \c 1 if this function creates an object successfully,
    /// \c 0 otherwise. Note that this is inconsistent with the
    /// other CRFsuite API calls.
    pub fn crfsuite_create_instance(
        iid: *const libc::c_char,
        ptr: *mut *mut libc::c_void,
    ) -> libc::c_int;
}
extern "C" {

    /// Create an instance of a model object from a model file.
    ///
    /// * `filename`    The filename of the model.
    /// * `ptr`         The pointer to \c void* that points to the
    /// instance of the model object if successful,
    /// *ptr points to \c NULL otherwise.
    ///
    /// Returns int         \c 0 if this function creates an object successfully,
    /// \c 1 otherwise.
    pub fn crfsuite_create_instance_from_file(
        filename: *const libc::c_char,
        ptr: *mut *mut libc::c_void,
    ) -> libc::c_int;
}
extern "C" {

    /// Create an instance of a model object from a model in memory.
    ///
    /// * `data`        A pointer to the model data.
    /// Must be 16-byte aligned.
    /// * `size`        A size (in bytes) of the model data.
    /// * `ptr`         The pointer to \c void* that points to the
    /// instance of the model object if successful,
    /// *ptr points to \c NULL otherwise.
    ///
    /// Returns int         \c 0 if this function creates an object successfully,
    /// \c 1 otherwise
    pub fn crfsuite_create_instance_from_memory(
        data: *const libc::c_void,
        size: usize,
        ptr: *mut *mut libc::c_void,
    ) -> libc::c_int;
}
extern "C" {

    /// Create instances of tagging object from a model file.
    ///
    /// * `filename`    The filename of the model.
    /// * `ptr_tagger`  The pointer to \c void* that points to the
    /// instance of the tagger object if successful,
    /// *ptr points to \c NULL otherwise.
    /// * `ptr_attrs`   The pointer to \c void* that points to the
    /// instance of the dictionary object for attributes
    /// if successful, *ptr points to \c NULL otherwise.
    /// * `ptr_labels`  The pointer to \c void* that points to the
    /// instance of the dictionary object for labels
    /// if successful, *ptr points to \c NULL otherwise.
    ///
    /// Returns int         \c 0 if this function creates an object successfully,
    /// \c 1 otherwise.
    pub fn crfsuite_create_tagger(
        filename: *const libc::c_char,
        ptr_tagger: *mut *mut crfsuite_tagger_t,
        ptr_attrs: *mut *mut crfsuite_dictionary_t,
        ptr_labels: *mut *mut crfsuite_dictionary_t,
    ) -> libc::c_int;
}
extern "C" {

    /// Initialize an attribute structure.
    ///
    /// `attr`        The pointer to crfsuite_attribute_t.
    pub fn crfsuite_attribute_init(attr: *mut crfsuite_attribute_t);
}
extern "C" {

    /// Set an attribute and its value.
    ///
    /// * `attr`        The pointer to crfsuite_attribute_t.
    /// * `aid`         The attribute identifier.
    /// * `value`       The attribute value.
    pub fn crfsuite_attribute_set(
        attr: *mut crfsuite_attribute_t,
        aid: libc::c_int,
        value: floatval_t,
    );
}
extern "C" {

    /// Copy the content of an attribute structure.
    ///
    /// * `dst`         The pointer to the destination.
    /// * `src`         The pointer to the source.
    pub fn crfsuite_attribute_copy(
        dst: *mut crfsuite_attribute_t,
        src: *const crfsuite_attribute_t,
    );
}
extern "C" {

    /// Swap the contents of two attribute structures.
    ///
    /// * `x`           The pointer to an attribute structure.
    /// * `y`           The pointer to another attribute structure.
    pub fn crfsuite_attribute_swap(x: *mut crfsuite_attribute_t, y: *mut crfsuite_attribute_t);
}
extern "C" {

    /// Initialize an item structure.
    ///
    /// `item`        The pointer to crfsuite_item_t.
    pub fn crfsuite_item_init(item: *mut crfsuite_item_t);
}
extern "C" {

    /// Initialize an item structure with the number of attributes.
    ///
    /// * `item`        The pointer to crfsuite_item_t.
    /// * `num_attributes`  The number of attributes.
    pub fn crfsuite_item_init_n(item: *mut crfsuite_item_t, num_attributes: libc::c_int);
}
extern "C" {

    /// Uninitialize an item structure.
    ///
    /// `item`        The pointer to crfsuite_item_t.
    pub fn crfsuite_item_finish(item: *mut crfsuite_item_t);
}
extern "C" {

    /// Copy the content of an item structure.
    ///
    /// * `dst`         The pointer to the destination.
    /// * `src`         The pointer to the source.
    pub fn crfsuite_item_copy(dst: *mut crfsuite_item_t, src: *const crfsuite_item_t);
}
extern "C" {

    /// Swap the contents of two item structures.
    ///
    /// * `x`           The pointer to an item structure.
    /// * `y`           The pointer to another item structure.
    pub fn crfsuite_item_swap(x: *mut crfsuite_item_t, y: *mut crfsuite_item_t);
}
extern "C" {

    /// Append an attribute to the item structure.
    ///
    /// * `item`        The pointer to crfsuite_item_t.
    /// * `attr`        The attribute to be added to the item.
    ///
    /// Returns int         \c 0 if successful, \c -1 otherwise.
    pub fn crfsuite_item_append_attribute(
        item: *mut crfsuite_item_t,
        attr: *const crfsuite_attribute_t,
    ) -> libc::c_int;
}
extern "C" {

    /// Check whether the item has no attribute.
    ///
    /// `item`        The pointer to crfsuite_item_t.
    ///
    /// Returns int         \c 1 if the item has no attribute, \c 0 otherwise.
    pub fn crfsuite_item_empty(item: *mut crfsuite_item_t) -> libc::c_int;
}
extern "C" {

    /// Initialize an instance structure.
    ///
    /// `seq`         The pointer to crfsuite_instance_t.
    pub fn crfsuite_instance_init(seq: *mut crfsuite_instance_t);
}
extern "C" {

    /// Initialize an instance structure with the number of items.
    ///
    /// * `seq`         The pointer to crfsuite_instance_t.
    /// * `num_items`   The number of items.
    pub fn crfsuite_instance_init_n(seq: *mut crfsuite_instance_t, num_items: libc::c_int);
}
extern "C" {

    /// Uninitialize an instance structure.
    ///
    /// `seq`         The pointer to crfsuite_instance_t.
    pub fn crfsuite_instance_finish(seq: *mut crfsuite_instance_t);
}
extern "C" {

    /// Copy the content of an instance structure.
    ///
    /// * `dst`         The pointer to the destination.
    /// * `src`         The pointer to the source.
    pub fn crfsuite_instance_copy(dst: *mut crfsuite_instance_t, src: *const crfsuite_instance_t);
}
extern "C" {

    /// Swap the contents of two instance structures.
    ///
    /// * `x`           The pointer to an instance structure.
    /// * `y`           The pointer to another instance structure.
    pub fn crfsuite_instance_swap(x: *mut crfsuite_instance_t, y: *mut crfsuite_instance_t);
}
extern "C" {

    /// Append a pair of item and label to the instance structure.
    ///
    /// * `seq`         The pointer to crfsuite_instance_t.
    /// * `item`        The item to be added to the instance.
    /// * `label`       The label to be added to the instance.
    ///
    /// Returns int         \c 0 if successful, \c -1 otherwise.
    pub fn crfsuite_instance_append(
        seq: *mut crfsuite_instance_t,
        item: *const crfsuite_item_t,
        label: libc::c_int,
    ) -> libc::c_int;
}
extern "C" {

    /// Check whether the instance has no item.
    ///
    /// `seq`         The pointer to crfsuite_instance_t.
    ///
    /// Returns int         \c 1 if the instance has no attribute, \c 0 otherwise.
    pub fn crfsuite_instance_empty(seq: *mut crfsuite_instance_t) -> libc::c_int;
}
extern "C" {

    /// Initialize a dataset structure.
    ///
    /// `data`        The pointer to crfsuite_data_t.
    pub fn crfsuite_data_init(data: *mut crfsuite_data_t);
}
extern "C" {

    /// Initialize a dataset structure with the number of instances.
    ///
    /// * `data`        The pointer to crfsuite_data_t.
    /// * `n`           The number of instances.
    pub fn crfsuite_data_init_n(data: *mut crfsuite_data_t, n: libc::c_int);
}
extern "C" {

    /// Uninitialize a dataset structure.
    ///
    /// `data`        The pointer to crfsuite_data_t.
    pub fn crfsuite_data_finish(data: *mut crfsuite_data_t);
}
extern "C" {

    /// Copy the content of a dataset structure.
    ///
    /// * `dst`         The pointer to the destination.
    /// * `src`         The pointer to the source.
    pub fn crfsuite_data_copy(dst: *mut crfsuite_data_t, src: *const crfsuite_data_t);
}
extern "C" {

    /// Swap the contents of two dataset structures.
    ///
    /// * `x`           The pointer to a dataset structure.
    /// * `y`           The pointer to another dataset structure.
    pub fn crfsuite_data_swap(x: *mut crfsuite_data_t, y: *mut crfsuite_data_t);
}
extern "C" {

    /// Append an instance to the dataset structure.
    ///
    /// * `data`        The pointer to crfsuite_data_t.
    /// * `inst`        The instance to be added to the dataset.
    ///
    /// Returns int         \c 0 if successful, \c -1 otherwise.
    pub fn crfsuite_data_append(
        data: *mut crfsuite_data_t,
        inst: *const crfsuite_instance_t,
    ) -> libc::c_int;
}
extern "C" {

    /// Obtain the maximum length of the instances in the dataset.
    ///
    /// `data`        The pointer to crfsuite_data_t.
    ///
    /// Returns the maximum number of items of the instances in the
    /// dataset.
    pub fn crfsuite_data_maxlength(data: *mut crfsuite_data_t) -> libc::c_int;
}
extern "C" {

    /// Obtain the total number of items in the dataset.
    ///
    /// `data`        The pointer to crfsuite_data_t.
    ///
    /// Returns the total number of items in the dataset.
    pub fn crfsuite_data_totalitems(data: *mut crfsuite_data_t) -> libc::c_int;
}
extern "C" {

    /// Initialize an evaluation structure.
    ///
    /// * `eval`        The pointer to crfsuite_evaluation_t.
    /// * `n`           The number of labels in the dataset.
    pub fn crfsuite_evaluation_init(eval: *mut crfsuite_evaluation_t, n: libc::c_int);
}
extern "C" {

    /// Uninitialize an evaluation structure.
    ///
    /// `eval`        The pointer to crfsuite_evaluation_t.
    pub fn crfsuite_evaluation_finish(eval: *mut crfsuite_evaluation_t);
}
extern "C" {

    /// Reset an evaluation structure.
    ///
    /// `eval`        The pointer to crfsuite_evaluation_t.
    pub fn crfsuite_evaluation_clear(eval: *mut crfsuite_evaluation_t);
}
extern "C" {

    /// Accmulate the correctness of the predicted label sequence.
    ///
    /// * `eval`        The pointer to crfsuite_evaluation_t.
    /// * `reference`   The reference label sequence.
    /// * `prediction`  The predicted label sequence.
    /// * `T`           The length of the label sequence.
    ///
    /// Returns int         \c 0 if succeeded, \c 1 otherwise.
    pub fn crfsuite_evaluation_accmulate(
        eval: *mut crfsuite_evaluation_t,
        reference: *const libc::c_int,
        prediction: *const libc::c_int,
        T: libc::c_int,
    ) -> libc::c_int;
}
extern "C" {

    /// Finalize the evaluation result.
    ///
    /// `eval`        The pointer to crfsuite_evaluation_t.
    pub fn crfsuite_evaluation_finalize(eval: *mut crfsuite_evaluation_t);
}
extern "C" {

    /// Print the evaluation result.
    ///
    /// * `eval`        The pointer to crfsuite_evaluation_t.
    /// * `labels`      The pointer to the label dictionary.
    /// * `cbm`         The callback function to receive the evaluation result.
    /// * `user`        The pointer to the user data that is forwarded to the
    /// callback function.
    pub fn crfsuite_evaluation_output(
        eval: *mut crfsuite_evaluation_t,
        labels: *mut crfsuite_dictionary_t,
        cbm: crfsuite_logging_callback,
        user: *mut libc::c_void,
    );
}
extern "C" {

    /// Increments the value of the integer variable as an atomic operation.
    ///
    /// `count`       The pointer to the integer variable.
    ///
    /// Returns the value after this increment.
    pub fn crfsuite_interlocked_increment(count: *mut libc::c_int) -> libc::c_int;
}
extern "C" {

    /// Decrements the value of the integer variable as an atomic operation.
    ///
    /// `count`       The pointer to the integer variable.
    ///
    /// Returns the value after this decrement.
    pub fn crfsuite_interlocked_decrement(count: *mut libc::c_int) -> libc::c_int;
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __va_list_tag {
    pub gp_offset: libc::c_uint,
    pub fp_offset: libc::c_uint,
    pub overflow_arg_area: *mut libc::c_void,
    pub reg_save_area: *mut libc::c_void,
}
