"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MicroService = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const constructs_1 = require("constructs");
const autoScalingGroup_1 = require("./autoScalingGroup");
const deployment_1 = require("./deployment");
const network_1 = require("./network");
class MicroService extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r;
        super(scope, id);
        this.instanceType = (_b = props === null || props === void 0 ? void 0 : props.instanceType) !== null && _b !== void 0 ? _b : 't3a.micro';
        this.appName = props.appName;
        this.asgMaxSize = (_c = props === null || props === void 0 ? void 0 : props.asgMaxSize) !== null && _c !== void 0 ? _c : '2';
        this.asgMinSize = (_d = props === null || props === void 0 ? void 0 : props.asgMinSize) !== null && _d !== void 0 ? _d : '1';
        this.env = (_e = props === null || props === void 0 ? void 0 : props.env) !== null && _e !== void 0 ? _e : 'development';
        this.instanceLabels = props === null || props === void 0 ? void 0 : props.instanceLabels;
        this.diskSize = (_f = props.diskSize) !== null && _f !== void 0 ? _f : 8;
        this.vpc = props.vpc;
        this.role = props.role;
        this.tcpRules = (_g = props.tcpRules) !== null && _g !== void 0 ? _g : [];
        this.subnets = props.subnets;
        this.sshKey = props.sshKey;
        this.diskType = props.diskType;
        this.createCodedeployApplication = (_h = props.createCodedeployApplication) !== null && _h !== void 0 ? _h : false;
        this.deploymentPolicies = (_j = props.deploymentPolicies) !== null && _j !== void 0 ? _j : [];
        this.applicationType = (_k = props.applicationType) !== null && _k !== void 0 ? _k : 'new';
        this.securityGroupProps = props.securityGroupProps;
        this.networkProps = (_l = props.networkProps) !== null && _l !== void 0 ? _l : [];
        this.targetGroupProps = [];
        this.networkProps = (_m = props.networkProps) !== null && _m !== void 0 ? _m : [];
        const resourceNamePrefix = this.env + '-' + this.appName;
        const asg = new autoScalingGroup_1.AutoScaler(this, resourceNamePrefix + '-as', {
            asgName: resourceNamePrefix + '-ASG',
            appName: resourceNamePrefix,
            networkProps: this.networkProps,
            maxSize: this.asgMaxSize,
            minSize: this.asgMinSize,
            templateProps: {
                instanceType: this.instanceType,
                detailedMonitoring: false,
                templateName: resourceNamePrefix + '-LT',
                amiImageId: (_o = props.ami) !== null && _o !== void 0 ? _o : 'Ubuntu Server 20.04 LTS (HVM), SSD Volume Type',
                type: 'new',
                blockDevice: {
                    size: this.diskSize,
                    name: '/dev/sda1',
                    type: this.getDiskType((_p = this.diskType) !== null && _p !== void 0 ? _p : 'GP3'),
                },
                vpc: {
                    type: 'existing',
                    vpcName: this.vpc,
                },
                securityGroup: (_q = this.securityGroupProps) !== null && _q !== void 0 ? _q : {
                    type: 'new',
                    allowAllOutbound: true,
                    securityGroupName: resourceNamePrefix + '-SG',
                    ingressRules: this.tcpRules,
                },
                role: this.role,
                sshKey: this.sshKey,
            },
            tags: props.instanceLabels,
            subnets: this.subnets,
        });
        if (this.createCodedeployApplication) {
            const depRole = this.getDeploymentGroupRole();
            const dep = new deployment_1.Deployment(this, resourceNamePrefix + '-cd', {
                asgNames: [resourceNamePrefix + '-ASG'],
                deploymentConfigName: 'CodeDeployDefault.OneAtATime',
                roleArn: depRole.roleArn,
                applicationProps: {
                    applicationName: this.appName + '-' + this.env,
                    type: this.applicationType,
                    resourceType: 'Server',
                },
                deploymentGroupName: this.env,
                tgName: resourceNamePrefix + '-TG',
            });
            dep.node.addDependency(depRole);
            dep.node.addDependency(asg);
        }
        if (this.networkProps.length) {
            (_r = asg.loadBalancerProperties) === null || _r === void 0 ? void 0 : _r.forEach(lbProp => {
                const lbEntry = new network_1.BalancerEntry(this, lbProp.hostHeader, lbProp);
                lbEntry.node.addDependency(asg);
            });
        }
    }
    getDeploymentGroupRole() {
        var _b;
        var role = new aws_iam_1.Role(this, this.appName + '-deployment-group-role', {
            assumedBy: new aws_iam_1.ServicePrincipal('codedeploy.amazonaws.com'),
            roleName: this.appName + '-deployment-group-role',
        });
        role.addToPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            resources: ['*'],
            actions: [
                'autoscaling:CompleteLifecycleAction',
                'autoscaling:DeleteLifecycleHook',
                'autoscaling:DescribeAutoScalingGroups',
                'autoscaling:DescribeLifecycleHooks',
                'autoscaling:PutLifecycleHook',
                'autoscaling:RecordLifecycleActionHeartbeat',
                'autoscaling:CreateAutoScalingGroup',
                'autoscaling:UpdateAutoScalingGroup',
                'autoscaling:EnableMetricsCollection',
                'autoscaling:DescribePolicies',
                'autoscaling:DescribeScheduledActions',
                'autoscaling:DescribeNotificationConfigurations',
                'autoscaling:SuspendProcesses',
                'autoscaling:ResumeProcesses',
                'autoscaling:AttachLoadBalancers',
                'autoscaling:AttachLoadBalancerTargetGroups',
                'autoscaling:PutScalingPolicy',
                'autoscaling:PutScheduledUpdateGroupAction',
                'autoscaling:PutNotificationConfiguration',
                'autoscaling:PutWarmPool',
                'autoscaling:DescribeScalingActivities',
                'autoscaling:DeleteAutoScalingGroup',
                'ec2:DescribeInstances',
                'ec2:DescribeInstanceStatus',
                'ec2:TerminateInstances',
                'tag:GetResources',
                'sns:Publish',
                'cloudwatch:DescribeAlarms',
                'cloudwatch:PutMetricAlarm',
                'elasticloadbalancing:DescribeLoadBalancers',
                'elasticloadbalancing:DescribeInstanceHealth',
                'elasticloadbalancing:RegisterInstancesWithLoadBalancer',
                'elasticloadbalancing:DeregisterInstancesFromLoadBalancer',
                'elasticloadbalancing:DescribeTargetGroups',
                'elasticloadbalancing:DescribeTargetHealth',
                'elasticloadbalancing:RegisterTargets',
                'elasticloadbalancing:DeregisterTargets',
                'ec2:CreateTags',
                'ec2:RunInstances',
                'iam:PassRole',
                ...(_b = this.deploymentPolicies) !== null && _b !== void 0 ? _b : [],
            ],
        }));
        return role;
    }
    getDiskType(type) {
        return type;
    }
}
exports.MicroService = MicroService;
_a = JSII_RTTI_SYMBOL_1;
MicroService[_a] = { fqn: "@smallcase/aws-cdk-microservice.MicroService", version: "0.0.15" };
//# sourceMappingURL=data:application/json;base64,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