import { CfnAutoScalingGroup } from 'aws-cdk-lib/aws-autoscaling';
import { Construct } from 'constructs';
import { IngressRule, NetworkProps, InternalSG, TargetGroupProps, InternalRole } from './autoScalingGroup';
export interface MicroServiceProps {
    readonly env: string;
    readonly instanceType?: string;
    readonly appName: string;
    readonly asgMaxSize?: string;
    readonly asgMinSize?: string;
    readonly instanceLabels?: CfnAutoScalingGroup.TagPropertyProperty[];
    readonly vpc: string;
    readonly subnets: string[];
    readonly diskSize?: number;
    readonly role: InternalRole;
    readonly tcpRules?: IngressRule[];
    readonly ami?: string;
    readonly sshKey: string;
    readonly diskType?: string;
    readonly createCodedeployApplication?: boolean;
    readonly deploymentPolicies?: string[];
    readonly applicationType?: string;
    readonly securityGroupProps?: InternalSG;
    readonly networkProps?: NetworkProps[];
}
export declare class MicroService extends Construct {
    readonly instanceType?: string;
    readonly appName: string;
    readonly asgMaxSize?: string;
    readonly asgMinSize?: string;
    readonly env?: string;
    readonly instanceLabels?: CfnAutoScalingGroup.TagPropertyProperty[];
    readonly diskSize?: number;
    readonly vpc: string;
    readonly role: InternalRole;
    readonly tcpRules?: IngressRule[];
    readonly subnets: string[];
    readonly sshKey: string;
    readonly diskType?: string;
    readonly createCodedeployApplication?: boolean;
    readonly deploymentPolicies?: string[];
    readonly applicationType?: string;
    readonly securityGroupProps?: InternalSG;
    readonly networkProps?: NetworkProps[];
    readonly targetGroupProps: TargetGroupProps[];
    constructor(scope: Construct, id: string, props: MicroServiceProps);
    private getDeploymentGroupRole;
    private getDiskType;
}
