"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Deployment = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_codedeploy_1 = require("aws-cdk-lib/aws-codedeploy");
const constructs_1 = require("constructs");
class Deployment extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const app = this.getApp(props.applicationProps);
        const dg = new aws_codedeploy_1.CfnDeploymentGroup(this, props.deploymentGroupName, {
            deploymentGroupName: props.deploymentGroupName,
            applicationName: props.applicationProps.applicationName,
            serviceRoleArn: props.roleArn,
            autoScalingGroups: props.asgNames,
            deploymentConfigName: props.deploymentConfigName,
        });
        dg.node.addDependency(app);
    }
    getApp(props) {
        if (props.type == 'existing') {
            const app = aws_codedeploy_1.ServerApplication.fromServerApplicationName(this, props.applicationName, props.applicationName);
            return app;
        }
        else {
            const app = new aws_codedeploy_1.ServerApplication(this, props.applicationName, {
                applicationName: props.applicationName,
            });
            return app;
        }
    }
}
exports.Deployment = Deployment;
_a = JSII_RTTI_SYMBOL_1;
Deployment[_a] = { fqn: "@smallcase/aws-cdk-microservice.Deployment", version: "0.0.15" };
//# sourceMappingURL=data:application/json;base64,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