import sys
from pathlib import Path

sys.path.insert(0, str(Path(__file__).resolve().parents[1] / "src"))

from limen import Constant, KnowledgeBase, Predicate, format_kb


def test_format_kb_lists_predicates_and_constants():
    kb = KnowledgeBase()
    kb.add_predicate(Predicate("risk", 1, description="Risk score"))
    kb.add_constant(Constant("alice"))
    output = format_kb(kb)
    assert "risk/1" in output
    assert "alice" in output

