import sys
from pathlib import Path

sys.path.insert(0, str(Path(__file__).resolve().parents[1] / "src"))

from limen import (
    Atom,
    Constant,
    ConstantTruthFunction,
    FormulaNode,
    KnowledgeBase,
    Operator,
    Predicate,
    TruthAssignment,
    WeightedFormula,
    format_explanations,
    summarize_rule_contributions,
)


def test_summarize_rule_contributions_orders_by_contribution():
    kb = KnowledgeBase()
    predicate = Predicate("risk", 0)
    kb.add_predicate(predicate)
    atom = Atom(predicate, tuple())
    kb.add_formula(WeightedFormula(FormulaNode.atom_node(atom), 2.0, name="risk_rule"))
    assignment = TruthAssignment({atom: 0.4})

    summaries = summarize_rule_contributions(kb, assignment)
    assert summaries[0].name == "risk_rule"
    assert summaries[0].contribution == 0.8


def test_format_explanations_creates_table():
    kb = KnowledgeBase()
    predicate = Predicate("risk", 0)
    kb.add_predicate(predicate)
    atom = Atom(predicate, tuple())
    kb.add_formula(WeightedFormula(FormulaNode.atom_node(atom), 1.0, name="risk_rule"))
    assignment = TruthAssignment({atom: 0.5})

    text = format_explanations(summarize_rule_contributions(kb, assignment))
    assert "risk_rule" in text

