import sys
from pathlib import Path

import pytest

sys.path.insert(0, str(Path(__file__).resolve().parents[1] / "src"))

from limen import (
    Atom,
    Constant,
    ConstantTruthFunction,
    FormulaNode,
    GeneratedAtom,
    KnowledgeBase,
    Operator,
    Predicate,
    TruthAssignment,
    WeightedFormula,
    generate_atoms,
)


def _demo_kb():
    kb = KnowledgeBase()
    p = Predicate("p", 0)
    q = Predicate("q", 0)
    kb.add_predicate(p)
    kb.add_predicate(q)
    atom_p = Atom(p, tuple())
    atom_q = Atom(q, tuple())
    implication = FormulaNode(
        operator=Operator.IMPLIES,
        children=(FormulaNode.atom_node(atom_p), FormulaNode.atom_node(atom_q)),
    )
    kb.add_formula(WeightedFormula(implication, weight=1.0, name="rule"))
    kb.register_truth_function("p", ConstantTruthFunction(0.9))
    return kb, atom_p, atom_q


def test_generate_atoms_infers_new_fact():
    kb, _, atom_q = _demo_kb()
    assignment = kb.build_assignment_from_truth_functions()
    updated, generated = generate_atoms(kb, assignment, threshold=0.8)
    assert updated.get(atom_q) == pytest.approx(0.9, abs=1e-9)
    assert len(generated) == 1
    assert isinstance(generated[0], GeneratedAtom)

