import pickle

from revscoring.datasources import revision_oriented
from revscoring.dependencies import solve
from revscoring.languages import albanian

from .util import compare_extraction

BAD = [
    "alexeev",
    "amazingdusseldorf",
    "amerikanjizor",
    "baloncesto",
    "bande",
    "banya",
    "bator",
    "baturina",
    "beker",
    "ber",
    "biuro",
    "bole",
    "bolshoj",
    "brezhnjevit",
    "budalla",
    "budalle",
    "budallë",
    "bushter",
    "bushtre",
    "bushtër",
    "byth",
    "bythec",
    "bythqir",
    "bythqirë",
    "bythë",
    "carët",
    "categoria",
    "centurionëve",
    "cet",
    "cezanne",
    "chadwik",
    "chaika",
    "cica",
    "cicë",
    "cmimi",
    "commpton",
    "comt",
    "condado",
    "contea",
    "dcoyrpca",
    "debil",
    "debile",
    "debill",
    "deripaska",
    "derr",
    "deshtak",
    "dessin",
    "detoksifikuese",
    "dheura",
    "didn",
    "diplomatrus",
    "doha",
    "dolgoruki",
    "dredharake",
    "dzial",
    "dështakë",
    "dështak",
    "deshtak",
    "ehrenfest",
    "emmss",
    "esht",
    "eshte",
    "fedor",
    "fermion",
    "fizikië",
    "fizioni",
    "foundin",
    "freewebtown",
    "fresko",
    "fyell",
    "georgio",
    "gjith",
    "gjithe",
    "gllup",
    "gomar",
    "gona",
    "gonik",
    "gorkipark",
    "gorky",
    "gotingen",
    "grend",
    "grise",
    "gts",
    "guderian",
    "guzhine",
    "hacked",
    "hajvan",
    "haodym",
    "hierarkizuar",
    "hollet",
    "homoseksual",
    "homosexueal",
    "hor",
    "horr",
    "horra",
    "horre",
    "hrabstwo",
    "internacionale",
    "iovao",
    "izmaylovsky",
    "jelgava",
    "jgbi",
    "joohr",
    "kalifatietëria",
    "kantono",
    "kar",
    "karakteirzuar",
    "kari",
    "karin",
    "karit",
    "karuc",
    "katunar",
    "katundar",
    "kekun",
    "kolomna",
    "komshi",
    "kopil",
    "kopuk",
    "koqe",
    "kot",
    "krep",
    "kreten",
    "krploschad",
    "kuark",
    "kujtoini",
    "kurv",
    "kurvë",
    "kurva",
    "kurvar",
    "kurve",
    "kushof",
    "kushtetucenturionëve",
    "kushtueshem",
    "kuytryzertyshtrim",
    "laekzistencës",
    "lavire",
    "lehtënë",
    "lepton",
    "lesh",
    "localgovt",
    "lope",
    "lopë",
    "loqe",
    "luzhkov",
    "majakovskaja",
    "malyi",
    "managery",
    "manakor",
    "margaritit",
    "marrë",
    "matuf",
    "mbikodrinore",
    "mbretitit",
    "mbërritjes",
    "michailowitsch",
    "mietner",
    "mockbuster",
    "mokekao",
    "mosbesnikëri",
    "mosco",
    "moscobha",
    "moscohuia",
    "moskov",
    "moskovas",
    "moskuas",
    "moskvich",
    "mrtix",
    "musique",
    "mut",
    "muti",
    "mutin",
    "mështekne",
    "nadal",
    "nadals",
    "name",
    "nanen",
    "naryan",
    "nbsp",
    "ncedh",
    "ndenjjeje",
    "newkosova",
    "nigga",
    "njpe",
    "njëeoria",
    "nonen",
    "novy",
    "osakas",
    "osht",
    "palaço",
    "pallacanestro",
    "paftyrë",
    "paftyr",
    "paftyre",
    "palloj",
    "pampered",
    "pararevolucionarë",
    "parera",
    "partnerskie",
    "paskha",
    "pavarstorianët",
    "peder",
    "pederast",
    "pedofil",
    "per",
    "performuara",
    "pidh",
    "pidh",
    "pidhar",
    "pidhu",
    "pie",
    "pirdhu",
    "pishinat",
    "populluarit",
    "porcelane",
    "pordha",
    "pordhe",
    "prokhorov",
    "promocji",
    "prostitut",
    "prostitutë",
    "provojmë",
    "pshurr",
    "pussy",
    "përshëndesje",
    "qelbsir",
    "qelbsire",
    "qelbësirë",
    "qen",
    "qi",
    "qifsh",
    "qifsha",
    "qiu",
    "qiu",
    "qiju",
    "qsdfesef",
    "rafa",
    "rafaels",
    "rasht",
    "really",
    "republshtë",
    "reçensionit",
    "rips",
    "robqire",
    "robqirë",
    "robt",
    "ropt",
    "rossiya",
    "rrugac",
    "rrugaç",
    "rublev",
    "sandunovskiye",
    "semi",
    "serebryaniy",
    "setun",
    "shkalluar",
    "shkerdhat",
    "shkerdhatë",
    "shkërdhej",
    "shum",
    "shume",
    "shurrë",
    "sib",
    "sibneft",
    "sistercities",
    "slem",
    "slita",
    "sokolniki",
    "sorrë",
    "speciale",
    "sperma",
    "stalla",
    "starkov",
    "stupid",
    "syrenka",
    "telefonatëtë",
    "tells",
    "tenis",
    "teniserëve",
    "tenist",
    "tenisti",
    "tenistët",
    "teplostanskaya",
    "terrenet",
    "teveqel",
    "thi",
    "tinajxher",
    "tnjë",
    "transuranik",
    "trap",
    "trapin",
    "trbrmca",
    "tretiakov",
    "tretyakov",
    "tretyakovi",
    "tretyakovskaya",
    "tsvetaevas",
    "tsvetnoy",
    "une",
    "vaginë",
    "vraft",
    "warszawy",
    "wxcvwxcvwxcvwxcvwvc",
    "xhentilesë",
    "yausa",
    "yelena",
    "zagar",
    "zezak",
    "zhyteni",
    "zuskë",
    "çerekshekull",
    "çitt",
    "ëodyë"
]

INFORMAL = [
    "ahah", "ahahah", "ahahaha", "ahahahah",
    "alarmues",
    "btw",
    "cdo",
    "cool",
    "dreq",
    "eshte",
    "ftw",
    "haha", "hahah", "hahaha", "hahahahahaha",
    "hehe", "hehehe", "hihi",
    "hata",
    "hej",
    "joohr",
    "kohe",
    "kosov", "kosova", "kosovë",
    "lol",
    "mirësevjen",
    "moj",
    "mor",
    "ndersa",
    "nje",
    "njerez",
    "ok",
    "okej",
    "old",
    "omg",
    "ora",
    "përshëndetje",
    "qene",
    "shqiperi",
    "shqipëri",
    "shqipëria",
    "shqipërisë",
    "sib",
    "suck",
    "te",
    "vetem",
    "wow",
    "yeah",
    "yes",
    "yolo",
]

OTHER = [
    """
    Kirenea (greqishtja e lashtë: Κυρήνη Kyrēnē) ka qenë një qytet antik g
    rek dhe romak pranë qytetit të sotëm Shahhat, Libi. Ai ishte qyteti
    më i vjetër dhe më i rëndësishëm nga pesë qytetet greke në rajon. Ai i
    dha Libisë lindore emrin klasik Cyrenaica që ajo ka ruajtur deri në
    kohët moderne.
    """
]

r_text = revision_oriented.revision.text


def test_badwords():
    compare_extraction(albanian.badwords.revision.datasources.matches,
                       BAD, OTHER)

    assert albanian.badwords == pickle.loads(pickle.dumps(albanian.badwords))


def test_informals():
    compare_extraction(albanian.informals.revision.datasources.matches,
                       INFORMAL, OTHER)

    assert albanian.informals == pickle.loads(pickle.dumps(albanian.informals))


def test_stopwords():
    cache = {revision_oriented.revision.text:
             "Ai ishte qyteti më i vjetër dhe më " +
             "pesë qytetet greke në rajon"}
    assert (solve(albanian.stopwords.revision.datasources.stopwords, cache=cache) ==
            ["ishte", "dhe"])
    assert (solve(albanian.stopwords.revision.datasources.non_stopwords,
                  cache=cache) ==
            ["Ai", "qyteti", "më", "i", "vjetër", "më", "pesë",
             "qytetet", "greke", "në", "rajon"])

    assert albanian.stopwords == pickle.loads(pickle.dumps(albanian.stopwords))
