# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['astoria',
 'astoria.astctl',
 'astoria.astctl.metadata',
 'astoria.astctl.static_disks',
 'astoria.astctl.usercode',
 'astoria.astdiskd',
 'astoria.astmetad',
 'astoria.astprocd',
 'astoria.common',
 'astoria.common.components',
 'astoria.common.config',
 'astoria.common.disks',
 'astoria.common.ipc',
 'astoria.common.mixins',
 'astoria.common.mqtt']

package_data = \
{'': ['*']}

install_requires = \
['click>=8.1.2,<9.0.0',
 'dbus-next>=0.2.3,<0.3.0',
 'gmqtt>=0.6.11,<0.7.0',
 'pydantic>=1.9.1,<2.0.0',
 'tomli-w>=1.0.0,<2.0.0']

extras_require = \
{':python_full_version <= "3.10.0"': ['tomli>=2.0.1,<3.0.0']}

entry_points = \
{'console_scripts': ['astctl = astoria.astctl:main',
                     'astdiskd = astoria.astdiskd:main',
                     'astmetad = astoria.astmetad:main',
                     'astprocd = astoria.astprocd:main',
                     'astwifid = astoria.astwifid:main']}

setup_kwargs = {
    'name': 'astoria',
    'version': '0.11.0',
    'description': 'Robot Management System for Student Robotics Kit',
    'long_description': '# Astoria\n\n![Tests](https://github.com/srobo/astoria/workflows/Tests/badge.svg)\n![Build and Publish docs](https://github.com/srobo/astoria/workflows/Build%20and%20Publish%20docs/badge.svg)\n[![PyPI version](https://badge.fury.io/py/astoria.svg)](https://badge.fury.io/py/astoria)\n[![MIT license](https://img.shields.io/badge/license-MIT-brightgreen.svg?style=flat)](https://opensource.org/licenses/MIT)\n![Bees](https://img.shields.io/badge/bees-110%25-yellow.svg)\n\nRobot Management System for Student Robotics 2022 kit.\n\nFor more information, please see the [documentation](https://srobo.github.io/astoria).\n\n## Contributions\n\nThis project is released under the MIT Licence. For more information, please see LICENSE.\n\nThe CONTRIBUTORS file can be generated by executing CONTRIBUTORS.gen. This generated file contains a list of people who have contributed to Astoria.\n\n',
    'author': 'Dan Trickey',
    'author_email': 'srobo-astoria@trickey.io',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/srobo/astoria',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
