from setuptools import setup, find_packages
from os.path import abspath, dirname, join

README_MD = open(join(dirname(abspath(__file__)), "README.md")).read()

setup(
    name='tuttusa_utils',         # How you named your package folder (MyLib)
    #packages=['tuttusa_utils'],   # Chose the same as "name"
    version='0.1',      # Start with a small number and increase it with every change you make
    packages=find_packages(exclude="tests"),
    # Chose a license from here: https://help.github.com/articles/licensing-a-repository
    license='MIT',
    description='Tuttusa Utils',   # Give a short description about your library
    long_description=README_MD,
    long_description_content_type="text/markdown",
    author='Ashish',                   # Type in your name
    author_email='agarwal.ashish.singhal@gmail.com',      # Type in your E-Mail
    # Provide either the link to your github or to your website
    url='https://github.com/Tuttusa/tuttusa-utils',
    # I explain this later on
    download_url='https://github.com/Tuttusa/tuttusa-utils/archive/v_01.tar.gz',
    keywords=['utils', 'pypi', 'Tuttusa'],   # Keywords that define your package best
    install_requires=[            # I get to this in a second
        'fire',
		'tqdm',
		'google-cloud-storage',
		'sklearn',
		'boto3',
		'dload',
		'requests'
    ],
    include_package_data=True,
    classifiers=[
        # Chose either "3 - Alpha", "4 - Beta" or "5 - Production/Stable" as the current state of your package
        'Development Status :: 3 - Alpha',
        'Intended Audience :: Developers',      # Define that your audience are developers
        'Topic :: Software Development :: Build Tools',
        'License :: OSI Approved :: MIT License',   # Again, pick a license
        # Specify which pyhton versions that you want to support
        'Programming Language :: Python :: 3',
        #'Programming Language :: Python :: 3.4',
        #'Programming Language :: Python :: 3.5',
        #'Programming Language :: Python :: 3.6',
        #'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: 3.9',
    ],
)
