from datetime import datetime

import pytest

from firepit.timestamp import timefmt
from firepit.timestamp import to_datetime


@pytest.mark.parametrize(
    'ts, dt', [
        ("2022-02-01T00:00:00", datetime(2022, 2, 1, 0, 0, 0, 0)),
        ("2022-02-01T00:00:00.1", datetime(2022, 2, 1, 0, 0, 0, 100000)),
        ("2022-02-01T00:00:00.12", datetime(2022, 2, 1, 0, 0, 0, 120000)),
        ("2022-02-01T00:00:00.123", datetime(2022, 2, 1, 0, 0, 0, 123000)),
        ("2022-02-01T00:00:00.1234", datetime(2022, 2, 1, 0, 0, 0, 123400)),
        ("2022-02-01T00:00:00.12345", datetime(2022, 2, 1, 0, 0, 0, 123450)),
        ("2022-02-01T00:00:00.123456", datetime(2022, 2, 1, 0, 0, 0, 123456)),
    ]
)
def test_to_datetime(ts, dt):
    assert to_datetime(ts) == dt


@pytest.mark.parametrize(
    'ts, dt, prec', [
        ("2022-02-01T00:00:00.000Z", datetime(2022, 2, 1, 0, 0, 0, 0), 3),
        ("2022-02-01T00:00:00.100Z", datetime(2022, 2, 1, 0, 0, 0, 100000), 3),
        ("2022-02-01T00:00:00.120Z", datetime(2022, 2, 1, 0, 0, 0, 120000), 3),
        ("2022-02-01T00:00:00.123Z", datetime(2022, 2, 1, 0, 0, 0, 123000), 3),
        ("2022-02-01T00:00:00.123Z", datetime(2022, 2, 1, 0, 0, 0, 123400), 3),
        ("2022-02-01T00:00:00.123Z", datetime(2022, 2, 1, 0, 0, 0, 123450), 3),
        ("2022-02-01T00:00:00.123Z", datetime(2022, 2, 1, 0, 0, 0, 123456), 3),
        ("2022-02-01T00:00:00.123000Z", datetime(2022, 2, 1, 0, 0, 0, 123000), 6),
        ("2022-02-01T00:00:00.123400Z", datetime(2022, 2, 1, 0, 0, 0, 123400), 6),
        ("2022-02-01T00:00:00.123450Z", datetime(2022, 2, 1, 0, 0, 0, 123450), 6),
        ("2022-02-01T00:00:00.123456Z", datetime(2022, 2, 1, 0, 0, 0, 123456), 6),
    ]
)
def test_timefmt(ts, dt, prec):
    assert ts == timefmt(dt, prec)
    
