"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodePipelineStatus = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const codePipeline = require("@aws-cdk/aws-codepipeline");
const targets = require("@aws-cdk/aws-events-targets");
const iam = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/core");
/**
 * @experimental
 */
class CodePipelineStatus extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b, _c, _d, _e;
        super(scope, id);
        /**
         * @experimental
         */
        this.badgeUrl = '';
        /**
         * @experimental
         */
        this.codePipelineLink = '';
        const pipeline = codePipeline.Pipeline.fromPipelineArn(this, 'CodePipeline', props.pipelineArn);
        const gitHubToken = ((_b = props === null || props === void 0 ? void 0 : props.gitHubTokenFromSecretsManager) === null || _b === void 0 ? void 0 : _b.secretsManagerArn) && ((_c = props === null || props === void 0 ? void 0 : props.gitHubTokenFromSecretsManager) === null || _c === void 0 ? void 0 : _c.secretKey)
            ? cdk.SecretValue.secretsManager(props.gitHubTokenFromSecretsManager.secretsManagerArn, {
                jsonField: props.gitHubTokenFromSecretsManager.secretKey,
            })
            : null;
        const targetLambda = this.createCodePipelineEventLambdaFunction(pipeline.pipelineName, gitHubToken, (_d = props === null || props === void 0 ? void 0 : props.notification) === null || _d === void 0 ? void 0 : _d.stageName, (_e = props === null || props === void 0 ? void 0 : props.notification) === null || _e === void 0 ? void 0 : _e.slackWebHookUrl);
        pipeline.onStateChange('CodePipelineChange', {
            eventPattern: {
                source: ['aws.codepipeline'],
                detailType: ['CodePipeline Pipeline Execution State Change'],
            },
            target: new targets.LambdaFunction(targetLambda),
        });
    }
    createCodePipelineEventLambdaFunction(codePipelineName, gitHubToken, stage, slackWebhookURL) {
        var _b, _c;
        const badgeBucket = new s3.Bucket(this, 'BadgeBucket', {
            publicReadAccess: true,
        });
        const stageKeyName = stage ? `${stage}-` : '';
        const badgeBucketImageKeyName = `${stageKeyName}latest-build.svg`;
        const lambdaFunc = new lambda.DockerImageFunction(this, 'CodepipelineEventLambda', {
            code: lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../lambda/codepipeline-event'), {
                cmd: ['codepipelineEventLambda.handler'],
            }),
            environment: {
                STAGE: stage !== null && stage !== void 0 ? stage : '',
                SLACK_WEBHOOK_URL: slackWebhookURL !== null && slackWebhookURL !== void 0 ? slackWebhookURL : '',
                BADGE_BUCKET_NAME: badgeBucket.bucketName,
                BADGE_BUCKET_IMAGE_KEY_NAME: badgeBucketImageKeyName,
                CODE_PIPELINE_NAME: codePipelineName,
                GITHUB_PERSONAL_TOKEN: gitHubToken ? `${gitHubToken}` : '',
            },
        });
        badgeBucket.grantReadWrite(lambdaFunc);
        const region = (_b = cdk.Aws.REGION) !== null && _b !== void 0 ? _b : 'ap-northeast-1';
        this.badgeUrl = `https://${badgeBucket.bucketName}.s3-ap-northeast-1.amazonaws.com/${badgeBucketImageKeyName}#1`;
        this.codePipelineLink = `https://${region}.console.aws.amazon.com/codesuite/codepipeline/pipelines/${codePipelineName}/view`;
        new cdk.CfnOutput(this, 'badgeMarkdownLink', {
            value: `[![Build Status](${this.badgeUrl})](${this.codePipelineLink})`,
        });
        (_c = lambdaFunc.role) === null || _c === void 0 ? void 0 : _c.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('AWSCodePipeline_ReadOnlyAccess'));
        this.tagResource(lambdaFunc);
        return lambdaFunc;
    }
    tagResource(scope) {
        cdk.Tags.of(scope).add('CDK-CfnStackId', cdk.Aws.STACK_ID);
        cdk.Tags.of(scope).add('CDK-CfnStackName', cdk.Aws.STACK_NAME);
    }
}
exports.CodePipelineStatus = CodePipelineStatus;
_a = JSII_RTTI_SYMBOL_1;
CodePipelineStatus[_a] = { fqn: "cdk-codepipeline-badge-notification.CodePipelineStatus", version: "0.1.43" };
//# sourceMappingURL=data:application/json;base64,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