"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
const core_1 = require("@aws-cdk/core");
const gitlab_runner_autoscaling_1 = require("./gitlab-runner-autoscaling");
const env = {
    region: process.env.CDK_DEFAULT_REGION,
    account: process.env.CDK_DEFAULT_ACCOUNT,
};
const app = new core_1.App();
const stack = new core_1.Stack(app, 'TestStackAutoscaling', { env });
const vpc = aws_ec2_1.Vpc.fromLookup(stack, 'DefaultVpc', {
    isDefault: true,
});
const runner = new gitlab_runner_autoscaling_1.GitlabRunnerAutoscaling(stack, 'TestRunnerAutoscaling', {
    gitlabToken: stack.node.tryGetContext('GITLAB_TOKEN'),
    ebsSize: 10,
    vpc: vpc,
    dockerVolumes: [{
            hostPath: '/tmp/cache',
            containerPath: '/tmp/cache',
        }],
    desiredCapacity: 1,
    maxCapacity: 1,
    minCapacity: 1,
});
new core_1.CfnOutput(stack, 'role', { value: runner.instanceRole.roleArn });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuZ2l0bGFiLXJ1bm5lci1hdXRvc2NhbGluZy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9pbnRlZy5naXRsYWItcnVubmVyLWF1dG9zY2FsaW5nLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsOENBQXVDO0FBQ3ZDLHdDQUFzRDtBQUN0RCwyRUFBc0U7QUFFdEUsTUFBTSxHQUFHLEdBQUc7SUFDVixNQUFNLEVBQUUsT0FBTyxDQUFDLEdBQUcsQ0FBQyxrQkFBa0I7SUFDdEMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxHQUFHLENBQUMsbUJBQW1CO0NBQ3pDLENBQUM7QUFFRixNQUFNLEdBQUcsR0FBRyxJQUFJLFVBQUcsRUFBRSxDQUFDO0FBQ3RCLE1BQU0sS0FBSyxHQUFHLElBQUksWUFBSyxDQUFDLEdBQUcsRUFBRSxzQkFBc0IsRUFBRSxFQUFFLEdBQUcsRUFBRSxDQUFDLENBQUM7QUFFOUQsTUFBTSxHQUFHLEdBQUcsYUFBRyxDQUFDLFVBQVUsQ0FBQyxLQUFLLEVBQUUsWUFBWSxFQUFFO0lBQzlDLFNBQVMsRUFBRSxJQUFJO0NBQ2hCLENBQUMsQ0FBQztBQUNILE1BQU0sTUFBTSxHQUFHLElBQUksbURBQXVCLENBQUMsS0FBSyxFQUFFLHVCQUF1QixFQUFFO0lBQ3pFLFdBQVcsRUFBRSxLQUFLLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxjQUFjLENBQUM7SUFDckQsT0FBTyxFQUFFLEVBQUU7SUFDWCxHQUFHLEVBQUUsR0FBRztJQUNSLGFBQWEsRUFBRSxDQUFDO1lBQ2QsUUFBUSxFQUFFLFlBQVk7WUFDdEIsYUFBYSxFQUFFLFlBQVk7U0FDNUIsQ0FBQztJQUNGLGVBQWUsRUFBRSxDQUFDO0lBQ2xCLFdBQVcsRUFBRSxDQUFDO0lBQ2QsV0FBVyxFQUFFLENBQUM7Q0FDZixDQUFDLENBQUM7QUFFSCxJQUFJLGdCQUFTLENBQUMsS0FBSyxFQUFFLE1BQU0sRUFBRSxFQUFFLEtBQUssRUFBRSxNQUFNLENBQUMsWUFBWSxDQUFDLE9BQU8sRUFBRSxDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBWcGMgfSBmcm9tICdAYXdzLWNkay9hd3MtZWMyJztcbmltcG9ydCB7IEFwcCwgU3RhY2ssIENmbk91dHB1dCB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgR2l0bGFiUnVubmVyQXV0b3NjYWxpbmcgfSBmcm9tICcuL2dpdGxhYi1ydW5uZXItYXV0b3NjYWxpbmcnO1xuXG5jb25zdCBlbnYgPSB7XG4gIHJlZ2lvbjogcHJvY2Vzcy5lbnYuQ0RLX0RFRkFVTFRfUkVHSU9OLFxuICBhY2NvdW50OiBwcm9jZXNzLmVudi5DREtfREVGQVVMVF9BQ0NPVU5ULFxufTtcblxuY29uc3QgYXBwID0gbmV3IEFwcCgpO1xuY29uc3Qgc3RhY2sgPSBuZXcgU3RhY2soYXBwLCAnVGVzdFN0YWNrQXV0b3NjYWxpbmcnLCB7IGVudiB9KTtcblxuY29uc3QgdnBjID0gVnBjLmZyb21Mb29rdXAoc3RhY2ssICdEZWZhdWx0VnBjJywge1xuICBpc0RlZmF1bHQ6IHRydWUsXG59KTtcbmNvbnN0IHJ1bm5lciA9IG5ldyBHaXRsYWJSdW5uZXJBdXRvc2NhbGluZyhzdGFjaywgJ1Rlc3RSdW5uZXJBdXRvc2NhbGluZycsIHtcbiAgZ2l0bGFiVG9rZW46IHN0YWNrLm5vZGUudHJ5R2V0Q29udGV4dCgnR0lUTEFCX1RPS0VOJyksXG4gIGVic1NpemU6IDEwLFxuICB2cGM6IHZwYyxcbiAgZG9ja2VyVm9sdW1lczogW3tcbiAgICBob3N0UGF0aDogJy90bXAvY2FjaGUnLFxuICAgIGNvbnRhaW5lclBhdGg6ICcvdG1wL2NhY2hlJyxcbiAgfV0sXG4gIGRlc2lyZWRDYXBhY2l0eTogMSxcbiAgbWF4Q2FwYWNpdHk6IDEsXG4gIG1pbkNhcGFjaXR5OiAxLFxufSk7XG5cbm5ldyBDZm5PdXRwdXQoc3RhY2ssICdyb2xlJywgeyB2YWx1ZTogcnVubmVyLmluc3RhbmNlUm9sZS5yb2xlQXJuIH0pO1xuIl19