(self["webpackChunkweb_js"] = self["webpackChunkweb_js"] || []).push([["vendors-node_modules_monaco-editor_esm_vs_basic-languages_redshift_redshift_js"],{

/***/ "./node_modules/monaco-editor/esm/vs/basic-languages/redshift/redshift.js":
/*!********************************************************************************!*\
  !*** ./node_modules/monaco-editor/esm/vs/basic-languages/redshift/redshift.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "conf": () => (/* binding */ conf),
/* harmony export */   "language": () => (/* binding */ language)
/* harmony export */ });
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/

// src/basic-languages/redshift/redshift.ts
var conf = {
  comments: {
    lineComment: "--",
    blockComment: ["/*", "*/"]
  },
  brackets: [
    ["{", "}"],
    ["[", "]"],
    ["(", ")"]
  ],
  autoClosingPairs: [
    { open: "{", close: "}" },
    { open: "[", close: "]" },
    { open: "(", close: ")" },
    { open: '"', close: '"' },
    { open: "'", close: "'" }
  ],
  surroundingPairs: [
    { open: "{", close: "}" },
    { open: "[", close: "]" },
    { open: "(", close: ")" },
    { open: '"', close: '"' },
    { open: "'", close: "'" }
  ]
};
var language = {
  defaultToken: "",
  tokenPostfix: ".sql",
  ignoreCase: true,
  brackets: [
    { open: "[", close: "]", token: "delimiter.square" },
    { open: "(", close: ")", token: "delimiter.parenthesis" }
  ],
  keywords: [
    "AES128",
    "AES256",
    "ALL",
    "ALLOWOVERWRITE",
    "ANALYSE",
    "ANALYZE",
    "AND",
    "ANY",
    "ARRAY",
    "AS",
    "ASC",
    "AUTHORIZATION",
    "AZ64",
    "BACKUP",
    "BETWEEN",
    "BINARY",
    "BLANKSASNULL",
    "BOTH",
    "BYTEDICT",
    "BZIP2",
    "CASE",
    "CAST",
    "CHECK",
    "COLLATE",
    "COLUMN",
    "CONSTRAINT",
    "CREATE",
    "CREDENTIALS",
    "CROSS",
    "CURRENT_DATE",
    "CURRENT_TIME",
    "CURRENT_TIMESTAMP",
    "CURRENT_USER",
    "CURRENT_USER_ID",
    "DEFAULT",
    "DEFERRABLE",
    "DEFLATE",
    "DEFRAG",
    "DELTA",
    "DELTA32K",
    "DESC",
    "DISABLE",
    "DISTINCT",
    "DO",
    "ELSE",
    "EMPTYASNULL",
    "ENABLE",
    "ENCODE",
    "ENCRYPT",
    "ENCRYPTION",
    "END",
    "EXCEPT",
    "EXPLICIT",
    "FALSE",
    "FOR",
    "FOREIGN",
    "FREEZE",
    "FROM",
    "FULL",
    "GLOBALDICT256",
    "GLOBALDICT64K",
    "GRANT",
    "GROUP",
    "GZIP",
    "HAVING",
    "IDENTITY",
    "IGNORE",
    "ILIKE",
    "IN",
    "INITIALLY",
    "INNER",
    "INTERSECT",
    "INTO",
    "IS",
    "ISNULL",
    "JOIN",
    "LANGUAGE",
    "LEADING",
    "LEFT",
    "LIKE",
    "LIMIT",
    "LOCALTIME",
    "LOCALTIMESTAMP",
    "LUN",
    "LUNS",
    "LZO",
    "LZOP",
    "MINUS",
    "MOSTLY16",
    "MOSTLY32",
    "MOSTLY8",
    "NATURAL",
    "NEW",
    "NOT",
    "NOTNULL",
    "NULL",
    "NULLS",
    "OFF",
    "OFFLINE",
    "OFFSET",
    "OID",
    "OLD",
    "ON",
    "ONLY",
    "OPEN",
    "OR",
    "ORDER",
    "OUTER",
    "OVERLAPS",
    "PARALLEL",
    "PARTITION",
    "PERCENT",
    "PERMISSIONS",
    "PLACING",
    "PRIMARY",
    "RAW",
    "READRATIO",
    "RECOVER",
    "REFERENCES",
    "RESPECT",
    "REJECTLOG",
    "RESORT",
    "RESTORE",
    "RIGHT",
    "SELECT",
    "SESSION_USER",
    "SIMILAR",
    "SNAPSHOT",
    "SOME",
    "SYSDATE",
    "SYSTEM",
    "TABLE",
    "TAG",
    "TDES",
    "TEXT255",
    "TEXT32K",
    "THEN",
    "TIMESTAMP",
    "TO",
    "TOP",
    "TRAILING",
    "TRUE",
    "TRUNCATECOLUMNS",
    "UNION",
    "UNIQUE",
    "USER",
    "USING",
    "VERBOSE",
    "WALLET",
    "WHEN",
    "WHERE",
    "WITH",
    "WITHOUT"
  ],
  operators: [
    "AND",
    "BETWEEN",
    "IN",
    "LIKE",
    "NOT",
    "OR",
    "IS",
    "NULL",
    "INTERSECT",
    "UNION",
    "INNER",
    "JOIN",
    "LEFT",
    "OUTER",
    "RIGHT"
  ],
  builtinFunctions: [
    "current_schema",
    "current_schemas",
    "has_database_privilege",
    "has_schema_privilege",
    "has_table_privilege",
    "age",
    "current_time",
    "current_timestamp",
    "localtime",
    "isfinite",
    "now",
    "ascii",
    "get_bit",
    "get_byte",
    "set_bit",
    "set_byte",
    "to_ascii",
    "approximate percentile_disc",
    "avg",
    "count",
    "listagg",
    "max",
    "median",
    "min",
    "percentile_cont",
    "stddev_samp",
    "stddev_pop",
    "sum",
    "var_samp",
    "var_pop",
    "bit_and",
    "bit_or",
    "bool_and",
    "bool_or",
    "cume_dist",
    "first_value",
    "lag",
    "last_value",
    "lead",
    "nth_value",
    "ratio_to_report",
    "dense_rank",
    "ntile",
    "percent_rank",
    "rank",
    "row_number",
    "case",
    "coalesce",
    "decode",
    "greatest",
    "least",
    "nvl",
    "nvl2",
    "nullif",
    "add_months",
    "at time zone",
    "convert_timezone",
    "current_date",
    "date_cmp",
    "date_cmp_timestamp",
    "date_cmp_timestamptz",
    "date_part_year",
    "dateadd",
    "datediff",
    "date_part",
    "date_trunc",
    "extract",
    "getdate",
    "interval_cmp",
    "last_day",
    "months_between",
    "next_day",
    "sysdate",
    "timeofday",
    "timestamp_cmp",
    "timestamp_cmp_date",
    "timestamp_cmp_timestamptz",
    "timestamptz_cmp",
    "timestamptz_cmp_date",
    "timestamptz_cmp_timestamp",
    "timezone",
    "to_timestamp",
    "trunc",
    "abs",
    "acos",
    "asin",
    "atan",
    "atan2",
    "cbrt",
    "ceil",
    "ceiling",
    "checksum",
    "cos",
    "cot",
    "degrees",
    "dexp",
    "dlog1",
    "dlog10",
    "exp",
    "floor",
    "ln",
    "log",
    "mod",
    "pi",
    "power",
    "radians",
    "random",
    "round",
    "sin",
    "sign",
    "sqrt",
    "tan",
    "to_hex",
    "bpcharcmp",
    "btrim",
    "bttext_pattern_cmp",
    "char_length",
    "character_length",
    "charindex",
    "chr",
    "concat",
    "crc32",
    "func_sha1",
    "initcap",
    "left and rights",
    "len",
    "length",
    "lower",
    "lpad and rpads",
    "ltrim",
    "md5",
    "octet_length",
    "position",
    "quote_ident",
    "quote_literal",
    "regexp_count",
    "regexp_instr",
    "regexp_replace",
    "regexp_substr",
    "repeat",
    "replace",
    "replicate",
    "reverse",
    "rtrim",
    "split_part",
    "strpos",
    "strtol",
    "substring",
    "textlen",
    "translate",
    "trim",
    "upper",
    "cast",
    "convert",
    "to_char",
    "to_date",
    "to_number",
    "json_array_length",
    "json_extract_array_element_text",
    "json_extract_path_text",
    "current_setting",
    "pg_cancel_backend",
    "pg_terminate_backend",
    "set_config",
    "current_database",
    "current_user",
    "current_user_id",
    "pg_backend_pid",
    "pg_last_copy_count",
    "pg_last_copy_id",
    "pg_last_query_id",
    "pg_last_unload_count",
    "session_user",
    "slice_num",
    "user",
    "version",
    "abbrev",
    "acosd",
    "any",
    "area",
    "array_agg",
    "array_append",
    "array_cat",
    "array_dims",
    "array_fill",
    "array_length",
    "array_lower",
    "array_ndims",
    "array_position",
    "array_positions",
    "array_prepend",
    "array_remove",
    "array_replace",
    "array_to_json",
    "array_to_string",
    "array_to_tsvector",
    "array_upper",
    "asind",
    "atan2d",
    "atand",
    "bit",
    "bit_length",
    "bound_box",
    "box",
    "brin_summarize_new_values",
    "broadcast",
    "cardinality",
    "center",
    "circle",
    "clock_timestamp",
    "col_description",
    "concat_ws",
    "convert_from",
    "convert_to",
    "corr",
    "cosd",
    "cotd",
    "covar_pop",
    "covar_samp",
    "current_catalog",
    "current_query",
    "current_role",
    "currval",
    "cursor_to_xml",
    "diameter",
    "div",
    "encode",
    "enum_first",
    "enum_last",
    "enum_range",
    "every",
    "family",
    "format",
    "format_type",
    "generate_series",
    "generate_subscripts",
    "get_current_ts_config",
    "gin_clean_pending_list",
    "grouping",
    "has_any_column_privilege",
    "has_column_privilege",
    "has_foreign_data_wrapper_privilege",
    "has_function_privilege",
    "has_language_privilege",
    "has_sequence_privilege",
    "has_server_privilege",
    "has_tablespace_privilege",
    "has_type_privilege",
    "height",
    "host",
    "hostmask",
    "inet_client_addr",
    "inet_client_port",
    "inet_merge",
    "inet_same_family",
    "inet_server_addr",
    "inet_server_port",
    "isclosed",
    "isempty",
    "isopen",
    "json_agg",
    "json_object",
    "json_object_agg",
    "json_populate_record",
    "json_populate_recordset",
    "json_to_record",
    "json_to_recordset",
    "jsonb_agg",
    "jsonb_object_agg",
    "justify_days",
    "justify_hours",
    "justify_interval",
    "lastval",
    "left",
    "line",
    "localtimestamp",
    "lower_inc",
    "lower_inf",
    "lpad",
    "lseg",
    "make_date",
    "make_interval",
    "make_time",
    "make_timestamp",
    "make_timestamptz",
    "masklen",
    "mode",
    "netmask",
    "network",
    "nextval",
    "npoints",
    "num_nonnulls",
    "num_nulls",
    "numnode",
    "obj_description",
    "overlay",
    "parse_ident",
    "path",
    "pclose",
    "percentile_disc",
    "pg_advisory_lock",
    "pg_advisory_lock_shared",
    "pg_advisory_unlock",
    "pg_advisory_unlock_all",
    "pg_advisory_unlock_shared",
    "pg_advisory_xact_lock",
    "pg_advisory_xact_lock_shared",
    "pg_backup_start_time",
    "pg_blocking_pids",
    "pg_client_encoding",
    "pg_collation_is_visible",
    "pg_column_size",
    "pg_conf_load_time",
    "pg_control_checkpoint",
    "pg_control_init",
    "pg_control_recovery",
    "pg_control_system",
    "pg_conversion_is_visible",
    "pg_create_logical_replication_slot",
    "pg_create_physical_replication_slot",
    "pg_create_restore_point",
    "pg_current_xlog_flush_location",
    "pg_current_xlog_insert_location",
    "pg_current_xlog_location",
    "pg_database_size",
    "pg_describe_object",
    "pg_drop_replication_slot",
    "pg_export_snapshot",
    "pg_filenode_relation",
    "pg_function_is_visible",
    "pg_get_constraintdef",
    "pg_get_expr",
    "pg_get_function_arguments",
    "pg_get_function_identity_arguments",
    "pg_get_function_result",
    "pg_get_functiondef",
    "pg_get_indexdef",
    "pg_get_keywords",
    "pg_get_object_address",
    "pg_get_owned_sequence",
    "pg_get_ruledef",
    "pg_get_serial_sequence",
    "pg_get_triggerdef",
    "pg_get_userbyid",
    "pg_get_viewdef",
    "pg_has_role",
    "pg_identify_object",
    "pg_identify_object_as_address",
    "pg_index_column_has_property",
    "pg_index_has_property",
    "pg_indexam_has_property",
    "pg_indexes_size",
    "pg_is_in_backup",
    "pg_is_in_recovery",
    "pg_is_other_temp_schema",
    "pg_is_xlog_replay_paused",
    "pg_last_committed_xact",
    "pg_last_xact_replay_timestamp",
    "pg_last_xlog_receive_location",
    "pg_last_xlog_replay_location",
    "pg_listening_channels",
    "pg_logical_emit_message",
    "pg_logical_slot_get_binary_changes",
    "pg_logical_slot_get_changes",
    "pg_logical_slot_peek_binary_changes",
    "pg_logical_slot_peek_changes",
    "pg_ls_dir",
    "pg_my_temp_schema",
    "pg_notification_queue_usage",
    "pg_opclass_is_visible",
    "pg_operator_is_visible",
    "pg_opfamily_is_visible",
    "pg_options_to_table",
    "pg_postmaster_start_time",
    "pg_read_binary_file",
    "pg_read_file",
    "pg_relation_filenode",
    "pg_relation_filepath",
    "pg_relation_size",
    "pg_reload_conf",
    "pg_replication_origin_create",
    "pg_replication_origin_drop",
    "pg_replication_origin_oid",
    "pg_replication_origin_progress",
    "pg_replication_origin_session_is_setup",
    "pg_replication_origin_session_progress",
    "pg_replication_origin_session_reset",
    "pg_replication_origin_session_setup",
    "pg_replication_origin_xact_reset",
    "pg_replication_origin_xact_setup",
    "pg_rotate_logfile",
    "pg_size_bytes",
    "pg_size_pretty",
    "pg_sleep",
    "pg_sleep_for",
    "pg_sleep_until",
    "pg_start_backup",
    "pg_stat_file",
    "pg_stop_backup",
    "pg_switch_xlog",
    "pg_table_is_visible",
    "pg_table_size",
    "pg_tablespace_databases",
    "pg_tablespace_location",
    "pg_tablespace_size",
    "pg_total_relation_size",
    "pg_trigger_depth",
    "pg_try_advisory_lock",
    "pg_try_advisory_lock_shared",
    "pg_try_advisory_xact_lock",
    "pg_try_advisory_xact_lock_shared",
    "pg_ts_config_is_visible",
    "pg_ts_dict_is_visible",
    "pg_ts_parser_is_visible",
    "pg_ts_template_is_visible",
    "pg_type_is_visible",
    "pg_typeof",
    "pg_xact_commit_timestamp",
    "pg_xlog_location_diff",
    "pg_xlog_replay_pause",
    "pg_xlog_replay_resume",
    "pg_xlogfile_name",
    "pg_xlogfile_name_offset",
    "phraseto_tsquery",
    "plainto_tsquery",
    "point",
    "polygon",
    "popen",
    "pqserverversion",
    "query_to_xml",
    "querytree",
    "quote_nullable",
    "radius",
    "range_merge",
    "regexp_matches",
    "regexp_split_to_array",
    "regexp_split_to_table",
    "regr_avgx",
    "regr_avgy",
    "regr_count",
    "regr_intercept",
    "regr_r2",
    "regr_slope",
    "regr_sxx",
    "regr_sxy",
    "regr_syy",
    "right",
    "row_security_active",
    "row_to_json",
    "rpad",
    "scale",
    "set_masklen",
    "setseed",
    "setval",
    "setweight",
    "shobj_description",
    "sind",
    "sprintf",
    "statement_timestamp",
    "stddev",
    "string_agg",
    "string_to_array",
    "strip",
    "substr",
    "table_to_xml",
    "table_to_xml_and_xmlschema",
    "tand",
    "text",
    "to_json",
    "to_regclass",
    "to_regnamespace",
    "to_regoper",
    "to_regoperator",
    "to_regproc",
    "to_regprocedure",
    "to_regrole",
    "to_regtype",
    "to_tsquery",
    "to_tsvector",
    "transaction_timestamp",
    "ts_debug",
    "ts_delete",
    "ts_filter",
    "ts_headline",
    "ts_lexize",
    "ts_parse",
    "ts_rank",
    "ts_rank_cd",
    "ts_rewrite",
    "ts_stat",
    "ts_token_type",
    "tsquery_phrase",
    "tsvector_to_array",
    "tsvector_update_trigger",
    "tsvector_update_trigger_column",
    "txid_current",
    "txid_current_snapshot",
    "txid_snapshot_xip",
    "txid_snapshot_xmax",
    "txid_snapshot_xmin",
    "txid_visible_in_snapshot",
    "unnest",
    "upper_inc",
    "upper_inf",
    "variance",
    "width",
    "width_bucket",
    "xml_is_well_formed",
    "xml_is_well_formed_content",
    "xml_is_well_formed_document",
    "xmlagg",
    "xmlcomment",
    "xmlconcat",
    "xmlelement",
    "xmlexists",
    "xmlforest",
    "xmlparse",
    "xmlpi",
    "xmlroot",
    "xmlserialize",
    "xpath",
    "xpath_exists"
  ],
  builtinVariables: [],
  pseudoColumns: [],
  tokenizer: {
    root: [
      { include: "@comments" },
      { include: "@whitespace" },
      { include: "@pseudoColumns" },
      { include: "@numbers" },
      { include: "@strings" },
      { include: "@complexIdentifiers" },
      { include: "@scopes" },
      [/[;,.]/, "delimiter"],
      [/[()]/, "@brackets"],
      [
        /[\w@#$]+/,
        {
          cases: {
            "@keywords": "keyword",
            "@operators": "operator",
            "@builtinVariables": "predefined",
            "@builtinFunctions": "predefined",
            "@default": "identifier"
          }
        }
      ],
      [/[<>=!%&+\-*/|~^]/, "operator"]
    ],
    whitespace: [[/\s+/, "white"]],
    comments: [
      [/--+.*/, "comment"],
      [/\/\*/, { token: "comment.quote", next: "@comment" }]
    ],
    comment: [
      [/[^*/]+/, "comment"],
      [/\*\//, { token: "comment.quote", next: "@pop" }],
      [/./, "comment"]
    ],
    pseudoColumns: [
      [
        /[$][A-Za-z_][\w@#$]*/,
        {
          cases: {
            "@pseudoColumns": "predefined",
            "@default": "identifier"
          }
        }
      ]
    ],
    numbers: [
      [/0[xX][0-9a-fA-F]*/, "number"],
      [/[$][+-]*\d*(\.\d*)?/, "number"],
      [/((\d+(\.\d*)?)|(\.\d+))([eE][\-+]?\d+)?/, "number"]
    ],
    strings: [[/'/, { token: "string", next: "@string" }]],
    string: [
      [/[^']+/, "string"],
      [/''/, "string"],
      [/'/, { token: "string", next: "@pop" }]
    ],
    complexIdentifiers: [[/"/, { token: "identifier.quote", next: "@quotedIdentifier" }]],
    quotedIdentifier: [
      [/[^"]+/, "identifier"],
      [/""/, "identifier"],
      [/"/, { token: "identifier.quote", next: "@pop" }]
    ],
    scopes: []
  }
};



/***/ })

}])
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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