"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpJwtAuthorizer = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
/**
 * Authorize Http Api routes on whether the requester is registered as part of
 * an AWS Cognito user pool.
 */
class HttpJwtAuthorizer {
    /**
     * Initialize a JWT authorizer to be bound with HTTP route.
     * @param id The id of the underlying construct
     * @param jwtIssuer The base domain of the identity provider that issues JWT
     * @param props Properties to configure the authorizer
     */
    constructor(id, jwtIssuer, props) {
        this.id = id;
        this.jwtIssuer = jwtIssuer;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_authorizers_alpha_HttpJwtAuthorizerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, HttpJwtAuthorizer);
            }
            throw error;
        }
    }
    bind(options) {
        if (!this.authorizer) {
            this.authorizer = new aws_apigatewayv2_alpha_1.HttpAuthorizer(options.scope, this.id, {
                httpApi: options.route.httpApi,
                identitySource: this.props.identitySource ?? ['$request.header.Authorization'],
                type: aws_apigatewayv2_alpha_1.HttpAuthorizerType.JWT,
                authorizerName: this.props.authorizerName ?? this.id,
                jwtAudience: this.props.jwtAudience,
                jwtIssuer: this.jwtIssuer,
            });
        }
        return {
            authorizerId: this.authorizer.authorizerId,
            authorizationType: 'JWT',
        };
    }
}
exports.HttpJwtAuthorizer = HttpJwtAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
HttpJwtAuthorizer[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-authorizers-alpha.HttpJwtAuthorizer", version: "2.36.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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