# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from .errors.api_key_or_account_subscriptions_exceptions import ApiKeyOrAccountSubscriptionsExceptions
from .errors.cached_response import CachedResponse
from .errors.exceeded_api_credits_or_surcharge import ExceededApiCreditsOrSurcharge
from .errors.exceeded_api_plan_limit import ExceededApiPlanLimit
from .errors.internal_server_error import InternalServerError
from .errors.invalid_parameters import InvalidParameters
from .errors.invalid_parameters_reverse import InvalidParametersReverse
from .errors.partial_response import PartialResponse
from .errors.record_not_found import RecordNotFound
from .errors.request_timed_out import RequestTimedOut
from .errors.service_is_unavailable import ServiceIsUnavailable
from .errors.success_response import SuccessResponse
from .errors.success_response_historical import SuccessResponseHistorical
from .errors.success_response_reverse import SuccessResponseReverse
from .errors.too_many_requests import TooManyRequests
from .errors.unable_to_fetch_whois import UnableToFetchWhois
from .errors.unavailable_domain_extension import UnavailableDomainExtension
from .types.asn_whois_response import AsnWhoisResponse
from .types.bulk_whois_response import BulkWhoisResponse
from .types.exception_body import ExceptionBody
from .types.ip_whois_response import IpWhoisResponse
from .types.whois_response import WhoisResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawWhoisClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def live_lookup(
        self, *, api_key: str, domain_name: str, whois: str, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[WhoisResponse]:
        """
        Get live WHOIS information for a domain

        Parameters
        ----------
        api_key : str

        domain_name : str

        whois : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[WhoisResponse]
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1.0/whois",
            base_url=self._client_wrapper.get_environment().apis,
            method="GET",
            params={
                "apiKey": api_key,
                "domainName": domain_name,
                "whois": whois,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WhoisResponse,
                    parse_obj_as(
                        type_=WhoisResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 200:
                raise SuccessResponse(
                    typing.cast(
                        WhoisResponse,
                        parse_obj_as(
                            type_=WhoisResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 206:
                raise PartialResponse(
                    typing.cast(
                        WhoisResponse,
                        parse_obj_as(
                            type_=WhoisResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 210:
                raise CachedResponse(
                    typing.cast(
                        WhoisResponse,
                        parse_obj_as(
                            type_=WhoisResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 400:
                raise InvalidParameters(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise ApiKeyOrAccountSubscriptionsExceptions(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise UnavailableDomainExtension(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 408:
                raise UnableToFetchWhois(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 412:
                raise ExceededApiPlanLimit(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 413:
                raise ExceededApiCreditsOrSurcharge(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequests(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 503:
                raise ServiceIsUnavailable(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 504:
                raise RequestTimedOut(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    def historical_lookup(
        self,
        *,
        api_key: str,
        domain_name: str,
        whois: str,
        page: typing.Optional[str] = None,
        format: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[WhoisResponse]:
        """
        Get historical WHOIS records for a domain

        Parameters
        ----------
        api_key : str

        domain_name : str

        whois : str

        page : typing.Optional[str]

        format : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[WhoisResponse]
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1.0/whois",
            base_url=self._client_wrapper.get_environment().apis,
            method="GET",
            params={
                "apiKey": api_key,
                "domainName": domain_name,
                "whois": whois,
                "page": page,
                "format": format,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WhoisResponse,
                    parse_obj_as(
                        type_=WhoisResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 200:
                raise SuccessResponseHistorical(
                    typing.cast(
                        WhoisResponse,
                        parse_obj_as(
                            type_=WhoisResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 400:
                raise InvalidParameters(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise ApiKeyOrAccountSubscriptionsExceptions(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise RecordNotFound(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 412:
                raise ExceededApiPlanLimit(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 413:
                raise ExceededApiCreditsOrSurcharge(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequests(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 503:
                raise ServiceIsUnavailable(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 504:
                raise RequestTimedOut(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    def reverse_lookup(
        self,
        *,
        api_key: str,
        whois: str,
        keyword: typing.Optional[str] = None,
        email: typing.Optional[str] = None,
        owner: typing.Optional[str] = None,
        company: typing.Optional[str] = None,
        mode: typing.Optional[str] = None,
        exact: typing.Optional[str] = None,
        format: typing.Optional[str] = None,
        includes: typing.Optional[str] = None,
        page: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[WhoisResponse]:
        """
        Perform a reverse WHOIS lookup based on registrant information

        Parameters
        ----------
        api_key : str

        whois : str

        keyword : typing.Optional[str]

        email : typing.Optional[str]

        owner : typing.Optional[str]

        company : typing.Optional[str]

        mode : typing.Optional[str]

        exact : typing.Optional[str]

        format : typing.Optional[str]

        includes : typing.Optional[str]

        page : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[WhoisResponse]
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1.0/whois",
            base_url=self._client_wrapper.get_environment().apis,
            method="GET",
            params={
                "apiKey": api_key,
                "whois": whois,
                "keyword": keyword,
                "email": email,
                "owner": owner,
                "company": company,
                "mode": mode,
                "exact": exact,
                "format": format,
                "includes": includes,
                "page": page,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WhoisResponse,
                    parse_obj_as(
                        type_=WhoisResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 200:
                raise SuccessResponseReverse(
                    typing.cast(
                        WhoisResponse,
                        parse_obj_as(
                            type_=WhoisResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 400:
                raise InvalidParametersReverse(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise ApiKeyOrAccountSubscriptionsExceptions(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise RecordNotFound(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 412:
                raise ExceededApiPlanLimit(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 413:
                raise ExceededApiCreditsOrSurcharge(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequests(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 503:
                raise ServiceIsUnavailable(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 504:
                raise RequestTimedOut(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    def ip_whois_lookup(
        self,
        *,
        api_key: str,
        ip: str,
        format: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[IpWhoisResponse]:
        """
        Get WHOIS information for an IP

        Parameters
        ----------
        api_key : str

        ip : str

        format : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[IpWhoisResponse]
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1.0/ip-whois",
            base_url=self._client_wrapper.get_environment().apis,
            method="GET",
            params={
                "apiKey": api_key,
                "ip": ip,
                "format": format,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    IpWhoisResponse,
                    parse_obj_as(
                        type_=IpWhoisResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    def asn_whois_lookup(
        self,
        *,
        api_key: str,
        asn: str,
        format: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[AsnWhoisResponse]:
        """
        Get WHOIS information for an ASN

        Parameters
        ----------
        api_key : str

        asn : str

        format : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[AsnWhoisResponse]
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1.0/asn-whois",
            base_url=self._client_wrapper.get_environment().apis,
            method="GET",
            params={
                "apiKey": api_key,
                "asn": asn,
                "format": format,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    AsnWhoisResponse,
                    parse_obj_as(
                        type_=AsnWhoisResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    def bulk_domain_lookup(
        self,
        *,
        api_key: str,
        domain_names: typing.Sequence[str],
        format: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[BulkWhoisResponse]:
        """
        Get Live WHOIS information for more than one domain names

        Parameters
        ----------
        api_key : str

        domain_names : typing.Sequence[str]

        format : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[BulkWhoisResponse]
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1.0/bulkwhois",
            base_url=self._client_wrapper.get_environment().apis,
            method="POST",
            params={
                "apiKey": api_key,
                "format": format,
            },
            json={
                "domainNames": domain_names,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    BulkWhoisResponse,
                    parse_obj_as(
                        type_=BulkWhoisResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)


class AsyncRawWhoisClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def live_lookup(
        self, *, api_key: str, domain_name: str, whois: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[WhoisResponse]:
        """
        Get live WHOIS information for a domain

        Parameters
        ----------
        api_key : str

        domain_name : str

        whois : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[WhoisResponse]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1.0/whois",
            base_url=self._client_wrapper.get_environment().apis,
            method="GET",
            params={
                "apiKey": api_key,
                "domainName": domain_name,
                "whois": whois,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WhoisResponse,
                    parse_obj_as(
                        type_=WhoisResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 200:
                raise SuccessResponse(
                    typing.cast(
                        WhoisResponse,
                        parse_obj_as(
                            type_=WhoisResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 206:
                raise PartialResponse(
                    typing.cast(
                        WhoisResponse,
                        parse_obj_as(
                            type_=WhoisResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 210:
                raise CachedResponse(
                    typing.cast(
                        WhoisResponse,
                        parse_obj_as(
                            type_=WhoisResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 400:
                raise InvalidParameters(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise ApiKeyOrAccountSubscriptionsExceptions(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise UnavailableDomainExtension(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 408:
                raise UnableToFetchWhois(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 412:
                raise ExceededApiPlanLimit(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 413:
                raise ExceededApiCreditsOrSurcharge(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequests(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 503:
                raise ServiceIsUnavailable(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 504:
                raise RequestTimedOut(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    async def historical_lookup(
        self,
        *,
        api_key: str,
        domain_name: str,
        whois: str,
        page: typing.Optional[str] = None,
        format: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[WhoisResponse]:
        """
        Get historical WHOIS records for a domain

        Parameters
        ----------
        api_key : str

        domain_name : str

        whois : str

        page : typing.Optional[str]

        format : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[WhoisResponse]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1.0/whois",
            base_url=self._client_wrapper.get_environment().apis,
            method="GET",
            params={
                "apiKey": api_key,
                "domainName": domain_name,
                "whois": whois,
                "page": page,
                "format": format,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WhoisResponse,
                    parse_obj_as(
                        type_=WhoisResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 200:
                raise SuccessResponseHistorical(
                    typing.cast(
                        WhoisResponse,
                        parse_obj_as(
                            type_=WhoisResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 400:
                raise InvalidParameters(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise ApiKeyOrAccountSubscriptionsExceptions(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise RecordNotFound(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 412:
                raise ExceededApiPlanLimit(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 413:
                raise ExceededApiCreditsOrSurcharge(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequests(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 503:
                raise ServiceIsUnavailable(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 504:
                raise RequestTimedOut(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    async def reverse_lookup(
        self,
        *,
        api_key: str,
        whois: str,
        keyword: typing.Optional[str] = None,
        email: typing.Optional[str] = None,
        owner: typing.Optional[str] = None,
        company: typing.Optional[str] = None,
        mode: typing.Optional[str] = None,
        exact: typing.Optional[str] = None,
        format: typing.Optional[str] = None,
        includes: typing.Optional[str] = None,
        page: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[WhoisResponse]:
        """
        Perform a reverse WHOIS lookup based on registrant information

        Parameters
        ----------
        api_key : str

        whois : str

        keyword : typing.Optional[str]

        email : typing.Optional[str]

        owner : typing.Optional[str]

        company : typing.Optional[str]

        mode : typing.Optional[str]

        exact : typing.Optional[str]

        format : typing.Optional[str]

        includes : typing.Optional[str]

        page : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[WhoisResponse]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1.0/whois",
            base_url=self._client_wrapper.get_environment().apis,
            method="GET",
            params={
                "apiKey": api_key,
                "whois": whois,
                "keyword": keyword,
                "email": email,
                "owner": owner,
                "company": company,
                "mode": mode,
                "exact": exact,
                "format": format,
                "includes": includes,
                "page": page,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WhoisResponse,
                    parse_obj_as(
                        type_=WhoisResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 200:
                raise SuccessResponseReverse(
                    typing.cast(
                        WhoisResponse,
                        parse_obj_as(
                            type_=WhoisResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 400:
                raise InvalidParametersReverse(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise ApiKeyOrAccountSubscriptionsExceptions(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise RecordNotFound(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 412:
                raise ExceededApiPlanLimit(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 413:
                raise ExceededApiCreditsOrSurcharge(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequests(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 503:
                raise ServiceIsUnavailable(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 504:
                raise RequestTimedOut(
                    typing.cast(
                        ExceptionBody,
                        parse_obj_as(
                            type_=ExceptionBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    async def ip_whois_lookup(
        self,
        *,
        api_key: str,
        ip: str,
        format: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[IpWhoisResponse]:
        """
        Get WHOIS information for an IP

        Parameters
        ----------
        api_key : str

        ip : str

        format : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[IpWhoisResponse]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1.0/ip-whois",
            base_url=self._client_wrapper.get_environment().apis,
            method="GET",
            params={
                "apiKey": api_key,
                "ip": ip,
                "format": format,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    IpWhoisResponse,
                    parse_obj_as(
                        type_=IpWhoisResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    async def asn_whois_lookup(
        self,
        *,
        api_key: str,
        asn: str,
        format: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[AsnWhoisResponse]:
        """
        Get WHOIS information for an ASN

        Parameters
        ----------
        api_key : str

        asn : str

        format : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[AsnWhoisResponse]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1.0/asn-whois",
            base_url=self._client_wrapper.get_environment().apis,
            method="GET",
            params={
                "apiKey": api_key,
                "asn": asn,
                "format": format,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    AsnWhoisResponse,
                    parse_obj_as(
                        type_=AsnWhoisResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    async def bulk_domain_lookup(
        self,
        *,
        api_key: str,
        domain_names: typing.Sequence[str],
        format: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[BulkWhoisResponse]:
        """
        Get Live WHOIS information for more than one domain names

        Parameters
        ----------
        api_key : str

        domain_names : typing.Sequence[str]

        format : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[BulkWhoisResponse]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1.0/bulkwhois",
            base_url=self._client_wrapper.get_environment().apis,
            method="POST",
            params={
                "apiKey": api_key,
                "format": format,
            },
            json={
                "domainNames": domain_names,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    BulkWhoisResponse,
                    parse_obj_as(
                        type_=BulkWhoisResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)
