# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawWhoisClient, RawWhoisClient
from .types.asn_whois_response import AsnWhoisResponse
from .types.bulk_whois_response import BulkWhoisResponse
from .types.ip_whois_response import IpWhoisResponse
from .types.whois_response import WhoisResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class WhoisClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawWhoisClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawWhoisClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawWhoisClient
        """
        return self._raw_client

    def live_lookup(
        self, *, api_key: str, domain_name: str, whois: str, request_options: typing.Optional[RequestOptions] = None
    ) -> WhoisResponse:
        """
        Get live WHOIS information for a domain

        Parameters
        ----------
        api_key : str

        domain_name : str

        whois : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WhoisResponse

        Examples
        --------
        from whoisfreaks import WhoisfreaksApi
        from whoisfreaks.environment import WhoisfreaksApiEnvironment
        client = WhoisfreaksApi(environment=WhoisfreaksApiEnvironment.PRODUCTION, )
        client.whois.live_lookup(api_key='YOUR_API_KEY', domain_name='888starzci.ci', whois='live', )
        """
        _response = self._raw_client.live_lookup(
            api_key=api_key, domain_name=domain_name, whois=whois, request_options=request_options
        )
        return _response.data

    def historical_lookup(
        self,
        *,
        api_key: str,
        domain_name: str,
        whois: str,
        page: typing.Optional[str] = None,
        format: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WhoisResponse:
        """
        Get historical WHOIS records for a domain

        Parameters
        ----------
        api_key : str

        domain_name : str

        whois : str

        page : typing.Optional[str]

        format : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WhoisResponse

        Examples
        --------
        from whoisfreaks import WhoisfreaksApi
        from whoisfreaks.environment import WhoisfreaksApiEnvironment
        client = WhoisfreaksApi(environment=WhoisfreaksApiEnvironment.PRODUCTION, )
        client.whois.historical_lookup(api_key='YOUR_API_KEY', domain_name='whoisfreaks.com', whois='historical', )
        """
        _response = self._raw_client.historical_lookup(
            api_key=api_key,
            domain_name=domain_name,
            whois=whois,
            page=page,
            format=format,
            request_options=request_options,
        )
        return _response.data

    def reverse_lookup(
        self,
        *,
        api_key: str,
        whois: str,
        keyword: typing.Optional[str] = None,
        email: typing.Optional[str] = None,
        owner: typing.Optional[str] = None,
        company: typing.Optional[str] = None,
        mode: typing.Optional[str] = None,
        exact: typing.Optional[str] = None,
        format: typing.Optional[str] = None,
        includes: typing.Optional[str] = None,
        page: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WhoisResponse:
        """
        Perform a reverse WHOIS lookup based on registrant information

        Parameters
        ----------
        api_key : str

        whois : str

        keyword : typing.Optional[str]

        email : typing.Optional[str]

        owner : typing.Optional[str]

        company : typing.Optional[str]

        mode : typing.Optional[str]

        exact : typing.Optional[str]

        format : typing.Optional[str]

        includes : typing.Optional[str]

        page : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WhoisResponse

        Examples
        --------
        from whoisfreaks import WhoisfreaksApi
        from whoisfreaks.environment import WhoisfreaksApiEnvironment
        client = WhoisfreaksApi(environment=WhoisfreaksApiEnvironment.PRODUCTION, )
        client.whois.reverse_lookup(api_key='YOUR_API_KEY', whois='reverse', keyword='google', )
        """
        _response = self._raw_client.reverse_lookup(
            api_key=api_key,
            whois=whois,
            keyword=keyword,
            email=email,
            owner=owner,
            company=company,
            mode=mode,
            exact=exact,
            format=format,
            includes=includes,
            page=page,
            request_options=request_options,
        )
        return _response.data

    def ip_whois_lookup(
        self,
        *,
        api_key: str,
        ip: str,
        format: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> IpWhoisResponse:
        """
        Get WHOIS information for an IP

        Parameters
        ----------
        api_key : str

        ip : str

        format : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        IpWhoisResponse

        Examples
        --------
        from whoisfreaks import WhoisfreaksApi
        from whoisfreaks.environment import WhoisfreaksApiEnvironment
        client = WhoisfreaksApi(environment=WhoisfreaksApiEnvironment.PRODUCTION, )
        client.whois.ip_whois_lookup(api_key='YOUR_API_KEY', ip='8.8.8.8', )
        """
        _response = self._raw_client.ip_whois_lookup(
            api_key=api_key, ip=ip, format=format, request_options=request_options
        )
        return _response.data

    def asn_whois_lookup(
        self,
        *,
        api_key: str,
        asn: str,
        format: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsnWhoisResponse:
        """
        Get WHOIS information for an ASN

        Parameters
        ----------
        api_key : str

        asn : str

        format : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsnWhoisResponse

        Examples
        --------
        from whoisfreaks import WhoisfreaksApi
        from whoisfreaks.environment import WhoisfreaksApiEnvironment
        client = WhoisfreaksApi(environment=WhoisfreaksApiEnvironment.PRODUCTION, )
        client.whois.asn_whois_lookup(api_key='YOUR_API_KEY', asn='1', )
        """
        _response = self._raw_client.asn_whois_lookup(
            api_key=api_key, asn=asn, format=format, request_options=request_options
        )
        return _response.data

    def bulk_domain_lookup(
        self,
        *,
        api_key: str,
        domain_names: typing.Sequence[str],
        format: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> BulkWhoisResponse:
        """
        Get Live WHOIS information for more than one domain names

        Parameters
        ----------
        api_key : str

        domain_names : typing.Sequence[str]

        format : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BulkWhoisResponse

        Examples
        --------
        from whoisfreaks import WhoisfreaksApi
        from whoisfreaks.environment import WhoisfreaksApiEnvironment
        client = WhoisfreaksApi(environment=WhoisfreaksApiEnvironment.PRODUCTION, )
        client.whois.bulk_domain_lookup(api_key='YOUR_API_KEY', format='json', domain_names=['whoisfreaks.com', 'jfreaks.com'], )
        """
        _response = self._raw_client.bulk_domain_lookup(
            api_key=api_key, domain_names=domain_names, format=format, request_options=request_options
        )
        return _response.data


class AsyncWhoisClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawWhoisClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawWhoisClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawWhoisClient
        """
        return self._raw_client

    async def live_lookup(
        self, *, api_key: str, domain_name: str, whois: str, request_options: typing.Optional[RequestOptions] = None
    ) -> WhoisResponse:
        """
        Get live WHOIS information for a domain

        Parameters
        ----------
        api_key : str

        domain_name : str

        whois : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WhoisResponse

        Examples
        --------
        from whoisfreaks import AsyncWhoisfreaksApi
        from whoisfreaks.environment import WhoisfreaksApiEnvironment
        import asyncio
        client = AsyncWhoisfreaksApi(environment=WhoisfreaksApiEnvironment.PRODUCTION, )
        async def main() -> None:
            await client.whois.live_lookup(api_key='YOUR_API_KEY', domain_name='888starzci.ci', whois='live', )
        asyncio.run(main())
        """
        _response = await self._raw_client.live_lookup(
            api_key=api_key, domain_name=domain_name, whois=whois, request_options=request_options
        )
        return _response.data

    async def historical_lookup(
        self,
        *,
        api_key: str,
        domain_name: str,
        whois: str,
        page: typing.Optional[str] = None,
        format: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WhoisResponse:
        """
        Get historical WHOIS records for a domain

        Parameters
        ----------
        api_key : str

        domain_name : str

        whois : str

        page : typing.Optional[str]

        format : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WhoisResponse

        Examples
        --------
        from whoisfreaks import AsyncWhoisfreaksApi
        from whoisfreaks.environment import WhoisfreaksApiEnvironment
        import asyncio
        client = AsyncWhoisfreaksApi(environment=WhoisfreaksApiEnvironment.PRODUCTION, )
        async def main() -> None:
            await client.whois.historical_lookup(api_key='YOUR_API_KEY', domain_name='whoisfreaks.com', whois='historical', )
        asyncio.run(main())
        """
        _response = await self._raw_client.historical_lookup(
            api_key=api_key,
            domain_name=domain_name,
            whois=whois,
            page=page,
            format=format,
            request_options=request_options,
        )
        return _response.data

    async def reverse_lookup(
        self,
        *,
        api_key: str,
        whois: str,
        keyword: typing.Optional[str] = None,
        email: typing.Optional[str] = None,
        owner: typing.Optional[str] = None,
        company: typing.Optional[str] = None,
        mode: typing.Optional[str] = None,
        exact: typing.Optional[str] = None,
        format: typing.Optional[str] = None,
        includes: typing.Optional[str] = None,
        page: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WhoisResponse:
        """
        Perform a reverse WHOIS lookup based on registrant information

        Parameters
        ----------
        api_key : str

        whois : str

        keyword : typing.Optional[str]

        email : typing.Optional[str]

        owner : typing.Optional[str]

        company : typing.Optional[str]

        mode : typing.Optional[str]

        exact : typing.Optional[str]

        format : typing.Optional[str]

        includes : typing.Optional[str]

        page : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WhoisResponse

        Examples
        --------
        from whoisfreaks import AsyncWhoisfreaksApi
        from whoisfreaks.environment import WhoisfreaksApiEnvironment
        import asyncio
        client = AsyncWhoisfreaksApi(environment=WhoisfreaksApiEnvironment.PRODUCTION, )
        async def main() -> None:
            await client.whois.reverse_lookup(api_key='YOUR_API_KEY', whois='reverse', keyword='google', )
        asyncio.run(main())
        """
        _response = await self._raw_client.reverse_lookup(
            api_key=api_key,
            whois=whois,
            keyword=keyword,
            email=email,
            owner=owner,
            company=company,
            mode=mode,
            exact=exact,
            format=format,
            includes=includes,
            page=page,
            request_options=request_options,
        )
        return _response.data

    async def ip_whois_lookup(
        self,
        *,
        api_key: str,
        ip: str,
        format: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> IpWhoisResponse:
        """
        Get WHOIS information for an IP

        Parameters
        ----------
        api_key : str

        ip : str

        format : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        IpWhoisResponse

        Examples
        --------
        from whoisfreaks import AsyncWhoisfreaksApi
        from whoisfreaks.environment import WhoisfreaksApiEnvironment
        import asyncio
        client = AsyncWhoisfreaksApi(environment=WhoisfreaksApiEnvironment.PRODUCTION, )
        async def main() -> None:
            await client.whois.ip_whois_lookup(api_key='YOUR_API_KEY', ip='8.8.8.8', )
        asyncio.run(main())
        """
        _response = await self._raw_client.ip_whois_lookup(
            api_key=api_key, ip=ip, format=format, request_options=request_options
        )
        return _response.data

    async def asn_whois_lookup(
        self,
        *,
        api_key: str,
        asn: str,
        format: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsnWhoisResponse:
        """
        Get WHOIS information for an ASN

        Parameters
        ----------
        api_key : str

        asn : str

        format : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsnWhoisResponse

        Examples
        --------
        from whoisfreaks import AsyncWhoisfreaksApi
        from whoisfreaks.environment import WhoisfreaksApiEnvironment
        import asyncio
        client = AsyncWhoisfreaksApi(environment=WhoisfreaksApiEnvironment.PRODUCTION, )
        async def main() -> None:
            await client.whois.asn_whois_lookup(api_key='YOUR_API_KEY', asn='1', )
        asyncio.run(main())
        """
        _response = await self._raw_client.asn_whois_lookup(
            api_key=api_key, asn=asn, format=format, request_options=request_options
        )
        return _response.data

    async def bulk_domain_lookup(
        self,
        *,
        api_key: str,
        domain_names: typing.Sequence[str],
        format: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> BulkWhoisResponse:
        """
        Get Live WHOIS information for more than one domain names

        Parameters
        ----------
        api_key : str

        domain_names : typing.Sequence[str]

        format : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BulkWhoisResponse

        Examples
        --------
        from whoisfreaks import AsyncWhoisfreaksApi
        from whoisfreaks.environment import WhoisfreaksApiEnvironment
        import asyncio
        client = AsyncWhoisfreaksApi(environment=WhoisfreaksApiEnvironment.PRODUCTION, )
        async def main() -> None:
            await client.whois.bulk_domain_lookup(api_key='YOUR_API_KEY', format='json', domain_names=['whoisfreaks.com', 'jfreaks.com'], )
        asyncio.run(main())
        """
        _response = await self._raw_client.bulk_domain_lookup(
            api_key=api_key, domain_names=domain_names, format=format, request_options=request_options
        )
        return _response.data
