# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from .ssl_extensions import SslExtensions
from .ssl_issuer import SslIssuer
from .ssl_public_key import SslPublicKey
from .ssl_subject import SslSubject


class SslCertificate(UniversalBaseModel):
    chain_order: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="chainOrder")] = None
    authentication_type: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="authenticationType")
    ] = None
    validity_start_date: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="validityStartDate")] = (
        None
    )
    validity_end_date: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="validityEndDate")] = None
    serial_number: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="serialNumber")] = None
    signature_algorithm: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="signatureAlgorithm")
    ] = None
    subject: typing.Optional[SslSubject] = None
    issuer: typing.Optional[SslIssuer] = None
    public_key: typing_extensions.Annotated[typing.Optional[SslPublicKey], FieldMetadata(alias="publicKey")] = None
    extensions: typing.Optional[SslExtensions] = None
    pem_raw: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="pemRaw")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
