# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawSslClient, RawSslClient
from .types.ssl_live_lookup_response import SslLiveLookupResponse


class SslClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSslClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSslClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSslClient
        """
        return self._raw_client

    def ssl_live_lookup(
        self,
        *,
        api_key: str,
        domain_name: str,
        chain: typing.Optional[bool] = None,
        ssl_raw: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SslLiveLookupResponse:
        """
        Retrieve live SSL certificate details for a domain

        Parameters
        ----------
        api_key : str

        domain_name : str

        chain : typing.Optional[bool]

        ssl_raw : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SslLiveLookupResponse

        Examples
        --------
        from whoisfreaks import WhoisfreaksApi
        from whoisfreaks.environment import WhoisfreaksApiEnvironment
        client = WhoisfreaksApi(environment=WhoisfreaksApiEnvironment.PRODUCTION, )
        client.ssl.ssl_live_lookup(api_key='YOUR_API_KEY', domain_name='google.com', chain=True, ssl_raw=True, )
        """
        _response = self._raw_client.ssl_live_lookup(
            api_key=api_key, domain_name=domain_name, chain=chain, ssl_raw=ssl_raw, request_options=request_options
        )
        return _response.data


class AsyncSslClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSslClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSslClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSslClient
        """
        return self._raw_client

    async def ssl_live_lookup(
        self,
        *,
        api_key: str,
        domain_name: str,
        chain: typing.Optional[bool] = None,
        ssl_raw: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SslLiveLookupResponse:
        """
        Retrieve live SSL certificate details for a domain

        Parameters
        ----------
        api_key : str

        domain_name : str

        chain : typing.Optional[bool]

        ssl_raw : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SslLiveLookupResponse

        Examples
        --------
        from whoisfreaks import AsyncWhoisfreaksApi
        from whoisfreaks.environment import WhoisfreaksApiEnvironment
        import asyncio
        client = AsyncWhoisfreaksApi(environment=WhoisfreaksApiEnvironment.PRODUCTION, )
        async def main() -> None:
            await client.ssl.ssl_live_lookup(api_key='YOUR_API_KEY', domain_name='google.com', chain=True, ssl_raw=True, )
        asyncio.run(main())
        """
        _response = await self._raw_client.ssl_live_lookup(
            api_key=api_key, domain_name=domain_name, chain=chain, ssl_raw=ssl_raw, request_options=request_options
        )
        return _response.data
