# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from .types.file_status_api_response import FileStatusApiResponse


class RawFileStatusClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def file_status_api(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[FileStatusApiResponse]:
        """
        The Whois Files Status API provides comprehensive details about the availability and update status of various Whois datasets. It includes several key datasets, such as:
        - Newly registered domains: Includes cleaned gTLDs, cleaned ccTLDs, gTLDs, DNS records, and ccTLDs.
        - Expired domains: Covers both cleaned and regular expired domains.
        - Dropped domains: Details on domains that have been removed or dropped.

        In addition to these datasets, the API offers information on the update frequency of Whois and DNS data. Updates are available in three time intervals:
        - Daily: Regularly updated Whois and DNS data.
        - Weekly: Whois and DNS data refreshed on a weekly basis.
        - Monthly: Monthly updates are provided for Whois data, though DNS updates may not always be available.
        This structure enables users to track the currency and availability of various domain datasets, ensuring access to the latest WHOIS and DNS information.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[FileStatusApiResponse]
        """
        _response = self._client_wrapper.httpx_client.request(
            "v3.2/status",
            base_url=self._client_wrapper.get_environment().files,
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    FileStatusApiResponse,
                    parse_obj_as(
                        type_=FileStatusApiResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)


class AsyncRawFileStatusClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def file_status_api(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[FileStatusApiResponse]:
        """
        The Whois Files Status API provides comprehensive details about the availability and update status of various Whois datasets. It includes several key datasets, such as:
        - Newly registered domains: Includes cleaned gTLDs, cleaned ccTLDs, gTLDs, DNS records, and ccTLDs.
        - Expired domains: Covers both cleaned and regular expired domains.
        - Dropped domains: Details on domains that have been removed or dropped.

        In addition to these datasets, the API offers information on the update frequency of Whois and DNS data. Updates are available in three time intervals:
        - Daily: Regularly updated Whois and DNS data.
        - Weekly: Whois and DNS data refreshed on a weekly basis.
        - Monthly: Monthly updates are provided for Whois data, though DNS updates may not always be available.
        This structure enables users to track the currency and availability of various domain datasets, ensuring access to the latest WHOIS and DNS information.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[FileStatusApiResponse]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v3.2/status",
            base_url=self._client_wrapper.get_environment().files,
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    FileStatusApiResponse,
                    parse_obj_as(
                        type_=FileStatusApiResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)
