# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from .types.bulk_dns_response import BulkDnsResponse
from .types.dns_historical_response import DnsHistoricalResponse
from .types.dns_live_response import DnsLiveResponse
from .types.dns_reverse_response import DnsReverseResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawDnsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def live_dns_lookup(
        self,
        *,
        api_key: str,
        type: str,
        domain_name: typing.Optional[str] = None,
        ip_address: typing.Optional[str] = None,
        format: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[DnsLiveResponse]:
        """
        Get Live DNS information for a domain or an IP address

        Parameters
        ----------
        api_key : str

        type : str

        domain_name : typing.Optional[str]

        ip_address : typing.Optional[str]

        format : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DnsLiveResponse]
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2.0/dns/live",
            base_url=self._client_wrapper.get_environment().apis,
            method="GET",
            params={
                "apiKey": api_key,
                "domainName": domain_name,
                "ipAddress": ip_address,
                "type": type,
                "format": format,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DnsLiveResponse,
                    parse_obj_as(
                        type_=DnsLiveResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    def ns_lookup(
        self,
        *,
        api_key: str,
        type: str,
        domain_name: typing.Optional[str] = None,
        format: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[DnsLiveResponse]:
        """
        Get NS information for a domain

        Parameters
        ----------
        api_key : str

        type : str

        domain_name : typing.Optional[str]

        format : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DnsLiveResponse]
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2.0/dns/live",
            base_url=self._client_wrapper.get_environment().apis,
            method="GET",
            params={
                "apiKey": api_key,
                "domainName": domain_name,
                "type": type,
                "format": format,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DnsLiveResponse,
                    parse_obj_as(
                        type_=DnsLiveResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    def mx_lookup(
        self,
        *,
        api_key: str,
        type: str,
        domain_name: typing.Optional[str] = None,
        format: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[DnsLiveResponse]:
        """
        Get MX information for a domain

        Parameters
        ----------
        api_key : str

        type : str

        domain_name : typing.Optional[str]

        format : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DnsLiveResponse]
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2.0/dns/live",
            base_url=self._client_wrapper.get_environment().apis,
            method="GET",
            params={
                "apiKey": api_key,
                "domainName": domain_name,
                "type": type,
                "format": format,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DnsLiveResponse,
                    parse_obj_as(
                        type_=DnsLiveResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    def historical_dns_lookup(
        self,
        *,
        api_key: str,
        domain_name: str,
        type: str,
        page: typing.Optional[int] = None,
        format: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[DnsHistoricalResponse]:
        """
        Get Historical DNS information for a domain

        Parameters
        ----------
        api_key : str

        domain_name : str

        type : str

        page : typing.Optional[int]

        format : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DnsHistoricalResponse]
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2.0/dns/historical",
            base_url=self._client_wrapper.get_environment().apis,
            method="GET",
            params={
                "apiKey": api_key,
                "domainName": domain_name,
                "type": type,
                "page": page,
                "format": format,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DnsHistoricalResponse,
                    parse_obj_as(
                        type_=DnsHistoricalResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    def reverse_dns_lookup(
        self,
        *,
        api_key: str,
        value: str,
        type: str,
        page: typing.Optional[int] = None,
        format: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[DnsReverseResponse]:
        """
        Get Reverse DNS info for a DNS record

        Parameters
        ----------
        api_key : str

        value : str

        type : str

        page : typing.Optional[int]

        format : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DnsReverseResponse]
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2.0/dns/reverse",
            base_url=self._client_wrapper.get_environment().apis,
            method="GET",
            params={
                "apiKey": api_key,
                "value": value,
                "type": type,
                "page": page,
                "format": format,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DnsReverseResponse,
                    parse_obj_as(
                        type_=DnsReverseResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    def bulk_dns_lookup(
        self,
        *,
        api_key: str,
        type: str,
        format: typing.Optional[str] = None,
        domain_names: typing.Optional[typing.Sequence[str]] = OMIT,
        ip_addresses: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[BulkDnsResponse]:
        """
        Get Bulk DNS information for multiple domains or IP addresses

        Parameters
        ----------
        api_key : str

        type : str

        format : typing.Optional[str]

        domain_names : typing.Optional[typing.Sequence[str]]

        ip_addresses : typing.Optional[typing.Sequence[str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[BulkDnsResponse]
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2.0/dns/bulk/live",
            base_url=self._client_wrapper.get_environment().apis,
            method="POST",
            params={
                "apiKey": api_key,
                "type": type,
                "format": format,
            },
            json={
                "domainNames": domain_names,
                "ipAddresses": ip_addresses,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    BulkDnsResponse,
                    parse_obj_as(
                        type_=BulkDnsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)


class AsyncRawDnsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def live_dns_lookup(
        self,
        *,
        api_key: str,
        type: str,
        domain_name: typing.Optional[str] = None,
        ip_address: typing.Optional[str] = None,
        format: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[DnsLiveResponse]:
        """
        Get Live DNS information for a domain or an IP address

        Parameters
        ----------
        api_key : str

        type : str

        domain_name : typing.Optional[str]

        ip_address : typing.Optional[str]

        format : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DnsLiveResponse]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2.0/dns/live",
            base_url=self._client_wrapper.get_environment().apis,
            method="GET",
            params={
                "apiKey": api_key,
                "domainName": domain_name,
                "ipAddress": ip_address,
                "type": type,
                "format": format,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DnsLiveResponse,
                    parse_obj_as(
                        type_=DnsLiveResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    async def ns_lookup(
        self,
        *,
        api_key: str,
        type: str,
        domain_name: typing.Optional[str] = None,
        format: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[DnsLiveResponse]:
        """
        Get NS information for a domain

        Parameters
        ----------
        api_key : str

        type : str

        domain_name : typing.Optional[str]

        format : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DnsLiveResponse]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2.0/dns/live",
            base_url=self._client_wrapper.get_environment().apis,
            method="GET",
            params={
                "apiKey": api_key,
                "domainName": domain_name,
                "type": type,
                "format": format,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DnsLiveResponse,
                    parse_obj_as(
                        type_=DnsLiveResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    async def mx_lookup(
        self,
        *,
        api_key: str,
        type: str,
        domain_name: typing.Optional[str] = None,
        format: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[DnsLiveResponse]:
        """
        Get MX information for a domain

        Parameters
        ----------
        api_key : str

        type : str

        domain_name : typing.Optional[str]

        format : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DnsLiveResponse]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2.0/dns/live",
            base_url=self._client_wrapper.get_environment().apis,
            method="GET",
            params={
                "apiKey": api_key,
                "domainName": domain_name,
                "type": type,
                "format": format,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DnsLiveResponse,
                    parse_obj_as(
                        type_=DnsLiveResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    async def historical_dns_lookup(
        self,
        *,
        api_key: str,
        domain_name: str,
        type: str,
        page: typing.Optional[int] = None,
        format: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[DnsHistoricalResponse]:
        """
        Get Historical DNS information for a domain

        Parameters
        ----------
        api_key : str

        domain_name : str

        type : str

        page : typing.Optional[int]

        format : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DnsHistoricalResponse]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2.0/dns/historical",
            base_url=self._client_wrapper.get_environment().apis,
            method="GET",
            params={
                "apiKey": api_key,
                "domainName": domain_name,
                "type": type,
                "page": page,
                "format": format,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DnsHistoricalResponse,
                    parse_obj_as(
                        type_=DnsHistoricalResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    async def reverse_dns_lookup(
        self,
        *,
        api_key: str,
        value: str,
        type: str,
        page: typing.Optional[int] = None,
        format: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[DnsReverseResponse]:
        """
        Get Reverse DNS info for a DNS record

        Parameters
        ----------
        api_key : str

        value : str

        type : str

        page : typing.Optional[int]

        format : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DnsReverseResponse]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2.0/dns/reverse",
            base_url=self._client_wrapper.get_environment().apis,
            method="GET",
            params={
                "apiKey": api_key,
                "value": value,
                "type": type,
                "page": page,
                "format": format,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DnsReverseResponse,
                    parse_obj_as(
                        type_=DnsReverseResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    async def bulk_dns_lookup(
        self,
        *,
        api_key: str,
        type: str,
        format: typing.Optional[str] = None,
        domain_names: typing.Optional[typing.Sequence[str]] = OMIT,
        ip_addresses: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[BulkDnsResponse]:
        """
        Get Bulk DNS information for multiple domains or IP addresses

        Parameters
        ----------
        api_key : str

        type : str

        format : typing.Optional[str]

        domain_names : typing.Optional[typing.Sequence[str]]

        ip_addresses : typing.Optional[typing.Sequence[str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[BulkDnsResponse]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2.0/dns/bulk/live",
            base_url=self._client_wrapper.get_environment().apis,
            method="POST",
            params={
                "apiKey": api_key,
                "type": type,
                "format": format,
            },
            json={
                "domainNames": domain_names,
                "ipAddresses": ip_addresses,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    BulkDnsResponse,
                    parse_obj_as(
                        type_=BulkDnsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)
