# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawCreditsClient, RawCreditsClient
from .types.credits_response import CreditsResponse


class CreditsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCreditsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawCreditsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCreditsClient
        """
        return self._raw_client

    def credits_usage_api(
        self, *, api_key: str, request_options: typing.Optional[RequestOptions] = None
    ) -> CreditsResponse:
        """
        You need credits to use Whois and DNS APIs. You can use this API to see your remaining credits for your API Key.

        Parameters
        ----------
        api_key : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditsResponse

        Examples
        --------
        from whoisfreaks import WhoisfreaksApi
        from whoisfreaks.environment import WhoisfreaksApiEnvironment
        client = WhoisfreaksApi(environment=WhoisfreaksApiEnvironment.PRODUCTION, )
        client.credits.credits_usage_api(api_key='YOUR_API_KEY', )
        """
        _response = self._raw_client.credits_usage_api(api_key=api_key, request_options=request_options)
        return _response.data


class AsyncCreditsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCreditsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawCreditsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCreditsClient
        """
        return self._raw_client

    async def credits_usage_api(
        self, *, api_key: str, request_options: typing.Optional[RequestOptions] = None
    ) -> CreditsResponse:
        """
        You need credits to use Whois and DNS APIs. You can use this API to see your remaining credits for your API Key.

        Parameters
        ----------
        api_key : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditsResponse

        Examples
        --------
        from whoisfreaks import AsyncWhoisfreaksApi
        from whoisfreaks.environment import WhoisfreaksApiEnvironment
        import asyncio
        client = AsyncWhoisfreaksApi(environment=WhoisfreaksApiEnvironment.PRODUCTION, )
        async def main() -> None:
            await client.credits.credits_usage_api(api_key='YOUR_API_KEY', )
        asyncio.run(main())
        """
        _response = await self._raw_client.credits_usage_api(api_key=api_key, request_options=request_options)
        return _response.data
