# This file was auto-generated by Fern from our API Definition.

import typing

import httpx
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .credits.client import AsyncCreditsClient, CreditsClient
from .dns.client import AsyncDnsClient, DnsClient
from .domain_availability.client import AsyncDomainAvailabilityClient, DomainAvailabilityClient
from .environment import WhoisfreaksApiEnvironment
from .file_status.client import AsyncFileStatusClient, FileStatusClient
from .ssl.client import AsyncSslClient, SslClient
from .whois.client import AsyncWhoisClient, WhoisClient


class WhoisfreaksApi:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    environment : WhoisfreaksApiEnvironment
        The environment to use for requests from the client.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from whoisfreaks import WhoisfreaksApi
    from whoisfreaks.environment import WhoisfreaksApiEnvironment
    client = WhoisfreaksApi(environment=WhoisfreaksApiEnvironment.PRODUCTION, )
    """

    def __init__(
        self,
        *,
        environment: WhoisfreaksApiEnvironment,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = SyncClientWrapper(
            environment=environment,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self.credits = CreditsClient(client_wrapper=self._client_wrapper)
        self.dns = DnsClient(client_wrapper=self._client_wrapper)
        self.domain_availability = DomainAvailabilityClient(client_wrapper=self._client_wrapper)
        self.file_status = FileStatusClient(client_wrapper=self._client_wrapper)
        self.ssl = SslClient(client_wrapper=self._client_wrapper)
        self.whois = WhoisClient(client_wrapper=self._client_wrapper)


class AsyncWhoisfreaksApi:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    environment : WhoisfreaksApiEnvironment
        The environment to use for requests from the client.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from whoisfreaks import AsyncWhoisfreaksApi
    from whoisfreaks.environment import WhoisfreaksApiEnvironment
    client = AsyncWhoisfreaksApi(environment=WhoisfreaksApiEnvironment.PRODUCTION, )
    """

    def __init__(
        self,
        *,
        environment: WhoisfreaksApiEnvironment,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = AsyncClientWrapper(
            environment=environment,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self.credits = AsyncCreditsClient(client_wrapper=self._client_wrapper)
        self.dns = AsyncDnsClient(client_wrapper=self._client_wrapper)
        self.domain_availability = AsyncDomainAvailabilityClient(client_wrapper=self._client_wrapper)
        self.file_status = AsyncFileStatusClient(client_wrapper=self._client_wrapper)
        self.ssl = AsyncSslClient(client_wrapper=self._client_wrapper)
        self.whois = AsyncWhoisClient(client_wrapper=self._client_wrapper)
