# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['rmfuse']

package_data = \
{'': ['*']}

install_requires = \
['bidict>=0.21.2,<0.22.0',
 'rmcl>=0.4.1,<0.5.0',
 'rmrl>=0.2.1,<0.3.0',
 'xdg>=5.0.1,<6.0.0']

extras_require = \
{'llfuse': ['llfuse>=1.4.1,<2.0.0'], 'pyfuse3': ['pyfuse3>=3.2.0,<4.0.0']}

entry_points = \
{'console_scripts': ['rmfuse = rmfuse.fuse:main']}

setup_kwargs = {
    'name': 'rmfuse',
    'version': '0.2.2',
    'description': '',
    'long_description': '# RMfuse\n\nRMfuse provides access to your reMarkable Cloud files in the form of a\n[FUSE](https://github.com/libfuse/libfuse) filesystem.  These files are\nexposed either in their original format, or as PDF files that contain\nyour annotations.  This lets you manage files in the reMarkable Cloud\nusing the same tools you use on your local system.\n\n## Installation\n\nRMfuse requires Python 3.7 or later.  It also requires either FUSE3 and\nthe [pyfuse3 library](https://github.com/libfuse/pyfuse3), or FUSE2 and\nthe [llfuse library](https://github.com/python-llfuse/python-llfuse).\nThese can be installed from pip with RMfuse, or installed separately\nvia your system package manager.  This means that there are three main\nways to get RMfuse installed.\n\n*Confused?  Look below to see examples for several OSes.*\n\n### Install with pyfuse3 through pip\n\nPrior to installing RMfuse, you will need to install FUSE3, along with\nits header files, which are probably in a package with a name something\nlike *libfuse3-devel*.  You will also need a C build system.  Once those\nare installed, you can install RMfuse with pip:\n```\npip install rmfuse[pyfuse3]\n```\nAlternatively, you may clone this repository and install with\n[Poetry](https://python-poetry.org/):\n```\npoetry install -E pyfuse3\n```\n\n### Install with llfuse through pip\n\nPrior to installing RMfuse, you will need to install FUSE, along with\nits header files, which are probably in a package with a name something\nlike *libfuse-devel*.  You will also need a C build system.  Once those\nare installed, you can install RMfuse with pip:\n```\npip install rmfuse[llfuse]\n```\nAlternatively, you may clone this repository and install with\n[Poetry](https://python-poetry.org/):\n```\npoetry install -E llfuse\n```\n\n### Install with system FUSE packages\n\nIf your system provides either pyfuse3 or llfuse in its package system,\nyou can install one of them that way.  You can then install RMfuse\nwithout needing to specify either library:\n```\npip install rmfuse\n```\nRMfuse will find whichever library is available at runtime.  (Note that\nif you are using a venv, you will need to create it with the\n`--system-site-packages` option.  Otherwise, RMfuse will not be able to\nsee the library you installed.)\n\n### Example installations\n\nHere are some instructions for installations known to succeed.  These are\nnot the only solutions, so feel free to go another direction.  But if\nyou\'re confused by all of the options, you might want to start here.\n\n#### Debian-based systems\n\nInstall the FUSE3 libraries and headers with apt:\n```\nsudo apt install fuse3 libfuse3-3 libfuse3-dev build-essential\n```\nThen install RMfuse in your chosen environment:\n```\npip install rmfuse[pyfuse3]\n```\nThis was tested on Ubuntu 20.04.\n\n#### Fedora-based systems\n\nInstall FUSE3 and pyfuse3 with dnf:\n```\nsudo dnf install fuse3-libs python3-fusepy fuse3-devel python3-devel\n```\nBe sure to add `~/.local/bin` to your path.  Then install with your\nsystem\'s pip:\n```\npip install rmfuse\n```\nThis was tested on Fedora 33.\n\n#### Arch-based systems\n\nInstall RMfuse from this AUR package: [rmfuse](https://aur.archlinux.org/packages/rmfuse/)<sup>AUR</sup>.\n\n[pyfuse3](https://aur.archlinux.org/packages/python-pyfuse3/)<sup>AUR</sup> and [llfuse](https://archlinux.org/packages/community/x86_64/python-llfuse/) are set as optional. Choose the one you prefer and install it.\n\nFor example\n```\nyay -S rmfuse python-pyfuse3\n```\n\n#### MacOS\n\nInstall [macFuse](https://osxfuse.github.io/) with brew:\n```\nbrew install macfuse pkg-config\n```\nYou will need to allow a kernel extension and reboot.  Then install\nRMfuse with the llfuse package:\n```\npip install rmfuse[llfuse]\n```\n\nThere is a [known bug](https://github.com/rschroll/rmfuse/issues/18) with writing large files to RMfuse on a Mac.\n\n#### Windows\n\nAs far as I know, no one has tried this.  If you\'re interested,\n[WinFuse](https://github.com/billziss-gh/winfuse) is probably the place\nto start.\n\n## Usage\n\nRMfuse installs the script `rmfuse`.  The script takes a single argument,\nthe path at which the filesystem should be mounted.  This must be an\nexisting directory.  Any files within that directory will be hidden as\nlong as RMfuse is mounted.\n```\nmkdir ~/remarkable\nrmfuse ~/remarkable\n```\n(If you installed with Poetry, you may need to run `poetry run rmfuse`.)\n\nThe first time RMfuse is run, it will need a _one-time code_ to get\naccess to your reMarkable Cloud account.  You will be prompted to get\nthat code from https://my.remarkable.com/connect/desktop, which may\nrequire logging in to your reMarkable account.  RMfuse uses that code\nto obtain tokens which it uses in the future to authenticate itself.\n\nNote that RMfuse will not produce any output by default.  (You can use\n`-v` or `-vv` to make it more talkative.)  It does not provide a user\ninterface to your files; instead you use another terminal or a file\nbrowser to access the mounted directory.\n\nTo unmount and halt RMfuse, use the `fusermount` command:\n```\nfusermount -u ~/remarkable\n```\n\n### Modes\n\nRMfuse offers several modes to display your reMarkable Cloud files.  You\ncan choose the mode with the `-m` option.\n\n`annot`: Displays all files in PDF format, with your annotations added.\nThis is the default mode.\n\n`orig`: Displays the original file for ebooks and PDF files.  Notebooks\nare rendered as PDF files, as in the `annot` mode.\n\n`raw`: Displays all files as ZIP files, reflecting the underlying format\nused by the reMarkable Cloud.  This may be useful when working with other\ntools that expect files in this form.\n\n`meta`: Displays metadata about the files in JSON format.  Only useful for\ndebugging.\n\nRMfuse provides a special file named `.mode` in root directory.  When read,\nthis file gives the current mode.  Writing a valid mode to this file will\nswitch the mode RMfuse is in.  Additionally, writing `refresh` to this file\nwill cause RMfuse to refresh its information from the reMarkable Cloud.\n(By default, this happens every five minutes.)\n```\n~/remarkable $ cat .mode\nannot\n~/remarkable $ ls\nbook.pdf        document.pdf    notebook.pdf\n~/remarkable $ echo orig > .mode\n~/remarkable $ ls\nbook.epub       document.pdf    notebook.pdf\n```\n\n### Capabilities\n\nRMfuse allows reading of all files in the reMarkable Cloud.  Since reading\nthe file requires several HTTP requests, as well as local processing, reads\nmake take some time.  Running RMfuse in verbose mode (`-v` or `-vv`) will\ndisplay information about the actions underway.  Open files are cached, to\nimprove performance.  More sophisticated caching is planned for the future.\n\nRMfuse does its best to provide accurate metadata for the files.  However,\nthe reMarkable Cloud provides only modification dates, so that is reported\nfor creation and access dates as well.  File sizes in `annot` mode are\nonly estimates until the file is read for the first time.  This metadata\nis cached locally to improve responsiveness in the future.\n\nFiles can be renamed and moved within the RMfuse filesystem.  These changes\nwill be propagated to the reMarkable Cloud.  Changes to the file extension\nwill be ignored.\n\nDeleting files from a RMfuse filesystem moves them into the reMarkable\nCloud\'s trash area.  These files are accessible in the `.trash` hidden\ndirectory in the root of the file system.  Deleting files within the\n`.trash` folder removes them from the reMarkable Cloud.  (_N.B._ It is\nnot known if this deletes the files from the cloud, or just hides them\nfrom clients.)\n\nEPUB and PDF files may be copied into the filesystem, and new directories\ncan be created.  These changes are uploaded to the reMarkable Cloud.\nCopying other types of files into the RMfuse filesystem will fail silently\n(unfortunately).  File extensions are ignored by RMfuse, and thus may\nchange when files are uploaded.  For instance, if `book.epub` is uploaded\nand RMFuse is in `annot` mode, it will show up in the filesystem as\n`book.pdf`.\n\nExisting files cannot be edited; they appear in read-only mode. If you\nwant to edit the contents of a file, you will need to copy it to your\nlocal filesystem, edit it, and then copy it back to the RMfuse filesystem.\nThis will cause annotations to be lost (in `orig` mode) or flattened into\nthe document itself (in `annot` mode).\n\nThere are several rendering options that affect the appearance of annotated\ndocuments.  These can be set in a config file, which by default lives at\n`~/.config/rmfuse/config.ini`.  Run `rmfuse --write-config` to create a\nconfig file with the defaults at that location.  The default mode and\nmountpoint can also be set in this file.\n\n## Known Limitations\n\n- The file size for annotated files is just an estimate before the file\nis first read.  This can confuse some tools which use the file size to\ndetermine how much to read.  After reading the file once, the file size\nwill be correctly reported going forward; rerunning these tools a second\ntime is usually enough to get them working.\n\n- To try to address this, RMfuse throws an error when a program tries to\nread past the end of a file.  This can cause "No data available" errors\nto be reported.  These are harmless.\n\n- Adding a file other than an EPUB or PDF silently fails.  RMfuse does\nthrow an error when it has been given an invalid file, but this comes\ntoo late for FUSE to pass the error back to the caller.  RMfuse may be\nable to throw an error earlier, based on the first bytes it receives;\nthis will be investigated in the future.\n\n- RMfuse caches open files in memory.  This is bad for large files (too\nmuch memory used) and small files (we could cache several files).  A more\nsophisticated caching system is planned.\n\n## Libraries\n\nRMfuse is powered by [rmcl](https://github.com/rschroll/rmcl), for accessing\nthe reMarkable Cloud, and by [rmrl](https://github.com/rschroll/rmrl), for\nrendering annotated documents.  The early development of RMfuse can be found\nin the [rmcl repository](https://github.com/rschroll/rmcl)\n\n## Trademarks\n\nreMarkable(R) is a registered trademark of reMarkable AS. rmrl is not\naffiliated with, or endorsed by, reMarkable AS. The use of "reMarkable"\nin this work refers to the company’s e-paper tablet product(s).\n\n## Copyright\n\nCopyright 2020-2021 Robert Schroll\n\nRMfuse is released under the MIT license.  See LICENSE.txt for details.\n\n## Disclaimer of Warranty\n\nRMfuse is provided without any warranty.  Users accept the risk of damages,\nincluding the loss of data on their local system, on their reMarkable\ndevice, and in the reMarkable Cloud.\n\nIf it breaks, you get to keep both halves.\n',
    'author': 'Robert Schroll',
    'author_email': 'rschroll@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/rschroll/rmfuse',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
