"""
Functionality related to the Q-CTRL graph structure.

The commons objects are re-imported here to allow all access to the objects to happen directly from
the `qctrl` package.
"""

import sys

# We import Graph to expose it directly from this module.
# pylint: disable=unused-import
from qctrlcommons.graph import Graph as _BaseGraph
from qctrlcommons.node.registry import TYPE_REGISTRY as _TYPE_REGISTRY

from qctrl.builders.namespaces import ToolkitCategory as _ToolkitCategory
from qctrl.builders.namespaces import build_and_bind_toolkit as _build_and_bind_toolkit
from qctrl.utils import PackageRegistry as _PackageRegistry

_module = sys.modules[__name__]
for _type_cls in _TYPE_REGISTRY:
    setattr(_module, _type_cls.__name__, _type_cls)

# pylint: disable=too-few-public-methods
class Graph(_BaseGraph):

    """
    Utility class for representing and building a Q-CTRL data flow graph.
    """

    def __init__(self):
        super().__init__()
        if _PackageRegistry.QCTRLTOOLKIT.is_installed():
            _qt = _PackageRegistry.QCTRLTOOLKIT.import_pkg()
            _build_and_bind_toolkit(self, _ToolkitCategory.NODES, _qt)
