# behavioral_signals_swagger_client_3
Oliver API in the cloud service

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 3.10
- Package version: 3.10.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen
For more information, please visit [https://api.behavioralsignals.com](https://api.behavioralsignals.com)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import behavioral_signals_swagger_client_3 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import behavioral_signals_swagger_client_3
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import behavioral_signals_swagger_client_3
from behavioral_signals_swagger_client_3.rest import ApiException
from pprint import pprint

# Configure API key authorization: token
configuration = behavioral_signals_swagger_client_3.Configuration()
configuration.api_key['X-Auth-Token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Auth-Token'] = 'Bearer'

# create an instance of the API class
api_instance = behavioral_signals_swagger_client_3.CallProcessingApi(behavioral_signals_swagger_client_3.ApiClient(configuration))
cid = 789 # int | ID of client giving request

try:
    api_response = api_instance.get_all_processes(cid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CallProcessingApi->get_all_processes: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api.behavioralsignals.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CallProcessingApi* | [**get_all_processes**](docs/CallProcessingApi.md#get_all_processes) | **GET** /client/{cid}/process | 
*UpdateProcessesStatusEGToAbortProcessingApi* | [**update_processes**](docs/UpdateProcessesStatusEGToAbortProcessingApi.md#update_processes) | **PUT** /client/{cid}/process | 
*DefaultApi* | [**client_auth**](docs/DefaultApi.md#client_auth) | **GET** /auth | 
*DefaultApi* | [**create_client**](docs/DefaultApi.md#create_client) | **POST** /client | 
*DefaultApi* | [**delete_client**](docs/DefaultApi.md#delete_client) | **DELETE** /client/{cid} | 
*DefaultApi* | [**get_process_info**](docs/DefaultApi.md#get_process_info) | **GET** /client/{cid}/process/{pid} | 
*DefaultApi* | [**get_process_results**](docs/DefaultApi.md#get_process_results) | **GET** /client/{cid}/process/{pid}/result | 
*DefaultApi* | [**get_process_results_asr**](docs/DefaultApi.md#get_process_results_asr) | **GET** /client/{cid}/process/{pid}/resultasr | 
*DefaultApi* | [**get_process_results_demo**](docs/DefaultApi.md#get_process_results_demo) | **GET** /client/{cid}/process/{pid}/resultdemo | 
*DefaultApi* | [**get_process_results_diarization**](docs/DefaultApi.md#get_process_results_diarization) | **GET** /client/{cid}/process/{pid}/resultdiarization | 
*DefaultApi* | [**get_process_results_features**](docs/DefaultApi.md#get_process_results_features) | **GET** /client/{cid}/process/{pid}/resultfeatures | 
*DefaultApi* | [**get_process_results_frames**](docs/DefaultApi.md#get_process_results_frames) | **GET** /client/{cid}/process/{pid}/resultframes | 
*DefaultApi* | [**get_process_stats**](docs/DefaultApi.md#get_process_stats) | **GET** /client/{cid}/process/{pid}/stats | 
*DefaultApi* | [**info_client**](docs/DefaultApi.md#info_client) | **GET** /client/{cid} | 
*DefaultApi* | [**modify_token**](docs/DefaultApi.md#modify_token) | **PUT** /token | 
*DefaultApi* | [**post_feedback**](docs/DefaultApi.md#post_feedback) | **POST** /client/{cid}/process/feedback | 
*DefaultApi* | [**put_feedback**](docs/DefaultApi.md#put_feedback) | **PUT** /client/{cid}/process/feedback/{formCode} | 
*DefaultApi* | [**send_process_audio**](docs/DefaultApi.md#send_process_audio) | **POST** /client/{cid}/process/audio | 
*DefaultApi* | [**send_process_tcp**](docs/DefaultApi.md#send_process_tcp) | **POST** /client/{cid}/process/stream | 
*DefaultApi* | [**send_process_url**](docs/DefaultApi.md#send_process_url) | **POST** /client/{cid}/process/url | 
*DefaultApi* | [**send_process_video**](docs/DefaultApi.md#send_process_video) | **POST** /client/{cid}/process/video | 
*DefaultApi* | [**service_status**](docs/DefaultApi.md#service_status) | **GET** /status | 


## Documentation For Models

 - [ArrayOfProcesses](docs/ArrayOfProcesses.md)
 - [Authorized](docs/Authorized.md)
 - [CallflowEvents](docs/CallflowEvents.md)
 - [CallflowEventsInner](docs/CallflowEventsInner.md)
 - [Client](docs/Client.md)
 - [ErrorModel](docs/ErrorModel.md)
 - [GenericResponse](docs/GenericResponse.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InputFeedback](docs/InputFeedback.md)
 - [PaginationResponse](docs/PaginationResponse.md)
 - [Process](docs/Process.md)
 - [ProcessStats](docs/ProcessStats.md)
 - [ProcessUpdatedStatus](docs/ProcessUpdatedStatus.md)
 - [ProcessesUpdate](docs/ProcessesUpdate.md)
 - [ProcessesUpdatedStatus](docs/ProcessesUpdatedStatus.md)
 - [ResponseFeedback](docs/ResponseFeedback.md)
 - [ResultJSON](docs/ResultJSON.md)
 - [ResultJSONASR](docs/ResultJSONASR.md)
 - [ResultJSONASRDetections](docs/ResultJSONASRDetections.md)
 - [ResultJSONASROccurrences](docs/ResultJSONASROccurrences.md)
 - [ResultJSONASRPredictions](docs/ResultJSONASRPredictions.md)
 - [ResultJSONASRWords](docs/ResultJSONASRWords.md)
 - [ResultJSONBasic](docs/ResultJSONBasic.md)
 - [ResultJSONBasicAge](docs/ResultJSONBasicAge.md)
 - [ResultJSONBasicGender](docs/ResultJSONBasicGender.md)
 - [ResultJSONBasicId](docs/ResultJSONBasicId.md)
 - [ResultJSONBasicLang](docs/ResultJSONBasicLang.md)
 - [ResultJSONBasicLangEnglish](docs/ResultJSONBasicLangEnglish.md)
 - [ResultJSONBasicLangSpanish](docs/ResultJSONBasicLangSpanish.md)
 - [ResultJSONBasicUtterances](docs/ResultJSONBasicUtterances.md)
 - [ResultJSONBasicVad](docs/ResultJSONBasicVad.md)
 - [ResultJSONCore](docs/ResultJSONCore.md)
 - [ResultJSONCoreBehaviors](docs/ResultJSONCoreBehaviors.md)
 - [ResultJSONCoreDiarization](docs/ResultJSONCoreDiarization.md)
 - [ResultJSONCoreEmotions](docs/ResultJSONCoreEmotions.md)
 - [ResultJSONCoreEmotionsAnger](docs/ResultJSONCoreEmotionsAnger.md)
 - [ResultJSONCoreEmotionsFrustration](docs/ResultJSONCoreEmotionsFrustration.md)
 - [ResultJSONCoreEmotionsHappy](docs/ResultJSONCoreEmotionsHappy.md)
 - [ResultJSONCoreEmotionsSad](docs/ResultJSONCoreEmotionsSad.md)
 - [ResultJSONCoreEmpathy](docs/ResultJSONCoreEmpathy.md)
 - [ResultJSONCoreEngagement](docs/ResultJSONCoreEngagement.md)
 - [ResultJSONCorePoliteness](docs/ResultJSONCorePoliteness.md)
 - [ResultJSONCorePositivity](docs/ResultJSONCorePositivity.md)
 - [ResultJSONCoreSoundquality](docs/ResultJSONCoreSoundquality.md)
 - [ResultJSONCoreStrength](docs/ResultJSONCoreStrength.md)
 - [ResultJSONCoreValue](docs/ResultJSONCoreValue.md)
 - [ResultJSONCoreValue1](docs/ResultJSONCoreValue1.md)
 - [ResultJSONDiarization](docs/ResultJSONDiarization.md)
 - [ResultJSONDiarizationDiarization](docs/ResultJSONDiarizationDiarization.md)
 - [ResultJSONEvents](docs/ResultJSONEvents.md)
 - [ResultJSONEventsBehavioral](docs/ResultJSONEventsBehavioral.md)
 - [ResultJSONEventsCallflow](docs/ResultJSONEventsCallflow.md)
 - [ResultJSONFeatures](docs/ResultJSONFeatures.md)
 - [ResultJSONFeaturesFeatures](docs/ResultJSONFeaturesFeatures.md)
 - [ResultJSONFrames](docs/ResultJSONFrames.md)
 - [ResultJSONFramesActivation](docs/ResultJSONFramesActivation.md)
 - [ResultJSONFramesAge](docs/ResultJSONFramesAge.md)
 - [ResultJSONFramesBeep](docs/ResultJSONFramesBeep.md)
 - [ResultJSONFramesEmotion](docs/ResultJSONFramesEmotion.md)
 - [ResultJSONFramesEngagement](docs/ResultJSONFramesEngagement.md)
 - [ResultJSONFramesF0](docs/ResultJSONFramesF0.md)
 - [ResultJSONFramesFrames](docs/ResultJSONFramesFrames.md)
 - [ResultJSONFramesGender](docs/ResultJSONFramesGender.md)
 - [ResultJSONFramesIntensity](docs/ResultJSONFramesIntensity.md)
 - [ResultJSONFramesLanguage](docs/ResultJSONFramesLanguage.md)
 - [ResultJSONFramesPoliteness](docs/ResultJSONFramesPoliteness.md)
 - [ResultJSONFramesPositivity](docs/ResultJSONFramesPositivity.md)
 - [ResultJSONFramesRing](docs/ResultJSONFramesRing.md)
 - [ResultJSONFramesSnr](docs/ResultJSONFramesSnr.md)
 - [ResultJSONFramesSpeakers](docs/ResultJSONFramesSpeakers.md)
 - [ResultJSONFramesSpeakingRate](docs/ResultJSONFramesSpeakingRate.md)
 - [ResultJSONFramesStrength](docs/ResultJSONFramesStrength.md)
 - [ResultJSONFramesSuccess](docs/ResultJSONFramesSuccess.md)
 - [ResultJSONFramesToneVariety](docs/ResultJSONFramesToneVariety.md)
 - [ResultJSONFramesVad](docs/ResultJSONFramesVad.md)
 - [ResultJSONFramesValence](docs/ResultJSONFramesValence.md)
 - [ResultJSONKpi](docs/ResultJSONKpi.md)
 - [ResultJSONKpiCompliance](docs/ResultJSONKpiCompliance.md)
 - [ResultJSONKpiTrends](docs/ResultJSONKpiTrends.md)
 - [SpeakerBehavioralEvents](docs/SpeakerBehavioralEvents.md)
 - [SpeakerBehavioralEventsEmotion](docs/SpeakerBehavioralEventsEmotion.md)
 - [SpeakerBehavioralEventsEngagement](docs/SpeakerBehavioralEventsEngagement.md)
 - [SpeakerBehavioralEventsPoliteness](docs/SpeakerBehavioralEventsPoliteness.md)
 - [SpeakerBehavioralEventsPositivity](docs/SpeakerBehavioralEventsPositivity.md)
 - [SpeakerBehavioralEventsStrength](docs/SpeakerBehavioralEventsStrength.md)
 - [SpeakerDiarizationRanges](docs/SpeakerDiarizationRanges.md)
 - [SpeakerDiarizationRangesInner](docs/SpeakerDiarizationRangesInner.md)
 - [Status](docs/Status.md)
 - [Token](docs/Token.md)


## Documentation For Authorization


## token

- **Type**: API key
- **API key parameter name**: X-Auth-Token
- **Location**: HTTP header


## Author

api@behavioralsignals.com

