# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 8
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class SshSettingsSettings(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'auth_settings_template': 'str',
        'authentication_methods': 'str',
        'banner': 'str',
        'ca_signature_algorithms': 'str',
        'challenge_response_authentication': 'bool',
        'ciphers': 'str',
        'host_key_algorithms': 'str',
        'ignore_rhosts': 'bool',
        'kex_algorithms': 'str',
        'keyboard_interactive_authentication': 'bool',
        'log_level': 'str',
        'login_grace_time': 'int',
        'macs': 'str',
        'match': 'str',
        'max_auth_tries': 'int',
        'max_sessions': 'int',
        'max_startups': 'str',
        'password_authentication': 'bool',
        'permit_empty_passwords': 'bool',
        'permit_root_login': 'bool',
        'port': 'int',
        'print_motd': 'bool',
        'pubkey_accepted_key_types': 'str',
        'pubkey_authentication': 'bool',
        'strict_modes': 'bool',
        'subsystem': 'str',
        'syslog_facility': 'str',
        'tcp_keep_alive': 'bool',
        'use_dns': 'bool',
        'use_pam': 'bool'
    }

    attribute_map = {
        'auth_settings_template': 'auth_settings_template',
        'authentication_methods': 'authentication_methods',
        'banner': 'banner',
        'ca_signature_algorithms': 'ca_signature_algorithms',
        'challenge_response_authentication': 'challenge_response_authentication',
        'ciphers': 'ciphers',
        'host_key_algorithms': 'host_key_algorithms',
        'ignore_rhosts': 'ignore_rhosts',
        'kex_algorithms': 'kex_algorithms',
        'keyboard_interactive_authentication': 'keyboard_interactive_authentication',
        'log_level': 'log_level',
        'login_grace_time': 'login_grace_time',
        'macs': 'macs',
        'match': 'match',
        'max_auth_tries': 'max_auth_tries',
        'max_sessions': 'max_sessions',
        'max_startups': 'max_startups',
        'password_authentication': 'password_authentication',
        'permit_empty_passwords': 'permit_empty_passwords',
        'permit_root_login': 'permit_root_login',
        'port': 'port',
        'print_motd': 'print_motd',
        'pubkey_accepted_key_types': 'pubkey_accepted_key_types',
        'pubkey_authentication': 'pubkey_authentication',
        'strict_modes': 'strict_modes',
        'subsystem': 'subsystem',
        'syslog_facility': 'syslog_facility',
        'tcp_keep_alive': 'tcp_keep_alive',
        'use_dns': 'use_dns',
        'use_pam': 'use_pam'
    }

    def __init__(self, auth_settings_template=None, authentication_methods=None, banner=None, ca_signature_algorithms=None, challenge_response_authentication=None, ciphers=None, host_key_algorithms=None, ignore_rhosts=None, kex_algorithms=None, keyboard_interactive_authentication=None, log_level=None, login_grace_time=None, macs=None, match=None, max_auth_tries=None, max_sessions=None, max_startups=None, password_authentication=None, permit_empty_passwords=None, permit_root_login=None, port=None, print_motd=None, pubkey_accepted_key_types=None, pubkey_authentication=None, strict_modes=None, subsystem=None, syslog_facility=None, tcp_keep_alive=None, use_dns=None, use_pam=None):  # noqa: E501
        """SshSettingsSettings - a model defined in Swagger"""  # noqa: E501

        self._auth_settings_template = None
        self._authentication_methods = None
        self._banner = None
        self._ca_signature_algorithms = None
        self._challenge_response_authentication = None
        self._ciphers = None
        self._host_key_algorithms = None
        self._ignore_rhosts = None
        self._kex_algorithms = None
        self._keyboard_interactive_authentication = None
        self._log_level = None
        self._login_grace_time = None
        self._macs = None
        self._match = None
        self._max_auth_tries = None
        self._max_sessions = None
        self._max_startups = None
        self._password_authentication = None
        self._permit_empty_passwords = None
        self._permit_root_login = None
        self._port = None
        self._print_motd = None
        self._pubkey_accepted_key_types = None
        self._pubkey_authentication = None
        self._strict_modes = None
        self._subsystem = None
        self._syslog_facility = None
        self._tcp_keep_alive = None
        self._use_dns = None
        self._use_pam = None
        self.discriminator = None

        if auth_settings_template is not None:
            self.auth_settings_template = auth_settings_template
        if authentication_methods is not None:
            self.authentication_methods = authentication_methods
        if banner is not None:
            self.banner = banner
        if ca_signature_algorithms is not None:
            self.ca_signature_algorithms = ca_signature_algorithms
        if challenge_response_authentication is not None:
            self.challenge_response_authentication = challenge_response_authentication
        if ciphers is not None:
            self.ciphers = ciphers
        if host_key_algorithms is not None:
            self.host_key_algorithms = host_key_algorithms
        if ignore_rhosts is not None:
            self.ignore_rhosts = ignore_rhosts
        if kex_algorithms is not None:
            self.kex_algorithms = kex_algorithms
        if keyboard_interactive_authentication is not None:
            self.keyboard_interactive_authentication = keyboard_interactive_authentication
        if log_level is not None:
            self.log_level = log_level
        if login_grace_time is not None:
            self.login_grace_time = login_grace_time
        if macs is not None:
            self.macs = macs
        if match is not None:
            self.match = match
        if max_auth_tries is not None:
            self.max_auth_tries = max_auth_tries
        if max_sessions is not None:
            self.max_sessions = max_sessions
        if max_startups is not None:
            self.max_startups = max_startups
        if password_authentication is not None:
            self.password_authentication = password_authentication
        if permit_empty_passwords is not None:
            self.permit_empty_passwords = permit_empty_passwords
        if permit_root_login is not None:
            self.permit_root_login = permit_root_login
        if port is not None:
            self.port = port
        if print_motd is not None:
            self.print_motd = print_motd
        if pubkey_accepted_key_types is not None:
            self.pubkey_accepted_key_types = pubkey_accepted_key_types
        if pubkey_authentication is not None:
            self.pubkey_authentication = pubkey_authentication
        if strict_modes is not None:
            self.strict_modes = strict_modes
        if subsystem is not None:
            self.subsystem = subsystem
        if syslog_facility is not None:
            self.syslog_facility = syslog_facility
        if tcp_keep_alive is not None:
            self.tcp_keep_alive = tcp_keep_alive
        if use_dns is not None:
            self.use_dns = use_dns
        if use_pam is not None:
            self.use_pam = use_pam

    @property
    def auth_settings_template(self):
        """Gets the auth_settings_template of this SshSettingsSettings.  # noqa: E501

        Specifies the configuration template for the supported method by which a user is authenticated.  # noqa: E501

        :return: The auth_settings_template of this SshSettingsSettings.  # noqa: E501
        :rtype: str
        """
        return self._auth_settings_template

    @auth_settings_template.setter
    def auth_settings_template(self, auth_settings_template):
        """Sets the auth_settings_template of this SshSettingsSettings.

        Specifies the configuration template for the supported method by which a user is authenticated.  # noqa: E501

        :param auth_settings_template: The auth_settings_template of this SshSettingsSettings.  # noqa: E501
        :type: str
        """
        allowed_values = ["password", "publickey", "both", "any", "custom"]  # noqa: E501
        if auth_settings_template not in allowed_values:
            raise ValueError(
                "Invalid value for `auth_settings_template` ({0}), must be one of {1}"  # noqa: E501
                .format(auth_settings_template, allowed_values)
            )

        self._auth_settings_template = auth_settings_template

    @property
    def authentication_methods(self):
        """Gets the authentication_methods of this SshSettingsSettings.  # noqa: E501

        Specifies the authentication methods that must be successfully completed for a user to be granted access.  # noqa: E501

        :return: The authentication_methods of this SshSettingsSettings.  # noqa: E501
        :rtype: str
        """
        return self._authentication_methods

    @authentication_methods.setter
    def authentication_methods(self, authentication_methods):
        """Sets the authentication_methods of this SshSettingsSettings.

        Specifies the authentication methods that must be successfully completed for a user to be granted access.  # noqa: E501

        :param authentication_methods: The authentication_methods of this SshSettingsSettings.  # noqa: E501
        :type: str
        """
        if authentication_methods is not None and len(authentication_methods) > 1024:
            raise ValueError("Invalid value for `authentication_methods`, length must be less than or equal to `1024`")  # noqa: E501
        if authentication_methods is not None and len(authentication_methods) < 0:
            raise ValueError("Invalid value for `authentication_methods`, length must be greater than or equal to `0`")  # noqa: E501
        if authentication_methods is not None and not re.search('^[^ ]*$', authentication_methods):  # noqa: E501
            raise ValueError("Invalid value for `authentication_methods`, must be a follow pattern or equal to `/^[^ ]*$/`")  # noqa: E501

        self._authentication_methods = authentication_methods

    @property
    def banner(self):
        """Gets the banner of this SshSettingsSettings.  # noqa: E501

        Specifies file name to be used as SSH warning banner that is shown before the password prompt  # noqa: E501

        :return: The banner of this SshSettingsSettings.  # noqa: E501
        :rtype: str
        """
        return self._banner

    @banner.setter
    def banner(self, banner):
        """Sets the banner of this SshSettingsSettings.

        Specifies file name to be used as SSH warning banner that is shown before the password prompt  # noqa: E501

        :param banner: The banner of this SshSettingsSettings.  # noqa: E501
        :type: str
        """
        if banner is not None and len(banner) > 4096:
            raise ValueError("Invalid value for `banner`, length must be less than or equal to `4096`")  # noqa: E501
        if banner is not None and len(banner) < 0:
            raise ValueError("Invalid value for `banner`, length must be greater than or equal to `0`")  # noqa: E501
        if banner is not None and not re.search('^[^ ]*$', banner):  # noqa: E501
            raise ValueError("Invalid value for `banner`, must be a follow pattern or equal to `/^[^ ]*$/`")  # noqa: E501

        self._banner = banner

    @property
    def ca_signature_algorithms(self):
        """Gets the ca_signature_algorithms of this SshSettingsSettings.  # noqa: E501

        Specifies which algorithms are allowed for signing of certificates by certificate authorities (CAs).  # noqa: E501

        :return: The ca_signature_algorithms of this SshSettingsSettings.  # noqa: E501
        :rtype: str
        """
        return self._ca_signature_algorithms

    @ca_signature_algorithms.setter
    def ca_signature_algorithms(self, ca_signature_algorithms):
        """Sets the ca_signature_algorithms of this SshSettingsSettings.

        Specifies which algorithms are allowed for signing of certificates by certificate authorities (CAs).  # noqa: E501

        :param ca_signature_algorithms: The ca_signature_algorithms of this SshSettingsSettings.  # noqa: E501
        :type: str
        """
        if ca_signature_algorithms is not None and len(ca_signature_algorithms) > 4096:
            raise ValueError("Invalid value for `ca_signature_algorithms`, length must be less than or equal to `4096`")  # noqa: E501
        if ca_signature_algorithms is not None and len(ca_signature_algorithms) < 0:
            raise ValueError("Invalid value for `ca_signature_algorithms`, length must be greater than or equal to `0`")  # noqa: E501
        if ca_signature_algorithms is not None and not re.search('^(\\+?)(ecdsa-sha2-nistp256|ecdsa-sha2-nistp384|ecdsa-sha2-nistp521|ssh-ed25519|rsa-sha2-512|rsa-sha2-256|ssh-rsa)(,(ecdsa-sha2-nistp256|ecdsa-sha2-nistp384|ecdsa-sha2-nistp521|ssh-ed25519|rsa-sha2-512|rsa-sha2-256|ssh-rsa))*$', ca_signature_algorithms):  # noqa: E501
            raise ValueError("Invalid value for `ca_signature_algorithms`, must be a follow pattern or equal to `/^(\\+?)(ecdsa-sha2-nistp256|ecdsa-sha2-nistp384|ecdsa-sha2-nistp521|ssh-ed25519|rsa-sha2-512|rsa-sha2-256|ssh-rsa)(,(ecdsa-sha2-nistp256|ecdsa-sha2-nistp384|ecdsa-sha2-nistp521|ssh-ed25519|rsa-sha2-512|rsa-sha2-256|ssh-rsa))*$/`")  # noqa: E501

        self._ca_signature_algorithms = ca_signature_algorithms

    @property
    def challenge_response_authentication(self):
        """Gets the challenge_response_authentication of this SshSettingsSettings.  # noqa: E501

        Specifies whether challenge-response authentication is allowed.  # noqa: E501

        :return: The challenge_response_authentication of this SshSettingsSettings.  # noqa: E501
        :rtype: bool
        """
        return self._challenge_response_authentication

    @challenge_response_authentication.setter
    def challenge_response_authentication(self, challenge_response_authentication):
        """Sets the challenge_response_authentication of this SshSettingsSettings.

        Specifies whether challenge-response authentication is allowed.  # noqa: E501

        :param challenge_response_authentication: The challenge_response_authentication of this SshSettingsSettings.  # noqa: E501
        :type: bool
        """

        self._challenge_response_authentication = challenge_response_authentication

    @property
    def ciphers(self):
        """Gets the ciphers of this SshSettingsSettings.  # noqa: E501

        Specifies the ciphers allowed for protocol version 2.  # noqa: E501

        :return: The ciphers of this SshSettingsSettings.  # noqa: E501
        :rtype: str
        """
        return self._ciphers

    @ciphers.setter
    def ciphers(self, ciphers):
        """Sets the ciphers of this SshSettingsSettings.

        Specifies the ciphers allowed for protocol version 2.  # noqa: E501

        :param ciphers: The ciphers of this SshSettingsSettings.  # noqa: E501
        :type: str
        """
        if ciphers is not None and len(ciphers) > 4096:
            raise ValueError("Invalid value for `ciphers`, length must be less than or equal to `4096`")  # noqa: E501
        if ciphers is not None and len(ciphers) < 7:
            raise ValueError("Invalid value for `ciphers`, length must be greater than or equal to `7`")  # noqa: E501
        if ciphers is not None and not re.search('^(\\+?)(3des-cbc|aes128-cbc|aes192-cbc|aes256-cbc|aes128-ctr|aes192-ctr|aes256-ctr|aes128-gcm@openssh\\.com|aes256-gcm@openssh\\.com|chacha20-poly1305@openssh\\.com)(,(3des-cbc|aes128-cbc|aes192-cbc|aes256-cbc|aes128-ctr|aes192-ctr|aes256-ctr|aes128-gcm@openssh\\.com|aes256-gcm@openssh\\.com|chacha20-poly1305@openssh\\.com))*$', ciphers):  # noqa: E501
            raise ValueError("Invalid value for `ciphers`, must be a follow pattern or equal to `/^(\\+?)(3des-cbc|aes128-cbc|aes192-cbc|aes256-cbc|aes128-ctr|aes192-ctr|aes256-ctr|aes128-gcm@openssh\\.com|aes256-gcm@openssh\\.com|chacha20-poly1305@openssh\\.com)(,(3des-cbc|aes128-cbc|aes192-cbc|aes256-cbc|aes128-ctr|aes192-ctr|aes256-ctr|aes128-gcm@openssh\\.com|aes256-gcm@openssh\\.com|chacha20-poly1305@openssh\\.com))*$/`")  # noqa: E501

        self._ciphers = ciphers

    @property
    def host_key_algorithms(self):
        """Gets the host_key_algorithms of this SshSettingsSettings.  # noqa: E501

        Specifies the protocol version 2 host key algorithms the server offers.  # noqa: E501

        :return: The host_key_algorithms of this SshSettingsSettings.  # noqa: E501
        :rtype: str
        """
        return self._host_key_algorithms

    @host_key_algorithms.setter
    def host_key_algorithms(self, host_key_algorithms):
        """Sets the host_key_algorithms of this SshSettingsSettings.

        Specifies the protocol version 2 host key algorithms the server offers.  # noqa: E501

        :param host_key_algorithms: The host_key_algorithms of this SshSettingsSettings.  # noqa: E501
        :type: str
        """
        if host_key_algorithms is not None and len(host_key_algorithms) > 4096:
            raise ValueError("Invalid value for `host_key_algorithms`, length must be less than or equal to `4096`")  # noqa: E501
        if host_key_algorithms is not None and len(host_key_algorithms) < 7:
            raise ValueError("Invalid value for `host_key_algorithms`, length must be greater than or equal to `7`")  # noqa: E501
        if host_key_algorithms is not None and not re.search('^(\\+?)(ssh-ed25519|ssh-ed25519-cert-v01@openssh\\.com|ssh-rsa|ssh-dss|ecdsa-sha2-nistp256|ecdsa-sha2-nistp384|ecdsa-sha2-nistp521|ssh-rsa-cert-v01@openssh\\.com|ssh-dss-cert-v01@openssh\\.com|ecdsa-sha2-nistp256-cert-v01@openssh\\.com|ecdsa-sha2-nistp384-cert-v01@openssh\\.com|ecdsa-sha2-nistp521-cert-v01@openssh\\.com)(,(ssh-ed25519|ssh-ed25519-cert-v01@openssh\\.com|ssh-rsa|ssh-dss|ecdsa-sha2-nistp256|ecdsa-sha2-nistp384|ecdsa-sha2-nistp521|ssh-rsa-cert-v01@openssh\\.com|ssh-dss-cert-v01@openssh\\.com|ecdsa-sha2-nistp256-cert-v01@openssh\\.com|ecdsa-sha2-nistp384-cert-v01@openssh\\.com|ecdsa-sha2-nistp521-cert-v01@openssh\\.com))*$', host_key_algorithms):  # noqa: E501
            raise ValueError("Invalid value for `host_key_algorithms`, must be a follow pattern or equal to `/^(\\+?)(ssh-ed25519|ssh-ed25519-cert-v01@openssh\\.com|ssh-rsa|ssh-dss|ecdsa-sha2-nistp256|ecdsa-sha2-nistp384|ecdsa-sha2-nistp521|ssh-rsa-cert-v01@openssh\\.com|ssh-dss-cert-v01@openssh\\.com|ecdsa-sha2-nistp256-cert-v01@openssh\\.com|ecdsa-sha2-nistp384-cert-v01@openssh\\.com|ecdsa-sha2-nistp521-cert-v01@openssh\\.com)(,(ssh-ed25519|ssh-ed25519-cert-v01@openssh\\.com|ssh-rsa|ssh-dss|ecdsa-sha2-nistp256|ecdsa-sha2-nistp384|ecdsa-sha2-nistp521|ssh-rsa-cert-v01@openssh\\.com|ssh-dss-cert-v01@openssh\\.com|ecdsa-sha2-nistp256-cert-v01@openssh\\.com|ecdsa-sha2-nistp384-cert-v01@openssh\\.com|ecdsa-sha2-nistp521-cert-v01@openssh\\.com))*$/`")  # noqa: E501

        self._host_key_algorithms = host_key_algorithms

    @property
    def ignore_rhosts(self):
        """Gets the ignore_rhosts of this SshSettingsSettings.  # noqa: E501

        If true, ignores .rhosts and .shosts files.  # noqa: E501

        :return: The ignore_rhosts of this SshSettingsSettings.  # noqa: E501
        :rtype: bool
        """
        return self._ignore_rhosts

    @ignore_rhosts.setter
    def ignore_rhosts(self, ignore_rhosts):
        """Sets the ignore_rhosts of this SshSettingsSettings.

        If true, ignores .rhosts and .shosts files.  # noqa: E501

        :param ignore_rhosts: The ignore_rhosts of this SshSettingsSettings.  # noqa: E501
        :type: bool
        """

        self._ignore_rhosts = ignore_rhosts

    @property
    def kex_algorithms(self):
        """Gets the kex_algorithms of this SshSettingsSettings.  # noqa: E501

        Specifies the available KEX algorithms.  # noqa: E501

        :return: The kex_algorithms of this SshSettingsSettings.  # noqa: E501
        :rtype: str
        """
        return self._kex_algorithms

    @kex_algorithms.setter
    def kex_algorithms(self, kex_algorithms):
        """Sets the kex_algorithms of this SshSettingsSettings.

        Specifies the available KEX algorithms.  # noqa: E501

        :param kex_algorithms: The kex_algorithms of this SshSettingsSettings.  # noqa: E501
        :type: str
        """
        if kex_algorithms is not None and len(kex_algorithms) > 4096:
            raise ValueError("Invalid value for `kex_algorithms`, length must be less than or equal to `4096`")  # noqa: E501
        if kex_algorithms is not None and len(kex_algorithms) < 18:
            raise ValueError("Invalid value for `kex_algorithms`, length must be greater than or equal to `18`")  # noqa: E501
        if kex_algorithms is not None and not re.search('^(\\+?)(curve25519-sha256|curve25519-sha256@libssh\\.org|diffie-hellman-group1-sha1|diffie-hellman-group14-sha1|diffie-hellman-group14-sha256|diffie-hellman-group16-sha512|diffie-hellman-group18-sha512|diffie-hellman-group-exchange-sha1|diffie-hellman-group-exchange-sha256|ecdh-sha2-nistp256|ecdh-sha2-nistp384|ecdh-sha2-nistp521)(,(curve25519-sha256|curve25519-sha256@libssh\\.org|diffie-hellman-group1-sha1|diffie-hellman-group14-sha1|diffie-hellman-group14-sha256|diffie-hellman-group16-sha512|diffie-hellman-group18-sha512|diffie-hellman-group-exchange-sha1|diffie-hellman-group-exchange-sha256|ecdh-sha2-nistp256|ecdh-sha2-nistp384|ecdh-sha2-nistp521))*$', kex_algorithms):  # noqa: E501
            raise ValueError("Invalid value for `kex_algorithms`, must be a follow pattern or equal to `/^(\\+?)(curve25519-sha256|curve25519-sha256@libssh\\.org|diffie-hellman-group1-sha1|diffie-hellman-group14-sha1|diffie-hellman-group14-sha256|diffie-hellman-group16-sha512|diffie-hellman-group18-sha512|diffie-hellman-group-exchange-sha1|diffie-hellman-group-exchange-sha256|ecdh-sha2-nistp256|ecdh-sha2-nistp384|ecdh-sha2-nistp521)(,(curve25519-sha256|curve25519-sha256@libssh\\.org|diffie-hellman-group1-sha1|diffie-hellman-group14-sha1|diffie-hellman-group14-sha256|diffie-hellman-group16-sha512|diffie-hellman-group18-sha512|diffie-hellman-group-exchange-sha1|diffie-hellman-group-exchange-sha256|ecdh-sha2-nistp256|ecdh-sha2-nistp384|ecdh-sha2-nistp521))*$/`")  # noqa: E501

        self._kex_algorithms = kex_algorithms

    @property
    def keyboard_interactive_authentication(self):
        """Gets the keyboard_interactive_authentication of this SshSettingsSettings.  # noqa: E501

        Specifies whether to allow keyboard-interactive authentication.  # noqa: E501

        :return: The keyboard_interactive_authentication of this SshSettingsSettings.  # noqa: E501
        :rtype: bool
        """
        return self._keyboard_interactive_authentication

    @keyboard_interactive_authentication.setter
    def keyboard_interactive_authentication(self, keyboard_interactive_authentication):
        """Sets the keyboard_interactive_authentication of this SshSettingsSettings.

        Specifies whether to allow keyboard-interactive authentication.  # noqa: E501

        :param keyboard_interactive_authentication: The keyboard_interactive_authentication of this SshSettingsSettings.  # noqa: E501
        :type: bool
        """

        self._keyboard_interactive_authentication = keyboard_interactive_authentication

    @property
    def log_level(self):
        """Gets the log_level of this SshSettingsSettings.  # noqa: E501

        Specifies the log level when logging messages from sshd(8).  # noqa: E501

        :return: The log_level of this SshSettingsSettings.  # noqa: E501
        :rtype: str
        """
        return self._log_level

    @log_level.setter
    def log_level(self, log_level):
        """Sets the log_level of this SshSettingsSettings.

        Specifies the log level when logging messages from sshd(8).  # noqa: E501

        :param log_level: The log_level of this SshSettingsSettings.  # noqa: E501
        :type: str
        """
        allowed_values = ["INFO", "QUIET", "FATAL", "ERROR", "VERBOSE", "DEBUG", "DEBUG1", "DEBUG2", "DEBUG3"]  # noqa: E501
        if log_level not in allowed_values:
            raise ValueError(
                "Invalid value for `log_level` ({0}), must be one of {1}"  # noqa: E501
                .format(log_level, allowed_values)
            )

        self._log_level = log_level

    @property
    def login_grace_time(self):
        """Gets the login_grace_time of this SshSettingsSettings.  # noqa: E501

        Specifies the length of time in seconds before idle log in fails.  If the value is 0, there is no time limit.  # noqa: E501

        :return: The login_grace_time of this SshSettingsSettings.  # noqa: E501
        :rtype: int
        """
        return self._login_grace_time

    @login_grace_time.setter
    def login_grace_time(self, login_grace_time):
        """Sets the login_grace_time of this SshSettingsSettings.

        Specifies the length of time in seconds before idle log in fails.  If the value is 0, there is no time limit.  # noqa: E501

        :param login_grace_time: The login_grace_time of this SshSettingsSettings.  # noqa: E501
        :type: int
        """
        if login_grace_time is not None and login_grace_time > 600:  # noqa: E501
            raise ValueError("Invalid value for `login_grace_time`, must be a value less than or equal to `600`")  # noqa: E501
        if login_grace_time is not None and login_grace_time < 0:  # noqa: E501
            raise ValueError("Invalid value for `login_grace_time`, must be a value greater than or equal to `0`")  # noqa: E501

        self._login_grace_time = login_grace_time

    @property
    def macs(self):
        """Gets the macs of this SshSettingsSettings.  # noqa: E501

        Specifies the available MAC algorithms.  # noqa: E501

        :return: The macs of this SshSettingsSettings.  # noqa: E501
        :rtype: str
        """
        return self._macs

    @macs.setter
    def macs(self, macs):
        """Sets the macs of this SshSettingsSettings.

        Specifies the available MAC algorithms.  # noqa: E501

        :param macs: The macs of this SshSettingsSettings.  # noqa: E501
        :type: str
        """
        if macs is not None and len(macs) > 4096:
            raise ValueError("Invalid value for `macs`, length must be less than or equal to `4096`")  # noqa: E501
        if macs is not None and len(macs) < 8:
            raise ValueError("Invalid value for `macs`, length must be greater than or equal to `8`")  # noqa: E501
        if macs is not None and not re.search('^(\\+?)(hmac-md5|hmac-md5-96|hmac-sha1|hmac-sha1-96|hmac-sha2-256|hmac-sha2-512|umac-64@openssh.com|umac-128@openssh.com|hmac-md5-etm@openssh.com|hmac-md5-96-etm@openssh.com|hmac-sha1-etm@openssh.com|hmac-sha1-96-etm@openssh.com|hmac-sha2-256-etm@openssh.com|hmac-sha2-512-etm@openssh.com|umac-64-etm@openssh.com|umac-128-etm@openssh.com)(,(hmac-md5|hmac-md5-96|hmac-sha1|hmac-sha1-96|hmac-sha2-256|hmac-sha2-512|umac-64@openssh.com|umac-128@openssh.com|hmac-md5-etm@openssh.com|hmac-md5-96-etm@openssh.com|hmac-sha1-etm@openssh.com|hmac-sha1-96-etm@openssh.com|hmac-sha2-256-etm@openssh.com|hmac-sha2-512-etm@openssh.com|umac-64-etm@openssh.com|umac-128-etm@openssh.com))*$', macs):  # noqa: E501
            raise ValueError("Invalid value for `macs`, must be a follow pattern or equal to `/^(\\+?)(hmac-md5|hmac-md5-96|hmac-sha1|hmac-sha1-96|hmac-sha2-256|hmac-sha2-512|umac-64@openssh.com|umac-128@openssh.com|hmac-md5-etm@openssh.com|hmac-md5-96-etm@openssh.com|hmac-sha1-etm@openssh.com|hmac-sha1-96-etm@openssh.com|hmac-sha2-256-etm@openssh.com|hmac-sha2-512-etm@openssh.com|umac-64-etm@openssh.com|umac-128-etm@openssh.com)(,(hmac-md5|hmac-md5-96|hmac-sha1|hmac-sha1-96|hmac-sha2-256|hmac-sha2-512|umac-64@openssh.com|umac-128@openssh.com|hmac-md5-etm@openssh.com|hmac-md5-96-etm@openssh.com|hmac-sha1-etm@openssh.com|hmac-sha1-96-etm@openssh.com|hmac-sha2-256-etm@openssh.com|hmac-sha2-512-etm@openssh.com|umac-64-etm@openssh.com|umac-128-etm@openssh.com))*$/`")  # noqa: E501

        self._macs = macs

    @property
    def match(self):
        """Gets the match of this SshSettingsSettings.  # noqa: E501

        Specifies match blocks.  # noqa: E501

        :return: The match of this SshSettingsSettings.  # noqa: E501
        :rtype: str
        """
        return self._match

    @match.setter
    def match(self, match):
        """Sets the match of this SshSettingsSettings.

        Specifies match blocks.  # noqa: E501

        :param match: The match of this SshSettingsSettings.  # noqa: E501
        :type: str
        """
        if match is not None and len(match) > 8192:
            raise ValueError("Invalid value for `match`, length must be less than or equal to `8192`")  # noqa: E501
        if match is not None and len(match) < 0:
            raise ValueError("Invalid value for `match`, length must be greater than or equal to `0`")  # noqa: E501

        self._match = match

    @property
    def max_auth_tries(self):
        """Gets the max_auth_tries of this SshSettingsSettings.  # noqa: E501

        Specifies the maximum number of authentication attempts per connection.  # noqa: E501

        :return: The max_auth_tries of this SshSettingsSettings.  # noqa: E501
        :rtype: int
        """
        return self._max_auth_tries

    @max_auth_tries.setter
    def max_auth_tries(self, max_auth_tries):
        """Sets the max_auth_tries of this SshSettingsSettings.

        Specifies the maximum number of authentication attempts per connection.  # noqa: E501

        :param max_auth_tries: The max_auth_tries of this SshSettingsSettings.  # noqa: E501
        :type: int
        """
        if max_auth_tries is not None and max_auth_tries > 1024:  # noqa: E501
            raise ValueError("Invalid value for `max_auth_tries`, must be a value less than or equal to `1024`")  # noqa: E501
        if max_auth_tries is not None and max_auth_tries < 0:  # noqa: E501
            raise ValueError("Invalid value for `max_auth_tries`, must be a value greater than or equal to `0`")  # noqa: E501

        self._max_auth_tries = max_auth_tries

    @property
    def max_sessions(self):
        """Gets the max_sessions of this SshSettingsSettings.  # noqa: E501

        Specifies the maximum number of open sessions permitted per network connection.  # noqa: E501

        :return: The max_sessions of this SshSettingsSettings.  # noqa: E501
        :rtype: int
        """
        return self._max_sessions

    @max_sessions.setter
    def max_sessions(self, max_sessions):
        """Sets the max_sessions of this SshSettingsSettings.

        Specifies the maximum number of open sessions permitted per network connection.  # noqa: E501

        :param max_sessions: The max_sessions of this SshSettingsSettings.  # noqa: E501
        :type: int
        """
        if max_sessions is not None and max_sessions > 1024:  # noqa: E501
            raise ValueError("Invalid value for `max_sessions`, must be a value less than or equal to `1024`")  # noqa: E501
        if max_sessions is not None and max_sessions < 0:  # noqa: E501
            raise ValueError("Invalid value for `max_sessions`, must be a value greater than or equal to `0`")  # noqa: E501

        self._max_sessions = max_sessions

    @property
    def max_startups(self):
        """Gets the max_startups of this SshSettingsSettings.  # noqa: E501

        Specifies maximum number of unauthenticated connections.  # noqa: E501

        :return: The max_startups of this SshSettingsSettings.  # noqa: E501
        :rtype: str
        """
        return self._max_startups

    @max_startups.setter
    def max_startups(self, max_startups):
        """Sets the max_startups of this SshSettingsSettings.

        Specifies maximum number of unauthenticated connections.  # noqa: E501

        :param max_startups: The max_startups of this SshSettingsSettings.  # noqa: E501
        :type: str
        """
        if max_startups is not None and len(max_startups) > 11:
            raise ValueError("Invalid value for `max_startups`, length must be less than or equal to `11`")  # noqa: E501
        if max_startups is not None and len(max_startups) < 0:
            raise ValueError("Invalid value for `max_startups`, length must be greater than or equal to `0`")  # noqa: E501
        if max_startups is not None and not re.search('^$|^([0-9]|[0-9][0-9]|[0-9][0-9][0-9]):([0-9]|[0-9][0-9]|[0-9][0-9][0-9]):([0-9]|[0-9][0-9]|[0-9][0-9][0-9])$', max_startups):  # noqa: E501
            raise ValueError("Invalid value for `max_startups`, must be a follow pattern or equal to `/^$|^([0-9]|[0-9][0-9]|[0-9][0-9][0-9]):([0-9]|[0-9][0-9]|[0-9][0-9][0-9]):([0-9]|[0-9][0-9]|[0-9][0-9][0-9])$/`")  # noqa: E501

        self._max_startups = max_startups

    @property
    def password_authentication(self):
        """Gets the password_authentication of this SshSettingsSettings.  # noqa: E501

        Specifies whether password authentication is allowed.  # noqa: E501

        :return: The password_authentication of this SshSettingsSettings.  # noqa: E501
        :rtype: bool
        """
        return self._password_authentication

    @password_authentication.setter
    def password_authentication(self, password_authentication):
        """Sets the password_authentication of this SshSettingsSettings.

        Specifies whether password authentication is allowed.  # noqa: E501

        :param password_authentication: The password_authentication of this SshSettingsSettings.  # noqa: E501
        :type: bool
        """

        self._password_authentication = password_authentication

    @property
    def permit_empty_passwords(self):
        """Gets the permit_empty_passwords of this SshSettingsSettings.  # noqa: E501

        Enable empty passwords if password authentication is allowed.  # noqa: E501

        :return: The permit_empty_passwords of this SshSettingsSettings.  # noqa: E501
        :rtype: bool
        """
        return self._permit_empty_passwords

    @permit_empty_passwords.setter
    def permit_empty_passwords(self, permit_empty_passwords):
        """Sets the permit_empty_passwords of this SshSettingsSettings.

        Enable empty passwords if password authentication is allowed.  # noqa: E501

        :param permit_empty_passwords: The permit_empty_passwords of this SshSettingsSettings.  # noqa: E501
        :type: bool
        """

        self._permit_empty_passwords = permit_empty_passwords

    @property
    def permit_root_login(self):
        """Gets the permit_root_login of this SshSettingsSettings.  # noqa: E501

        Enable root SSH login.  # noqa: E501

        :return: The permit_root_login of this SshSettingsSettings.  # noqa: E501
        :rtype: bool
        """
        return self._permit_root_login

    @permit_root_login.setter
    def permit_root_login(self, permit_root_login):
        """Sets the permit_root_login of this SshSettingsSettings.

        Enable root SSH login.  # noqa: E501

        :param permit_root_login: The permit_root_login of this SshSettingsSettings.  # noqa: E501
        :type: bool
        """

        self._permit_root_login = permit_root_login

    @property
    def port(self):
        """Gets the port of this SshSettingsSettings.  # noqa: E501

        Specifies the port sshd(8) should listen on  # noqa: E501

        :return: The port of this SshSettingsSettings.  # noqa: E501
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """Sets the port of this SshSettingsSettings.

        Specifies the port sshd(8) should listen on  # noqa: E501

        :param port: The port of this SshSettingsSettings.  # noqa: E501
        :type: int
        """
        if port is not None and port > 65535:  # noqa: E501
            raise ValueError("Invalid value for `port`, must be a value less than or equal to `65535`")  # noqa: E501
        if port is not None and port < 1:  # noqa: E501
            raise ValueError("Invalid value for `port`, must be a value greater than or equal to `1`")  # noqa: E501

        self._port = port

    @property
    def print_motd(self):
        """Gets the print_motd of this SshSettingsSettings.  # noqa: E501

        Enable printing /etc/motd when a user logs in.  # noqa: E501

        :return: The print_motd of this SshSettingsSettings.  # noqa: E501
        :rtype: bool
        """
        return self._print_motd

    @print_motd.setter
    def print_motd(self, print_motd):
        """Sets the print_motd of this SshSettingsSettings.

        Enable printing /etc/motd when a user logs in.  # noqa: E501

        :param print_motd: The print_motd of this SshSettingsSettings.  # noqa: E501
        :type: bool
        """

        self._print_motd = print_motd

    @property
    def pubkey_accepted_key_types(self):
        """Gets the pubkey_accepted_key_types of this SshSettingsSettings.  # noqa: E501

        Specifies the accepted public key types.  # noqa: E501

        :return: The pubkey_accepted_key_types of this SshSettingsSettings.  # noqa: E501
        :rtype: str
        """
        return self._pubkey_accepted_key_types

    @pubkey_accepted_key_types.setter
    def pubkey_accepted_key_types(self, pubkey_accepted_key_types):
        """Sets the pubkey_accepted_key_types of this SshSettingsSettings.

        Specifies the accepted public key types.  # noqa: E501

        :param pubkey_accepted_key_types: The pubkey_accepted_key_types of this SshSettingsSettings.  # noqa: E501
        :type: str
        """
        if pubkey_accepted_key_types is not None and len(pubkey_accepted_key_types) > 4096:
            raise ValueError("Invalid value for `pubkey_accepted_key_types`, length must be less than or equal to `4096`")  # noqa: E501
        if pubkey_accepted_key_types is not None and len(pubkey_accepted_key_types) < 7:
            raise ValueError("Invalid value for `pubkey_accepted_key_types`, length must be greater than or equal to `7`")  # noqa: E501
        if pubkey_accepted_key_types is not None and not re.search('^(\\+?)(ssh-ed25519|ssh-ed25519-cert-v01@openssh\\.com|ssh-rsa|ssh-dss|ecdsa-sha2-nistp256|ecdsa-sha2-nistp384|ecdsa-sha2-nistp521|ssh-rsa-cert-v01@openssh\\.com|ssh-dss-cert-v01@openssh\\.com|ecdsa-sha2-nistp256-cert-v01@openssh\\.com|ecdsa-sha2-nistp384-cert-v01@openssh\\.com|ecdsa-sha2-nistp521-cert-v01@openssh\\.com)(,(ssh-ed25519|ssh-ed25519-cert-v01@openssh\\.com|ssh-rsa|ssh-dss|ecdsa-sha2-nistp256|ecdsa-sha2-nistp384|ecdsa-sha2-nistp521|ssh-rsa-cert-v01@openssh\\.com|ssh-dss-cert-v01@openssh\\.com|ecdsa-sha2-nistp256-cert-v01@openssh\\.com|ecdsa-sha2-nistp384-cert-v01@openssh\\.com|ecdsa-sha2-nistp521-cert-v01@openssh\\.com))*$', pubkey_accepted_key_types):  # noqa: E501
            raise ValueError("Invalid value for `pubkey_accepted_key_types`, must be a follow pattern or equal to `/^(\\+?)(ssh-ed25519|ssh-ed25519-cert-v01@openssh\\.com|ssh-rsa|ssh-dss|ecdsa-sha2-nistp256|ecdsa-sha2-nistp384|ecdsa-sha2-nistp521|ssh-rsa-cert-v01@openssh\\.com|ssh-dss-cert-v01@openssh\\.com|ecdsa-sha2-nistp256-cert-v01@openssh\\.com|ecdsa-sha2-nistp384-cert-v01@openssh\\.com|ecdsa-sha2-nistp521-cert-v01@openssh\\.com)(,(ssh-ed25519|ssh-ed25519-cert-v01@openssh\\.com|ssh-rsa|ssh-dss|ecdsa-sha2-nistp256|ecdsa-sha2-nistp384|ecdsa-sha2-nistp521|ssh-rsa-cert-v01@openssh\\.com|ssh-dss-cert-v01@openssh\\.com|ecdsa-sha2-nistp256-cert-v01@openssh\\.com|ecdsa-sha2-nistp384-cert-v01@openssh\\.com|ecdsa-sha2-nistp521-cert-v01@openssh\\.com))*$/`")  # noqa: E501

        self._pubkey_accepted_key_types = pubkey_accepted_key_types

    @property
    def pubkey_authentication(self):
        """Gets the pubkey_authentication of this SshSettingsSettings.  # noqa: E501

        Specifies whether public key authentication is allowed.  # noqa: E501

        :return: The pubkey_authentication of this SshSettingsSettings.  # noqa: E501
        :rtype: bool
        """
        return self._pubkey_authentication

    @pubkey_authentication.setter
    def pubkey_authentication(self, pubkey_authentication):
        """Sets the pubkey_authentication of this SshSettingsSettings.

        Specifies whether public key authentication is allowed.  # noqa: E501

        :param pubkey_authentication: The pubkey_authentication of this SshSettingsSettings.  # noqa: E501
        :type: bool
        """

        self._pubkey_authentication = pubkey_authentication

    @property
    def strict_modes(self):
        """Gets the strict_modes of this SshSettingsSettings.  # noqa: E501

        Specifies if sshd(8) should check home directory permissions before accepting login.  # noqa: E501

        :return: The strict_modes of this SshSettingsSettings.  # noqa: E501
        :rtype: bool
        """
        return self._strict_modes

    @strict_modes.setter
    def strict_modes(self, strict_modes):
        """Sets the strict_modes of this SshSettingsSettings.

        Specifies if sshd(8) should check home directory permissions before accepting login.  # noqa: E501

        :param strict_modes: The strict_modes of this SshSettingsSettings.  # noqa: E501
        :type: bool
        """

        self._strict_modes = strict_modes

    @property
    def subsystem(self):
        """Gets the subsystem of this SshSettingsSettings.  # noqa: E501

        Specifies an external subsystem.  # noqa: E501

        :return: The subsystem of this SshSettingsSettings.  # noqa: E501
        :rtype: str
        """
        return self._subsystem

    @subsystem.setter
    def subsystem(self, subsystem):
        """Sets the subsystem of this SshSettingsSettings.

        Specifies an external subsystem.  # noqa: E501

        :param subsystem: The subsystem of this SshSettingsSettings.  # noqa: E501
        :type: str
        """
        if subsystem is not None and len(subsystem) > 1024:
            raise ValueError("Invalid value for `subsystem`, length must be less than or equal to `1024`")  # noqa: E501
        if subsystem is not None and len(subsystem) < 0:
            raise ValueError("Invalid value for `subsystem`, length must be greater than or equal to `0`")  # noqa: E501
        if subsystem is not None and not re.search('^[^\\n]*$', subsystem):  # noqa: E501
            raise ValueError("Invalid value for `subsystem`, must be a follow pattern or equal to `/^[^\\n]*$/`")  # noqa: E501

        self._subsystem = subsystem

    @property
    def syslog_facility(self):
        """Gets the syslog_facility of this SshSettingsSettings.  # noqa: E501

        Specifies the facility code when logging messages from sshd(8).  # noqa: E501

        :return: The syslog_facility of this SshSettingsSettings.  # noqa: E501
        :rtype: str
        """
        return self._syslog_facility

    @syslog_facility.setter
    def syslog_facility(self, syslog_facility):
        """Sets the syslog_facility of this SshSettingsSettings.

        Specifies the facility code when logging messages from sshd(8).  # noqa: E501

        :param syslog_facility: The syslog_facility of this SshSettingsSettings.  # noqa: E501
        :type: str
        """
        allowed_values = ["AUTH", "DAEMON", "USER", "LOCAL0", "LOCAL1", "LOCAL2", "LOCAL3", "LOCAL4", "LOCAL5", "LOCAL6", "LOCAL7"]  # noqa: E501
        if syslog_facility not in allowed_values:
            raise ValueError(
                "Invalid value for `syslog_facility` ({0}), must be one of {1}"  # noqa: E501
                .format(syslog_facility, allowed_values)
            )

        self._syslog_facility = syslog_facility

    @property
    def tcp_keep_alive(self):
        """Gets the tcp_keep_alive of this SshSettingsSettings.  # noqa: E501

        Enable sending TCP keep alive messages.  # noqa: E501

        :return: The tcp_keep_alive of this SshSettingsSettings.  # noqa: E501
        :rtype: bool
        """
        return self._tcp_keep_alive

    @tcp_keep_alive.setter
    def tcp_keep_alive(self, tcp_keep_alive):
        """Sets the tcp_keep_alive of this SshSettingsSettings.

        Enable sending TCP keep alive messages.  # noqa: E501

        :param tcp_keep_alive: The tcp_keep_alive of this SshSettingsSettings.  # noqa: E501
        :type: bool
        """

        self._tcp_keep_alive = tcp_keep_alive

    @property
    def use_dns(self):
        """Gets the use_dns of this SshSettingsSettings.  # noqa: E501

        Specifies whether sshd should look up the remote host name.  # noqa: E501

        :return: The use_dns of this SshSettingsSettings.  # noqa: E501
        :rtype: bool
        """
        return self._use_dns

    @use_dns.setter
    def use_dns(self, use_dns):
        """Sets the use_dns of this SshSettingsSettings.

        Specifies whether sshd should look up the remote host name.  # noqa: E501

        :param use_dns: The use_dns of this SshSettingsSettings.  # noqa: E501
        :type: bool
        """

        self._use_dns = use_dns

    @property
    def use_pam(self):
        """Gets the use_pam of this SshSettingsSettings.  # noqa: E501

        Enables the Pluggable Authentication Module interface.  # noqa: E501

        :return: The use_pam of this SshSettingsSettings.  # noqa: E501
        :rtype: bool
        """
        return self._use_pam

    @use_pam.setter
    def use_pam(self, use_pam):
        """Sets the use_pam of this SshSettingsSettings.

        Enables the Pluggable Authentication Module interface.  # noqa: E501

        :param use_pam: The use_pam of this SshSettingsSettings.  # noqa: E501
        :type: bool
        """

        self._use_pam = use_pam

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SshSettingsSettings):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
