/*
 * Decompiled with CFR 0.152.
 */
package utils;

import config.Config;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import utils.TaskRunner;
import utils.TaskRunnerKt;
import utils.TaskRunnerKt$sam$java_lang_Runnable$0;
import utils.TaskRunnerKt$sam$java_util_concurrent_Callable$0;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lutils/TaskRunner;", "", "()V", "Companion", "Shared"})
public final class TaskRunner {
    private static final int DEFAULT_TIMEOUT_SECS;
    private static final ExecutorService executor;
    private static final ExecutorService subExecutor;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        DEFAULT_TIMEOUT_SECS = ((Number)Config.INSTANCE.getSimpleTaskTimeout().get()).intValue();
        executor = Executors.newFixedThreadPool(Math.max(2, Runtime.getRuntime().availableProcessors() - 2));
        subExecutor = Executors.newFixedThreadPool(Math.max(2, Runtime.getRuntime().availableProcessors() - 2));
        TaskRunnerKt.access$getLogger$p().info("TaskRunner has " + Math.max(2, Runtime.getRuntime().availableProcessors() - 2) + " threads");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010\u0014\u001a\u00020\u00132\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015J\u0006\u0010\u0016\u001a\u00020\u000fJ\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lutils/TaskRunner$Companion;", "", "()V", "DEFAULT_TIMEOUT_SECS", "", "getDEFAULT_TIMEOUT_SECS", "()I", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "getExecutor", "()Ljava/util/concurrent/ExecutorService;", "subExecutor", "getSubExecutor", "addTask", "", "task", "Ljava/lang/Runnable;", "name", "", "addTaskAndWait", "Ljava/util/concurrent/Callable;", "bye", "runInThread", "Shared"})
    public static final class Companion {
        public final int getDEFAULT_TIMEOUT_SECS() {
            return DEFAULT_TIMEOUT_SECS;
        }

        public final ExecutorService getExecutor() {
            return executor;
        }

        public final ExecutorService getSubExecutor() {
            return subExecutor;
        }

        public final void runInThread(@NotNull Runnable task) {
            Intrinsics.checkParameterIsNotNull(task, "task");
            new Thread(task).start();
        }

        public final void addTask(@NotNull Runnable task, @NotNull String name) {
            Intrinsics.checkParameterIsNotNull(task, "task");
            Intrinsics.checkParameterIsNotNull(name, "name");
            Function0 wrappingTask2 = new Function0<Unit>(task, name){
                final /* synthetic */ Runnable $task;
                final /* synthetic */ String $name;

                public final void invoke() {
                    try {
                        this.$task.run();
                    }
                    catch (InterruptedException interrupt) {
                        TaskRunnerKt.access$getLogger$p().info("Got interrupt " + interrupt);
                    }
                    catch (Exception t2) {
                        TaskRunnerKt.access$getLogger$p().error("Task " + this.$name + " had error", t2);
                    }
                }
                {
                    this.$task = runnable;
                    this.$name = string2;
                    super(0);
                }
            };
            try {
                Function0 function0 = wrappingTask2;
                this.getExecutor().submit(new TaskRunnerKt$sam$java_lang_Runnable$0(function0));
            }
            catch (RejectedExecutionException e) {
                TaskRunnerKt.access$getLogger$p().error("Rejected task " + name, e);
            }
        }

        @NotNull
        public final String addTaskAndWait(@NotNull Callable<String> task) {
            Function0 wrappingTask2;
            Intrinsics.checkParameterIsNotNull(task, "task");
            Function0 function0 = wrappingTask2 = (Function0)new Function0<String>(task){
                final /* synthetic */ Callable $task;

                @Nullable
                public final String invoke() {
                    String string2;
                    try {
                        string2 = (String)this.$task.call();
                    }
                    catch (InterruptedException interrupt) {
                        TaskRunnerKt.access$getLogger$p().info("Got interrupt " + interrupt);
                        string2 = null;
                    }
                    return string2;
                }
                {
                    this.$task = callable;
                    super(0);
                }
            };
            Future futureResult = this.getSubExecutor().submit(new TaskRunnerKt$sam$java_util_concurrent_Callable$0(function0));
            try {
                String result2 = (String)futureResult.get(this.getDEFAULT_TIMEOUT_SECS(), TimeUnit.SECONDS);
                if (result2 != null) {
                    return result2;
                }
                return "GraphViz timed out";
            }
            catch (Exception e) {
                TaskRunnerKt.access$getLogger$p().info("Got exception " + e + " when getting future result");
                return "GraphViz timed out";
            }
        }

        public final void bye() {
            TaskRunnerKt.access$getLogger$p().info("Pending tasks to finish...");
            bye.1 $fun$getCurrentActive1$1 = bye.1.INSTANCE;
            bye.2 $fun$getCurrentActive2$2 = bye.2.INSTANCE;
            bye.3 $fun$getCompletedCount1$3 = bye.3.INSTANCE;
            bye.4 $fun$getCompletedCount2$4 = bye.4.INSTANCE;
            long currentCompleted1 = $fun$getCompletedCount1$3.invoke();
            long currentCompleted2 = $fun$getCompletedCount2$4.invoke();
            int attemptNumber = 1;
            while (currentCompleted1 > 0L || currentCompleted2 > 0L || attemptNumber <= 5) {
                Thread.sleep((long)((Number)Config.INSTANCE.getPatienceSeconds().get()).intValue() * (long)1000);
                long newCompleted1 = $fun$getCompletedCount1$3.invoke();
                long newCompleted2 = $fun$getCompletedCount2$4.invoke();
                if (($fun$getCurrentActive1$1.invoke() != 0 || $fun$getCurrentActive2$2.invoke() != 0) && currentCompleted1 == newCompleted1 && currentCompleted2 == newCompleted2) {
                    TaskRunnerKt.access$getLogger$p().info("Not all tasks may have ended in time. (1) Completed (before,after) the wait (" + currentCompleted1 + ',' + newCompleted1 + "), (2) Completed (before,after) the wait (" + currentCompleted2 + ',' + newCompleted2 + "). Active: (1) " + $fun$getCurrentActive1$1.invoke() + ", (2) " + $fun$getCurrentActive2$2.invoke() + ". Attempt number " + attemptNumber);
                    if (attemptNumber > 5) break;
                    ++attemptNumber;
                } else {
                    currentCompleted1 = newCompleted1;
                    currentCompleted2 = newCompleted2;
                }
                if ($fun$getCurrentActive1$1.invoke() != 0 || $fun$getCurrentActive2$2.invoke() != 0) continue;
                TaskRunnerKt.access$getLogger$p().info("Done all tasks!");
                break;
            }
            this.getExecutor().shutdownNow();
            this.getSubExecutor().shutdownNow();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

