/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import log.ArtifactManagerFactoryInternal;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import utils.ArtifactFileUtils;
import utils.CommandLineExecutorKt;
import utils.Killer;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\u001a\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0016\u0010\t\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0002\u001a]\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u0018\u001a<\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000e0\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u001a\u001a\u00020\u000e2\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0013\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"logger", "Lmu/KLogger;", "catchInterrupt", "", "f", "Lkotlin/Function0;", "cleanUpProcess", "p", "Ljava/lang/Process;", "noInterrupt", "safeCommandArrayExecLines", "Lkotlin/Pair;", "", "", "", "cmd", "", "outputName", "readStandardOutput", "", "checkExitCode", "timeoutSecs", "", "input", "([Ljava/lang/String;Ljava/lang/String;ZZLjava/lang/Long;Ljava/lang/String;)Lkotlin/Pair;", "safeCommandExec", "outName", "Shared"})
public final class CommandLineExecutorKt {
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(logger.1.INSTANCE);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Pair<Integer, List<String>> safeCommandArrayExecLines(@NotNull String[] cmd, @NotNull String outputName, boolean readStandardOutput, boolean checkExitCode, @Nullable Long timeoutSecs, @Nullable String input) {
        List<String> list2;
        boolean bl;
        int exitValue;
        BufferedReader bufferedOutputReader;
        Object object;
        Object object2;
        File fileOutput;
        boolean redirectStdoutStderr;
        block49: {
            Object object3;
            String stringCommand;
            File fileError;
            block51: {
                block50: {
                    File e2;
                    File file;
                    Intrinsics.checkParameterIsNotNull(cmd, "cmd");
                    Intrinsics.checkParameterIsNotNull(outputName, "outputName");
                    redirectStdoutStderr = readStandardOutput && ArtifactManagerFactoryInternal.Companion.isEnabled();
                    try {
                        file = redirectStdoutStderr ? new File(ArtifactFileUtils.Companion.getCmdErrorFilepath(outputName)) : null;
                    }
                    catch (IllegalStateException e2) {
                        file = null;
                    }
                    fileError = file;
                    try {
                        e2 = redirectStdoutStderr ? new File(ArtifactFileUtils.Companion.getCmdOutputFilepath(outputName)) : null;
                    }
                    catch (IllegalStateException e3) {
                        e2 = null;
                    }
                    fileOutput = e2;
                    boolean hasRedirects = fileError != null && fileOutput != null;
                    stringCommand = ArraysKt.joinToString$default(cmd, (CharSequence)" ", null, null, 0, null, null, 62, null);
                    boolean bl2 = !redirectStdoutStderr || hasRedirects;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    if (!bl2) {
                        boolean bl5 = false;
                        String string2 = "If asked to redirect from stdout/stderr, must have path for output file";
                        throw (Throwable)new IllegalStateException(string2.toString());
                    }
                    if (hasRedirects && redirectStdoutStderr) {
                        Object writer2;
                        File file2 = fileError;
                        if (file2 == null) {
                            Intrinsics.throwNpe();
                        }
                        Closeable closeable = new PrintWriter(file2);
                        bl3 = false;
                        bl4 = false;
                        Throwable throwable = null;
                        try {
                            writer2 = (PrintWriter)closeable;
                            boolean bl6 = false;
                            ((PrintWriter)writer2).println("stderr: " + stringCommand);
                            writer2 = Unit.INSTANCE;
                        }
                        catch (Throwable writer2) {
                            throwable = writer2;
                            throw writer2;
                        }
                        finally {
                            CloseableKt.closeFinally(closeable, throwable);
                        }
                        File file3 = fileOutput;
                        if (file3 == null) {
                            Intrinsics.throwNpe();
                        }
                        closeable = new PrintWriter(file3);
                        bl3 = false;
                        boolean bl7 = false;
                        Throwable throwable2 = null;
                        try {
                            writer2 = (PrintWriter)closeable;
                            boolean bl8 = false;
                            ((PrintWriter)writer2).println("stdout: " + stringCommand);
                            writer2 = Unit.INSTANCE;
                        }
                        catch (Throwable writer222) {
                            throwable2 = writer222;
                            throw writer222;
                        }
                        finally {
                            CloseableKt.closeFinally(closeable, throwable2);
                        }
                    }
                    logger.info((Function0<? extends Object>)new Function0<String>(stringCommand){
                        final /* synthetic */ String $stringCommand;

                        @NotNull
                        public final String invoke() {
                            StringBuilder stringBuilder = new StringBuilder().append("Thread ");
                            Thread thread2 = Thread.currentThread();
                            Intrinsics.checkExpressionValueIsNotNull(thread2, "Thread.currentThread()");
                            return stringBuilder.append(thread2.getId()).append(": Going to start ").append(this.$stringCommand).toString();
                        }
                        {
                            this.$stringCommand = string2;
                            super(0);
                        }
                    });
                    Object object4 = new ProcessBuilder(new String[0]).command(Arrays.copyOf(cmd, cmd.length));
                    bl4 = false;
                    boolean writer222 = false;
                    ProcessBuilder it = object4;
                    boolean bl9 = false;
                    Process p = (redirectStdoutStderr ? it.redirectError(ProcessBuilder.Redirect.appendTo(fileError)).redirectOutput(ProcessBuilder.Redirect.appendTo(fileOutput)) : it).start();
                    if (input != null) {
                        Process process2 = p;
                        Intrinsics.checkExpressionValueIsNotNull(process2, "p");
                        object4 = process2.getOutputStream();
                        bl4 = false;
                        writer222 = false;
                        Throwable writer222 = null;
                        try {
                            OutputStream out = (OutputStream)object4;
                            boolean bl10 = false;
                            object2 = input;
                            Charset charset = Charset.defaultCharset();
                            Intrinsics.checkExpressionValueIsNotNull(charset, "Charset.defaultCharset()");
                            object = charset;
                            OutputStream outputStream = out;
                            boolean bl11 = false;
                            byte[] byArray = ((String)object2).getBytes((Charset)object);
                            Intrinsics.checkNotNullExpressionValue(byArray, "(this as java.lang.String).getBytes(charset)");
                            byte[] byArray2 = byArray;
                            outputStream.write(byArray2);
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable) {
                            writer222 = throwable;
                            throw throwable;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object4, writer222);
                        }
                    }
                    Thread.sleep(100L);
                    Process process3 = p;
                    Intrinsics.checkExpressionValueIsNotNull(process3, "p");
                    InputStream inputStream = process3.getInputStream();
                    Intrinsics.checkExpressionValueIsNotNull(inputStream, "p.inputStream");
                    Closeable closeable = inputStream;
                    Charset writer222 = Charsets.UTF_8;
                    boolean bl12 = false;
                    closeable = new InputStreamReader((InputStream)closeable, writer222);
                    int writer222 = 8192;
                    bl12 = false;
                    bufferedOutputReader = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, writer222);
                    exitValue = 0;
                    try {
                        if (timeoutSecs != null) {
                            p.waitFor(timeoutSecs, TimeUnit.SECONDS);
                        } else {
                            p.waitFor();
                        }
                    }
                    catch (InterruptedException e4) {
                        p.destroyForcibly();
                    }
                    finally {
                        CommandLineExecutorKt.cleanUpProcess(p);
                        exitValue = p.exitValue();
                    }
                    if (!checkExitCode || exitValue == 0) break block49;
                    object3 = fileError;
                    if (object3 == null || (object3 = ((File)object3).getPath()) == null) break block50;
                    Object object5 = object3;
                    bl = false;
                    boolean bl13 = false;
                    Object path = object5;
                    boolean bl14 = false;
                    object3 = TextStreamsKt.readText(new FileReader((String)path));
                    if (object3 != null) break block51;
                }
                object3 = "?";
            }
            Object errors2 = object3;
            StringBuilder stringBuilder = new StringBuilder().append("Failed to run command (").append(stringCommand).append("), exited with code ").append(exitValue).append(", see errors: ");
            Object object6 = fileError;
            if (object6 == null || (object6 = ((File)object6).getPath()) == null) {
                object6 = "N/A";
            }
            StringBuilder stringBuilder2 = stringBuilder.append((String)object6).append(", output: ");
            Object object7 = fileOutput;
            if (object7 == null || (object7 = ((File)object7).getPath()) == null) {
                object7 = "N/A";
            }
            throw (Throwable)new Exception(stringBuilder2.append((String)object7).append(". Details: ").append((String)errors2).toString());
        }
        if (redirectStdoutStderr) {
            File file = fileOutput;
            if (file == null) {
                Intrinsics.throwNpe();
            }
            Closeable closeable = new FileReader(file);
            bl = false;
            boolean bl15 = false;
            object2 = null;
            try {
                FileReader reader = (FileReader)closeable;
                boolean bl16 = false;
                object = TextStreamsKt.readLines(reader);
                list2 = object;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally(closeable, (Throwable)object2);
            }
        } else {
            list2 = readStandardOutput ? TextStreamsKt.readLines(bufferedOutputReader) : CollectionsKt.emptyList();
        }
        List lineList = list2;
        return new Pair<Integer, List<String>>(exitValue, lineList);
    }

    public static /* synthetic */ Pair safeCommandArrayExecLines$default(String[] stringArray, String string2, boolean bl, boolean bl2, Long l, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        if ((n & 0x20) != 0) {
            string3 = null;
        }
        return CommandLineExecutorKt.safeCommandArrayExecLines(stringArray, string2, bl, bl2, l, string3);
    }

    private static final void noInterrupt(Function0<Unit> f) {
        boolean again = false;
        do {
            try {
                f.invoke();
                again = false;
            }
            catch (InterruptedException e) {
                again = true;
                StackTraceElement loc = e.getStackTrace()[1];
                logger.warn((Function0<? extends Object>)new Function0<String>(loc){
                    final /* synthetic */ StackTraceElement $loc;

                    @NotNull
                    public final String invoke() {
                        StringBuilder stringBuilder = new StringBuilder().append("Thread ");
                        Thread thread2 = Thread.currentThread();
                        Intrinsics.checkExpressionValueIsNotNull(thread2, "Thread.currentThread()");
                        StringBuilder stringBuilder2 = stringBuilder.append(thread2.getId()).append(": Got Interrupted exception during noInterrupt at ");
                        StackTraceElement stackTraceElement = this.$loc;
                        Intrinsics.checkExpressionValueIsNotNull(stackTraceElement, "loc");
                        StringBuilder stringBuilder3 = stringBuilder2.append(stackTraceElement.getMethodName()).append(" in ");
                        StackTraceElement stackTraceElement2 = this.$loc;
                        Intrinsics.checkExpressionValueIsNotNull(stackTraceElement2, "loc");
                        StringBuilder stringBuilder4 = stringBuilder3.append(stackTraceElement2.getFileName()).append(':');
                        StackTraceElement stackTraceElement3 = this.$loc;
                        Intrinsics.checkExpressionValueIsNotNull(stackTraceElement3, "loc");
                        return stringBuilder4.append(stackTraceElement3.getLineNumber()).toString();
                    }
                    {
                        this.$loc = stackTraceElement;
                        super(0);
                    }
                });
            }
        } while (again);
    }

    private static final void catchInterrupt(Function0<Unit> f) {
        try {
            f.invoke();
        }
        catch (InterruptedException e) {
            StackTraceElement loc = e.getStackTrace()[1];
            logger.warn((Function0<? extends Object>)new Function0<String>(loc){
                final /* synthetic */ StackTraceElement $loc;

                @NotNull
                public final String invoke() {
                    StringBuilder stringBuilder = new StringBuilder().append("Thread ");
                    Thread thread2 = Thread.currentThread();
                    Intrinsics.checkExpressionValueIsNotNull(thread2, "Thread.currentThread()");
                    StringBuilder stringBuilder2 = stringBuilder.append(thread2.getId()).append(": Got Interrupted exception during catchInterrupt at ");
                    StackTraceElement stackTraceElement = this.$loc;
                    Intrinsics.checkExpressionValueIsNotNull(stackTraceElement, "loc");
                    StringBuilder stringBuilder3 = stringBuilder2.append(stackTraceElement.getMethodName()).append(" in ");
                    StackTraceElement stackTraceElement2 = this.$loc;
                    Intrinsics.checkExpressionValueIsNotNull(stackTraceElement2, "loc");
                    StringBuilder stringBuilder4 = stringBuilder3.append(stackTraceElement2.getFileName()).append(':');
                    StackTraceElement stackTraceElement3 = this.$loc;
                    Intrinsics.checkExpressionValueIsNotNull(stackTraceElement3, "loc");
                    return stringBuilder4.append(stackTraceElement3.getLineNumber()).toString();
                }
                {
                    this.$loc = stackTraceElement;
                    super(0);
                }
            });
        }
    }

    private static final void cleanUpProcess(Process p) {
        try {
            if (!p.isAlive()) {
                logger.info((Function0<? extends Object>)new Function0<String>(p){
                    final /* synthetic */ Process $p;

                    @NotNull
                    public final String invoke() {
                        StringBuilder stringBuilder = new StringBuilder().append("Thread ");
                        Thread thread2 = Thread.currentThread();
                        Intrinsics.checkExpressionValueIsNotNull(thread2, "Thread.currentThread()");
                        return stringBuilder.append(thread2.getId()).append(": Process ").append(this.$p.pid()).append(" was dead before cleanup").toString();
                    }
                    {
                        this.$p = process2;
                        super(0);
                    }
                });
                CommandLineExecutorKt.noInterrupt(new Function0<Unit>(p){
                    final /* synthetic */ Process $p;

                    public final void invoke() {
                        this.$p.waitFor();
                    }
                    {
                        this.$p = process2;
                        super(0);
                    }
                });
                return;
            }
            ProcessHandle processHandle = p.toHandle();
            Intrinsics.checkExpressionValueIsNotNull(processHandle, "p.toHandle()");
            Killer killer = new Killer(processHandle);
            CommandLineExecutorKt.noInterrupt(new Function0<Unit>(killer){
                final /* synthetic */ Killer $killer;

                public final void invoke() {
                    this.$killer.destroyChilds();
                }
                {
                    this.$killer = killer;
                    super(0);
                }
            });
            CommandLineExecutorKt.catchInterrupt(cleanUpProcess.4.INSTANCE);
            CommandLineExecutorKt.noInterrupt(new Function0<Unit>(killer){
                final /* synthetic */ Killer $killer;

                public final void invoke() {
                    this.$killer.destroyChildsForcibly();
                }
                {
                    this.$killer = killer;
                    super(0);
                }
            });
            CommandLineExecutorKt.catchInterrupt(cleanUpProcess.6.INSTANCE);
            if (p.isAlive()) {
                logger.info((Function0<? extends Object>)new Function0<String>(p){
                    final /* synthetic */ Process $p;

                    @NotNull
                    public final String invoke() {
                        return "Why does " + this.$p.pid() + " does not want to die?";
                    }
                    {
                        this.$p = process2;
                        super(0);
                    }
                });
            }
            CommandLineExecutorKt.noInterrupt(new Function0<Unit>(p){
                final /* synthetic */ Process $p;

                public final void invoke() {
                    this.$p.waitFor();
                }
                {
                    this.$p = process2;
                    super(0);
                }
            });
        }
        catch (Exception e) {
            logger.error("Clean up process failed by exception " + e);
        }
    }

    @NotNull
    public static final Pair<Integer, String> safeCommandExec(@NotNull List<String> cmd, @NotNull String outName, boolean readStandardOutput, boolean checkExitCode) {
        Intrinsics.checkParameterIsNotNull(cmd, "cmd");
        Intrinsics.checkParameterIsNotNull(outName, "outName");
        Collection $this$toTypedArray$iv = cmd;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Pair res2 = CommandLineExecutorKt.safeCommandArrayExecLines$default(stringArray, outName, readStandardOutput, checkExitCode, null, null, 32, null);
        List lineList = (List)res2.getSecond();
        StringBuffer sb = new StringBuffer();
        Iterable $this$forEach$iv = lineList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String l = (String)element$iv;
            boolean bl = false;
            Appendable appendable = sb;
            boolean bl2 = false;
            Appendable appendable2 = appendable.append(l);
            Intrinsics.checkNotNullExpressionValue(appendable2, "append(value)");
            StringsKt.appendln(appendable2);
        }
        return new Pair<Integer, String>((Integer)res2.getFirst(), sb.toString());
    }

    public static /* synthetic */ Pair safeCommandExec$default(List list2, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return CommandLineExecutorKt.safeCommandExec(list2, string2, bl, bl2);
    }
}

