/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast;

import java.io.Serializable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spec.CVLErrorLogger;
import spec.cvlast.CVLErrorType;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLExpTag;
import spec.cvlast.CVLFunctionType;
import spec.cvlast.CVLInbuiltSimpleTypes;
import spec.cvlast.CVLInbuiltStructTypes;
import spec.cvlast.CVLLocation;
import spec.cvlast.CVLSimpleType;
import spec.cvlast.CVLTupleType;
import spec.cvlast.CVLType;
import spec.cvlast.CVLTypeCheckerSettings;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005J(\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005J\"\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u000e\u00a8\u0006\u0013"}, d2={"Lspec/cvlast/CVLTypeConversions;", "", "()V", "convertToSameArithmeticType", "Lkotlin/Triple;", "Lspec/cvlast/CVLExp;", "", "lTypeChecked", "rTypeChecked", "convertToSameType", "convertTypeIfPossible", "Lkotlin/Pair;", "exp", "targetType", "Lspec/cvlast/CVLType;", "convertTypeIfPossibleAssertSuccess", "convertTypeToSimpleIfPossible", "isConvertibleToArithmeticType", "typeRaw", "Shared"})
public final class CVLTypeConversions {
    public static final CVLTypeConversions INSTANCE;

    @Nullable
    public final CVLExp convertTypeToSimpleIfPossible(@NotNull CVLExp exp) {
        Intrinsics.checkParameterIsNotNull(exp, "exp");
        CVLType type = exp.getCVLType();
        if (type instanceof CVLSimpleType) {
            return exp;
        }
        if (type instanceof CVLTupleType) {
            CVLExp cVLExp;
            if (((CVLTupleType)type).getTuple().size() == 1) {
                Pair<CVLExp, Boolean> res2 = this.convertTypeIfPossible(exp, CollectionsKt.first(((CVLTupleType)type).getTuple()));
                boolean bl = res2.getSecond();
                boolean bl2 = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl4 = false;
                    String string2 = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                cVLExp = res2.getFirst();
            } else {
                cVLExp = null;
            }
            return cVLExp;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CVLExp convertTypeIfPossibleAssertSuccess(@NotNull CVLExp exp, @NotNull CVLType targetType) {
        void converted;
        Intrinsics.checkParameterIsNotNull(exp, "exp");
        Intrinsics.checkParameterIsNotNull(targetType, "targetType");
        Pair<CVLExp, Boolean> pair = this.convertTypeIfPossible(exp, targetType);
        CVLExp cVLExp = pair.component1();
        boolean success = pair.component2();
        if (!success) {
            throw (Throwable)((Object)new AssertionError((Object)"conversion must succeed when using this method"));
        }
        return converted;
    }

    @NotNull
    public final Pair<CVLExp, Boolean> convertTypeIfPossible(@NotNull CVLExp exp, @NotNull CVLType targetType) {
        Intrinsics.checkParameterIsNotNull(exp, "exp");
        Intrinsics.checkParameterIsNotNull(targetType, "targetType");
        if (exp.getCVLType() instanceof CVLErrorType) {
            return new Pair<CVLExp, Boolean>(exp, true);
        }
        if (exp instanceof CVLExp.VariableExp) {
            return ((CVLExp.VariableExp)exp).isWildCard() ? TuplesKt.to(CVLExp.VariableExp.copy$default((CVLExp.VariableExp)exp, null, new CVLExpTag(targetType), null, 5, null), true) : (exp.getCVLType().isConvertibleTo(targetType) ? TuplesKt.to(exp, true) : TuplesKt.to(exp, false));
        }
        if (Intrinsics.areEqual(targetType, CVLInbuiltSimpleTypes.numberLiteral.INSTANCE.getCvlType())) {
            return new Pair<CVLExp, Boolean>(exp, false);
        }
        if (targetType instanceof CVLErrorType) {
            return new Pair<CVLExp, Boolean>(exp, true);
        }
        if (!exp.getCVLType().isConvertibleTo(targetType)) {
            return new Pair<CVLExp, Boolean>(exp, false);
        }
        return new Pair<CVLExp, Boolean>(exp.updateTag(exp.getTag().updateType(targetType)), true);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Triple<CVLExp, CVLExp, Boolean> convertToSameType(@NotNull CVLExp lTypeChecked, @NotNull CVLExp rTypeChecked) {
        Intrinsics.checkParameterIsNotNull(lTypeChecked, "lTypeChecked");
        Intrinsics.checkParameterIsNotNull(rTypeChecked, "rTypeChecked");
        CVLType lType = lTypeChecked.getCVLType();
        CVLType rType = rTypeChecked.getCVLType();
        if (lType instanceof CVLErrorType || rType instanceof CVLErrorType) {
            return new Triple<CVLExp, CVLExp, Boolean>(lTypeChecked, rTypeChecked, true);
        }
        if (Intrinsics.areEqual(lType, rTypeChecked.getCVLType()) || Intrinsics.areEqual(lType, CVLInbuiltSimpleTypes.mathint.INSTANCE.getCvlType()) && rTypeChecked.getCVLType().isConvertibleTo(CVLInbuiltSimpleTypes.mathint.INSTANCE.getCvlType()) || Intrinsics.areEqual(rTypeChecked.getCVLType(), CVLInbuiltSimpleTypes.mathint.INSTANCE.getCvlType()) && lType.isConvertibleTo(CVLInbuiltSimpleTypes.mathint.INSTANCE.getCvlType())) {
            return new Triple<CVLExp, CVLExp, Boolean>(lTypeChecked, rTypeChecked, true);
        }
        if (lType instanceof CVLTupleType && ((CVLTupleType)lType).getTuple().size() == 1 && !(rType instanceof CVLTupleType)) {
            return this.convertToSameType(lTypeChecked.updateType(CollectionsKt.first(((CVLTupleType)lType).getTuple())), rTypeChecked);
        }
        if (rType instanceof CVLTupleType && ((CVLTupleType)rType).getTuple().size() == 1 && !(lType instanceof CVLTupleType)) {
            return this.convertToSameType(lTypeChecked, rTypeChecked.updateType(CollectionsKt.first(((CVLTupleType)rType).getTuple())));
        }
        if (Intrinsics.areEqual(lType, CVLInbuiltSimpleTypes.uint.INSTANCE.getCvlType())) {
            return this.convertToSameType(lTypeChecked.updateType(CVLInbuiltSimpleTypes.Companion.uint(256).getCvlType()), rTypeChecked);
        }
        if (Intrinsics.areEqual(rType, CVLInbuiltSimpleTypes.uint.INSTANCE.getCvlType())) {
            return this.convertToSameType(lTypeChecked, rTypeChecked.updateType(CVLInbuiltSimpleTypes.Companion.uint(256).getCvlType()));
        }
        if (Intrinsics.areEqual(lType, CVLInbuiltSimpleTypes.Companion.bytes(32).getCvlType())) {
            return this.convertToSameType(lTypeChecked.updateType(CVLInbuiltSimpleTypes.Companion.uint(256).getCvlType()), rTypeChecked);
        }
        if (Intrinsics.areEqual(rType, CVLInbuiltSimpleTypes.Companion.bytes(32).getCvlType())) {
            return this.convertToSameType(lTypeChecked, rTypeChecked.updateType(CVLInbuiltSimpleTypes.Companion.uint(256).getCvlType()));
        }
        Serializable serializable = this.convertTypeIfPossible(lTypeChecked, rType);
        CVLExp cVLExp = serializable.component1();
        boolean lIsConvertible = serializable.component2();
        if (lIsConvertible) {
            void newLType;
            return new Triple<void, CVLExp, Boolean>(newLType, rTypeChecked, true);
        }
        Pair<CVLExp, Boolean> pair = this.convertTypeIfPossible(rTypeChecked, lType);
        serializable = pair.component1();
        boolean rIsConvertible = pair.component2();
        if (rIsConvertible) {
            void newRType;
            return new Triple<CVLExp, void, Boolean>(lTypeChecked, newRType, true);
        }
        CVLErrorLogger.INSTANCE.warn("unable to convert from (" + lTypeChecked + " : " + lType + ") to (" + rTypeChecked + " : " + rType + ')', new CVLLocation.Empty(null, 1, null));
        if (Intrinsics.areEqual(lType, CVLInbuiltStructTypes.methodType.getCvlType()) && rType instanceof CVLFunctionType || Intrinsics.areEqual(rType, CVLInbuiltStructTypes.methodType.getCvlType()) && lType instanceof CVLFunctionType) {
            CVLErrorLogger.INSTANCE.warn("Possible reason for this error: used a function's name (e.g. 'foo') instead of canonical name (e.g. 'foo(uint256, uint256) in a comparison with a method variable.", new CVLLocation.Empty(null, 1, null));
        }
        return new Triple<CVLExp, CVLExp, Boolean>(lTypeChecked, rTypeChecked, false);
    }

    @NotNull
    public final Triple<CVLExp, CVLExp, Boolean> convertToSameArithmeticType(@NotNull CVLExp lTypeChecked, @NotNull CVLExp rTypeChecked) {
        Intrinsics.checkParameterIsNotNull(lTypeChecked, "lTypeChecked");
        Intrinsics.checkParameterIsNotNull(rTypeChecked, "rTypeChecked");
        if (!this.isConvertibleToArithmeticType(lTypeChecked.getCVLType()) || !this.isConvertibleToArithmeticType(rTypeChecked.getCVLType())) {
            return new Triple<CVLExp, CVLExp, Boolean>(lTypeChecked, rTypeChecked, false);
        }
        return this.convertToSameType(lTypeChecked, rTypeChecked);
    }

    public final boolean isConvertibleToArithmeticType(@NotNull CVLType typeRaw) {
        boolean bl;
        CVLType type;
        Intrinsics.checkParameterIsNotNull(typeRaw, "typeRaw");
        CVLType cVLType = type = typeRaw instanceof CVLTupleType && ((CVLTupleType)typeRaw).getTuple().size() == 1 ? ((CVLTupleType)typeRaw).getTuple().get(0) : typeRaw;
        if (!(type instanceof CVLSimpleType.Inbuilt)) {
            return false;
        }
        CVLInbuiltSimpleTypes cVLInbuiltSimpleTypes = ((CVLSimpleType.Inbuilt)type).getEType();
        if (cVLInbuiltSimpleTypes instanceof CVLInbuiltSimpleTypes.EVMArray) {
            bl = false;
        } else if (cVLInbuiltSimpleTypes instanceof CVLInbuiltSimpleTypes.EVMStruct) {
            bl = false;
        } else if (Intrinsics.areEqual(cVLInbuiltSimpleTypes, CVLInbuiltSimpleTypes.calldataarg.INSTANCE)) {
            bl = false;
        } else if (Intrinsics.areEqual(cVLInbuiltSimpleTypes, CVLInbuiltSimpleTypes.storage.INSTANCE)) {
            bl = false;
        } else if (cVLInbuiltSimpleTypes instanceof CVLInbuiltSimpleTypes.UIntK) {
            bl = true;
        } else if (Intrinsics.areEqual(cVLInbuiltSimpleTypes, CVLInbuiltSimpleTypes.uint.INSTANCE)) {
            bl = true;
        } else if (Intrinsics.areEqual(cVLInbuiltSimpleTypes, CVLInbuiltSimpleTypes.int.INSTANCE)) {
            bl = true;
        } else if (cVLInbuiltSimpleTypes instanceof CVLInbuiltSimpleTypes.IntK) {
            bl = true;
        } else if (Intrinsics.areEqual(cVLInbuiltSimpleTypes, CVLInbuiltSimpleTypes.mathint.INSTANCE)) {
            bl = true;
        } else if (Intrinsics.areEqual(cVLInbuiltSimpleTypes, CVLInbuiltSimpleTypes.address.INSTANCE)) {
            bl = CVLTypeCheckerSettings.INSTANCE.isImplicitConversionAllowed(CVLInbuiltSimpleTypes.address.INSTANCE.getCvlType(), CVLInbuiltSimpleTypes.Companion.uint(256).getCvlType());
        } else if (Intrinsics.areEqual(cVLInbuiltSimpleTypes, CVLInbuiltSimpleTypes.bool.INSTANCE)) {
            bl = false;
        } else if (Intrinsics.areEqual(cVLInbuiltSimpleTypes, CVLInbuiltSimpleTypes.string.INSTANCE)) {
            bl = false;
        } else if (Intrinsics.areEqual(cVLInbuiltSimpleTypes, CVLInbuiltSimpleTypes.bytes.INSTANCE)) {
            bl = false;
        } else if (cVLInbuiltSimpleTypes instanceof CVLInbuiltSimpleTypes.StoragePointer) {
            bl = false;
        } else if (cVLInbuiltSimpleTypes instanceof CVLInbuiltSimpleTypes.Opaque) {
            bl = false;
        } else if (cVLInbuiltSimpleTypes instanceof CVLInbuiltSimpleTypes.BytesK) {
            bl = false;
        } else if (Intrinsics.areEqual(cVLInbuiltSimpleTypes, CVLInbuiltSimpleTypes.numberLiteral.INSTANCE)) {
            bl = true;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    private CVLTypeConversions() {
    }

    static {
        CVLTypeConversions cVLTypeConversions;
        INSTANCE = cVLTypeConversions = new CVLTypeConversions();
    }
}

