/*
 * Decompiled with CFR 0.152.
 */
package scene;

import caching.WithMemento;
import disassembler.DisassembledEVMBytecode;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import scene.IMutableStorageInfo;
import scene.IScene;
import scene.ITACMethod;
import scene.MethodAttribute;
import tac.ICoreTACProgram;
import tac.IStorageInfo;
import tac.TACStorageSlot;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00013J\b\u0010\u0017\u001a\u00020\u0000H&J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u001bH&J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001d\u001a\u00020\u0004H&J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001f\u001a\u00020 H&J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00190\"H\u0016J\u001c\u0010#\u001a\u0016\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020%\u0018\u00010$j\u0004\u0018\u0001`&H&J\b\u0010'\u001a\u00020\u0019H\u0016J*\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0018\u0010,\u001a\u0014\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020.0-H&J*\u0010/\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0018\u0010,\u001a\u0014\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020)0-H\u0016J\u0010\u00100\u001a\u00020)2\u0006\u00101\u001a\u00020\u0002H\u0016J\b\u00102\u001a\u00020\u0002H\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u0004\u0018\u00010\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0012\u0010\u0013\u001a\u00020\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00064"}, d2={"Lscene/IContractClass;", "Lcaching/WithMemento;", "Lscene/IContractClass$ContractMemento;", "address", "Ljava/math/BigInteger;", "getAddress", "()Ljava/math/BigInteger;", "bytecode", "Ldisassembler/DisassembledEVMBytecode;", "getBytecode", "()Ldisassembler/DisassembledEVMBytecode;", "constructorBytecode", "getConstructorBytecode", "constructorCodeName", "", "getConstructorCodeName", "()Ljava/lang/String;", "name", "getName", "storage", "Ltac/IStorageInfo;", "getStorage", "()Ltac/IStorageInfo;", "fork", "getConstructor", "Lscene/ITACMethod;", "getDeclaredMethods", "", "getMethodBySigHash", "sig", "getMethodByUniqueAttribute", "attr", "Lscene/MethodAttribute$Unique;", "getMethods", "", "getStorageLayout", "", "Ltac/TACStorageSlot;", "Ltac/TACStorageLayout;", "getWholeContract", "mapMethods", "", "scene", "Lscene/IScene;", "p", "Lkotlin/Function2;", "Ltac/ICoreTACProgram;", "mapMethodsInPlace", "restore", "m", "saveState", "ContractMemento", "Shared"})
public interface IContractClass
extends WithMemento<ContractMemento> {
    @NotNull
    public ITACMethod getWholeContract();

    @Nullable
    public ITACMethod getConstructor();

    @Nullable
    public ITACMethod getMethodBySigHash(@NotNull BigInteger var1);

    @Nullable
    public ITACMethod getMethodByUniqueAttribute(@NotNull MethodAttribute.Unique var1);

    @NotNull
    public IStorageInfo getStorage();

    @Nullable
    public Map<String, TACStorageSlot> getStorageLayout();

    @NotNull
    public List<ITACMethod> getMethods();

    @NotNull
    public Collection<ITACMethod> getDeclaredMethods();

    public void mapMethodsInPlace(@NotNull IScene var1, @NotNull Function2<? super IScene, ? super ITACMethod, Unit> var2);

    public void mapMethods(@NotNull IScene var1, @NotNull Function2<? super IScene, ? super ITACMethod, ? extends ICoreTACProgram> var2);

    @NotNull
    public IContractClass fork();

    @NotNull
    public BigInteger getAddress();

    @NotNull
    public String getName();

    @Nullable
    public DisassembledEVMBytecode getBytecode();

    @Nullable
    public DisassembledEVMBytecode getConstructorBytecode();

    @NotNull
    public String getConstructorCodeName();

    @Override
    @NotNull
    public ContractMemento saveState();

    @Override
    public void restore(@NotNull ContractMemento var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B+\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lscene/IContractClass$ContractMemento;", "Ljava/io/Serializable;", "methods", "", "Ljava/math/BigInteger;", "Ltac/ICoreTACProgram;", "constructorCode", "Lscene/ITACMethod;", "storageInfo", "Ltac/IStorageInfo;", "(Ljava/util/Map;Lscene/ITACMethod;Ltac/IStorageInfo;)V", "getConstructorCode", "()Lscene/ITACMethod;", "getMethods", "()Ljava/util/Map;", "getStorageInfo", "()Ltac/IStorageInfo;", "Shared"})
    public static final class ContractMemento
    implements Serializable {
        @NotNull
        private final Map<BigInteger, ICoreTACProgram> methods;
        @Nullable
        private final ITACMethod constructorCode;
        @NotNull
        private final IStorageInfo storageInfo;

        @NotNull
        public final Map<BigInteger, ICoreTACProgram> getMethods() {
            return this.methods;
        }

        @Nullable
        public final ITACMethod getConstructorCode() {
            return this.constructorCode;
        }

        @NotNull
        public final IStorageInfo getStorageInfo() {
            return this.storageInfo;
        }

        public ContractMemento(@NotNull Map<BigInteger, ? extends ICoreTACProgram> methods, @Nullable ITACMethod constructorCode, @NotNull IStorageInfo storageInfo) {
            Intrinsics.checkParameterIsNotNull(methods, "methods");
            Intrinsics.checkParameterIsNotNull(storageInfo, "storageInfo");
            this.methods = methods;
            this.constructorCode = constructorCode;
            this.storageInfo = storageInfo;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @NotNull
        public static ITACMethod getWholeContract(IContractClass $this) {
            ITACMethod iTACMethod = $this.getMethodByUniqueAttribute(MethodAttribute.Unique.Whole.INSTANCE);
            if (iTACMethod == null) {
                String string2 = "Can't ask for whole contract before loading";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            return iTACMethod;
        }

        @Nullable
        public static ITACMethod getConstructor(IContractClass $this) {
            return $this.getMethodByUniqueAttribute(MethodAttribute.Unique.Constructor.INSTANCE);
        }

        @NotNull
        public static List<ITACMethod> getMethods(IContractClass $this) {
            return CollectionsKt.plus($this.getDeclaredMethods(), $this.getWholeContract());
        }

        public static void mapMethodsInPlace(IContractClass $this, @NotNull IScene scene, @NotNull Function2<? super IScene, ? super ITACMethod, Unit> p) {
            Intrinsics.checkParameterIsNotNull(scene, "scene");
            Intrinsics.checkParameterIsNotNull(p, "p");
            Iterable $this$forEach$iv = $this.getDeclaredMethods();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ITACMethod it = (ITACMethod)element$iv;
                boolean bl = false;
                p.invoke(scene, it);
            }
        }

        @NotNull
        public static String getConstructorCodeName(IContractClass $this) {
            return "constructor_" + $this.getName();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static ContractMemento saveState(IContractClass $this) {
            Collection<Pair<BigInteger, ICoreTACProgram>> collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this.getMethods();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ITACMethod iTACMethod = (ITACMethod)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Pair<BigInteger, ICoreTACProgram> pair = TuplesKt.to(it.getSigHash().getN(), it.getCode());
                collection.add(pair);
            }
            collection = (List)destination$iv$iv;
            IStorageInfo iStorageInfo = $this.getStorage();
            ITACMethod iTACMethod = $this.getConstructor();
            Map map2 = MapsKt.toMap((Iterable)collection);
            return new ContractMemento(map2, iTACMethod, iStorageInfo);
        }

        public static void restore(IContractClass $this, @NotNull ContractMemento m) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            Iterator<ITACMethod> iterator2 = $this.getMethods().iterator();
            while (iterator2.hasNext()) {
                ITACMethod meth;
                ITACMethod iTACMethod = meth = iterator2.next();
                ICoreTACProgram iCoreTACProgram = m.getMethods().get(meth.getSigHash().getN());
                if (iCoreTACProgram == null) {
                    String string2 = "Broken cache";
                    ITACMethod iTACMethod2 = iTACMethod;
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                iTACMethod.setCode(iCoreTACProgram);
            }
            ITACMethod iTACMethod = $this.getConstructor();
            if (iTACMethod != null) {
                ITACMethod iTACMethod3 = m.getConstructorCode();
                if (iTACMethod3 == null) {
                    Intrinsics.throwNpe();
                }
                iTACMethod.setCode(iTACMethod3.getCode());
            }
            if ($this instanceof IMutableStorageInfo) {
                ((IMutableStorageInfo)((Object)$this)).setStorageInfo(m.getStorageInfo());
            } else {
                boolean bl = Intrinsics.areEqual($this.getStorage(), m.getStorageInfo());
                boolean bl2 = false;
                boolean bl3 = false;
                bl3 = false;
                boolean bl4 = false;
                if (!bl) {
                    boolean bl5 = false;
                    String string3 = "Check failed.";
                    throw (Throwable)new IllegalStateException(string3.toString());
                }
            }
        }
    }
}

