/*
 * Decompiled with CFR 0.152.
 */
package log;

import config.Config;
import java.io.OutputStreamWriter;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import log.ArtifactManagerFactoryInternal;
import log.ILogger;
import log.Logger;
import log.LoggerKt;
import log.LoggerTypes;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import utils.OutPrinter;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012H\u0016J\u001e\u0010\u0011\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Llog/Logger;", "Llog/ILogger;", "type", "Llog/LoggerTypes;", "(Llog/LoggerTypes;)V", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "getType", "()Llog/LoggerTypes;", "error", "", "s", "", "isEnabled", "", "warn", "Lkotlin/Function0;", "t", "", "Companion", "Shared"})
public final class Logger
implements ILogger {
    @NotNull
    private final KLogger logger;
    @NotNull
    private final LoggerTypes type;
    private static final Lazy regressionFile$delegate;
    public static final Companion Companion;

    @Override
    @NotNull
    public KLogger getLogger() {
        return this.logger;
    }

    @Override
    public boolean isEnabled() {
        return Config.INSTANCE.isEnabledLogger(this.type);
    }

    @Override
    public void error(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull(s, "s");
        OutPrinter.INSTANCE._println(s, false, true, false);
        this.getLogger().error(s);
    }

    public final void warn(@NotNull Function0<String> s, @Nullable Throwable t2) {
        Intrinsics.checkParameterIsNotNull(s, "s");
        OutPrinter.INSTANCE._println(s.invoke(), true, false, false);
        ILogger.DefaultImpls.warn(this, t2, s);
    }

    @Override
    public void warn(@NotNull Function0<String> s) {
        Intrinsics.checkParameterIsNotNull(s, "s");
        this.warn(s, null);
    }

    @NotNull
    public final LoggerTypes getType() {
        return this.type;
    }

    public Logger(@NotNull LoggerTypes type) {
        String levelProp;
        String level;
        Intrinsics.checkParameterIsNotNull((Object)type, "type");
        this.type = type;
        String verboseProp = "verbose." + StringsKt.removePrefix(this.type.toDebugTopic(), (CharSequence)"topic.");
        String levelString = null;
        if (System.getProperty(verboseProp) != null) {
            levelString = "debug";
        }
        if ((level = System.getProperty(levelProp = "level." + StringsKt.removePrefix(this.type.toDebugTopic(), (CharSequence)"topic."))) != null) {
            levelString = level;
        }
        if (levelString != null) {
            System.setProperty("org.slf4j.simpleLogger.log." + (Object)((Object)this.type), levelString);
            if (System.getProperty(this.type.toDebugTopic()) == null) {
                System.setProperty(this.type.toDebugTopic(), "1");
            }
        }
        this.logger = KotlinLogging.INSTANCE.logger(this.type.toString());
    }

    static {
        Companion = new Companion(null);
        regressionFile$delegate = LazyKt.lazy(Companion.regressionFile.2.INSTANCE);
    }

    @Override
    public void error(@NotNull Function0<String> l) {
        Intrinsics.checkParameterIsNotNull(l, "l");
        ILogger.DefaultImpls.error((ILogger)this, l);
    }

    @Override
    public void error(@Nullable Throwable t2, @NotNull Function0<? extends Object> lazyMsg) {
        Intrinsics.checkParameterIsNotNull(lazyMsg, "lazyMsg");
        ILogger.DefaultImpls.error(this, t2, lazyMsg);
    }

    @Override
    public void warn(@Nullable Throwable t2, @NotNull Function0<? extends Object> lazyMsg) {
        Intrinsics.checkParameterIsNotNull(lazyMsg, "lazyMsg");
        ILogger.DefaultImpls.warn(this, t2, lazyMsg);
    }

    @Override
    public void debug(@NotNull Function0<String> s) {
        Intrinsics.checkParameterIsNotNull(s, "s");
        ILogger.DefaultImpls.debug(this, s);
    }

    @Override
    public void info(@NotNull Function0<String> s) {
        Intrinsics.checkParameterIsNotNull(s, "s");
        ILogger.DefaultImpls.info(this, s);
    }

    @Override
    public void trace(@NotNull Function0<String> s) {
        Intrinsics.checkParameterIsNotNull(s, "s");
        ILogger.DefaultImpls.trace(this, s);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0014\u0010\u0014\u001a\u00020\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0016J\u000e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u001d\u0010\u0003\u001a\u0004\u0018\u00010\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Llog/Logger$Companion;", "", "()V", "regressionFile", "Ljava/io/OutputStreamWriter;", "getRegressionFile", "()Ljava/io/OutputStreamWriter;", "regressionFile$delegate", "Lkotlin/Lazy;", "always", "", "s", "", "respectQuiet", "", "alwaysError", "t", "", "alwaysStacktrace", "alwaysWarn", "regression", "str", "Lkotlin/Function0;", "toResultsFile", "Shared"})
    public static final class Companion {
        private final OutputStreamWriter getRegressionFile() {
            Lazy lazy = regressionFile$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (OutputStreamWriter)lazy.getValue();
        }

        public final void always(@NotNull String s, boolean respectQuiet) {
            Intrinsics.checkParameterIsNotNull(s, "s");
            boolean beQuiet = respectQuiet && (Boolean)Config.INSTANCE.getQuietMode().get() != false;
            OutPrinter.INSTANCE._println(s, false, false, !beQuiet);
            LoggerKt.access$getAlwaysLogger$p().info(s);
        }

        public final void toResultsFile(@NotNull String s) {
            Intrinsics.checkParameterIsNotNull(s, "s");
            OutPrinter.INSTANCE._println(s, false, false, false);
        }

        public final void alwaysError(@NotNull String s) {
            Intrinsics.checkParameterIsNotNull(s, "s");
            OutPrinter.INSTANCE._println(s, false, true, false);
            LoggerKt.access$getAlwaysLogger$p().error(s);
        }

        public final void alwaysError(@NotNull String s, @NotNull Throwable t2) {
            Intrinsics.checkParameterIsNotNull(s, "s");
            Intrinsics.checkParameterIsNotNull(t2, "t");
            this.alwaysError(s);
            this.alwaysStacktrace(t2);
        }

        public final void alwaysStacktrace(@NotNull Throwable t2) {
            Intrinsics.checkParameterIsNotNull(t2, "t");
            this.alwaysError(ILogger.Companion.getStacktraceStr(t2));
        }

        public final void alwaysWarn(@NotNull String s, @NotNull Throwable t2) {
            Intrinsics.checkParameterIsNotNull(s, "s");
            Intrinsics.checkParameterIsNotNull(t2, "t");
            this.alwaysWarn(s);
            this.alwaysWarn(ILogger.Companion.getStacktraceStr(t2));
        }

        public final void alwaysWarn(@NotNull String s) {
            Intrinsics.checkParameterIsNotNull(s, "s");
            OutPrinter.INSTANCE._println(s, true, false, false);
            LoggerKt.access$getAlwaysLogger$p().warn(s);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void regression(@NotNull Function0<String> str) {
            Intrinsics.checkParameterIsNotNull(str, "str");
            boolean bl = false;
            boolean bl2 = false;
            synchronized (this) {
                boolean bl3 = false;
                OutPrinter.INSTANCE._println(str.invoke(), false, false, false);
                if (((Boolean)Config.INSTANCE.getRegressionTest().get()).booleanValue() && ArtifactManagerFactoryInternal.Companion.isEnabled()) {
                    OutputStreamWriter outputStreamWriter = Companion.getRegressionFile();
                    if (outputStreamWriter != null) {
                        Appendable appendable = outputStreamWriter;
                        CharSequence charSequence = str.invoke();
                        boolean bl4 = false;
                        Appendable appendable2 = appendable.append(charSequence);
                        Intrinsics.checkNotNullExpressionValue(appendable2, "append(value)");
                        StringsKt.appendln(appendable2);
                    }
                    OutputStreamWriter outputStreamWriter2 = Companion.getRegressionFile();
                    if (outputStreamWriter2 != null) {
                        outputStreamWriter2.flush();
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

