/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonArraySerializer;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonExceptionsKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectSerializer;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.internal.JsonTreeOutput;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u0006H\u0016J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J \u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lkotlinx/serialization/json/internal/JsonTreeMapOutput;", "Lkotlinx/serialization/json/internal/JsonTreeOutput;", "json", "Lkotlinx/serialization/json/Json;", "nodeConsumer", "Lkotlin/Function1;", "Lkotlinx/serialization/json/JsonElement;", "", "(Lkotlinx/serialization/json/Json;Lkotlin/jvm/functions/Function1;)V", "isKey", "", "tag", "", "getCurrent", "putElement", "key", "element", "shouldWriteElement", "desc", "Lkotlinx/serialization/SerialDescriptor;", "index", "", "kotlinx-serialization-runtime"})
final class JsonTreeMapOutput
extends JsonTreeOutput {
    private String tag;
    private boolean isKey;

    @Override
    public void putElement(@NotNull String key, @NotNull JsonElement element) {
        Intrinsics.checkParameterIsNotNull(key, "key");
        Intrinsics.checkParameterIsNotNull(element, "element");
        if (this.isKey) {
            JsonElement jsonElement = element;
            if (!(jsonElement instanceof JsonPrimitive)) {
                if (jsonElement instanceof JsonObject) {
                    throw (Throwable)JsonExceptionsKt.InvalidKeyKindException(JsonObjectSerializer.INSTANCE.getDescriptor());
                }
                if (jsonElement instanceof JsonArray) {
                    throw (Throwable)JsonExceptionsKt.InvalidKeyKindException(JsonArraySerializer.INSTANCE.getDescriptor());
                }
                throw new NoWhenBranchMatchedException();
            }
            this.tag = ((JsonPrimitive)element).getContent();
            this.isKey = false;
        } else {
            Map<String, JsonElement> map2 = this.getContent();
            String string2 = this.tag;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("tag");
            }
            map2.put(string2, element);
            this.isKey = true;
        }
    }

    @Override
    @NotNull
    public JsonElement getCurrent() {
        return new JsonObject(this.getContent());
    }

    @Override
    public boolean shouldWriteElement(@NotNull SerialDescriptor desc, @NotNull String tag2, int index) {
        Intrinsics.checkParameterIsNotNull(desc, "desc");
        Intrinsics.checkParameterIsNotNull(tag2, "tag");
        return true;
    }

    public JsonTreeMapOutput(@NotNull Json json2, @NotNull Function1<? super JsonElement, Unit> nodeConsumer) {
        Intrinsics.checkParameterIsNotNull(json2, "json");
        Intrinsics.checkParameterIsNotNull(nodeConsumer, "nodeConsumer");
        super(json2, nodeConsumer);
        this.isKey = true;
    }
}

