/*
 * Decompiled with CFR 0.152.
 */
package datastructures;

import datastructures.HashRelation;
import datastructures.LabelledGraph;
import datastructures.MutableHashRelation;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0004B9\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u001e\u0010\u0007\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\t\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\fJ#\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00028\u00012\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J*\u0010\u0013\u001a\u00020\u000e2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u0015\u001a\u00028\u0001H\u0086\u0002\u00a2\u0006\u0002\u0010\u0016R&\u0010\u0007\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\t\u0012\u0004\u0012\u00028\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ldatastructures/MutableLabelledGraph;", "V", "E", "", "()V", "relation", "Ldatastructures/MutableHashRelation;", "labelMapping", "", "Lkotlin/Pair;", "(Ldatastructures/MutableHashRelation;Ljava/util/Map;)V", "freeze", "Ldatastructures/LabelledGraph;", "put", "", "src", "lab", "tgt", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "set", "pair", "label", "(Lkotlin/Pair;Ljava/lang/Object;)V", "GeneralUtils"})
public final class MutableLabelledGraph<V, E> {
    private final MutableHashRelation<V, V> relation;
    private final Map<Pair<V, V>, E> labelMapping;

    public final void set(@NotNull Pair<? extends V, ? extends V> pair, E label) {
        Intrinsics.checkParameterIsNotNull(pair, "pair");
        this.put(pair.getFirst(), label, pair.getSecond());
    }

    public final void put(V src, E lab, V tgt) {
        this.relation.add(TuplesKt.to(src, tgt));
        this.labelMapping.put(TuplesKt.to(src, tgt), lab);
    }

    @NotNull
    public final LabelledGraph<V, E> freeze() {
        return new LabelledGraph<V, E>((HashRelation)this.relation, this.labelMapping);
    }

    public MutableLabelledGraph(@NotNull MutableHashRelation<V, V> relation, @NotNull Map<Pair<V, V>, E> labelMapping) {
        Intrinsics.checkParameterIsNotNull(relation, "relation");
        Intrinsics.checkParameterIsNotNull(labelMapping, "labelMapping");
        this.relation = relation;
        this.labelMapping = labelMapping;
    }

    public MutableLabelledGraph() {
        this(new MutableHashRelation(), new LinkedHashMap());
    }
}

