/*
 * Decompiled with CFR 0.152.
 */
package com.ionspin.kotlin.bignum.decimal;

import com.ionspin.kotlin.bignum.BigNumber;
import com.ionspin.kotlin.bignum.CommonBigNumberOperations;
import com.ionspin.kotlin.bignum.NarrowingOperations;
import com.ionspin.kotlin.bignum.decimal.BigDecimal$Companion$WhenMappings;
import com.ionspin.kotlin.bignum.decimal.BigDecimal$WhenMappings;
import com.ionspin.kotlin.bignum.decimal.BigDecimalExtensionsKt;
import com.ionspin.kotlin.bignum.decimal.DecimalMode;
import com.ionspin.kotlin.bignum.decimal.RoundingMode;
import com.ionspin.kotlin.bignum.integer.BigInteger;
import com.ionspin.kotlin.bignum.integer.BigIntegerExtensionsKt;
import com.ionspin.kotlin.bignum.integer.ComparisonWorkaround;
import com.ionspin.kotlin.bignum.integer.ConfigurationKt;
import com.ionspin.kotlin.bignum.integer.Sign;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0004\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\n\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0003\u0018\u0000 \u0085\u00012\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u00022\b\u0012\u0004\u0012\u00020\u00000\u00032\b\u0012\u0004\u0012\u00020\u00050\u0004:\u0004\u0085\u0001\u0086\u0001B%\b\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010#\u001a\u00020\u0000H\u0016J\u0010\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0000H\u0016J\u001a\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u00002\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bJ*\u0010&\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0'2\u0006\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u0000H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020 H\u0016J\u0006\u0010-\u001a\u00020\u0000J\u0010\u0010.\u001a\u00020/2\u0006\u0010,\u001a\u00020 H\u0002J\u000e\u00100\u001a\u0002012\u0006\u0010%\u001a\u00020\u0000J\u0011\u00102\u001a\u0002012\u0006\u0010%\u001a\u00020\u0005H\u0096\u0002J\u0018\u00103\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u00002\u0006\u00104\u001a\u000205H\u0002J&\u00106\u001a\u00020\u00002\b\b\u0002\u0010\u001c\u001a\u00020\u00072\b\b\u0002\u0010\u000f\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0006\u00107\u001a\u00020\u0000J\u0011\u00108\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0000H\u0096\u0002J\u0010\u00109\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0000H\u0016J\u001a\u00109\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u00002\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u001c\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000;2\u0006\u0010%\u001a\u00020\u0000H\u0016J\u001d\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000;2\u0006\u0010%\u001a\u00020\u0000H\u0086\u0004J(\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000;2\u0006\u0010%\u001a\u00020\u00002\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010=\u001a\u00020>2\u0006\u0010,\u001a\u00020 H\u0016J\u0013\u0010?\u001a\u00020 2\b\u0010%\u001a\u0004\u0018\u00010\u0005H\u0096\u0002J\u0010\u0010@\u001a\u00020A2\u0006\u0010,\u001a\u00020 H\u0016J\u0006\u0010B\u001a\u00020\u0000J\u000e\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00000DH\u0016J\b\u0010E\u001a\u00020\u0000H\u0016J\u0010\u0010F\u001a\u00020\u00002\u0006\u0010G\u001a\u00020\u0000H\u0002J\b\u0010H\u001a\u000201H\u0016J\u0006\u0010I\u001a\u00020\u0000J\u0010\u0010J\u001a\u0002012\u0006\u0010,\u001a\u00020 H\u0016J\u001c\u0010K\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u00002\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0006\u0010L\u001a\u00020 J\b\u0010M\u001a\u00020 H\u0016J\u0010\u0010N\u001a\u0002012\u0006\u0010O\u001a\u00020PH\u0002J\u0010\u0010Q\u001a\u00020\t2\u0006\u0010,\u001a\u00020 H\u0016J\u0011\u0010R\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0000H\u0096\u0002J\u000e\u0010S\u001a\u00020\u00002\u0006\u0010T\u001a\u000201J\u0010\u0010U\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0000H\u0016J\u001a\u0010U\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u00002\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bJ\b\u0010V\u001a\u00020\u0000H\u0016J\u0010\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020XH\u0002J\b\u0010Z\u001a\u00020\tH\u0016J\u0018\u0010[\u001a\u00020X2\u0006\u0010Y\u001a\u00020X2\u0006\u0010\\\u001a\u000201H\u0002J\u0018\u0010]\u001a\u00020X2\u0006\u0010Y\u001a\u00020X2\u0006\u0010\\\u001a\u000201H\u0002J\u0011\u0010^\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0000H\u0096\u0002J\u0010\u0010_\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u000201H\u0016J\u0010\u0010_\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u0011\u0010`\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0000H\u0096\u0002J\u001c\u0010`\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u00002\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010a\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0000H\u0016J\u0006\u0010b\u001a\u00020\u0000J\u0010\u0010c\u001a\u00020\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0018\u0010d\u001a\u00020\u00002\u0006\u0010e\u001a\u00020\t2\b\b\u0002\u0010\u0016\u001a\u00020\u0017J\u0016\u0010f\u001a\u00020\u00002\u0006\u0010e\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\tJ\b\u0010g\u001a\u00020/H\u0016J\u0010\u0010h\u001a\u00020i2\u0006\u0010,\u001a\u00020 H\u0016J\b\u0010j\u001a\u000201H\u0016J\u0010\u0010k\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0000H\u0016J\u001a\u0010k\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u00002\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0011\u0010l\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0000H\u0096\u0002J\u0006\u0010m\u001a\u00020\u0007J\u0006\u0010n\u001a\u00020XJ\b\u0010o\u001a\u00020XH\u0016J\u0010\u0010o\u001a\u00020X2\u0006\u0010p\u001a\u000201H\u0016J\u0006\u0010q\u001a\u00020XJ \u0010r\u001a\u00020s2\u0006\u0010,\u001a\u00020 H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bt\u0010uJ \u0010v\u001a\u00020w2\u0006\u0010,\u001a\u00020 H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bx\u0010yJ \u0010z\u001a\u00020{2\u0006\u0010,\u001a\u00020 H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b|\u0010}J\t\u0010~\u001a\u00020\u0000H\u0096\u0002J#\u0010\u007f\u001a\u00030\u0080\u00012\u0006\u0010,\u001a\u00020 H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0006\b\u0081\u0001\u0010\u0082\u0001J\u0017\u0010l\u001a\u00020X*\u00020\t2\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001H\u0086\u0002R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011R\u0011\u0010\u001c\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0087\u0001"}, d2={"Lcom/ionspin/kotlin/bignum/decimal/BigDecimal;", "Lcom/ionspin/kotlin/bignum/BigNumber;", "Lcom/ionspin/kotlin/bignum/CommonBigNumberOperations;", "Lcom/ionspin/kotlin/bignum/NarrowingOperations;", "", "", "_significand", "Lcom/ionspin/kotlin/bignum/integer/BigInteger;", "_exponent", "", "decimalMode", "Lcom/ionspin/kotlin/bignum/decimal/DecimalMode;", "(Lcom/ionspin/kotlin/bignum/integer/BigInteger;JLcom/ionspin/kotlin/bignum/decimal/DecimalMode;)V", "getDecimalMode", "()Lcom/ionspin/kotlin/bignum/decimal/DecimalMode;", "exponent", "getExponent", "()J", "precision", "getPrecision", "precisionLimit", "getPrecisionLimit", "roundingMode", "Lcom/ionspin/kotlin/bignum/decimal/RoundingMode;", "getRoundingMode", "()Lcom/ionspin/kotlin/bignum/decimal/RoundingMode;", "scale", "getScale", "significand", "getSignificand", "()Lcom/ionspin/kotlin/bignum/integer/BigInteger;", "usingScale", "", "getUsingScale", "()Z", "abs", "add", "other", "bringSignificandToSameExponent", "Lkotlin/Triple;", "first", "second", "byteValue", "", "exactRequired", "ceil", "checkWholeness", "", "compare", "", "compareTo", "computeMode", "op", "Lcom/ionspin/kotlin/bignum/decimal/BigDecimal$ScaleOps;", "copy", "dec", "div", "divide", "divideAndRemainder", "Lkotlin/Pair;", "divrem", "doubleValue", "", "equals", "floatValue", "", "floor", "getCreator", "Lcom/ionspin/kotlin/bignum/BigNumber$Creator;", "getInstance", "getRidOfRadix", "bigDecimal", "hashCode", "inc", "intValue", "integerDiv", "isWholeNumber", "isZero", "javascriptNumberComparison", "number", "", "longValue", "minus", "moveDecimalPoint", "places", "multiply", "negate", "noExponentStringtoScientificNotation", "", "input", "numberOfDecimalDigits", "placeADotInString", "position", "placeADotInStringExpanded", "plus", "pow", "rem", "remainder", "removeScale", "roundSignificand", "roundToDigitPosition", "digitPosition", "roundToDigitPositionAfterDecimalPoint", "secureOverwrite", "shortValue", "", "signum", "subtract", "times", "toBigInteger", "toPlainString", "toString", "base", "toStringExpanded", "ubyteValue", "Lkotlin/UByte;", "ubyteValue-Wa3L5BU", "(Z)B", "uintValue", "Lkotlin/UInt;", "uintValue-OGnWXxg", "(Z)I", "ulongValue", "Lkotlin/ULong;", "ulongValue-I7RO_PI", "(Z)J", "unaryMinus", "ushortValue", "Lkotlin/UShort;", "ushortValue-BwKQO78", "(Z)S", "char", "", "Companion", "ScaleOps", "bignum"})
public final class BigDecimal
implements BigNumber<BigDecimal>,
CommonBigNumberOperations<BigDecimal>,
NarrowingOperations<BigDecimal>,
Comparable<Object> {
    private final long precision;
    private final long precisionLimit;
    @NotNull
    private final RoundingMode roundingMode;
    @NotNull
    private final BigInteger significand;
    private final long exponent;
    private final long scale;
    private final boolean usingScale;
    @Nullable
    private final DecimalMode decimalMode;
    @NotNull
    private static final BigDecimal ZERO;
    @NotNull
    private static final BigDecimal ONE;
    @NotNull
    private static final BigDecimal TWO;
    @NotNull
    private static final BigDecimal TEN;
    private static boolean useToStringExpanded;
    private static final double[] double10pow;
    private static final BigDecimal maximumDouble;
    private static final BigDecimal leastSignificantDouble;
    private static final float[] float10pow;
    private static final BigDecimal maximumFloat;
    private static final BigDecimal leastSignificantFloat;
    @NotNull
    public static final Companion Companion;

    public final long getPrecision() {
        return this.precision;
    }

    public final long getPrecisionLimit() {
        return this.precisionLimit;
    }

    @NotNull
    public final RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    @NotNull
    public final BigInteger getSignificand() {
        return this.significand;
    }

    public final long getExponent() {
        return this.exponent;
    }

    public final long getScale() {
        return this.scale;
    }

    public final boolean getUsingScale() {
        return this.usingScale;
    }

    @NotNull
    public final BigDecimal scale(long scale) {
        if (scale < 0L) {
            throw (Throwable)new ArithmeticException("Negative Scale is unsupported.");
        }
        DecimalMode mode2 = this.decimalMode == null ? (scale == -1L ? DecimalMode.Companion.getDEFAULT() : new DecimalMode(0L, RoundingMode.ROUND_HALF_AWAY_FROM_ZERO, scale)) : new DecimalMode(this.decimalMode.getDecimalPrecision(), this.decimalMode.getRoundingMode(), scale);
        return new BigDecimal(this.significand, this.exponent, mode2);
    }

    @NotNull
    public final BigDecimal removeScale() {
        DecimalMode decimalMode = this.decimalMode;
        long l = decimalMode != null ? decimalMode.getDecimalPrecision() : 0L;
        Object object = this.decimalMode;
        if (object == null || (object = object.getRoundingMode()) == null) {
            object = RoundingMode.NONE;
        }
        return new BigDecimal(this.significand, this.exponent, new DecimalMode(l, (RoundingMode)((Object)object), -1L));
    }

    @Override
    @NotNull
    public BigNumber.Creator<BigDecimal> getCreator() {
        return Companion;
    }

    @Override
    @NotNull
    public BigDecimal getInstance() {
        return this;
    }

    @Override
    @NotNull
    public BigDecimal add(@NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.add(other, this.computeMode(other, ScaleOps.Max));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BigDecimal add(@NotNull BigDecimal other, @Nullable DecimalMode decimalMode) {
        void first2;
        Intrinsics.checkNotNullParameter(other, "other");
        DecimalMode resolvedDecimalMode = BigDecimal.Companion.resolveDecimalMode(this.decimalMode, other.decimalMode, decimalMode);
        Triple<BigInteger, BigInteger, Long> triple = this.bringSignificandToSameExponent(this, other);
        BigInteger bigInteger = triple.component1();
        BigInteger second = triple.component2();
        long firstNumOfDigits = first2.numberOfDecimalDigits();
        long secondNumOfDigits = second.numberOfDecimalDigits();
        BigInteger newSignificand = (BigInteger)first2.plus((BigNumber)second);
        long newSignificandNumOfDigit = newSignificand.numberOfDecimalDigits();
        long largerOperand = firstNumOfDigits > secondNumOfDigits ? firstNumOfDigits : secondNumOfDigits;
        long carryDetected = newSignificandNumOfDigit - largerOperand;
        long l = this.exponent;
        long l2 = other.exponent;
        boolean bl = false;
        long newExponent = Math.max(l, l2) + carryDetected;
        return BigDecimal.Companion.roundOrDont(newSignificand, newExponent, resolvedDecimalMode);
    }

    public static /* synthetic */ BigDecimal add$default(BigDecimal bigDecimal, BigDecimal bigDecimal2, DecimalMode decimalMode, int n, Object object) {
        if ((n & 2) != 0) {
            decimalMode = null;
        }
        return bigDecimal.add(bigDecimal2, decimalMode);
    }

    @Override
    @NotNull
    public BigDecimal subtract(@NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.subtract(other, this.computeMode(other, ScaleOps.Max));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BigDecimal subtract(@NotNull BigDecimal other, @Nullable DecimalMode decimalMode) {
        void first2;
        Intrinsics.checkNotNullParameter(other, "other");
        DecimalMode resolvedDecimalMode = BigDecimal.Companion.resolveDecimalMode(this.decimalMode, other.decimalMode, decimalMode);
        Triple<BigInteger, BigInteger, Long> triple = this.bringSignificandToSameExponent(this, other);
        BigInteger bigInteger = triple.component1();
        BigInteger second = triple.component2();
        long firstNumOfDigits = first2.numberOfDecimalDigits();
        long secondNumOfDigits = second.numberOfDecimalDigits();
        BigInteger newSignificand = (BigInteger)first2.minus((BigNumber)second);
        long newSignificandNumOfDigit = newSignificand.numberOfDecimalDigits();
        long largerOperand = firstNumOfDigits > secondNumOfDigits ? firstNumOfDigits : secondNumOfDigits;
        long borrowDetected = newSignificandNumOfDigit - largerOperand;
        long l = this.exponent;
        long l2 = other.exponent;
        boolean bl = false;
        long newExponent = Math.max(l, l2) + borrowDetected;
        return BigDecimal.Companion.roundOrDont(newSignificand, newExponent, resolvedDecimalMode);
    }

    public static /* synthetic */ BigDecimal subtract$default(BigDecimal bigDecimal, BigDecimal bigDecimal2, DecimalMode decimalMode, int n, Object object) {
        if ((n & 2) != 0) {
            decimalMode = null;
        }
        return bigDecimal.subtract(bigDecimal2, decimalMode);
    }

    @Override
    @NotNull
    public BigDecimal multiply(@NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.multiply(other, this.computeMode(other, ScaleOps.Add));
    }

    @NotNull
    public final BigDecimal multiply(@NotNull BigDecimal other, @Nullable DecimalMode decimalMode) {
        Intrinsics.checkNotNullParameter(other, "other");
        DecimalMode resolvedDecimalMode = BigDecimal.Companion.resolveDecimalMode(this.decimalMode, other.decimalMode, decimalMode);
        long firstNumOfDigits = this.significand.numberOfDecimalDigits();
        long secondNumOfDigits = other.significand.numberOfDecimalDigits();
        BigInteger newSignificand = (BigInteger)this.significand.times((BigNumber)other.significand);
        long newSignificandNumOfDigit = newSignificand.numberOfDecimalDigits();
        long moveExponent = newSignificandNumOfDigit - (firstNumOfDigits + secondNumOfDigits);
        long newExponent = this.exponent + other.exponent + moveExponent + 1L;
        return BigDecimal.Companion.roundOrDont(newSignificand, newExponent, resolvedDecimalMode);
    }

    public static /* synthetic */ BigDecimal multiply$default(BigDecimal bigDecimal, BigDecimal bigDecimal2, DecimalMode decimalMode, int n, Object object) {
        if ((n & 2) != 0) {
            decimalMode = null;
        }
        return bigDecimal.multiply(bigDecimal2, decimalMode);
    }

    @Override
    @NotNull
    public BigDecimal divide(@NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.divide(other, this.computeMode(other, ScaleOps.Min));
    }

    @NotNull
    public final BigDecimal divide(@NotNull BigDecimal other, @Nullable DecimalMode decimalMode) {
        BigInteger bigInteger;
        Intrinsics.checkNotNullParameter(other, "other");
        DecimalMode resolvedDecimalMode = BigDecimal.Companion.resolveDecimalMode(this.decimalMode, other.decimalMode, decimalMode);
        if (resolvedDecimalMode.isPrecisionUnlimited()) {
            long newExponent = this.exponent - other.exponent;
            long power = other.precision * (long)2 + (long)6;
            BigInteger thisPrepared = (BigInteger)this.significand.times((BigNumber)BigInteger.Companion.getTEN().pow(power));
            BigInteger.QuotientAndRemainder divRem = thisPrepared.divrem(other.significand);
            BigInteger result2 = divRem.getQuotient();
            long expectedDiff = other.precision - 1L;
            long exponentModifier = expectedDiff + (result2.numberOfDecimalDigits() - thisPrepared.numberOfDecimalDigits());
            if (Intrinsics.areEqual(divRem.getRemainder(), BigInteger.Companion.getZERO()) ^ true) {
                throw (Throwable)new ArithmeticException("Non-terminating result of division operation (i.e. 1/3 = 0.3333... library needs to know when to stop and how to round up at that point). Specify decimalPrecision inside your decimal mode.");
            }
            return new BigDecimal(result2, newExponent + exponentModifier, resolvedDecimalMode);
        }
        long newExponent = this.exponent - other.exponent - 1L;
        long desiredPrecision = resolvedDecimalMode.getDecimalPrecision();
        long power = desiredPrecision - this.precision + other.precision;
        if (power > 0L) {
            bigInteger = (BigInteger)this.significand.times((BigNumber)BigIntegerExtensionsKt.toBigInteger(10).pow(power));
        } else if (power < 0L) {
            long expectedDiff = power;
            boolean exponentModifier = false;
            bigInteger = (BigInteger)this.significand.div((BigNumber)BigIntegerExtensionsKt.toBigInteger(10).pow(Math.abs(expectedDiff)));
        } else {
            bigInteger = this.significand;
        }
        BigInteger thisPrepared = bigInteger;
        BigInteger.QuotientAndRemainder divRem = thisPrepared.divrem(other.significand);
        BigInteger result3 = divRem.getQuotient();
        if (Intrinsics.areEqual(result3, BigInteger.Companion.getZERO())) {
            long exponentModifier = newExponent;
            newExponent = exponentModifier + -1L;
        }
        long exponentModifier = result3.numberOfDecimalDigits() - resolvedDecimalMode.getDecimalPrecision();
        return new BigDecimal(BigDecimal.Companion.roundDiscarded(result3, divRem.getRemainder(), resolvedDecimalMode), newExponent + exponentModifier, resolvedDecimalMode);
    }

    public static /* synthetic */ BigDecimal divide$default(BigDecimal bigDecimal, BigDecimal bigDecimal2, DecimalMode decimalMode, int n, Object object) {
        if ((n & 2) != 0) {
            decimalMode = null;
        }
        return bigDecimal.divide(bigDecimal2, decimalMode);
    }

    @Override
    @NotNull
    public BigDecimal remainder(@NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.divideAndRemainder(other).getSecond();
    }

    @Override
    @NotNull
    public Pair<BigDecimal, BigDecimal> divideAndRemainder(@NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter(other, "other");
        DecimalMode decimalMode = this.decimalMode;
        if (decimalMode == null) {
            decimalMode = new DecimalMode(this.exponent + 1L, RoundingMode.FLOOR, 0L, 4, null);
        }
        DecimalMode resolvedRoundingMode = decimalMode;
        BigDecimal quotient = this.divide(other, resolvedRoundingMode);
        BigDecimal quotientInfinitePrecision = BigDecimal.copy$default(quotient, null, 0L, DecimalMode.Companion.getDEFAULT(), 3, null);
        BigDecimal remainder = this.minus(quotientInfinitePrecision.times(other));
        return new Pair<BigDecimal, BigDecimal>(quotient, remainder);
    }

    @Override
    public boolean isZero() {
        return this.significand.isZero();
    }

    @NotNull
    public final BigDecimal copy(@NotNull BigInteger significand, long exponent, @Nullable DecimalMode decimalMode) {
        Intrinsics.checkNotNullParameter(significand, "significand");
        return new BigDecimal(significand, exponent, decimalMode);
    }

    public static /* synthetic */ BigDecimal copy$default(BigDecimal bigDecimal, BigInteger bigInteger, long l, DecimalMode decimalMode, int n, Object object) {
        if ((n & 1) != 0) {
            bigInteger = bigDecimal.significand;
        }
        if ((n & 2) != 0) {
            l = bigDecimal.exponent;
        }
        if ((n & 4) != 0) {
            decimalMode = bigDecimal.decimalMode;
        }
        return bigDecimal.copy(bigInteger, l, decimalMode);
    }

    @NotNull
    public final BigDecimal moveDecimalPoint(int places) {
        return BigDecimal.copy$default(this, null, this.exponent + (long)places, null, 5, null);
    }

    @Override
    @NotNull
    public BigDecimal pow(int exponent) {
        return this.pow((long)exponent);
    }

    @NotNull
    public final BigDecimal floor() {
        return this.roundSignificand(new DecimalMode(this.exponent + 1L, RoundingMode.FLOOR, 0L, 4, null));
    }

    @NotNull
    public final BigDecimal ceil() {
        return this.roundSignificand(new DecimalMode(this.exponent + 1L, RoundingMode.CEILING, 0L, 4, null));
    }

    @NotNull
    public final BigInteger toBigInteger() {
        BigInteger bigInteger;
        if (this.exponent < 0L) {
            return BigInteger.Companion.getZERO();
        }
        long precisionExponentDiff = this.exponent - this.precision;
        if (precisionExponentDiff > 0L) {
            bigInteger = (BigInteger)this.significand.times((BigNumber)BigIntegerExtensionsKt.toBigInteger(10).pow(precisionExponentDiff + 1L));
        } else if (precisionExponentDiff < 0L) {
            long l = precisionExponentDiff;
            boolean bl = false;
            bigInteger = (BigInteger)this.significand.div((BigNumber)BigIntegerExtensionsKt.toBigInteger(10).pow(Math.abs(l) - 1L));
        } else {
            bigInteger = this.significand;
        }
        return bigInteger;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long numberOfDecimalDigits() {
        int n;
        long l;
        long l2 = this.exponent;
        if (1L <= l2 && this.precision > l2) {
            l = this.precision;
        } else if (this.exponent > 0L && this.exponent > this.precision) {
            l = this.exponent + 1L;
        } else if (this.exponent > 0L && this.exponent == this.precision) {
            l = this.precision + 1L;
        } else if (this.exponent < 0L) {
            l2 = this.exponent;
            n = 0;
            l = Math.abs(l2) + this.precision;
        } else if (this.exponent == 0L) {
            String string2;
            block12: {
                String $this$dropLastWhile$iv = this.significand.toString();
                boolean $i$f$dropLastWhile = false;
                n = StringsKt.getLastIndex($this$dropLastWhile$iv);
                boolean bl = false;
                while (n >= 0) {
                    void index$iv;
                    char it = $this$dropLastWhile$iv.charAt((int)index$iv);
                    boolean bl2 = false;
                    if (!(it == '0')) {
                        String string3 = $this$dropLastWhile$iv;
                        int n2 = 0;
                        void var9_9 = index$iv + true;
                        boolean bl3 = false;
                        String string4 = string3.substring(n2, (int)var9_9);
                        string2 = string4;
                        Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        break block12;
                    }
                    --index$iv;
                }
                string2 = "";
            }
            l = string2.length();
        } else {
            throw (Throwable)new RuntimeException("Invalid case when getting number of decimal digits");
        }
        long numberOfDigits = l;
        return numberOfDigits;
    }

    @Override
    @NotNull
    public String toString(int base2) {
        if (base2 != 10) {
            throw (Throwable)new RuntimeException("BigDecimal in base other than 10 is not supported yet");
        }
        return this.toString();
    }

    private final BigDecimal integerDiv(BigDecimal other, DecimalMode decimalMode) {
        DecimalMode resolvedDecimalMode = BigDecimal.Companion.resolveDecimalMode(this.decimalMode, other.decimalMode, decimalMode);
        long newExponent = this.exponent - other.exponent;
        BigInteger newSignificand = (BigInteger)this.significand.div((BigNumber)other.significand);
        return BigDecimal.Companion.roundOrDont(newSignificand, newExponent, resolvedDecimalMode);
    }

    static /* synthetic */ BigDecimal integerDiv$default(BigDecimal bigDecimal, BigDecimal bigDecimal2, DecimalMode decimalMode, int n, Object object) {
        if ((n & 2) != 0) {
            decimalMode = null;
        }
        return bigDecimal.integerDiv(bigDecimal2, decimalMode);
    }

    private final BigDecimal rem(BigDecimal other, DecimalMode decimalMode) {
        DecimalMode resolvedDecimalMode = BigDecimal.Companion.resolveDecimalMode(this.decimalMode, other.decimalMode, decimalMode);
        long newExponent = this.exponent - other.exponent;
        BigInteger newSignificand = (BigInteger)this.significand.rem((BigNumber)other.significand);
        return BigDecimal.Companion.roundOrDont(newSignificand, newExponent, resolvedDecimalMode);
    }

    static /* synthetic */ BigDecimal rem$default(BigDecimal bigDecimal, BigDecimal bigDecimal2, DecimalMode decimalMode, int n, Object object) {
        if ((n & 2) != 0) {
            decimalMode = null;
        }
        return bigDecimal.rem(bigDecimal2, decimalMode);
    }

    private final Pair<BigDecimal, BigDecimal> divrem(BigDecimal other, DecimalMode decimalMode) {
        DecimalMode resolvedDecimalMode = BigDecimal.Companion.resolveDecimalMode(this.decimalMode, other.decimalMode, decimalMode);
        long l = this.exponent;
        long l2 = other.exponent;
        boolean bl = false;
        long newExponent = Math.max(l, l2);
        BigInteger newSignificand = (BigInteger)this.significand.div((BigNumber)other.significand);
        BigInteger newRemainderSignificand = (BigInteger)this.significand.rem((BigNumber)other.significand);
        return new Pair<BigDecimal, BigDecimal>(BigDecimal.Companion.roundOrDont(newSignificand, newExponent, resolvedDecimalMode), BigDecimal.Companion.roundOrDont(newRemainderSignificand, newExponent, resolvedDecimalMode));
    }

    static /* synthetic */ Pair divrem$default(BigDecimal bigDecimal, BigDecimal bigDecimal2, DecimalMode decimalMode, int n, Object object) {
        if ((n & 2) != 0) {
            decimalMode = null;
        }
        return bigDecimal.divrem(bigDecimal2, decimalMode);
    }

    @NotNull
    public final Pair<BigDecimal, BigDecimal> divrem(@NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.divideAndRemainder(other);
    }

    private final DecimalMode computeMode(BigDecimal other, ScaleOps op) {
        DecimalMode decimalMode;
        block6: {
            long l;
            RoundingMode roundingMode;
            long l2;
            block8: {
                block7: {
                    block5: {
                        if (this.decimalMode != null && !this.decimalMode.isPrecisionUnlimited() && other.decimalMode != null && !other.decimalMode.isPrecisionUnlimited()) break block5;
                        decimalMode = DecimalMode.Companion.getDEFAULT();
                        break block6;
                    }
                    long l3 = this.decimalMode.getDecimalPrecision();
                    long l4 = other.decimalMode.getDecimalPrecision();
                    boolean bl = false;
                    l2 = Math.max(l3, l4);
                    roundingMode = this.decimalMode.getRoundingMode();
                    if (!this.decimalMode.getUsingScale() || !other.decimalMode.getUsingScale()) break block7;
                    switch (BigDecimal$WhenMappings.$EnumSwitchMapping$0[op.ordinal()]) {
                        case 1: {
                            l3 = this.decimalMode.getScale();
                            l4 = other.decimalMode.getScale();
                            bl = false;
                            l = Math.max(l3, l4);
                            break block8;
                        }
                        case 2: {
                            l3 = this.decimalMode.getScale();
                            l4 = other.decimalMode.getScale();
                            bl = false;
                            l = Math.min(l3, l4);
                            break block8;
                        }
                        case 3: {
                            l = this.decimalMode.getScale() + other.decimalMode.getScale();
                            break block8;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                l = -1L;
            }
            decimalMode = new DecimalMode(l2, roundingMode, l);
        }
        return decimalMode;
    }

    @Override
    @NotNull
    public BigDecimal plus(@NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.add(other, this.computeMode(other, ScaleOps.Max));
    }

    @Override
    @NotNull
    public BigDecimal minus(@NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.subtract(other, this.computeMode(other, ScaleOps.Max));
    }

    @Override
    @NotNull
    public BigDecimal times(@NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.multiply(other, this.computeMode(other, ScaleOps.Add));
    }

    @Override
    @NotNull
    public BigDecimal div(@NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.divide(other, this.computeMode(other, ScaleOps.Min));
    }

    @Override
    @NotNull
    public BigDecimal rem(@NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.rem(other, null);
    }

    @Override
    @NotNull
    public BigDecimal unaryMinus() {
        return new BigDecimal(this.significand.negate(), this.exponent, null, 4, null);
    }

    @Override
    public void secureOverwrite() {
        this.significand.secureOverwrite();
    }

    @NotNull
    public final BigDecimal inc() {
        return (BigDecimal)this.plus(1);
    }

    @NotNull
    public final BigDecimal dec() {
        return (BigDecimal)this.minus(1);
    }

    @Override
    @NotNull
    public BigDecimal abs() {
        return new BigDecimal(this.significand.abs(), this.exponent, this.decimalMode);
    }

    @Override
    @NotNull
    public BigDecimal negate() {
        return new BigDecimal(this.significand.negate(), this.exponent, this.decimalMode);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public BigDecimal pow(long exponent) {
        BigDecimal bigDecimal;
        BigDecimal result2 = this;
        if (exponent > 0L) {
            long l = 0L;
            long l2 = exponent - 1L;
            while (l < l2) {
                void i;
                result2 = result2.times(this);
                ++i;
            }
            bigDecimal = result2;
        } else if (exponent < 0L) {
            long i = 0L;
            long l = exponent;
            boolean bl = false;
            long l3 = Math.abs(l);
            if (i <= l3) {
                while (true) {
                    result2 = result2.div(this);
                    if (i == l3) break;
                    ++i;
                }
            }
            bigDecimal = result2;
        } else {
            bigDecimal = Companion.getONE();
        }
        return bigDecimal;
    }

    @Override
    public int signum() {
        return this.significand.signum();
    }

    @Override
    public int intValue(boolean exactRequired) {
        this.checkWholeness(exactRequired);
        return this.toBigInteger().intValue(exactRequired);
    }

    @Override
    public long longValue(boolean exactRequired) {
        this.checkWholeness(exactRequired);
        return this.toBigInteger().longValue(exactRequired);
    }

    @Override
    public byte byteValue(boolean exactRequired) {
        this.checkWholeness(exactRequired);
        return this.toBigInteger().byteValue(exactRequired);
    }

    @Override
    public short shortValue(boolean exactRequired) {
        this.checkWholeness(exactRequired);
        return this.toBigInteger().shortValue(exactRequired);
    }

    @Override
    public int uintValue-OGnWXxg(boolean exactRequired) {
        this.checkWholeness(exactRequired);
        return this.toBigInteger().uintValue-OGnWXxg(exactRequired);
    }

    @Override
    public long ulongValue-I7RO_PI(boolean exactRequired) {
        this.checkWholeness(exactRequired);
        return this.toBigInteger().ulongValue-I7RO_PI(exactRequired);
    }

    @Override
    public byte ubyteValue-Wa3L5BU(boolean exactRequired) {
        this.checkWholeness(exactRequired);
        return this.toBigInteger().ubyteValue-Wa3L5BU(exactRequired);
    }

    @Override
    public short ushortValue-BwKQO78(boolean exactRequired) {
        this.checkWholeness(exactRequired);
        return this.toBigInteger().ushortValue-BwKQO78(exactRequired);
    }

    public final boolean isWholeNumber() {
        return this.abs().divrem(Companion.getONE()).getSecond().isZero();
    }

    private final void checkWholeness(boolean exactRequired) {
        if (exactRequired && !this.isWholeNumber()) {
            throw (Throwable)new ArithmeticException("Cannot convert to int and provide exact value");
        }
    }

    @Override
    public float floatValue(boolean exactRequired) {
        float f;
        if (exactRequired) {
            int totalBits;
            int n;
            boolean exactPossible = true;
            if (this.exponent < -45L || this.exponent > 38L) {
                exactPossible = false;
            }
            if (this.precision - this.exponent - 1L > 0L) {
                int bitSum;
                BigInteger integerPart = this.exponent >= 0L ? (BigInteger)this.significand.div((BigNumber)BigInteger.Companion.getTEN().pow(this.precision - this.exponent - 1L)) : BigInteger.Companion.getZERO();
                int integerPartBitLength = ConfigurationKt.getChosenArithmetic().bitLength-QwZRm1k(integerPart.getMagnitude-Y2RjT0g$bignum());
                BigInteger fractionPart = this.significand.divrem(BigInteger.Companion.getTEN().pow(this.precision - this.exponent - 1L)).getRemainder();
                BigDecimal fractionConvertTemp = new BigDecimal(fractionPart, -1L, null, 4, null);
                boolean bl = false;
                List bitList = new ArrayList();
                for (int counter = 0; Intrinsics.areEqual(fractionConvertTemp, Companion.getZERO()) ^ true && counter <= 24; ++counter) {
                    BigDecimal multiplied = (BigDecimal)fractionConvertTemp.times(2);
                    int bit = multiplied.compareTo(Companion.getONE()) >= 0 ? 1 : 0;
                    bitList.add(bit);
                    fractionConvertTemp = bit == 1 ? multiplied.divrem(Companion.getTEN()).getSecond() : multiplied;
                }
                n = bitSum = integerPartBitLength + bitList.size();
            } else {
                int trailingZeroBits = ConfigurationKt.getChosenArithmetic().trailingZeroBits-QwZRm1k(this.significand.getMagnitude-Y2RjT0g$bignum());
                int bitSum = ConfigurationKt.getChosenArithmetic().bitLength-QwZRm1k(this.significand.getMagnitude-Y2RjT0g$bignum());
                n = totalBits = bitSum - trailingZeroBits;
            }
            if (totalBits > 24) {
                exactPossible = false;
            }
            if (!exactPossible) {
                throw (Throwable)new ArithmeticException("Value cannot be narrowed to float");
            }
        }
        long divExponent = this.precision - 1L - this.exponent;
        long f2 = this.significand.longValue(exactRequired);
        if (divExponent >= 0L && divExponent < (long)float10pow.length) {
            f = (float)f2 / float10pow[(int)divExponent];
        } else {
            String string2 = this.toString();
            boolean bl = false;
            f = Float.parseFloat(string2);
        }
        return f;
    }

    @Override
    public double doubleValue(boolean exactRequired) {
        double d;
        if (exactRequired) {
            int totalBits;
            int n;
            boolean exactPossible = true;
            if (this.exponent < (long)-324 || this.exponent > 308L) {
                exactPossible = false;
            }
            if (this.precision - this.exponent - 1L > 0L) {
                int bitSum;
                BigInteger integerPart = this.exponent >= 0L ? (BigInteger)this.significand.div((BigNumber)BigInteger.Companion.getTEN().pow(this.precision - this.exponent - 1L)) : BigInteger.Companion.getZERO();
                int integerPartBitLength = ConfigurationKt.getChosenArithmetic().bitLength-QwZRm1k(integerPart.getMagnitude-Y2RjT0g$bignum());
                BigInteger fractionPart = this.significand.divrem(BigInteger.Companion.getTEN().pow(this.precision - this.exponent - 1L)).getRemainder();
                BigDecimal fractionConvertTemp = new BigDecimal(fractionPart, -1L, null, 4, null);
                boolean bl = false;
                List bitList = new ArrayList();
                for (int counter = 0; Intrinsics.areEqual(fractionConvertTemp, Companion.getZERO()) ^ true && counter <= 53; ++counter) {
                    BigDecimal multiplied = (BigDecimal)fractionConvertTemp.times(2);
                    int bit = multiplied.compareTo(Companion.getONE()) >= 0 ? 1 : 0;
                    bitList.add(bit);
                    fractionConvertTemp = bit == 1 ? multiplied.divrem(Companion.getTEN()).getSecond() : multiplied;
                }
                n = bitSum = integerPartBitLength + bitList.size();
            } else {
                int trailingZeroBits = ConfigurationKt.getChosenArithmetic().trailingZeroBits-QwZRm1k(this.significand.getMagnitude-Y2RjT0g$bignum());
                int bitSum = ConfigurationKt.getChosenArithmetic().bitLength-QwZRm1k(this.significand.getMagnitude-Y2RjT0g$bignum());
                n = totalBits = bitSum - trailingZeroBits;
            }
            if (totalBits > 53) {
                exactPossible = false;
            }
            if (!exactPossible) {
                throw (Throwable)new ArithmeticException("Value cannot be narrowed to float");
            }
        }
        long divExponent = this.precision - 1L - this.exponent;
        long l = this.significand.longValue(exactRequired);
        if ((long)((double)l) == l && divExponent >= 0L && divExponent < (long)double10pow.length) {
            d = (double)l / double10pow[(int)divExponent];
        } else {
            String string2 = this.toString();
            boolean bl = false;
            d = Double.parseDouble(string2);
        }
        return d;
    }

    @NotNull
    public final BigDecimal roundSignificand(@Nullable DecimalMode decimalMode) {
        if (decimalMode == null) {
            return this;
        }
        return BigDecimal.Companion.roundSignificand(this.significand, this.exponent, decimalMode);
    }

    @NotNull
    public final BigDecimal roundToDigitPosition(long digitPosition, @NotNull RoundingMode roundingMode) {
        Intrinsics.checkNotNullParameter((Object)roundingMode, "roundingMode");
        if (digitPosition == 0L) {
            throw (Throwable)new ArithmeticException("Rounding to 0 position is not supported");
        }
        return this.exponent >= 0L ? this.roundSignificand(new DecimalMode(digitPosition, roundingMode, 0L, 4, null)) : (BigDecimal)((BigDecimal)this.plus(this.signum())).roundSignificand(new DecimalMode(digitPosition, roundingMode, 0L, 4, null)).minus(this.signum());
    }

    public static /* synthetic */ BigDecimal roundToDigitPosition$default(BigDecimal bigDecimal, long l, RoundingMode roundingMode, int n, Object object) {
        if ((n & 2) != 0) {
            roundingMode = bigDecimal.roundingMode;
        }
        return bigDecimal.roundToDigitPosition(l, roundingMode);
    }

    @NotNull
    public final BigDecimal roundToDigitPositionAfterDecimalPoint(long digitPosition, @NotNull RoundingMode roundingMode) {
        BigDecimal bigDecimal;
        Intrinsics.checkNotNullParameter((Object)roundingMode, "roundingMode");
        if (digitPosition < 0L) {
            throw (Throwable)new ArithmeticException("This method doesn't support negative digit position");
        }
        if (this.exponent >= 0L) {
            bigDecimal = this.roundToDigitPosition(this.exponent + digitPosition + 1L, roundingMode);
        } else if (this.exponent < 0L) {
            bigDecimal = this.roundToDigitPosition(digitPosition + 1L, roundingMode);
        } else {
            throw (Throwable)new RuntimeException("Unexpected state");
        }
        return bigDecimal;
    }

    private final BigDecimal getRidOfRadix(BigDecimal bigDecimal) {
        long precision = bigDecimal.significand.numberOfDecimalDigits();
        long newExponent = bigDecimal.exponent - precision + 1L;
        return new BigDecimal(bigDecimal.significand, newExponent, null, 4, null);
    }

    private final Triple<BigInteger, BigInteger, Long> bringSignificandToSameExponent(BigDecimal first2, BigDecimal second) {
        long moveFirstBy;
        BigDecimal firstPrepared = this.getRidOfRadix(first2);
        BigDecimal secondPrepared = this.getRidOfRadix(second);
        long firstPreparedExponent = firstPrepared.exponent;
        long secondPreparedExponent = secondPrepared.exponent;
        if (first2.exponent > second.exponent) {
            moveFirstBy = firstPreparedExponent - secondPreparedExponent;
            if (moveFirstBy >= 0L) {
                BigInteger movedFirst = (BigInteger)firstPrepared.significand.times((BigNumber)BigIntegerExtensionsKt.toBigInteger(10).pow(moveFirstBy));
                return new Triple<BigInteger, BigInteger, Long>(movedFirst, second.significand, secondPreparedExponent);
            }
        } else {
            if (first2.exponent < second.exponent) {
                Triple<BigInteger, BigInteger, Long> triple;
                long moveSecondBy = secondPreparedExponent - firstPreparedExponent;
                if (moveSecondBy >= 0L) {
                    BigInteger movedSecond = (BigInteger)secondPrepared.significand.times((BigNumber)BigIntegerExtensionsKt.toBigInteger(10).pow(moveSecondBy));
                    triple = new Triple<BigInteger, BigInteger, Long>(first2.significand, movedSecond, firstPreparedExponent);
                } else {
                    BigInteger movedFirst = (BigInteger)firstPrepared.significand.times((BigNumber)BigIntegerExtensionsKt.toBigInteger(10).pow(moveSecondBy * (long)-1));
                    triple = new Triple<BigInteger, BigInteger, Long>(movedFirst, second.significand, firstPreparedExponent);
                }
                return triple;
            }
            if (first2.exponent == second.exponent) {
                Triple<BigInteger, BigInteger, Long> triple;
                long delta = firstPreparedExponent - secondPreparedExponent;
                if (delta > 0L) {
                    BigInteger movedFirst = (BigInteger)first2.significand.times((BigNumber)BigIntegerExtensionsKt.toBigInteger(10).pow(delta));
                    triple = new Triple<BigInteger, BigInteger, Long>(movedFirst, second.significand, firstPreparedExponent);
                } else if (delta < 0L) {
                    BigInteger movedSecond = (BigInteger)second.significand.times((BigNumber)BigIntegerExtensionsKt.toBigInteger(10).pow(delta * (long)-1));
                    triple = new Triple<BigInteger, BigInteger, Long>(first2.significand, movedSecond, firstPreparedExponent);
                } else if (delta == 0L) {
                    triple = new Triple<BigInteger, BigInteger, Long>(first2.significand, second.significand, firstPreparedExponent);
                } else {
                    throw (Throwable)new RuntimeException("Invalid delta: " + delta);
                }
                return triple;
            }
            throw (Throwable)new RuntimeException("Invalid comparison state BigInteger: " + first2.exponent + ", " + second.exponent);
        }
        BigInteger movedSecond = (BigInteger)secondPrepared.significand.times((BigNumber)BigIntegerExtensionsKt.toBigInteger(10).pow(moveFirstBy * (long)-1));
        return new Triple<BigInteger, BigInteger, Long>(first2.significand, movedSecond, firstPreparedExponent);
    }

    /*
     * WARNING - void declaration
     */
    public final int compare(@NotNull BigDecimal other) {
        void preparedFirst;
        Intrinsics.checkNotNullParameter(other, "other");
        if (this.exponent == other.exponent && this.precision == other.precision) {
            return this.significand.compare(other.significand);
        }
        Triple<BigInteger, BigInteger, Long> triple = this.bringSignificandToSameExponent(this, other);
        BigInteger bigInteger = triple.component1();
        BigInteger preparedSecond = triple.component2();
        return preparedFirst.compare(preparedSecond);
    }

    @Override
    public int compareTo(@NotNull Object other) {
        int n;
        Intrinsics.checkNotNullParameter(other, "other");
        if (other instanceof Number && ComparisonWorkaround.INSTANCE.isSpecialHandlingForFloatNeeded((Number)other)) {
            return this.javascriptNumberComparison((Number)other);
        }
        Object object = other;
        if (object instanceof BigDecimal) {
            n = this.compare((BigDecimal)other);
        } else if (object instanceof Long) {
            n = this.compare(Companion.fromLong(((Number)other).longValue()));
        } else if (object instanceof Integer) {
            n = this.compare(Companion.fromInt(((Number)other).intValue()));
        } else if (object instanceof Short) {
            n = this.compare(Companion.fromShort(((Number)other).shortValue()));
        } else if (object instanceof Byte) {
            n = this.compare(Companion.fromByte(((Number)other).byteValue()));
        } else if (object instanceof Double) {
            n = this.compare(com.ionspin.kotlin.bignum.decimal.BigDecimal$Companion.fromDouble$default(Companion, ((Number)other).doubleValue(), null, 2, null));
        } else if (object instanceof Float) {
            n = this.compare(com.ionspin.kotlin.bignum.decimal.BigDecimal$Companion.fromFloat$default(Companion, ((Number)other).floatValue(), null, 2, null));
        } else {
            throw (Throwable)new RuntimeException("Invalid comparison type for BigDecimal: " + Reflection.getOrCreateKotlinClass(other.getClass()).getSimpleName());
        }
        return n;
    }

    private final int javascriptNumberComparison(Number number) {
        float f = number.floatValue();
        return f % 1.0f == 0.0f ? this.compare(Companion.fromLong(number.longValue())) : this.compare(BigDecimalExtensionsKt.toBigDecimal$default(number.floatValue(), null, 1, null));
    }

    @Override
    public boolean equals(@Nullable Object other) {
        Object object = other;
        int comparison = object instanceof BigDecimal ? this.compare((BigDecimal)other) : (object instanceof Long ? this.compare(Companion.fromLong(((Number)other).longValue())) : (object instanceof Integer ? this.compare(Companion.fromInt(((Number)other).intValue())) : (object instanceof Short ? this.compare(Companion.fromShort(((Number)other).shortValue())) : (object instanceof Byte ? this.compare(Companion.fromByte(((Number)other).byteValue())) : (object instanceof Double ? this.compare(com.ionspin.kotlin.bignum.decimal.BigDecimal$Companion.fromDouble$default(Companion, ((Number)other).doubleValue(), null, 2, null)) : (object instanceof Float ? this.compare(com.ionspin.kotlin.bignum.decimal.BigDecimal$Companion.fromFloat$default(Companion, ((Number)other).floatValue(), null, 2, null)) : -1))))));
        return comparison == 0;
    }

    public int hashCode() {
        DecimalMode decimalMode = this.decimalMode;
        boolean bl = false;
        DecimalMode decimalMode2 = decimalMode;
        return this.significand.hashCode() + ((Object)this.exponent).hashCode() + (decimalMode2 != null ? ((Object)decimalMode2).hashCode() : 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String toString() {
        String string2;
        String string3;
        int modifier;
        String significandString;
        block9: {
            if (useToStringExpanded) {
                return this.toStringExpanded();
            }
            significandString = this.significand.toString(10);
            modifier = this.significand.compareTo((Object)0) < 0 ? 2 : 1;
            String $this$dropLastWhile$iv = this.significand.toString();
            boolean $i$f$dropLastWhile = false;
            int n = StringsKt.getLastIndex($this$dropLastWhile$iv);
            boolean bl = false;
            while (n >= 0) {
                void index$iv;
                char it = $this$dropLastWhile$iv.charAt((int)index$iv);
                boolean bl2 = false;
                if (!(it == '0')) {
                    String string4 = $this$dropLastWhile$iv;
                    int n2 = 0;
                    void var10_10 = index$iv + true;
                    boolean bl3 = false;
                    String string5 = string4.substring(n2, (int)var10_10);
                    string3 = string5;
                    Intrinsics.checkNotNullExpressionValue(string5, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    break block9;
                }
                --index$iv;
            }
            string3 = "";
        }
        String expand = string3.length() <= 1 ? "0" : "";
        if (this.exponent > 0L) {
            string2 = this.placeADotInString(significandString, significandString.length() - modifier) + expand + "E+" + this.exponent;
        } else if (this.exponent < 0L) {
            string2 = this.placeADotInString(significandString, significandString.length() - modifier) + expand + 'E' + this.exponent;
        } else if (this.exponent == 0L) {
            string2 = this.placeADotInString(significandString, significandString.length() - modifier) + expand;
        } else {
            throw (Throwable)new RuntimeException("Invalid state, please report a bug (Integer compareTo invalid)");
        }
        return string2;
    }

    @NotNull
    public final String toPlainString() {
        return this.toStringExpanded();
    }

    @NotNull
    public final String toStringExpanded() {
        String string2;
        if (Intrinsics.areEqual(this, Companion.getZERO())) {
            return "0";
        }
        long digits = this.significand.numberOfDecimalDigits();
        if (this.exponent > (long)Integer.MAX_VALUE) {
            throw (Throwable)new RuntimeException("Invalid toStringExpanded request (exponent > Int.MAX_VALUE)");
        }
        String significandString = this.significand.toStringWithoutSign$bignum(10);
        String sign = this.significand.getSign$bignum() == Sign.NEGATIVE ? "-" : "";
        if (this.exponent > 0L) {
            long diffBigInt = this.exponent - digits + 1L;
            if (diffBigInt > 0L) {
                String expandZeros = this.times(diffBigInt, '0');
                string2 = significandString + expandZeros;
            } else {
                string2 = this.placeADotInStringExpanded(significandString, significandString.length() - (int)this.exponent - 1);
            }
        } else if (this.exponent < 0L) {
            int n = (int)this.exponent;
            boolean bl = false;
            int diffInt = Math.abs(n);
            if (diffInt > 0) {
                long l = this.exponent;
                boolean bl2 = false;
                String expandZeros = this.times(Math.abs(l), '0');
                string2 = this.placeADotInStringExpanded(expandZeros + significandString, diffInt + significandString.length() - 1);
            } else {
                string2 = this.placeADotInStringExpanded(significandString, significandString.length() - 1);
            }
        } else if (this.exponent == 0L) {
            if (digits == 1L) {
                return sign + significandString;
            }
            string2 = this.placeADotInStringExpanded(significandString, significandString.length() - 1);
        } else {
            throw (Throwable)new RuntimeException("Invalid state, please report a bug (Integer compareTo invalid)");
        }
        String adjusted = string2;
        return sign + adjusted;
    }

    private final String noExponentStringtoScientificNotation(String input) {
        return this.placeADotInString(input, input.length() - 1) + "E+" + (input.length() - 1);
    }

    /*
     * WARNING - void declaration
     */
    private final String placeADotInStringExpanded(String input, int position) {
        String string2;
        String prefix;
        block2: {
            prefix = StringsKt.substring(input, RangesKt.until(0, input.length() - position));
            String $this$dropLastWhile$iv = StringsKt.substring(input, RangesKt.until(input.length() - position, input.length()));
            boolean $i$f$dropLastWhile = false;
            int n = StringsKt.getLastIndex($this$dropLastWhile$iv);
            boolean bl = false;
            while (n >= 0) {
                void index$iv;
                char it = $this$dropLastWhile$iv.charAt((int)index$iv);
                boolean bl2 = false;
                if (!(it == '0')) {
                    String string3 = $this$dropLastWhile$iv;
                    int n2 = 0;
                    void var11_11 = index$iv + true;
                    boolean bl3 = false;
                    String string4 = string3.substring(n2, (int)var11_11);
                    string2 = string4;
                    Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    break block2;
                }
                --index$iv;
            }
            string2 = "";
        }
        String suffix = string2;
        CharSequence charSequence = suffix;
        boolean bl = false;
        return charSequence.length() > 0 ? prefix + '.' + suffix : prefix;
    }

    /*
     * WARNING - void declaration
     */
    private final String placeADotInString(String input, int position) {
        String string2;
        block2: {
            String prepared;
            String prefix = StringsKt.substring(input, RangesKt.until(0, input.length() - position));
            String suffix = StringsKt.substring(input, RangesKt.until(input.length() - position, input.length()));
            String $this$dropLastWhile$iv = prepared = prefix + '.' + suffix;
            boolean $i$f$dropLastWhile = false;
            int n = StringsKt.getLastIndex($this$dropLastWhile$iv);
            boolean bl = false;
            while (n >= 0) {
                void index$iv;
                char it = $this$dropLastWhile$iv.charAt((int)index$iv);
                boolean bl2 = false;
                if (!(it == '0')) {
                    String string3 = $this$dropLastWhile$iv;
                    int n2 = 0;
                    void var12_13 = index$iv + true;
                    boolean bl3 = false;
                    String string4 = string3.substring(n2, (int)var12_13);
                    string2 = string4;
                    Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    break block2;
                }
                --index$iv;
            }
            string2 = "";
        }
        return string2;
    }

    @NotNull
    public final String times(long $this$times, char c) {
        if ($this$times < 0L) {
            throw (Throwable)new RuntimeException("Char cannot be multiplied with negative number");
        }
        long counter = $this$times;
        StringBuilder stringBuilder = new StringBuilder();
        while (counter > 0L) {
            stringBuilder.append(c);
            long l = counter;
            counter = l + -1L;
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "stringBuilder.toString()");
        return string2;
    }

    @Nullable
    public final DecimalMode getDecimalMode() {
        return this.decimalMode;
    }

    private BigDecimal(BigInteger _significand, long _exponent, DecimalMode decimalMode) {
        this.decimalMode = decimalMode;
        this.precision = _significand.numberOfDecimalDigits();
        DecimalMode decimalMode2 = this.decimalMode;
        this.precisionLimit = decimalMode2 != null ? decimalMode2.getDecimalPrecision() : 0L;
        Object object = this.decimalMode;
        if (object == null || (object = object.getRoundingMode()) == null) {
            object = RoundingMode.NONE;
        }
        this.roundingMode = object;
        if (this.decimalMode != null && this.decimalMode.getUsingScale()) {
            BigDecimal wrk = BigDecimal.Companion.applyScale(_significand, _exponent, this.decimalMode);
            this.significand = wrk.significand;
            this.exponent = wrk.exponent;
        } else {
            this.significand = _significand;
            this.exponent = _exponent;
        }
        DecimalMode decimalMode3 = this.decimalMode;
        this.scale = decimalMode3 != null ? decimalMode3.getScale() : -1L;
        this.usingScale = this.scale >= 0L;
    }

    /* synthetic */ BigDecimal(BigInteger bigInteger, long l, DecimalMode decimalMode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        if ((n & 4) != 0) {
            decimalMode = null;
        }
        this(bigInteger, l, decimalMode);
    }

    static {
        Companion = new Companion(null);
        ZERO = new BigDecimal(BigInteger.Companion.getZERO(), 0L, null, 6, null);
        ONE = new BigDecimal(BigInteger.Companion.getONE(), 0L, null, 6, null);
        TWO = new BigDecimal(BigInteger.Companion.getTWO(), 0L, null, 6, null);
        TEN = new BigDecimal(BigInteger.Companion.getTEN(), 1L, null, 4, null);
        double10pow = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};
        maximumDouble = com.ionspin.kotlin.bignum.decimal.BigDecimal$Companion.fromDouble$default(Companion, Double.MAX_VALUE, null, 2, null);
        leastSignificantDouble = com.ionspin.kotlin.bignum.decimal.BigDecimal$Companion.fromDouble$default(Companion, Double.MIN_VALUE, null, 2, null);
        float10pow = new float[]{1.0f, 10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f, 1.0E7f, 1.0E8f, 1.0E9f, 1.0E10f};
        maximumFloat = com.ionspin.kotlin.bignum.decimal.BigDecimal$Companion.fromFloat$default(Companion, Float.MAX_VALUE, null, 2, null);
        leastSignificantFloat = com.ionspin.kotlin.bignum.decimal.BigDecimal$Companion.fromFloat$default(Companion, Float.MIN_VALUE, null, 2, null);
    }

    @Override
    @NotNull
    public BigDecimal rem(int n) {
        return CommonBigNumberOperations.DefaultImpls.rem(this, n);
    }

    @Override
    @NotNull
    public BigDecimal rem(long l) {
        return CommonBigNumberOperations.DefaultImpls.rem(this, l);
    }

    @Override
    @NotNull
    public BigDecimal rem(short s) {
        return CommonBigNumberOperations.DefaultImpls.rem(this, s);
    }

    @Override
    @NotNull
    public BigDecimal rem(byte by) {
        return CommonBigNumberOperations.DefaultImpls.rem(this, by);
    }

    @Override
    @NotNull
    public BigDecimal plus(int n) {
        return CommonBigNumberOperations.DefaultImpls.plus(this, n);
    }

    @Override
    @NotNull
    public BigDecimal plus(long l) {
        return CommonBigNumberOperations.DefaultImpls.plus(this, l);
    }

    @Override
    @NotNull
    public BigDecimal plus(short s) {
        return CommonBigNumberOperations.DefaultImpls.plus(this, s);
    }

    @Override
    @NotNull
    public BigDecimal plus(byte by) {
        return CommonBigNumberOperations.DefaultImpls.plus(this, by);
    }

    @Override
    @NotNull
    public BigDecimal minus(int n) {
        return CommonBigNumberOperations.DefaultImpls.minus(this, n);
    }

    @Override
    @NotNull
    public BigDecimal minus(long l) {
        return CommonBigNumberOperations.DefaultImpls.minus(this, l);
    }

    @Override
    @NotNull
    public BigDecimal minus(short s) {
        return CommonBigNumberOperations.DefaultImpls.minus(this, s);
    }

    @Override
    @NotNull
    public BigDecimal minus(byte by) {
        return CommonBigNumberOperations.DefaultImpls.minus(this, by);
    }

    @Override
    @NotNull
    public BigDecimal times(int n) {
        return CommonBigNumberOperations.DefaultImpls.times(this, n);
    }

    @Override
    @NotNull
    public BigDecimal times(long l) {
        return CommonBigNumberOperations.DefaultImpls.times(this, l);
    }

    @Override
    @NotNull
    public BigDecimal times(short s) {
        return CommonBigNumberOperations.DefaultImpls.times(this, s);
    }

    @Override
    @NotNull
    public BigDecimal times(byte by) {
        return CommonBigNumberOperations.DefaultImpls.times(this, by);
    }

    @Override
    @NotNull
    public BigDecimal div(int n) {
        return CommonBigNumberOperations.DefaultImpls.div(this, n);
    }

    @Override
    @NotNull
    public BigDecimal div(long l) {
        return CommonBigNumberOperations.DefaultImpls.div(this, l);
    }

    @Override
    @NotNull
    public BigDecimal div(short s) {
        return CommonBigNumberOperations.DefaultImpls.div(this, s);
    }

    @Override
    @NotNull
    public BigDecimal div(byte by) {
        return CommonBigNumberOperations.DefaultImpls.div(this, by);
    }

    @Override
    public boolean isNegative() {
        return BigNumber.DefaultImpls.isNegative(this);
    }

    @Override
    public boolean isPositive() {
        return BigNumber.DefaultImpls.isPositive(this);
    }

    public /* synthetic */ BigDecimal(BigInteger _significand, long _exponent, DecimalMode decimalMode, DefaultConstructorMarker $constructor_marker) {
        this(_significand, _exponent, decimalMode);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/ionspin/kotlin/bignum/decimal/BigDecimal$ScaleOps;", "", "(Ljava/lang/String;I)V", "Max", "Min", "Add", "bignum"})
    private static final class ScaleOps
    extends Enum<ScaleOps> {
        public static final /* enum */ ScaleOps Max;
        public static final /* enum */ ScaleOps Min;
        public static final /* enum */ ScaleOps Add;
        private static final /* synthetic */ ScaleOps[] $VALUES;

        static {
            ScaleOps[] scaleOpsArray = new ScaleOps[3];
            ScaleOps[] scaleOpsArray2 = scaleOpsArray;
            scaleOpsArray[0] = Max = new ScaleOps();
            scaleOpsArray[1] = Min = new ScaleOps();
            scaleOpsArray[2] = Add = new ScaleOps();
            $VALUES = scaleOpsArray;
        }

        public static ScaleOps[] values() {
            return (ScaleOps[])$VALUES.clone();
        }

        public static ScaleOps valueOf(String string2) {
            return Enum.valueOf(ScaleOps.class, string2);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u000f\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u001a\u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\u00022\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\u0010\u0010$\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\u001dH\u0016J\u001a\u0010$\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\u001d2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\"\u0010&\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\u0010\u0010'\u001a\u00020\u00022\u0006\u0010(\u001a\u00020)H\u0016J\u001a\u0010'\u001a\u00020\u00022\u0006\u0010(\u001a\u00020)2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\u001a\u0010*\u001a\u00020\u00022\u0006\u0010(\u001a\u00020)2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\"\u0010+\u001a\u00020\u00022\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\u001a\u0010,\u001a\u00020\u00022\u0006\u0010-\u001a\u00020.2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\u001a\u0010/\u001a\u00020\u00022\u0006\u00100\u001a\u0002012\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\u0010\u00102\u001a\u00020\u00022\u0006\u00103\u001a\u000204H\u0016J\u001a\u00102\u001a\u00020\u00022\u0006\u00103\u001a\u0002042\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\u001a\u00105\u001a\u00020\u00022\u0006\u00103\u001a\u0002042\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\"\u00106\u001a\u00020\u00022\u0006\u00103\u001a\u0002042\u0006\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\u0010\u00107\u001a\u00020\u00022\u0006\u00108\u001a\u00020\u001fH\u0016J\u001a\u00107\u001a\u00020\u00022\u0006\u00108\u001a\u00020\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\u001a\u00109\u001a\u00020\u00022\u0006\u00108\u001a\u00020\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\"\u0010:\u001a\u00020\u00022\u0006\u00108\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\u0010\u0010;\u001a\u00020\u00022\u0006\u0010<\u001a\u00020=H\u0016J\u001a\u0010;\u001a\u00020\u00022\u0006\u0010<\u001a\u00020=2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\u001a\u0010>\u001a\u00020\u00022\u0006\u0010<\u001a\u00020=2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\"\u0010?\u001a\u00020\u00022\u0006\u0010<\u001a\u00020=2\u0006\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\u001d\u0010@\u001a\u00020\u00022\u0006\u0010A\u001a\u00020BH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bC\u0010DJ'\u0010@\u001a\u00020\u00022\u0006\u0010A\u001a\u00020B2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bE\u0010FJ\u001d\u0010G\u001a\u00020\u00022\u0006\u0010H\u001a\u00020IH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bJ\u0010KJ'\u0010G\u001a\u00020\u00022\u0006\u0010H\u001a\u00020I2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bL\u0010MJ\u001d\u0010N\u001a\u00020\u00022\u0006\u0010O\u001a\u00020PH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bQ\u0010RJ'\u0010N\u001a\u00020\u00022\u0006\u0010O\u001a\u00020P2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bS\u0010TJ\u001d\u0010U\u001a\u00020\u00022\u0006\u0010V\u001a\u00020WH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bX\u0010YJ'\u0010U\u001a\u00020\u00022\u0006\u0010V\u001a\u00020W2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bZ\u0010[J\u000e\u0010\\\u001a\u00020\u00022\u0006\u0010]\u001a\u00020^J\u0018\u0010\\\u001a\u00020\u00022\u0006\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u000204H\u0016J\u001a\u0010`\u001a\u00020\u00022\u0006\u0010a\u001a\u00020^2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J&\u0010b\u001a\u00020!2\b\u0010c\u001a\u0004\u0018\u00010!2\b\u0010d\u001a\u0004\u0018\u00010!2\b\u0010e\u001a\u0004\u0018\u00010!H\u0002J \u0010f\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010g\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!H\u0002J \u0010h\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J \u0010i\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010j\u001a\u00020\u00022\u0006\u0010-\u001a\u00020.2\u0006\u0010k\u001a\u00020\u0016H\u0016J\u0018\u0010l\u001a\u00020\u00022\u0006\u00100\u001a\u0002012\u0006\u0010k\u001a\u00020\u0016H\u0016R\u0014\u0010\u0004\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006m"}, d2={"Lcom/ionspin/kotlin/bignum/decimal/BigDecimal$Companion;", "Lcom/ionspin/kotlin/bignum/BigNumber$Creator;", "Lcom/ionspin/kotlin/bignum/decimal/BigDecimal;", "()V", "ONE", "getONE", "()Lcom/ionspin/kotlin/bignum/decimal/BigDecimal;", "TEN", "getTEN", "TWO", "getTWO", "ZERO", "getZERO", "double10pow", "", "float10pow", "", "leastSignificantDouble", "leastSignificantFloat", "maximumDouble", "maximumFloat", "useToStringExpanded", "", "getUseToStringExpanded", "()Z", "setUseToStringExpanded", "(Z)V", "applyScale", "significand", "Lcom/ionspin/kotlin/bignum/integer/BigInteger;", "exponent", "", "decimalMode", "Lcom/ionspin/kotlin/bignum/decimal/DecimalMode;", "fromBigDecimal", "bigDecimal", "fromBigInteger", "bigInteger", "fromBigIntegerWithExponent", "fromByte", "byte", "", "fromByteAsSignificand", "fromByteWithExponent", "fromDouble", "double", "", "fromFloat", "float", "", "fromInt", "int", "", "fromIntAsSignificand", "fromIntWithExponent", "fromLong", "long", "fromLongAsSignificand", "fromLongWithExponent", "fromShort", "short", "", "fromShortAsSignificand", "fromShortWithExponent", "fromUByte", "uByte", "Lkotlin/UByte;", "fromUByte-7apg3OU", "(B)Lcom/ionspin/kotlin/bignum/decimal/BigDecimal;", "fromUByte-0ky7B_Q", "(BLcom/ionspin/kotlin/bignum/decimal/DecimalMode;)Lcom/ionspin/kotlin/bignum/decimal/BigDecimal;", "fromUInt", "uInt", "Lkotlin/UInt;", "fromUInt-WZ4Q5Ns", "(I)Lcom/ionspin/kotlin/bignum/decimal/BigDecimal;", "fromUInt-qim9Vi0", "(ILcom/ionspin/kotlin/bignum/decimal/DecimalMode;)Lcom/ionspin/kotlin/bignum/decimal/BigDecimal;", "fromULong", "uLong", "Lkotlin/ULong;", "fromULong-VKZWuLQ", "(J)Lcom/ionspin/kotlin/bignum/decimal/BigDecimal;", "fromULong-4PLdz1A", "(JLcom/ionspin/kotlin/bignum/decimal/DecimalMode;)Lcom/ionspin/kotlin/bignum/decimal/BigDecimal;", "fromUShort", "uShort", "Lkotlin/UShort;", "fromUShort-xj2QHRw", "(S)Lcom/ionspin/kotlin/bignum/decimal/BigDecimal;", "fromUShort-vckuEUM", "(SLcom/ionspin/kotlin/bignum/decimal/DecimalMode;)Lcom/ionspin/kotlin/bignum/decimal/BigDecimal;", "parseString", "string", "", "base", "parseStringWithMode", "floatingPointString", "resolveDecimalMode", "firstDecimalMode", "secondDecimalMode", "suppliedDecimalMode", "roundDiscarded", "discarded", "roundOrDont", "roundSignificand", "tryFromDouble", "exactRequired", "tryFromFloat", "bignum"})
    public static final class Companion
    implements BigNumber.Creator<BigDecimal> {
        @Override
        @NotNull
        public BigDecimal getZERO() {
            return ZERO;
        }

        @Override
        @NotNull
        public BigDecimal getONE() {
            return ONE;
        }

        @Override
        @NotNull
        public BigDecimal getTWO() {
            return TWO;
        }

        @Override
        @NotNull
        public BigDecimal getTEN() {
            return TEN;
        }

        public final boolean getUseToStringExpanded() {
            return useToStringExpanded;
        }

        public final void setUseToStringExpanded(boolean bl) {
            useToStringExpanded = bl;
        }

        private final BigDecimal roundOrDont(BigInteger significand, long exponent, DecimalMode decimalMode) {
            return decimalMode.isPrecisionUnlimited() ? new BigDecimal(significand, exponent, null, 4, null) : this.roundSignificand(significand, exponent, decimalMode);
        }

        private final BigInteger roundDiscarded(BigInteger significand, BigInteger discarded, DecimalMode decimalMode) {
            BigInteger significantRemainderDigit;
            Sign sign;
            long toDiscard = significand.numberOfDecimalDigits() - decimalMode.getDecimalPrecision();
            BigInteger result2 = toDiscard > 0L ? significand.divrem(BigInteger.Companion.getTEN().pow(toDiscard)).getQuotient() : significand;
            Sign sign2 = sign = Intrinsics.areEqual(significand, BigInteger.Companion.getZERO()) ? discarded.getSign$bignum() : significand.getSign$bignum();
            BigInteger bigInteger = toDiscard > 0L ? (Intrinsics.areEqual(discarded, BigInteger.Companion.getZERO()) ? BigInteger.Companion.getZERO() : (BigInteger)((BigInteger)discarded.div(discarded.numberOfDecimalDigits())).abs().plus(significand.divrem(BigInteger.Companion.getTEN().pow(toDiscard)).getRemainder().times((BigNumber)BigInteger.Companion.getTEN().pow(toDiscard)))) : (significantRemainderDigit = Intrinsics.areEqual(discarded, BigInteger.Companion.getZERO()) ? BigInteger.Companion.getZERO() : ((BigInteger)discarded.div((BigNumber)BigInteger.Companion.getTEN().pow(discarded.numberOfDecimalDigits() - 1L))).abs());
            if (significantRemainderDigit.isZero()) {
                return result2;
            }
            block0 : switch (BigDecimal$Companion$WhenMappings.$EnumSwitchMapping$4[decimalMode.getRoundingMode().ordinal()]) {
                case 1: {
                    if (sign == Sign.POSITIVE) {
                        BigInteger bigInteger2 = result2;
                        result2 = bigInteger2.inc();
                        break;
                    }
                    BigInteger bigInteger3 = result2;
                    result2 = bigInteger3.dec();
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    if (sign != Sign.POSITIVE) break;
                    BigInteger bigInteger4 = result2;
                    result2 = bigInteger4.inc();
                    break;
                }
                case 4: {
                    if (sign == Sign.POSITIVE) break;
                    BigInteger bigInteger5 = result2;
                    result2 = bigInteger5.dec();
                    break;
                }
                case 5: {
                    switch (BigDecimal$Companion$WhenMappings.$EnumSwitchMapping$0[sign.ordinal()]) {
                        case 1: {
                            if (significantRemainderDigit.compareTo((Object)5) < 0) break block0;
                            BigInteger bigInteger6 = result2;
                            result2 = bigInteger6.inc();
                            break block0;
                        }
                        case 2: {
                            if (significantRemainderDigit.compareTo((Object)5) < 0) break block0;
                            BigInteger bigInteger7 = result2;
                            result2 = bigInteger7.dec();
                            break block0;
                        }
                        case 3: {
                            break block0;
                        }
                    }
                    break;
                }
                case 6: {
                    switch (BigDecimal$Companion$WhenMappings.$EnumSwitchMapping$1[sign.ordinal()]) {
                        case 1: {
                            if (significantRemainderDigit.compareTo((Object)5) <= 0) break block0;
                            BigInteger bigInteger8 = result2;
                            result2 = bigInteger8.inc();
                            break block0;
                        }
                        case 2: {
                            if (significantRemainderDigit.compareTo((Object)5) <= 0) break block0;
                            BigInteger bigInteger9 = result2;
                            result2 = bigInteger9.dec();
                            break block0;
                        }
                        case 3: {
                            break block0;
                        }
                    }
                    break;
                }
                case 7: {
                    switch (BigDecimal$Companion$WhenMappings.$EnumSwitchMapping$2[sign.ordinal()]) {
                        case 1: {
                            if (significantRemainderDigit.compareTo((Object)5) < 0) break block0;
                            BigInteger bigInteger10 = result2;
                            result2 = bigInteger10.inc();
                            break block0;
                        }
                        case 2: {
                            if (significantRemainderDigit.compareTo((Object)5) <= 0) break block0;
                            BigInteger bigInteger11 = result2;
                            result2 = bigInteger11.dec();
                            break block0;
                        }
                        case 3: {
                            break block0;
                        }
                    }
                    break;
                }
                case 8: {
                    switch (BigDecimal$Companion$WhenMappings.$EnumSwitchMapping$3[sign.ordinal()]) {
                        case 1: {
                            if (significantRemainderDigit.compareTo((Object)5) <= 0) break block0;
                            BigInteger bigInteger12 = result2;
                            result2 = bigInteger12.inc();
                            break block0;
                        }
                        case 2: {
                            if (significantRemainderDigit.compareTo((Object)5) < 0) break block0;
                            BigInteger bigInteger13 = result2;
                            result2 = bigInteger13.dec();
                            break block0;
                        }
                        case 3: {
                            break block0;
                        }
                    }
                    break;
                }
                case 9: {
                    throw (Throwable)new ArithmeticException("Non-terminating result of division operation. Specify decimalPrecision");
                }
            }
            return result2;
        }

        private final BigDecimal roundSignificand(BigInteger significand, long exponent, DecimalMode decimalMode) {
            BigDecimal bigDecimal;
            if (Intrinsics.areEqual(significand, BigInteger.Companion.getZERO())) {
                return new BigDecimal(BigInteger.Companion.getZERO(), exponent, decimalMode, null);
            }
            long significandDigits = significand.numberOfDecimalDigits();
            long desiredPrecision = decimalMode.getDecimalPrecision();
            if (desiredPrecision > significandDigits) {
                BigInteger extendedSignificand = (BigInteger)significand.times((BigNumber)BigInteger.Companion.getTEN().pow(desiredPrecision - significandDigits));
                bigDecimal = new BigDecimal(extendedSignificand, exponent, decimalMode, null);
            } else if (desiredPrecision < significandDigits) {
                BigInteger.QuotientAndRemainder divRem = significand.divrem(BigInteger.Companion.getTEN().pow(significandDigits - desiredPrecision));
                BigInteger resolvedRemainder = divRem.getRemainder().numberOfDecimalDigits() < significandDigits - desiredPrecision ? BigInteger.Companion.getZERO() : divRem.getRemainder();
                BigInteger newSignificand = this.roundDiscarded(divRem.getQuotient(), resolvedRemainder, decimalMode);
                long exponentModifier = newSignificand.numberOfDecimalDigits() - divRem.getQuotient().numberOfDecimalDigits();
                bigDecimal = new BigDecimal(newSignificand, exponent + exponentModifier, decimalMode, null);
            } else {
                bigDecimal = new BigDecimal(significand, exponent, decimalMode, null);
            }
            return bigDecimal;
        }

        private final BigDecimal applyScale(BigInteger significand, long exponent, DecimalMode decimalMode) {
            BigDecimal bigDecimal;
            DecimalMode decimalMode2;
            if (!decimalMode.getUsingScale()) {
                return new BigDecimal(significand, exponent, decimalMode, null);
            }
            if (exponent >= 0L) {
                decimalMode2 = new DecimalMode(exponent + decimalMode.getScale() + 1L, decimalMode.getRoundingMode(), 0L, 4, null);
            } else if (exponent < 0L) {
                decimalMode2 = new DecimalMode(decimalMode.getScale() + 1L, decimalMode.getRoundingMode(), 0L, 4, null);
            } else {
                throw (Throwable)new RuntimeException("Unexpected state");
            }
            DecimalMode workMode = decimalMode2;
            if (decimalMode.getScale() == 0L) {
                BigInteger bigInteger;
                long digits = significand.numberOfDecimalDigits();
                if (exponent >= 0L) {
                    BigInteger tmp = significand;
                    while (digits > exponent + 1L) {
                        tmp = (BigInteger)tmp.div(10);
                        long l = digits;
                        digits = l + -1L;
                    }
                    bigInteger = tmp;
                } else if (exponent < 0L) {
                    bigInteger = BigInteger.Companion.getZERO();
                } else {
                    throw (Throwable)new IllegalStateException("Should be impossible. Exponent: " + exponent);
                }
                BigInteger bigInteger2 = bigInteger;
                return this.fromBigInteger(bigInteger2);
            }
            if (exponent >= 0L) {
                bigDecimal = this.roundSignificand(significand, exponent, workMode);
            } else {
                BigDecimal temp = (BigDecimal)new BigDecimal(significand, exponent, null, 4, null).plus(significand.signum());
                bigDecimal = (BigDecimal)this.roundSignificand(temp.getSignificand(), temp.getExponent(), workMode).minus(significand.signum());
            }
            return bigDecimal;
        }

        @NotNull
        public final BigDecimal fromBigDecimal(@NotNull BigDecimal bigDecimal, @Nullable DecimalMode decimalMode) {
            Intrinsics.checkNotNullParameter(bigDecimal, "bigDecimal");
            return new BigDecimal(bigDecimal.getSignificand(), bigDecimal.getExponent(), decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromBigDecimal$default(Companion companion, BigDecimal bigDecimal, DecimalMode decimalMode, int n, Object object) {
            if ((n & 2) != 0) {
                decimalMode = null;
            }
            return companion.fromBigDecimal(bigDecimal, decimalMode);
        }

        @NotNull
        public final BigDecimal fromBigInteger(@NotNull BigInteger bigInteger, @Nullable DecimalMode decimalMode) {
            Intrinsics.checkNotNullParameter(bigInteger, "bigInteger");
            return new BigDecimal(bigInteger, bigInteger.numberOfDecimalDigits() - 1L, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromBigInteger$default(Companion companion, BigInteger bigInteger, DecimalMode decimalMode, int n, Object object) {
            if ((n & 2) != 0) {
                decimalMode = null;
            }
            return companion.fromBigInteger(bigInteger, decimalMode);
        }

        @NotNull
        public final BigDecimal fromLong(long l, @Nullable DecimalMode decimalMode) {
            BigInteger bigint = BigInteger.Companion.fromLong(l);
            return new BigDecimal(bigint, bigint.numberOfDecimalDigits() - 1L, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromLong$default(Companion companion, long l, DecimalMode decimalMode, int n, Object object) {
            if ((n & 2) != 0) {
                decimalMode = null;
            }
            return companion.fromLong(l, decimalMode);
        }

        @NotNull
        public final BigDecimal fromULong-4PLdz1A(long uLong, @Nullable DecimalMode decimalMode) {
            BigInteger bigint = BigInteger.Companion.fromULong-VKZWuLQ(uLong);
            return new BigDecimal(bigint, bigint.numberOfDecimalDigits() - 1L, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromULong-4PLdz1A$default(Companion companion, long l, DecimalMode decimalMode, int n, Object object) {
            if ((n & 2) != 0) {
                decimalMode = null;
            }
            return companion.fromULong-4PLdz1A(l, decimalMode);
        }

        @NotNull
        public final BigDecimal fromInt(int n, @Nullable DecimalMode decimalMode) {
            BigInteger bigint = BigInteger.Companion.fromInt(n);
            return new BigDecimal(bigint, bigint.numberOfDecimalDigits() - 1L, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromInt$default(Companion companion, int n, DecimalMode decimalMode, int n2, Object object) {
            if ((n2 & 2) != 0) {
                decimalMode = null;
            }
            return companion.fromInt(n, decimalMode);
        }

        @NotNull
        public final BigDecimal fromUInt-qim9Vi0(int uInt, @Nullable DecimalMode decimalMode) {
            BigInteger bigint = BigInteger.Companion.fromUInt-WZ4Q5Ns(uInt);
            return new BigDecimal(bigint, bigint.numberOfDecimalDigits() - 1L, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromUInt-qim9Vi0$default(Companion companion, int n, DecimalMode decimalMode, int n2, Object object) {
            if ((n2 & 2) != 0) {
                decimalMode = null;
            }
            return companion.fromUInt-qim9Vi0(n, decimalMode);
        }

        @NotNull
        public final BigDecimal fromUShort-vckuEUM(short uShort, @Nullable DecimalMode decimalMode) {
            BigInteger bigint = BigInteger.Companion.fromUShort-xj2QHRw(uShort);
            return new BigDecimal(bigint, bigint.numberOfDecimalDigits() - 1L, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromUShort-vckuEUM$default(Companion companion, short s, DecimalMode decimalMode, int n, Object object) {
            if ((n & 2) != 0) {
                decimalMode = null;
            }
            return companion.fromUShort-vckuEUM(s, decimalMode);
        }

        @NotNull
        public final BigDecimal fromShort(short s, @Nullable DecimalMode decimalMode) {
            BigInteger bigint = BigInteger.Companion.fromShort(s);
            return new BigDecimal(bigint, bigint.numberOfDecimalDigits() - 1L, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromShort$default(Companion companion, short s, DecimalMode decimalMode, int n, Object object) {
            if ((n & 2) != 0) {
                decimalMode = null;
            }
            return companion.fromShort(s, decimalMode);
        }

        @NotNull
        public final BigDecimal fromUByte-0ky7B_Q(byte uByte, @Nullable DecimalMode decimalMode) {
            BigInteger bigint = BigInteger.Companion.fromUByte-7apg3OU(uByte);
            return new BigDecimal(bigint, bigint.numberOfDecimalDigits() - 1L, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromUByte-0ky7B_Q$default(Companion companion, byte by, DecimalMode decimalMode, int n, Object object) {
            if ((n & 2) != 0) {
                decimalMode = null;
            }
            return companion.fromUByte-0ky7B_Q(by, decimalMode);
        }

        @NotNull
        public final BigDecimal fromByte(byte by, @Nullable DecimalMode decimalMode) {
            BigInteger bigint = BigInteger.Companion.fromByte(by);
            return new BigDecimal(bigint, bigint.numberOfDecimalDigits() - 1L, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromByte$default(Companion companion, byte by, DecimalMode decimalMode, int n, Object object) {
            if ((n & 2) != 0) {
                decimalMode = null;
            }
            return companion.fromByte(by, decimalMode);
        }

        @NotNull
        public final BigDecimal fromLongAsSignificand(long l, @Nullable DecimalMode decimalMode) {
            return new BigDecimal(BigInteger.Companion.fromLong(l), 0L, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromLongAsSignificand$default(Companion companion, long l, DecimalMode decimalMode, int n, Object object) {
            if ((n & 2) != 0) {
                decimalMode = null;
            }
            return companion.fromLongAsSignificand(l, decimalMode);
        }

        @NotNull
        public final BigDecimal fromIntAsSignificand(int n, @Nullable DecimalMode decimalMode) {
            return new BigDecimal(BigInteger.Companion.fromInt(n), 0L, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromIntAsSignificand$default(Companion companion, int n, DecimalMode decimalMode, int n2, Object object) {
            if ((n2 & 2) != 0) {
                decimalMode = null;
            }
            return companion.fromIntAsSignificand(n, decimalMode);
        }

        @NotNull
        public final BigDecimal fromShortAsSignificand(short s, @Nullable DecimalMode decimalMode) {
            return new BigDecimal(BigInteger.Companion.fromShort(s), 0L, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromShortAsSignificand$default(Companion companion, short s, DecimalMode decimalMode, int n, Object object) {
            if ((n & 2) != 0) {
                decimalMode = null;
            }
            return companion.fromShortAsSignificand(s, decimalMode);
        }

        @NotNull
        public final BigDecimal fromByteAsSignificand(byte by, @Nullable DecimalMode decimalMode) {
            return new BigDecimal(BigInteger.Companion.fromByte(by), 0L, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromByteAsSignificand$default(Companion companion, byte by, DecimalMode decimalMode, int n, Object object) {
            if ((n & 2) != 0) {
                decimalMode = null;
            }
            return companion.fromByteAsSignificand(by, decimalMode);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final BigDecimal fromFloat(float f, @Nullable DecimalMode decimalMode) {
            BigDecimal bigDecimal;
            String floatString = String.valueOf(f);
            if (StringsKt.contains$default((CharSequence)floatString, '.', false, 2, null) && !StringsKt.contains((CharSequence)floatString, 'E', true)) {
                String string2;
                Companion companion;
                block4: {
                    void $this$dropLastWhile$iv;
                    String string3 = floatString;
                    companion = this;
                    boolean $i$f$dropLastWhile = false;
                    int n = StringsKt.getLastIndex((CharSequence)$this$dropLastWhile$iv);
                    boolean bl = false;
                    while (n >= 0) {
                        void index$iv;
                        char it = $this$dropLastWhile$iv.charAt((int)index$iv);
                        boolean bl2 = false;
                        if (!(it == '0')) {
                            void var8_10 = $this$dropLastWhile$iv;
                            int n2 = 0;
                            void var10_12 = index$iv + true;
                            boolean bl3 = false;
                            String string4 = var8_10.substring(n2, (int)var10_12);
                            string2 = string4;
                            Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                            break block4;
                        }
                        --index$iv;
                    }
                    string2 = "";
                }
                String string5 = string2;
                bigDecimal = companion.parseStringWithMode(string5, decimalMode);
            } else {
                bigDecimal = this.parseStringWithMode(floatString, decimalMode);
            }
            return bigDecimal;
        }

        public static /* synthetic */ BigDecimal fromFloat$default(Companion companion, float f, DecimalMode decimalMode, int n, Object object) {
            if ((n & 2) != 0) {
                decimalMode = null;
            }
            return companion.fromFloat(f, decimalMode);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final BigDecimal fromDouble(double d, @Nullable DecimalMode decimalMode) {
            BigDecimal bigDecimal;
            String doubleString = String.valueOf(d);
            if (StringsKt.contains$default((CharSequence)doubleString, '.', false, 2, null) && !StringsKt.contains((CharSequence)doubleString, 'E', true)) {
                String string2;
                Companion companion;
                block4: {
                    void $this$dropLastWhile$iv;
                    String string3 = doubleString;
                    companion = this;
                    boolean $i$f$dropLastWhile = false;
                    int n = StringsKt.getLastIndex((CharSequence)$this$dropLastWhile$iv);
                    boolean bl = false;
                    while (n >= 0) {
                        void index$iv;
                        char it = $this$dropLastWhile$iv.charAt((int)index$iv);
                        boolean bl2 = false;
                        if (!(it == '0')) {
                            void var9_10 = $this$dropLastWhile$iv;
                            int n2 = 0;
                            void var11_12 = index$iv + true;
                            boolean bl3 = false;
                            String string4 = var9_10.substring(n2, (int)var11_12);
                            string2 = string4;
                            Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                            break block4;
                        }
                        --index$iv;
                    }
                    string2 = "";
                }
                String string5 = string2;
                bigDecimal = companion.parseStringWithMode(string5, decimalMode);
            } else {
                bigDecimal = this.parseStringWithMode(doubleString, decimalMode);
            }
            return bigDecimal;
        }

        public static /* synthetic */ BigDecimal fromDouble$default(Companion companion, double d, DecimalMode decimalMode, int n, Object object) {
            if ((n & 2) != 0) {
                decimalMode = null;
            }
            return companion.fromDouble(d, decimalMode);
        }

        @NotNull
        public final BigDecimal fromBigIntegerWithExponent(@NotNull BigInteger bigInteger, long exponent, @Nullable DecimalMode decimalMode) {
            Intrinsics.checkNotNullParameter(bigInteger, "bigInteger");
            return new BigDecimal(bigInteger, exponent, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromBigIntegerWithExponent$default(Companion companion, BigInteger bigInteger, long l, DecimalMode decimalMode, int n, Object object) {
            if ((n & 4) != 0) {
                decimalMode = null;
            }
            return companion.fromBigIntegerWithExponent(bigInteger, l, decimalMode);
        }

        @NotNull
        public final BigDecimal fromLongWithExponent(long l, long exponent, @Nullable DecimalMode decimalMode) {
            BigInteger bigint = BigInteger.Companion.fromLong(l);
            return new BigDecimal(bigint, exponent, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromLongWithExponent$default(Companion companion, long l, long l2, DecimalMode decimalMode, int n, Object object) {
            if ((n & 4) != 0) {
                decimalMode = null;
            }
            return companion.fromLongWithExponent(l, l2, decimalMode);
        }

        @NotNull
        public final BigDecimal fromIntWithExponent(int n, long exponent, @Nullable DecimalMode decimalMode) {
            BigInteger bigint = BigInteger.Companion.fromInt(n);
            return new BigDecimal(bigint, exponent, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromIntWithExponent$default(Companion companion, int n, long l, DecimalMode decimalMode, int n2, Object object) {
            if ((n2 & 4) != 0) {
                decimalMode = null;
            }
            return companion.fromIntWithExponent(n, l, decimalMode);
        }

        @NotNull
        public final BigDecimal fromShortWithExponent(short s, long exponent, @Nullable DecimalMode decimalMode) {
            BigInteger bigint = BigInteger.Companion.fromShort(s);
            return new BigDecimal(bigint, exponent, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromShortWithExponent$default(Companion companion, short s, long l, DecimalMode decimalMode, int n, Object object) {
            if ((n & 4) != 0) {
                decimalMode = null;
            }
            return companion.fromShortWithExponent(s, l, decimalMode);
        }

        @NotNull
        public final BigDecimal fromByteWithExponent(byte by, long exponent, @Nullable DecimalMode decimalMode) {
            BigInteger bigint = BigInteger.Companion.fromByte(by);
            return new BigDecimal(bigint, exponent, decimalMode, null).roundSignificand(decimalMode);
        }

        public static /* synthetic */ BigDecimal fromByteWithExponent$default(Companion companion, byte by, long l, DecimalMode decimalMode, int n, Object object) {
            if ((n & 4) != 0) {
                decimalMode = null;
            }
            return companion.fromByteWithExponent(by, l, decimalMode);
        }

        @Override
        @NotNull
        public BigDecimal fromBigInteger(@NotNull BigInteger bigInteger) {
            Intrinsics.checkNotNullParameter(bigInteger, "bigInteger");
            return this.fromBigInteger(bigInteger, null);
        }

        @Override
        @NotNull
        public BigDecimal fromULong-VKZWuLQ(long uLong) {
            return this.fromULong-4PLdz1A(uLong, null);
        }

        @Override
        @NotNull
        public BigDecimal fromUInt-WZ4Q5Ns(int uInt) {
            return this.fromUInt-qim9Vi0(uInt, null);
        }

        @Override
        @NotNull
        public BigDecimal fromUShort-xj2QHRw(short uShort) {
            return this.fromUShort-vckuEUM(uShort, null);
        }

        @Override
        @NotNull
        public BigDecimal fromUByte-7apg3OU(byte uByte) {
            return this.fromUByte-0ky7B_Q(uByte, null);
        }

        @Override
        @NotNull
        public BigDecimal fromLong(long l) {
            return this.fromLong(l, null);
        }

        @Override
        @NotNull
        public BigDecimal fromInt(int n) {
            return this.fromInt(n, null);
        }

        @Override
        @NotNull
        public BigDecimal fromShort(short s) {
            return this.fromShort(s, null);
        }

        @Override
        @NotNull
        public BigDecimal fromByte(byte by) {
            return this.fromByte(by, null);
        }

        @Override
        @NotNull
        public BigDecimal tryFromFloat(float f, boolean exactRequired) {
            return this.fromFloat(f, null);
        }

        @Override
        @NotNull
        public BigDecimal tryFromDouble(double d, boolean exactRequired) {
            return this.fromDouble(d, null);
        }

        @Override
        @NotNull
        public BigDecimal parseString(@NotNull String string2, int base2) {
            Intrinsics.checkNotNullParameter(string2, "string");
            return this.parseStringWithMode(string2, null);
        }

        @NotNull
        public final BigDecimal parseString(@NotNull String string2) {
            Intrinsics.checkNotNullParameter(string2, "string");
            return com.ionspin.kotlin.bignum.decimal.BigDecimal$Companion.parseStringWithMode$default(this, string2, null, 2, null);
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final BigDecimal parseStringWithMode(@NotNull String floatingPointString, @Nullable DecimalMode decimalMode) {
            block32: {
                block31: {
                    Intrinsics.checkNotNullParameter(floatingPointString, "floatingPointString");
                    var3_3 = floatingPointString;
                    var4_4 = false;
                    if (var3_3.length() == 0) {
                        return this.getZERO();
                    }
                    if (!StringsKt.contains((CharSequence)floatingPointString, 'E', true)) break block31;
                    if (!StringsKt.contains$default((CharSequence)floatingPointString, '.', false, 2, null)) {
                        splitAroundE = StringsKt.split$default((CharSequence)floatingPointString, new char[]{'E', 'e'}, false, 0, 6, null);
                        v0 = CollectionsKt.listOf(new String[]{(String)splitAroundE.get(0), "0E" + (String)splitAroundE.get(1)});
                    } else {
                        v0 = StringsKt.split$default((CharSequence)floatingPointString, new char[]{'.'}, false, 0, 6, null);
                    }
                    split = v0;
                    switch (split.size()) {
                        case 2: {
                            signPresent = floatingPointString.charAt(0) == '-' || floatingPointString.charAt(0) == '+';
                            v1 = leftStart = signPresent != false ? 1 : 0;
                            sign = signPresent ? (floatingPointString.charAt(0) == '-' ? Sign.NEGATIVE : Sign.POSITIVE) : Sign.POSITIVE;
                            var8_11 = (String)split.get(0);
                            var9_13 = false;
                            v2 = var8_11;
                            if (v2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                            }
                            v3 = v2.substring(leftStart);
                            Intrinsics.checkNotNullExpressionValue(v3, "(this as java.lang.String).substring(startIndex)");
                            left = v3;
                            rightSplit = StringsKt.split$default((CharSequence)split.get(1), new char[]{'E', 'e'}, false, 0, 6, null);
                            right = (String)rightSplit.get(0);
                            exponentSplit = (String)rightSplit.get(1);
                            exponentSignPresent = exponentSplit.charAt(0) == '-' || exponentSplit.charAt(0) == '+';
                            exponentSign = exponentSplit.charAt(0) == '-' ? Sign.NEGATIVE : Sign.POSITIVE;
                            skipSignIfPresent = exponentSignPresent != false ? 1 : 0;
                            var15_30 = exponentSplit;
                            var16_34 = false;
                            v4 = var15_30;
                            if (v4 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                            }
                            v5 = v4.substring(skipSignIfPresent);
                            Intrinsics.checkNotNullExpressionValue(v5, "(this as java.lang.String).substring(startIndex)");
                            exponentString = v5;
                            if (exponentSign == Sign.POSITIVE) {
                                var17_38 = exponentString;
                                var18_41 = 10;
                                var19_45 = false;
                                v6 = Long.parseLong(var17_38, CharsKt.checkRadix(var18_41));
                            } else {
                                var17_38 = exponentString;
                                var18_41 = 10;
                                var19_45 = false;
                                v6 = Long.parseLong(var17_38, CharsKt.checkRadix(var18_41)) * (long)-1;
                            }
                            exponent = v6;
                            $this$indexOfFirst$iv = left;
                            $i$f$indexOfFirst = false;
                            var20_48 = 0;
                            var21_51 = $this$indexOfFirst$iv.length();
                            while (var20_48 < var21_51) {
                                it = $this$indexOfFirst$iv.charAt((int)index$iv);
                                $i$a$-indexOfFirst-BigDecimal$Companion$parseStringWithMode$leftFirstNonZero$1 = false;
                                if (!(it != '0')) ** GOTO lbl61
                                v7 = index$iv;
                                ** GOTO lbl64
lbl61:
                                // 1 sources

                                ++index$iv;
                            }
                            v7 = leftFirstNonZero = -1;
lbl64:
                            // 2 sources

                            if (leftFirstNonZero == -1) {
                                leftFirstNonZero = 0;
                            }
                            $this$indexOfLast$iv = right;
                            $i$f$indexOfLast = false;
                            var21_51 = $this$indexOfLast$iv.length();
                            --var21_51;
                            it = '\u0000';
                            while (var21_51 >= 0) {
                                it = $this$indexOfLast$iv.charAt(index$iv);
                                $i$a$-indexOfLast-BigDecimal$Companion$parseStringWithMode$rightLastNonZero$1 = false;
                                if (!(it != '0')) ** GOTO lbl77
                                v8 = index$iv;
                                ** GOTO lbl80
lbl77:
                                // 1 sources

                                --index$iv;
                            }
                            v8 = rightLastNonZero = -1;
lbl80:
                            // 2 sources

                            if (rightLastNonZero == -1) {
                                rightLastNonZero = right.length() - 1;
                            }
                            $i$f$indexOfLast = left;
                            index$iv = left.length();
                            it = '\u0000';
                            v9 = $i$f$indexOfLast;
                            if (v9 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                            }
                            v10 = v9.substring(leftFirstNonZero, index$iv);
                            Intrinsics.checkNotNullExpressionValue(v10, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                            leftTruncated = v10;
                            index$iv = right;
                            it = '\u0000';
                            var23_55 = rightLastNonZero + 1;
                            var24_56 = false;
                            v11 = index$iv;
                            if (v11 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                            }
                            v12 = v11.substring(it, var23_55);
                            Intrinsics.checkNotNullExpressionValue(v12, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                            rightTruncated = v12;
                            significand = BigInteger.Companion.parseString(leftTruncated + rightTruncated, 10);
                            if (Intrinsics.areEqual(significand, BigInteger.Companion.getZERO())) {
                                sign = Sign.ZERO;
                            }
                            if (sign == Sign.NEGATIVE) {
                                significand = significand.negate();
                            }
                            exponentModifiedByFloatingPointPosition = (Intrinsics.areEqual(leftTruncated, "0") ^ true) != false ? exponent + (long)leftTruncated.length() - 1L : exponent - ((long)rightTruncated.length() - significand.numberOfDecimalDigits()) - 1L;
                            return new BigDecimal(significand, exponentModifiedByFloatingPointPosition, decimalMode, null);
                        }
                    }
                    throw (Throwable)new ArithmeticException("Invalid (or unsupported) floating point number format: " + floatingPointString);
                }
                if (!StringsKt.contains$default((CharSequence)floatingPointString, '.', false, 2, null)) break block32;
                split = StringsKt.split$default((CharSequence)floatingPointString, new char[]{'.'}, false, 0, 6, null);
                switch (split.size()) {
                    case 2: {
                        signPresent = floatingPointString.charAt(0) == '-' || floatingPointString.charAt(0) == '+';
                        v13 = leftStart = signPresent != false ? 1 : 0;
                        sign = signPresent ? (floatingPointString.charAt(0) == '-' ? Sign.NEGATIVE : Sign.POSITIVE) : Sign.POSITIVE;
                        rightSplit = (String)split.get(0);
                        right = false;
                        v14 = rightSplit;
                        if (v14 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        v15 = v14.substring(leftStart);
                        Intrinsics.checkNotNullExpressionValue(v15, "(this as java.lang.String).substring(startIndex)");
                        left = v15;
                        right = split.get(1);
                        $this$indexOfFirst$iv = left;
                        $i$f$indexOfFirst = false;
                        exponentSign = 0;
                        skipSignIfPresent = $this$indexOfFirst$iv.length();
                        while (exponentSign < skipSignIfPresent) {
                            it = $this$indexOfFirst$iv.charAt((int)index$iv);
                            $i$a$-indexOfFirst-BigDecimal$Companion$parseStringWithMode$leftFirstNonZero$2 = false;
                            if (!(it != '0')) ** GOTO lbl136
                            v16 = index$iv;
                            ** GOTO lbl139
lbl136:
                            // 1 sources

                            ++index$iv;
                        }
                        v16 = leftFirstNonZero = -1;
lbl139:
                        // 2 sources

                        if (leftFirstNonZero == -1) {
                            leftFirstNonZero = 0;
                        }
                        $this$indexOfLast$iv = right;
                        $i$f$indexOfLast = false;
                        skipSignIfPresent = $this$indexOfLast$iv.length();
                        --skipSignIfPresent;
                        it = '\u0000';
                        while (skipSignIfPresent >= 0) {
                            it = $this$indexOfLast$iv.charAt(index$iv);
                            $i$a$-indexOfLast-BigDecimal$Companion$parseStringWithMode$rightLastNonZero$2 = false;
                            if (!(it != 48)) ** GOTO lbl152
                            v17 = index$iv;
                            ** GOTO lbl155
lbl152:
                            // 1 sources

                            --index$iv;
                        }
                        v17 = rightLastNonZero = -1;
lbl155:
                        // 2 sources

                        if (rightLastNonZero == -1) {
                            rightLastNonZero = right.length() - 1;
                        }
                        $i$f$indexOfLast = left;
                        index$iv = left.length();
                        it = '\u0000';
                        v18 = $i$f$indexOfLast;
                        if (v18 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        v19 = v18.substring(leftFirstNonZero, index$iv);
                        Intrinsics.checkNotNullExpressionValue(v19, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        leftTruncated = v19;
                        index$iv = right;
                        it = '\u0000';
                        it = rightLastNonZero + 1;
                        $i$a$-indexOfLast-BigDecimal$Companion$parseStringWithMode$rightLastNonZero$2 = false;
                        v20 = index$iv;
                        if (v20 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        v21 = v20.substring(it, it);
                        Intrinsics.checkNotNullExpressionValue(v21, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        rightTruncated = v21;
                        significand = BigInteger.Companion.parseString(leftTruncated + rightTruncated, 10);
                        it = leftTruncated;
                        $i$a$-indexOfLast-BigDecimal$Companion$parseStringWithMode$rightLastNonZero$2 = false;
                        if (!(it.length() > 0) || leftTruncated.charAt(0) == '0') ** GOTO lbl182
                        v22 = leftTruncated.length() - 1;
                        ** GOTO lbl196
lbl182:
                        // 1 sources

                        $this$indexOfFirst$iv = rightTruncated;
                        $i$f$indexOfFirst = false;
                        leftFirstNonZero = 0;
                        var18_44 = $this$indexOfFirst$iv.length();
                        while (leftFirstNonZero < var18_44) {
                            it = $this$indexOfFirst$iv.charAt((int)index$iv);
                            $i$a$-indexOfFirst-BigDecimal$Companion$parseStringWithMode$exponent$1 = false;
                            if (!(it != '0')) ** GOTO lbl192
                            v23 = index$iv;
                            ** GOTO lbl195
lbl192:
                            // 1 sources

                            ++index$iv;
                        }
                        v23 = -1;
lbl195:
                        // 2 sources

                        v22 = exponent = (v23 + 1) * -1;
lbl196:
                        // 2 sources

                        if (Intrinsics.areEqual(significand, BigInteger.Companion.getZERO())) {
                            sign = Sign.ZERO;
                        }
                        if (sign == Sign.NEGATIVE) {
                            significand = significand.negate();
                        }
                        return new BigDecimal(significand, exponent, decimalMode, null);
                    }
                }
                throw (Throwable)new ArithmeticException("Invalid (or unsupported) floating point number format: " + floatingPointString);
            }
            significand = BigInteger.Companion.parseString(floatingPointString, 10);
            return new BigDecimal(significand, significand.numberOfDecimalDigits() - 1L, decimalMode, null);
        }

        public static /* synthetic */ BigDecimal parseStringWithMode$default(Companion companion, String string2, DecimalMode decimalMode, int n, Object object) {
            if ((n & 2) != 0) {
                decimalMode = null;
            }
            return companion.parseStringWithMode(string2, decimalMode);
        }

        private final DecimalMode resolveDecimalMode(DecimalMode firstDecimalMode, DecimalMode secondDecimalMode, DecimalMode suppliedDecimalMode) {
            DecimalMode decimalMode;
            if (suppliedDecimalMode != null) {
                decimalMode = suppliedDecimalMode;
            } else {
                DecimalMode unifiedDecimalMode;
                if (firstDecimalMode == null && secondDecimalMode == null) {
                    return new DecimalMode(0L, null, 0L, 7, null);
                }
                if (firstDecimalMode == null && secondDecimalMode != null) {
                    return secondDecimalMode;
                }
                if (secondDecimalMode == null && firstDecimalMode != null) {
                    return firstDecimalMode;
                }
                DecimalMode decimalMode2 = firstDecimalMode;
                Intrinsics.checkNotNull(decimalMode2);
                RoundingMode roundingMode = decimalMode2.getRoundingMode();
                DecimalMode decimalMode3 = secondDecimalMode;
                Intrinsics.checkNotNull(decimalMode3);
                if (roundingMode != decimalMode3.getRoundingMode()) {
                    throw (Throwable)new ArithmeticException("Different rounding modes! This: " + (Object)((Object)firstDecimalMode.getRoundingMode()) + " Other: " + (Object)((Object)secondDecimalMode.getRoundingMode()));
                }
                decimalMode = unifiedDecimalMode = firstDecimalMode.getDecimalPrecision() >= secondDecimalMode.getDecimalPrecision() ? firstDecimalMode : secondDecimalMode;
            }
            return decimalMode;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

