/*
 * Decompiled with CFR 0.152.
 */
package com.certora.evmverifier.cvl;

import com.certora.evmverifier.cvl.Cmd;
import com.certora.evmverifier.cvl.Exp;
import com.certora.evmverifier.cvl.NumberExp;
import com.certora.evmverifier.cvl.Param;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java_cup.runtime.ComplexSymbolFactory;
import kotlinizable.Kotlinizable;
import kotlinizable.Kotlinizer;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLLocation;
import spec.cvlast.CVLTypeCheckerKt;
import spec.cvlast.SpecCallSummary;

public class CallSummary
implements Kotlinizable<SpecCallSummary> {
    private final ComplexSymbolFactory.Location loc;
    private final String specFile;
    private final Type type;
    private final NumberExp returnValue;
    private final Boolean optimistic;
    private final List<Cmd> blockCmd;
    private final List<Param> withParams;
    private final Exp exp;
    private Boolean forced;

    public CallSummary(String _specFile, ComplexSymbolFactory.Location _loc, Type _type) {
        if (_type == Type.ALWAYS) {
            throw new RuntimeException("Cannot call one-arg constructor when type is ALWAYS");
        }
        this.specFile = _specFile;
        this.loc = _loc;
        this.type = _type;
        this.returnValue = null;
        this.blockCmd = null;
        this.withParams = null;
        this.exp = null;
        this.forced = false;
        this.optimistic = null;
    }

    public CallSummary(String _specFile, ComplexSymbolFactory.Location _loc, Type _type, NumberExp _returnValue) {
        if (_type != Type.ALWAYS) {
            throw new RuntimeException("Cannot call constructor with returnValue when type is not ALWAYS");
        }
        this.specFile = _specFile;
        this.loc = _loc;
        this.type = _type;
        this.returnValue = _returnValue;
        this.blockCmd = null;
        this.withParams = null;
        this.exp = null;
        this.forced = false;
        this.optimistic = null;
    }

    public CallSummary(String _specFile, ComplexSymbolFactory.Location loc, Type type, Boolean optimistic) {
        if (type != Type.DISPATCHER) {
            throw new IllegalArgumentException("Cannot call two-arg boolean constructor when type is not DISPATCHER");
        }
        this.specFile = _specFile;
        this.loc = loc;
        this.type = type;
        this.optimistic = optimistic;
        this.forced = false;
        this.returnValue = null;
        this.blockCmd = null;
        this.withParams = null;
        this.exp = null;
    }

    public CallSummary(String _specFile, ComplexSymbolFactory.Location _loc, Type _type, List<Cmd> _block, List<Param> _extraParams) {
        if (_type != Type.COMMANDS) {
            throw new RuntimeException("Cannot call constructor with block when type is not COMMANDS");
        }
        this.specFile = _specFile;
        this.loc = _loc;
        this.type = _type;
        this.returnValue = null;
        this.blockCmd = _block;
        this.withParams = Objects.requireNonNullElse(_extraParams, Collections.emptyList());
        this.exp = null;
        this.forced = false;
        this.optimistic = null;
    }

    public CallSummary(String _specFile, ComplexSymbolFactory.Location _loc, Type _type, Exp _exp, List<Param> _withParams) {
        if (_type != Type.EXP) {
            throw new IllegalArgumentException("Cannot call constructor with expression when type is not EXP");
        }
        this.specFile = _specFile;
        this.loc = _loc;
        this.type = _type;
        this.returnValue = null;
        this.blockCmd = null;
        this.withParams = Objects.requireNonNullElse(_withParams, Collections.emptyList());
        this.exp = _exp;
        this.forced = false;
        this.optimistic = null;
    }

    public void force(String specFile, ComplexSymbolFactory.Location loc) {
        CVLLocation.Spec cvlLoc = CVLLocation.Companion.fromLocationAndSpecFile(loc, specFile);
        CVLTypeCheckerKt.syntaxError(cvlLoc, "Forced summaries are not actually supported yet, do not use the force keyword");
    }

    @Override
    public SpecCallSummary kotlinize() {
        SpecCallSummary summary;
        CVLLocation.Spec cvlLoc = CVLLocation.Companion.fromLocationAndSpecFile(this.loc, this.specFile);
        if (this.type == Type.ALWAYS) {
            assert (this.returnValue != null);
            summary = new SpecCallSummary.Always(this.returnValue.n, this.forced, cvlLoc);
        } else if (this.type == Type.CONSTANT) {
            summary = new SpecCallSummary.Constant(this.forced, cvlLoc);
        } else if (this.type == Type.PER_CALLEE_CONSTANT) {
            summary = new SpecCallSummary.PerCalleeConstant(this.forced, cvlLoc);
        } else if (this.type == Type.NONDET) {
            summary = new SpecCallSummary.HavocSummary.Nondet(this.forced, cvlLoc);
        } else if (this.type == Type.HAVOC_ECF) {
            summary = new SpecCallSummary.HavocSummary.HavocECF(this.forced, cvlLoc);
        } else if (this.type == Type.DISPATCHER) {
            summary = new SpecCallSummary.Dispatcher(this.forced, this.optimistic, cvlLoc);
        } else if (this.type == Type.HAVOC_ALL) {
            summary = new SpecCallSummary.HavocSummary.HavocAll(this.forced, cvlLoc);
        } else if (this.type == Type.COMMANDS) {
            if (this.blockCmd == null) {
                CVLTypeCheckerKt.syntaxError(cvlLoc, "required commands block not given for a summary");
                summary = new SpecCallSummary.Command(this.forced, Collections.emptyList(), Collections.emptyList(), cvlLoc);
            } else {
                summary = new SpecCallSummary.Command(this.forced, Kotlinizer.kotlinizeList(this.blockCmd), Param.kotlinizeList(this.withParams), cvlLoc);
            }
        } else if (this.type == Type.EXP) {
            summary = new SpecCallSummary.Exp(this.forced, (CVLExp)this.exp.kotlinize(), null, Param.kotlinizeList(this.withParams), cvlLoc);
        } else {
            if (this.type != Type.AUTO) {
                throw new RuntimeException("Not handling case: " + this.type.name());
            }
            summary = new SpecCallSummary.HavocSummary.Auto(this.forced, cvlLoc);
        }
        return summary;
    }

    static enum Type {
        ALWAYS,
        CONSTANT,
        PER_CALLEE_CONSTANT,
        NONDET,
        HAVOC_ECF,
        HAVOC_ALL,
        AUTO,
        DISPATCHER,
        COMMANDS,
        EXP;

    }
}

