/*
 * Decompiled with CFR 0.152.
 */
package com.certora.evmverifier.cvl;

import com.certora.evmverifier.cvl.Definitions;
import com.certora.evmverifier.cvl.ImportedContract;
import com.certora.evmverifier.cvl.ImportedEvent;
import com.certora.evmverifier.cvl.ImportedFunction;
import com.certora.evmverifier.cvl.ImportedSpecFile;
import java.util.List;
import kotlinizable.Kotlinizable;
import kotlinizable.Kotlinizer;
import spec.cvlast.CVLAst;

public class Ast
implements Kotlinizable<CVLAst> {
    public int pragma = 0;
    public List<ImportedFunction> imports;
    public List<ImportedEvent> events;
    public Definitions definitionsOrUseDecls;
    public List<ImportedContract> importedContracts;
    public List<ImportedSpecFile> importedSpecFiles;

    public Ast(String _pragma, List<ImportedFunction> _imports, List<ImportedEvent> _events, Definitions _definitionsOrUseDecls, List<ImportedContract> _contracts, List<ImportedSpecFile> _importedSpecFiles) {
        this.pragma = this.parsePragma(_pragma);
        this.imports = _imports;
        this.events = _events;
        this.definitionsOrUseDecls = _definitionsOrUseDecls;
        this.importedContracts = _contracts;
        this.importedSpecFiles = _importedSpecFiles;
    }

    private Integer parsePragma(String pragma) {
        int mainSeparator = pragma.indexOf(".");
        int majorVersion = Integer.parseInt(pragma.substring(0, mainSeparator));
        int minorVersion = Integer.parseInt(pragma.substring(mainSeparator + 1));
        return majorVersion * 100 + minorVersion;
    }

    @Override
    public CVLAst kotlinize() {
        return new CVLAst(this.pragma, Kotlinizer.kotlinizeList(this.imports), Kotlinizer.kotlinizeList(this.events), this.definitionsOrUseDecls.kotlinizeUseDeclarations(), this.definitionsOrUseDecls.kotlinizeRules(), this.definitionsOrUseDecls.kotlinizeSubs(), this.definitionsOrUseDecls.kotlinizeInvariants(), this.definitionsOrUseDecls.kotlinizeSorts(), this.definitionsOrUseDecls.kotlinizeGhostDecls(), this.definitionsOrUseDecls.kotlinizeMacroDefinitions(), this.definitionsOrUseDecls.kotlinizeHooks(), Kotlinizer.kotlinizeList(this.importedContracts), Kotlinizer.kotlinizeList(this.importedSpecFiles), null);
    }
}

