# Copyright (C) 2021 Satoshi Konno. All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http:#www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# To the extent possible under law, Sony Computer Science Laboratories, Inc has waived
# all copyright and related or neighboring rights to ECHONETLite-ObjectDatabase.
# This work is published from: Japan.
#
# GENERATED FROM objects.pl DO NOT EDIT THIS FILE.

from .reader import Object, Property

__std_scsl_objects: dict = {}


def get_all_std_scsl_objects() -> dict:
    return __std_scsl_objects


# Gas leak sensor (0x0001)
obj = Object("Gas leak sensor", 0x00, 0x01)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Detection threshold level", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB1, "Gas leak occurrence status", "unsigned char", 1, "mandatory", "-", "mandatory"))
obj.add_property(Property(0xBF, "Gas leak occurrence status resetting", "unsigned char", 1, "-", "optional", "-"))
__std_scsl_objects[(0x00, 0x01)] = obj

# Crime prevention sensor (0x0002)
obj = Object("Crime prevention sensor", 0x00, 0x02)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Detection threshold level", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB1, "Invasion occurrence status", "unsigned char", 1, "mandatory", "-", "mandatory"))
obj.add_property(Property(0xBF, "Invasion occurrence status resetting", "unsigned char", 1, "-", "optional", "-"))
__std_scsl_objects[(0x00, 0x02)] = obj

# Emergency button (0x0003)
obj = Object("Emergency button", 0x00, 0x03)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB1, "Emergency occurrence status", "unsigned char", 1, "mandatory", "-", "mandatory"))
obj.add_property(Property(0xBF, "Emergency occurrence status resetting", "unsigned char", 1, "-", "optional", "-"))
__std_scsl_objects[(0x00, 0x03)] = obj

# First-aid sensor (0x0004)
obj = Object("First-aid sensor", 0x00, 0x04)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Detection threshold level", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB1, "First-aid occurrence status", "unsigned char", 1, "mandatory", "-", "mandatory"))
obj.add_property(Property(0xBF, "First-aid occurrence status resetting", "unsigned char", 1, "-", "optional", "-"))
__std_scsl_objects[(0x00, 0x04)] = obj

# Earthquake sensor (0x0005)
obj = Object("Earthquake sensor", 0x00, 0x05)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Detection threshold level", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB1, "Earthquake occurrence status", "unsigned char", 1, "mandatory", "-", "mandatory"))
obj.add_property(Property(0xBF, "Earthquake occurrence status resetting", "unsigned char", 1, "-", "optional", "-"))
__std_scsl_objects[(0x00, 0x05)] = obj

# Electric leak sensor (0x0006)
obj = Object("Electric leak sensor", 0x00, 0x06)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Detection threshold level", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB1, "Electric leak occurrence status", "unsigned char", 1, "mandatory", "-", "mandatory"))
obj.add_property(Property(0xBF, "Electric leak occurrence status resetting", "unsigned char", 1, "-", "optional", "-"))
__std_scsl_objects[(0x00, 0x06)] = obj

# Human detection sensor (0x0007)
obj = Object("Human detection sensor", 0x00, 0x07)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Detection threshold level", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB1, "Human detection status", "unsigned char", 1, "mandatory", "-", "mandatory"))
__std_scsl_objects[(0x00, 0x07)] = obj

# Visitor sensor (0x0008)
obj = Object("Visitor sensor", 0x00, 0x08)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Detection threshold level", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB1, "Visitor detection status", "unsigned char", 1, "mandatory", "-", "mandatory"))
obj.add_property(Property(0xBE, "Visitor detection holding time", "unsigned short", 2, "optional", "optional", "-"))
__std_scsl_objects[(0x00, 0x08)] = obj

# Call sensor (0x0009)
obj = Object("Call sensor", 0x00, 0x09)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Detection threshold level", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB1, "Call status", "unsigned char", 1, "mandatory", "-", "mandatory"))
obj.add_property(Property(0xBE, "Call holding time", "unsigned short", 2, "optional", "optional", "-"))
__std_scsl_objects[(0x00, 0x09)] = obj

# Condensation sensor (0x000A)
obj = Object("Condensation sensor", 0x00, 0x0A)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Detection threshold level", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB1, "Condensation detection status", "unsigned char", 1, "mandatory", "-", "mandatory"))
__std_scsl_objects[(0x00, 0x0A)] = obj

# Air pollution sensor (0x000B)
obj = Object("Air pollution sensor", 0x00, 0x0B)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Detection threshold level", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB1, "Air pollution detection status", "unsigned char", 1, "mandatory", "-", "mandatory"))
__std_scsl_objects[(0x00, 0x0B)] = obj

# Oxygen sensor (0x000C)
obj = Object("Oxygen sensor", 0x00, 0x0C)
obj.add_property(Property(0x80, "Operation status", "unsigned short", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xE0, "Measured value of oxygen concentration", "unsigned short", 2, "mandatory", "-", "-"))
__std_scsl_objects[(0x00, 0x0C)] = obj

# Illuminance sensor (0x000D)
obj = Object("Illuminance sensor", 0x00, 0x0D)
obj.add_property(Property(0x80, "Operation status", "unsigned short", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xE0, "Measured illuminance value 1", "unsigned short", 2, "mandatory", "-", "-"))
obj.add_property(Property(0xE1, "Measured illuminance value 2", "unsigned short", 2, "mandatory", "-", "-"))
__std_scsl_objects[(0x00, 0x0D)] = obj

# Sound sensor (0x000E)
obj = Object("Sound sensor", 0x00, 0x0E)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Detection threshold level", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB1, "Sound detection status", "unsigned char", 1, "mandatory", "-", "mandatory"))
obj.add_property(Property(0xBE, "Sound detection holding time", "unsigned short", 2, "optional", "optional", "-"))
__std_scsl_objects[(0x00, 0x0E)] = obj

# Mailing sensor (0x000F)
obj = Object("Mailing sensor", 0x00, 0x0F)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Detection threshold level", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB1, "Mailing detection status", "unsigned char", 1, "mandatory", "-", "mandatory"))
__std_scsl_objects[(0x00, 0x0F)] = obj

# Weight sensor (0x0010)
obj = Object("Weight sensor", 0x00, 0x10)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Detection threshold level", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB1, "Weight detection status", "unsigned char", 1, "mandatory", "-", "mandatory"))
__std_scsl_objects[(0x00, 0x10)] = obj

# Temperature sensor (0x0011)
obj = Object("Temperature sensor", 0x00, 0x11)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xE0, "Measured temperature value", "signed short", 2, "mandatory", "-", "-"))
__std_scsl_objects[(0x00, 0x11)] = obj

# Humidity sensor (0x0012)
obj = Object("Humidity sensor", 0x00, 0x12)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xE0, "Measured value of relative humidity", "unsigned char", 1, "mandatory", "-", "-"))
__std_scsl_objects[(0x00, 0x12)] = obj

# Rain sensor (0x0013)
obj = Object("Rain sensor", 0x00, 0x13)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Detection threshold level", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB1, "Rain detection status", "unsigned char", 1, "mandatory", "-", "mandatory"))
__std_scsl_objects[(0x00, 0x13)] = obj

# Water level sensor (0x0014)
obj = Object("Water level sensor", 0x00, 0x14)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Water level over detection threshold level", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xB1, "Water level over detection status", "unsigned char", 1, "optional", "-", "mandatory"))
obj.add_property(Property(0xE0, "Measured value of water level", "unsigned char", 1, "mandatory", "-", "-"))
__std_scsl_objects[(0x00, 0x14)] = obj

# Bath water level sensor (0x0015)
obj = Object("Bath water level sensor", 0x00, 0x15)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Bath water level over detection threshold level", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xB1, "Bath water level over detection status", "unsigned char", 1, "optional", "-", "mandatory"))
obj.add_property(Property(0xE0, "Measured value of bath water level", "unsigned char", 1, "mandatory", "-", "-"))
__std_scsl_objects[(0x00, 0x15)] = obj

# Bath heating status sensor (0x0016)
obj = Object("Bath heating status sensor", 0x00, 0x16)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Detection threshold level", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB1, "Bath heating detection status", "unsigned char", 1, "mandatory", "-", "mandatory"))
__std_scsl_objects[(0x00, 0x16)] = obj

# Water leak sensor (0x0017)
obj = Object("Water leak sensor", 0x00, 0x17)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Detection threshold level", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB1, "Water leak detection status", "unsigned char", 1, "mandatory", "-", "mandatory"))
__std_scsl_objects[(0x00, 0x17)] = obj

# Water overflow sensor (0x0018)
obj = Object("Water overflow sensor", 0x00, 0x18)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Detection threshold level", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB1, "Water overflow detection status", "unsigned char", 1, "mandatory", "-", "mandatory"))
__std_scsl_objects[(0x00, 0x18)] = obj

# Fire sensor (0x0019)
obj = Object("Fire sensor", 0x00, 0x19)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Detection threshold level", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB1, "Fire occurrence detection status", "unsigned char", 1, "mandatory", "-", "mandatory"))
obj.add_property(Property(0xBF, "Fire occurrence detection status resetting", "unsigned char", 1, "-", "optional", "-"))
__std_scsl_objects[(0x00, 0x19)] = obj

# Cigarette smoke sensor (0x001A)
obj = Object("Cigarette smoke sensor", 0x00, 0x1A)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Detection threshold level", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB1, "Smoke (cigarette) detection status", "unsigned char", 1, "mandatory", "-", "mandatory"))
__std_scsl_objects[(0x00, 0x1A)] = obj

# CO2 sensor (0x001B)
obj = Object("CO2 sensor", 0x00, 0x1B)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xE0, "Measured value of CO2 concentration", "unsigned short", 2, "mandatory", "-", "-"))
__std_scsl_objects[(0x00, 0x1B)] = obj

# Gas sensor (0x001C)
obj = Object("Gas sensor", 0x00, 0x1C)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Detection threshold level", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB1, "Gas detection status", "unsigned char", 1, "optional", "-", "mandatory"))
obj.add_property(Property(0xE0, "Measured value of gas concentration", "unsigned short", 2, "mandatory", "-", "-"))
__std_scsl_objects[(0x00, 0x1C)] = obj

# VOC sensor (0x001D)
obj = Object("VOC sensor", 0x00, 0x1D)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Detection threshold level", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB1, "VOC detection status", "unsigned char", 1, "optional", "-", "mandatory"))
obj.add_property(Property(0xE0, "Measured value of VOC concentration", "unsigned short", 2, "mandatory", "-", "-"))
__std_scsl_objects[(0x00, 0x1D)] = obj

# Differential pressure sensor (0x001E)
obj = Object("Differential pressure sensor", 0x00, 0x1E)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xE0, "Measured value of differential pressure", "signed short", 2, "mandatory", "-", "-"))
__std_scsl_objects[(0x00, 0x1E)] = obj

# Air speed sensor (0x001F)
obj = Object("Air speed sensor", 0x00, 0x1F)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xE0, "Measured value of air speed", "unsigned short", 2, "mandatory", "-", "-"))
obj.add_property(Property(0xE1, "Air flow direction", "unsigned short", 2, "optional", "-", "-"))
__std_scsl_objects[(0x00, 0x1F)] = obj

# Odor sensor (0x0020)
obj = Object("Odor sensor", 0x00, 0x20)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Detection threshold level", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB1, "Odor detection status", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xE0, "Measured odor value", "unsigned char", 1, "mandatory", "-", "-"))
__std_scsl_objects[(0x00, 0x20)] = obj

# Flame sensor (0x0021)
obj = Object("Flame sensor", 0x00, 0x21)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Detection threshold level", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB1, "Flame detection status", "unsigned char", 1, "mandatory", "-", "mandatory"))
obj.add_property(Property(0xBF, "Flame detection status resetting", "unsigned char", 1, "-", "optional", "-"))
__std_scsl_objects[(0x00, 0x21)] = obj

# Electric energy sensor (0x0022)
obj = Object("Electric energy sensor", 0x00, 0x22)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xE0, "Integral electric energy", "unsigned long", 4, "mandatory", "-", "-"))
obj.add_property(Property(0xE1, "Medium-capacity sensor instantaneous electric energy", "signed long", 4, "optional", "-", "-"))
obj.add_property(Property(0xE2, "Small-capacity sensor instantaneous electric energy", "signed short", 2, "optional", "-", "-"))
obj.add_property(Property(0xE3, "Large-capacity sensor instantaneous electric energy", "signed short", 2, "optional", "-", "-"))
obj.add_property(Property(0xE4, "Integral electric energy measurement log", "unsigned long × 48", 192, "optional", "-", "-"))
obj.add_property(Property(0xE5, "Effective voltage value", "unsigned short", 2, "optional", "-", "-"))
__std_scsl_objects[(0x00, 0x22)] = obj

# Current value sensor (0x0023)
obj = Object("Current value sensor", 0x00, 0x23)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xE0, "Measured current value 1", "unsigned long", 4, "mandatory", "-", "-"))
obj.add_property(Property(0xE1, "Rated voltage to be measured", "unsigned short", 2, "optional", "-", "-"))
obj.add_property(Property(0xE2, "Measured current value 2", "unsigned long", 4, "mandatory", "-", "-"))
__std_scsl_objects[(0x00, 0x23)] = obj

# Water flow rate sensor (0x0025)
obj = Object("Water flow rate sensor", 0x00, 0x25)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xE0, "Integral flow rate", "unsigned long", 4, "optional", "-", "-"))
obj.add_property(Property(0xE2, "Flow rate", "unsigned long", 4, "mandatory", "-", "-"))
__std_scsl_objects[(0x00, 0x25)] = obj

# Micromotion sensor (0x0026)
obj = Object("Micromotion sensor", 0x00, 0x26)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Detection threshold level", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB1, "Micromotion detection status", "unsigned char", 1, "mandatory", "-", "mandatory"))
obj.add_property(Property(0xB2, "Detection counter", "unsigned short", 2, "optional", "optional", "-"))
obj.add_property(Property(0xBC, "Sampling count", "unsigned short", 2, "optional", "optional", "-"))
obj.add_property(Property(0xBD, "Sampling cycle", "unsigned short", 2, "optional", "optional", "-"))
__std_scsl_objects[(0x00, 0x26)] = obj

# Passage sensor (0x0027)
obj = Object("Passage sensor", 0x00, 0x27)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Detection threshold level", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xBE, "Passage detection hold time", "unsigned char", 2, "optional", "optional", "-"))
obj.add_property(Property(0xE0, "Passage detection direction", "unsigned char", 1, "mandatory", "-", "mandatory"))
__std_scsl_objects[(0x00, 0x27)] = obj

# Bed presence sensor (0x0028)
obj = Object("Bed presence sensor", 0x00, 0x28)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Detection threshold level", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB1, "Bed presence detection status", "unsigned char", 1, "mandatory", "-", "mandatory"))
__std_scsl_objects[(0x00, 0x28)] = obj

# Open/close sensor (0x0029)
obj = Object("Open/close sensor", 0x00, 0x29)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xE0, "Degree-of-openi ng detection status 1", "unsigned char", 1, "mandatory", "-", "-"))
obj.add_property(Property(0xB0, "Detection threshold level", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB1, "Degree-of-openi ng detection status 2", "unsigned char", 1, "mandatory", "-", "mandatory"))
__std_scsl_objects[(0x00, 0x29)] = obj

# Activity amount sensor (0x002A)
obj = Object("Activity amount sensor", 0x00, 0x2A)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xE0, "Activity amount level 1", "unsigned char × max 128", 0, "mandatory", "-", "-"))
obj.add_property(Property(0xE1, "Maximum number of human body ID's", "unsigned short", 2, "optional", "-", "-"))
obj.add_property(Property(0xE2, "Activity amount level 2", "unsigned char", 1, "mandatory", "-", "-"))
obj.add_property(Property(0xE3, "Human body existence information", "unsigned char × 16", 16, "optional", "-", "-"))
__std_scsl_objects[(0x00, 0x2A)] = obj

# Human body location sensor (0x002B)
obj = Object("Human body location sensor", 0x00, 0x2B)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xE0, "Human body detection location 1", "unsigned char × 3 x max 128", 0, "mandatory", "-", "-"))
obj.add_property(Property(0xE1, "Maximum number of human body ID's", "unsigned short", 2, "optional", "-", "-"))
obj.add_property(Property(0xE2, "Human body detection location 2", "unsigned char × 3", 3, "mandatory", "-", "-"))
obj.add_property(Property(0xE3, "Human body existence information", "unsigned char × 16", 16, "optional", "-", "-"))
__std_scsl_objects[(0x00, 0x2B)] = obj

# Snow sensor (0x002C)
obj = Object("Snow sensor", 0x00, 0x2C)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Detection threshold level", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB1, "Snow detection status", "unsigned char", 1, "mandatory", "-", "mandatory"))
__std_scsl_objects[(0x00, 0x2C)] = obj

# Home air conditioner (0x0130)
obj = Object("Home air conditioner", 0x01, 0x30)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "mandatory", "mandatory"))
obj.add_property(Property(0xB0, "Operation mode setting", "unsigned char", 1, "mandatory", "mandatory", "mandatory"))
obj.add_property(Property(0xB1, "Automatic temperature control setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB2, "Normal/high- speed/silent operation setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB3, "Set temperature value", "unsigned char", 1, "mandatory", "mandatory", "-"))
obj.add_property(Property(0xB4, "Set value of relative humidity in dehumidifying mode", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB5, "Set temperature value in cooling mode", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB6, "Set temperature value in heating mode", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB7, "Set temperature value in dehumidifying mode", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB8, "Rated power consumption", "unsigned short × 4", 8, "optional", "-", "-"))
obj.add_property(Property(0xB9, "Measured value of current consumption", "unsigned short", 2, "optional", "-", "-"))
obj.add_property(Property(0xBA, "Measured value of room relative humidity", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xBB, "Measured value of room temperature", "signed char", 1, "optional", "-", "-"))
obj.add_property(Property(0xBC, "Set temperature value of user remote control", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xBD, "Measured cooled air temperature", "signed char", 1, "optional", "-", "-"))
obj.add_property(Property(0xBE, "Measured outdoor air temperature", "signed char", 1, "optional", "-", "-"))
obj.add_property(Property(0xBF, "Relative temperature setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xA0, "Air flow rate setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xA1, "Automatic control of air flow direction setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xA3, "Automatic swing of air flow setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xA4, "Air flow direction (vertical) setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xA5, "Air flow direction (horizontal) setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xAA, "Special state", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xAB, "Non-priority state", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xC0, "Ventilation function setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xC1, "Humidifier function setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xC2, "Ventilation air flow rate setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xC4, "Degree of humidification setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xC6, "Mounted air cleaning method", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xC7, "Air purifier function setting", "unsigned char ×8", 8, "optional", "optional", "-"))
obj.add_property(Property(0xC8, "Mounted air refresh method", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xC9, "Air refresher function setting", "unsigned char × 8", 8, "optional", "optional", "-"))
obj.add_property(Property(0xCA, "Mounted self-cleaning method", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xCB, "Self-cleaning function setting", "unsigned char × 8", 8, "optional", "optional", "-"))
obj.add_property(Property(0xCC, "Special function setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xCD, "Operation status of components", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xCE, "Thermostat setting override function", "unsigned char", 1, "-", "optional", "-"))
obj.add_property(Property(0xCF, "Air purification mode setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0x90, "ON timer-based reservation setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0x91, "ON timer setting (time)", "unsigned char × 2", 2, "optional", "optional", "-"))
obj.add_property(Property(0x92, "ON timer setting (relative time)", "unsigned char × 2", 2, "optional", "optional", "-"))
obj.add_property(Property(0x94, "OFF timer-based reservation setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0x95, "OFF timer setting (time)", "unsigned char × 2", 2, "optional", "optional", "-"))
obj.add_property(Property(0x96, "OFF timer setting (relative time)", "unsigned char × 2", 2, "optional", "optional", "-"))
__std_scsl_objects[(0x01, 0x30)] = obj

# Ventilation fan (0x0133)
obj = Object("Ventilation fan", 0x01, 0x33)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "mandatory", "mandatory"))
obj.add_property(Property(0xBF, "Ventilation auto setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xA0, "Set value of ventilation air flow rate", "unsigned char", 1, "optional", "optional", "-"))
__std_scsl_objects[(0x01, 0x33)] = obj

# Air conditioner ventilation fan (0x0134)
obj = Object("Air conditioner ventilation fan", 0x01, 0x34)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "mandatory", "mandatory"))
obj.add_property(Property(0xB4, "Set value of room relative humidity", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xBF, "Ventilation auto setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xBA, "Measured value of room relative humidity", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xA0, "Set value of ventilation air flow rate", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE0, "Heat exchanger operation setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xC0, "Measured value of CO2 concentration", "unsigned short", 2, "optional", "-", "-"))
obj.add_property(Property(0xC1, "Smoke (cigarette) detection status", "unsigned char", 1, "optional", "-", "-"))
__std_scsl_objects[(0x01, 0x34)] = obj

# Air cleaner (0x0135)
obj = Object("Air cleaner", 0x01, 0x35)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "mandatory", "mandatory"))
obj.add_property(Property(0xE1, "Filter change notice", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xA0, "Air flow rate setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xC1, "Smoke (cigarette) detection status", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xC2, "Optical catalyst operation setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xC0, "Air pollution detection status", "unsigned char", 1, "optional", "-", "-"))
__std_scsl_objects[(0x01, 0x35)] = obj

# Humidifier (0x0139)
obj = Object("Humidifier", 0x01, 0x39)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "mandatory", "mandatory"))
obj.add_property(Property(0xC0, "Humidifying setting 1", "unsigned char", 1, "mandatory", "mandatory", "-"))
obj.add_property(Property(0xC1, "Humidifying setting 2", "unsigned char", 1, "mandatory", "mandatory", "-"))
obj.add_property(Property(0xB4, "Measured value of relative humidity", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0x94, "Reservation set of OFF timer", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0x96, "Relative time value set of OFF timer", "unsigned char ×2", 2, "optional", "optional", "-"))
obj.add_property(Property(0xC2, "Ion emission setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xC3, "Implemented ion emission method", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xC4, "Special operation mode setting", "unsigned short", 1, "optional", "optional", "-"))
obj.add_property(Property(0xC5, "Water amount level", "unsigned char", 1, "optional", "-", "-"))
__std_scsl_objects[(0x01, 0x39)] = obj

# Electric heater (0x0142)
obj = Object("Electric heater", 0x01, 0x42)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB1, "Automatic temperature control setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB3, "Temperature setting", "unsigned char", 1, "mandatory", "mandatory", "-"))
obj.add_property(Property(0xBB, "Measured room temperature", "signed char", 1, "optional", "-", "-"))
obj.add_property(Property(0xBC, "Remotely set temperature", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xA0, "Air flow rate setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0x90, "ON timer-based reservation setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0x91, "ON timer setting (time)", "unsigned char × 2", 2, "optional", "optional", "-"))
obj.add_property(Property(0x92, "ON timer setting (relative time)", "unsigned char × 2", 2, "optional", "optional", "-"))
obj.add_property(Property(0x94, "OFF timer-based reservation setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0x95, "OFF timer setting (time)", "unsigned char × 2", 2, "optional", "optional", "-"))
obj.add_property(Property(0x96, "Set value of OFF timer relative time", "unsigned char × 2", 2, "optional", "optional", "-"))
__std_scsl_objects[(0x01, 0x42)] = obj

# Fan heater (0x0143)
obj = Object("Fan heater", 0x01, 0x43)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "mandatory", "mandatory"))
obj.add_property(Property(0xB3, "Temperature setting value", "unsigned char", 1, "mandatory", "mandatory", "-"))
obj.add_property(Property(0xBB, "Measured temperature", "signed char", 1, "optional", "-", "-"))
obj.add_property(Property(0xB1, "Automatic temperature control setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0x90, "ON timer reservation setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0x91, "ON timer setting value (time)", "unsigned char × 2", 2, "optional", "optional", "-"))
obj.add_property(Property(0x92, "ON timer setting value (relative time)", "unsigned char × 2", 2, "optional", "optional", "-"))
obj.add_property(Property(0x94, "OFF timer reservation setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0x95, "OFF timer setting value (time)", "unsigned char × 2", 2, "optional", "optional", "-"))
obj.add_property(Property(0x96, "OFF timer value ( relative time)", "unsigned char × 2", 2, "optional", "optional", "-"))
obj.add_property(Property(0xC0, "Extentional operation setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xC1, "Extentional operation timer time setting value", "unsigned char × 2", 2, "optional", "optional", "-"))
obj.add_property(Property(0xC2, "Ion emission setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xC3, "Implemented ion emission method", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xC4, "Oil amount level", "unsigned char", 1, "optional", "-", "-"))
__std_scsl_objects[(0x01, 0x43)] = obj

# Package-type commercial air conditioner (indoor unit) (0x0145)
obj = Object("Package-type commercial air conditioner (indoor unit)", 0x01, 0x45)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "mandatory", "mandatory"))
obj.add_property(Property(0xB0, "Operation mode setting", "unsigned char", 1, "mandatory", "mandatory", "mandatory"))
obj.add_property(Property(0xB3, "Temperature setting 1", "signed char", 1, "mandatory", "mandatory", "mandatory"))
obj.add_property(Property(0xB4, "“Relative humidity setting for ‘dehumidifica- tion’ mode” 1", "unsigned char", 1, "optional", "optional", "mandatory"))
obj.add_property(Property(0xB5, "“Temperature setting for ‘cooling’ mode” 1", "signed char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB6, "“Temperature setting for ‘heating’ mode” 1", "signed char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB7, "“Temperature setting for ‘dehumidifica- tion’ mode” 1", "signed char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB8, "Rated power consumption of indoor unit", "unsigned short × 4", 8, "optional", "-", "-"))
obj.add_property(Property(0xB9, "Measured electric current consumption of indoor unit", "unsigned short", 2, "optional", "-", "-"))
obj.add_property(Property(0xBA, "Measured indoor relative humidity 1", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xBB, "Measured indoor temperature 1", "signed char", 1, "optional", "-", "-"))
obj.add_property(Property(0xBF, "Relative temperature setting", "signed char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xA0, "Air flow rate setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xA4, "“Air flow direction (vertical)” setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xA5, "“Air flow direction (horizontal)” setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xAA, "“Special” state", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xAC, "Thermostat state", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xAE, "Current function (“automatic” operation mode)", "unsigned char", 1, "optional", "-", "mandatory"))
obj.add_property(Property(0xC0, "Ventilation mode setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xC1, "Combined operation of indoor unit and total heat exchanger", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xC2, "Ventilation air flow rate setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xCD, "“Disabling of air conditioner” setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xCE, "Thermostat setting override function", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xCF, "Filter cleaning reminder lamp setting", "unsigned char", 1, "optional", "optional", "mandatory"))
obj.add_property(Property(0xDB, "Measured power consumption of indoor unit", "unsigned short", 2, "optional", "-", "-"))
obj.add_property(Property(0xDC, "Aperture of expansion valve", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xE3, "Temperature setting 2", "unsigned short", 2, "mandatory", "mandatory", "mandatory"))
obj.add_property(Property(0xE4, "“Relative humidity setting for ‘dehumidificatio n’ mode” 2", "unsigned short", 2, "optional", "optional", "mandatory"))
obj.add_property(Property(0xE5, "“Temperature setting for ‘cooling’ mode” 2", "unsigned short", 2, "optional", "optional", "-"))
obj.add_property(Property(0xE6, "“Temperature setting for ‘heating’ mode” 2", "unsigned short", 2, "optional", "optional", "-"))
obj.add_property(Property(0xE7, "“Temperature setting for ‘dehumidificatio n’ mode” 2", "unsigned short", 2, "optional", "optional", "-"))
obj.add_property(Property(0xEA, "Measured indoor relative humidity 2", "unsigned short", 2, "optional", "-", "-"))
obj.add_property(Property(0xEB, "Measured indoor temperature 2", "unsigned short", 2, "optional", "-", "-"))
obj.add_property(Property(0x90, "“ON timer-based reservation” setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0x91, "ON timer setting (time)", "unsigned char×2", 2, "optional", "optional", "-"))
obj.add_property(Property(0x92, "ON timer setting (relative time)", "unsigned char×2", 2, "optional", "optional", "-"))
obj.add_property(Property(0x94, "“OFF timer-based reservation” setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0x95, "OFF timer setting (time)", "unsigned char×2", 2, "optional", "optional", "-"))
obj.add_property(Property(0x96, "OFF timer setting (relative time)", "unsigned char×2", 2, "optional", "optional", "-"))
__std_scsl_objects[(0x01, 0x45)] = obj

# Package-type commercial air conditioner (outdoor unit) (0x0146)
obj = Object("Package-type commercial air conditioner (outdoor unit)", 0x01, 0x46)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Operation mode setting", "unsigned char", 1, "optional", "optional", "mandatory"))
obj.add_property(Property(0xB8, "Rated power consumption of outdoor unit", "unsigned short × 3", 6, "optional", "-", "-"))
obj.add_property(Property(0xB9, "Measured electric current consumption of outdoor unit", "unsigned short", 2, "optional", "-", "-"))
obj.add_property(Property(0xBE, "Measured outdoor air temperature 1", "signed char", 1, "optional", "-", "-"))
obj.add_property(Property(0xAA, "“Special” state", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xD0, "Operation status of compressor", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xD1, "Operation mode information", "unsigned char", 1, "mandatory", "-", "-"))
obj.add_property(Property(0xD2, "Fan rotation speed", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xDB, "Measured power consumption of outdoor unit", "unsigned short", 2, "optional", "-", "-"))
obj.add_property(Property(0xEE, "Measured outdoor air temperature 2", "signed short", 2, "optional", "-", "-"))
__std_scsl_objects[(0x01, 0x46)] = obj

# Electrically operated shade (0x0260)
obj = Object("Electrically operated shade", 0x02, 0x60)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xE0, "Open/close setting", "unsigned char", 1, "mandatory", "mandatory", "mandatory"))
obj.add_property(Property(0xE1, "Degree-of-openi ng level", "unsigned char", 1, "mandatory", "mandatory", "-"))
obj.add_property(Property(0xE2, "Set value of shade angle", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE3, "Shade open/close speed", "unsigned char", 1, "optional", "optional", "-"))
__std_scsl_objects[(0x02, 0x60)] = obj

# Electrically operated shutter (0x0261)
obj = Object("Electrically operated shutter", 0x02, 0x61)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xE0, "Open/close setting 1", "unsigned char", 1, "mandatory", "mandatory", "mandatory"))
obj.add_property(Property(0xE1, "Extent of opening 1", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE2, "Blind angle setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE3, "Shutter speed", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE4, "Extent of opening 2", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE5, "Electric lock setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE7, "Open/close setting 2", "unsigned char", 1, "mandatory", "mandatory", "mandatory"))
__std_scsl_objects[(0x02, 0x61)] = obj

# Electrically operated storm window (0x0263)
obj = Object("Electrically operated storm window", 0x02, 0x63)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xE0, "Open/close setting 1", "unsigned char", 1, "mandatory", "mandatory", "mandatory"))
obj.add_property(Property(0xE1, "Extent of opening 1", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE2, "Blind angle setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE3, "Shutter speed", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE4, "Extent of opening 2", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE5, "Electric lock setting", "unsigned char", 1, "mandatory", "mandatory", "mandatory"))
obj.add_property(Property(0xE7, "Open/close setting 2", "unsigned char", 1, "optional", "optional", "mandatory"))
__std_scsl_objects[(0x02, 0x63)] = obj

# Garden sprinkler (0x0267)
obj = Object("Garden sprinkler", 0x02, 0x67)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xE0, "Sprinkle valve open/close setting", "unsigned char", 1, "mandatory", "mandatory", "-"))
obj.add_property(Property(0xE1, "Sprinkle interval setting", "unsigned long", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE2, "Number of sprinkles setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE3, "Sprinkle time setting 1", "unsigned char ×2", 2, "optional", "optional", "-"))
obj.add_property(Property(0xE4, "Sprinkle time setting 2", "unsigned char ×2", 2, "optional", "optional", "-"))
obj.add_property(Property(0xE5, "Sprinkle duration setting", "unsigned char", 1, "optional", "optional", "-"))
__std_scsl_objects[(0x02, 0x67)] = obj

# Electric water heater (0x026B)
obj = Object("Electric water heater", 0x02, 0x6B)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "“Automatic water heating” setting", "unsigned char", 1, "mandatory", "mandatory", "-"))
obj.add_property(Property(0xB1, "“Automatic water temperature control” setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB2, "Water heater status", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xB3, "Water heating temperature setting", "unsigned char", 1, "mandatory", "mandatory", "-"))
obj.add_property(Property(0xC0, "“Daytime reheating permission” setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xC1, "Measured temperature of water in water heater", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xC2, "Alarm status", "unsigned char × 2", 4, "optional", "-", "mandatory"))
obj.add_property(Property(0xD1, "“Temperature of supplied water” setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xD3, "Bath water temperature setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE0, "Bath water volume setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE1, "Measured amount of water remaining in tank", "unsigned short", 2, "optional", "-", "-"))
obj.add_property(Property(0xE2, "Tank capacity", "unsigned short", 2, "optional", "-", "-"))
obj.add_property(Property(0xE3, "“Automatic bath water heating” mode setting", "unsigned char", 1, "mandatory", "mandatory", "-"))
obj.add_property(Property(0xE5, "“Addition of hot water” function setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE6, "“Slight bath water temperature lowering” function setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE7, "Bath water volume setting 1", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE8, "Bath water volume setting 2", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xEE, "Bath water volume setting 3", "unsigned short", 2, "optional", "optional", "-"))
obj.add_property(Property(0xD4, "Bath water volume setting 4", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xD5, "Bath water volume setting 4- Maximum settable level", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0x90, "ON timer reservation setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0x91, "ON timer setting", "unsigned char × 2", 2, "optional", "optional", "-"))
obj.add_property(Property(0xDB, "Rated power consumption of H/P unit in wintertime", "unsigned short", 2, "optional", "-", "-"))
obj.add_property(Property(0xDC, "Rated power consumption of H/P unit in in-between seasons", "unsigned short", 2, "optional", "-", "-"))
obj.add_property(Property(0xDD, "Rated power consumption of H/P unit in summertime", "unsigned short", 2, "optional", "-", "-"))
__std_scsl_objects[(0x02, 0x6B)] = obj

# Bidet-equipped toilet(with electrically warmed seat) (0x026E)
obj = Object("Bidet-equipped toilet(with electrically warmed seat)", 0x02, 0x6E)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xE0, "Temperature level of toilet seat", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE1, "Heater setting of toilet seat", "unsigned char", 1, "mandatory", "mandatory", "-"))
obj.add_property(Property(0xE2, "Temporal halt setting of toilet seat", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE3, "Temporal halt start time of toilet seat", "unsigned char ×2", 2, "optional", "optional", "-"))
obj.add_property(Property(0xE4, "Temporal halt time duration of toilet seat", "unsigned char ×2", 2, "optional", "optional", "-"))
obj.add_property(Property(0xE5, "Temperature level setting of room heating", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE6, "Room heating setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE7, "Room heating status", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xE8, "Start time of room heating", "unsigned char ×2", 2, "optional", "optional", "-"))
obj.add_property(Property(0xE9, "Duration time of room heating", "unsigned char ×2", 2, "optional", "optional", "-"))
obj.add_property(Property(0xEA, "Special operation mode setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xEB, "Human detection status", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xEC, "Seating detection status", "unsigned char", 1, "optional", "-", "-"))
__std_scsl_objects[(0x02, 0x6E)] = obj

# Electric key (0x026F)
obj = Object("Electric key", 0x02, 0x6F)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xE0, "Lock setting 1", "unsigned char", 1, "mandatory", "mandatory", "mandatory"))
obj.add_property(Property(0xE1, "Lock setting 2", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE2, "Lock status of door guard", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xE3, "Door open/close status", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xE4, "Occupant/ non-occupant status", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xE5, "Alarm status", "unsigned char", 1, "optional", "-", "mandatory"))
obj.add_property(Property(0xE6, "Auto lock mode setting", "unsigned char", 1, "optional", "optional", "-"))
__std_scsl_objects[(0x02, 0x6F)] = obj

# Hot water generator (0x0272)
obj = Object("Hot water generator", 0x02, 0x72)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xD0, "Hot water heating status", "unsigned char", 1, "mandatory", "-", "-"))
obj.add_property(Property(0xD1, "Set value of hot water temperature", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xD2, "Hot water Warmer setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xDA, "“Duration of automatic operation” setting", "unsigned char× 2", 2, "optional", "optional", "-"))
obj.add_property(Property(0xDB, "Remaining automatic operation time", "unsigned char × 2", 2, "optional", "-", "-"))
obj.add_property(Property(0xE1, "Set value of bath temperature", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE2, "Bath water heater status", "unsigned char", 1, "mandatory", "-", "-"))
obj.add_property(Property(0xE3, "Bath auto mode setting", "unsigned char", 1, "mandatory", "mandatory", "-"))
obj.add_property(Property(0xE4, "Bath additional boil-up operation setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE5, "Bath hot water adding operation setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE6, "Bath water temperature lowering operation setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE7, "Bath hot water volume setting 1", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE8, "Bath hot water volume setting 2", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xEE, "Bath hot water volume setting 3", "unsigned short", 2, "optional", "optional", "-"))
obj.add_property(Property(0xE9, "Bathroom priority setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xEA, "Shower hot water supply status", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xEB, "Kitchen hot water supply status", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xEC, "Hot water warmer ON timer reservation setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xED, "Set value of hot water warmer ON timer time", "unsigned char × 2", 2, "optional", "optional", "-"))
obj.add_property(Property(0x90, "ON timer reservation setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0x91, "Set value of ON timer time", "unsigned char × 2", 2, "optional", "optional", "-"))
obj.add_property(Property(0x92, "Set value of ON timer relative time", "unsigned char × 2", 2, "optional", "optional", "-"))
__std_scsl_objects[(0x02, 0x72)] = obj

# Bathroom dryer (0x0273)
obj = Object("Bathroom dryer", 0x02, 0x73)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Operation setting", "unsigned char", 1, "mandatory", "mandatory", "-"))
obj.add_property(Property(0xB1, "Ventilation operation setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB2, "Bathroom pre-warmer operation setting", "unsigned char", 1, "mandatory", "mandatory", "-"))
obj.add_property(Property(0xB3, "Bathroom heater operation setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB4, "Bathroom dryer operation setting", "unsigned char", 1, "mandatory", "mandatory", "-"))
obj.add_property(Property(0xB5, "Cool air circulator operation setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xBA, "Measured relative bathroom humidity", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xBB, "Measured bathroom temperature", "signed char", 1, "optional", "-", "-"))
obj.add_property(Property(0xC2, "Ventilation air flow rate setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xCF, "Filter cleaning reminder sign setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE0, "Human body detection status", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0x90, "“ON timer-based reservation” setting 1", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE1, "“ON timer-based reservation” setting 2", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0x91, "ON timer setting (time)", "unsigned char ×2", 2, "optional", "optional", "-"))
obj.add_property(Property(0x92, "ON timer setting (relative time)", "unsigned char ×2", 2, "optional", "optional", "-"))
obj.add_property(Property(0x94, "“OFF timer-based reservation” setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0x95, "OFF timer setting (time)", "unsigned char ×2", 2, "optional", "optional", "-"))
obj.add_property(Property(0x96, "OFF timer setting (relative time)", "unsigned char ×2", 2, "optional", "optional", "-"))
__std_scsl_objects[(0x02, 0x73)] = obj

# Home solar power generation (0x0279)
obj = Object("Home solar power generation", 0x02, 0x79)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xD0, "System-interconnected type", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xE0, "Measured instantaneous amount of electricity generated", "unsigned short", 2, "mandatory", "-", "-"))
obj.add_property(Property(0xE1, "Measured cumulative amount of electric energy generated", "unsigned long", 4, "mandatory", "-", "-"))
obj.add_property(Property(0xE2, "Resetting cumulative amount of electric energy generated", "unsigned char", 1, "-", "optional", "-"))
obj.add_property(Property(0xE3, "Measured cumulative amount of electric energy sold", "unsigned long", 4, "optional", "-", "-"))
obj.add_property(Property(0xE4, "Resetting cumulative amount of electric energy sold", "unsigned char", 1, "-", "optional", "-"))
obj.add_property(Property(0xE5, "Power generation output limit setting 1", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE6, "Power generation output limit setting 2", "unsigned short", 2, "optional", "optional", "-"))
obj.add_property(Property(0xE7, "Limit setting for the amount of electricity sold", "unsigned short", 2, "optional", "optional", "-"))
obj.add_property(Property(0xE8, "Rated power generation output (System-interconnected)", "unsigned short", 2, "optional", "optional", "-"))
obj.add_property(Property(0xE9, "Rated power generation output (Independent)", "unsigned short", 2, "optional", "optional", "-"))
__std_scsl_objects[(0x02, 0x79)] = obj

# Cold / hot water heat source equipment (0x027A)
obj = Object("Cold / hot water heat source equipment", 0x02, 0x7A)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xE0, "Operation mode setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE1, "Water temperature setting 1", "unsigned char", 1, "mandatory", "mandatory", "-"))
obj.add_property(Property(0xE2, "Water temperature setting 2", "unsigned char", 1, "mandatory", "mandatory", "-"))
obj.add_property(Property(0xE3, "Measured temperature of outward water (Exit water Temperature)", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xE4, "Measured temperature of inward water (Entrance water temperature)", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xE5, "Special operation setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE6, "Daily timer setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE7, "Daily timer setting 1", "unsigned char × 6", 6, "optional", "optional", "-"))
obj.add_property(Property(0xE8, "Daily timer setting 2", "unsigned char × 6", 6, "optional", "optional", "-"))
obj.add_property(Property(0x90, "ON timer reservation setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0x91, "ON timer setting", "unsigned char × 2", 2, "optional", "optional", "-"))
obj.add_property(Property(0x92, "Relative ON timer setting", "unsigned char × 2", 2, "optional", "optional", "-"))
obj.add_property(Property(0x94, "OFF timer reservation setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0x95, "Time set by OFF timer", "unsigned char ×2", 2, "optional", "optional", "-"))
obj.add_property(Property(0x96, "Relative OFF timer setting", "unsigned char ×2", 2, "optional", "optional", "-"))
__std_scsl_objects[(0x02, 0x7A)] = obj

# Floor heater (0x027B)
obj = Object("Floor heater", 0x02, 0x7B)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "mandatory", "mandatory"))
obj.add_property(Property(0xE0, "Temperature setting 1", "unsigned char", 1, "mandatory", "mandatory", "-"))
obj.add_property(Property(0xE1, "Temperature setting 2", "unsigned char", 1, "mandatory", "mandatory", "-"))
obj.add_property(Property(0xE2, "Measured room temperature", "signed char", 1, "optional", "-", "-"))
obj.add_property(Property(0xE3, "Measured floor temperature", "signed char", 1, "optional", "-", "-"))
obj.add_property(Property(0xE4, "Zone change setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE5, "Special operation setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE6, "Daily timer setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE7, "Daily timer setting 1", "unsigned char × 6", 6, "optional", "optional", "-"))
obj.add_property(Property(0xE8, "Daily timer setting 2", "unsigned char × 6", 6, "optional", "optional", "-"))
obj.add_property(Property(0x90, "ON timer reservation setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0x91, "Time set by ON timer", "unsigned char × 2", 2, "optional", "optional", "-"))
obj.add_property(Property(0x92, "Relative ON timer setting", "unsigned char × 2", 2, "optional", "optional", "-"))
obj.add_property(Property(0x94, "OFF timer reservation setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0x95, "Time set by OFF timer", "unsigned char ×2", 2, "optional", "optional", "-"))
obj.add_property(Property(0x96, "Relative OFF timer setting", "unsigned char ×2", 2, "optional", "optional", "-"))
__std_scsl_objects[(0x02, 0x7B)] = obj

# Fuel cell (0x027C)
obj = Object("Fuel cell", 0x02, 0x7C)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xC1, "Measured temperature of water in water heater", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xC2, "Rated power generation output", "unsigned short", 2, "optional", "-", "-"))
obj.add_property(Property(0xC3, "Heating value of hot water storage tank", "unsigned short", 2, "optional", "-", "-"))
obj.add_property(Property(0xC4, "Measured instantaneous power generation output", "unsigned short", 2, "mandatory", "-", "-"))
obj.add_property(Property(0xC5, "Measured cumulative power generation output", "unsigned long", 4, "mandatory", "-", "-"))
obj.add_property(Property(0xC6, "Cumulative power generation output reset setting", "unsigned char", 1, "-", "optional", "-"))
obj.add_property(Property(0xC7, "Measured instantaneous gas consumption", "unsigned short", 2, "optional", "-", "-"))
obj.add_property(Property(0xC8, "Measured cumulative gas consumption", "unsigned long", 4, "optional", "-", "-"))
obj.add_property(Property(0xC9, "Cumulative gas consumption reset setting", "unsigned char", 1, "-", "optional", "-"))
obj.add_property(Property(0xCA, "Power generation setting", "unsigned char", 1, "-", "optional", "-"))
obj.add_property(Property(0xCB, "Power generation status", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xCC, "Measured in-house instantaneous power consumption", "unsigned short", 2, "optional", "-", "-"))
obj.add_property(Property(0xCD, "Measured in-house cumulative power consumption", "unsigned long", 4, "optional", "-", "-"))
obj.add_property(Property(0xCE, "In-house cumulative power consumption reset", "unsigned char", 1, "-", "optional", "-"))
obj.add_property(Property(0xD0, "System interconnected type", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xE1, "Measured remaining hot water amount", "unsigned short", 2, "optional", "-", "-"))
obj.add_property(Property(0xE2, "Tank capacity", "unsigned short", 2, "optional", "-", "-"))
__std_scsl_objects[(0x02, 0x7C)] = obj

# Storage battery (0x027D)
obj = Object("Storage battery", 0x02, 0x7D)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xC8, "Minimum/maxim um charge electric energy", "unsigned long ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xC9, "Minimum/maxim um discharge electric energy", "unsigned long ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xCA, "Minimum/maxim um charge current", "unsigned short ×2", 4, "optional", "-", "-"))
obj.add_property(Property(0xCB, "Minimum/maxim um discharge current", "unsigned short ×2", 4, "optional", "-", "-"))
obj.add_property(Property(0xCF, "Working operation status", "", 0, "", "", ""))
obj.add_property(Property(0xD0, "Rated electric energy", "unsigned long", 4, "optional", "-", "-"))
obj.add_property(Property(0xD1, "Rated capacity", "unsigned short", 2, "optional", "-", "-"))
obj.add_property(Property(0xD2, "Rated voltage", "unsigned short", 2, "optional", "-", "-"))
obj.add_property(Property(0xD3, "Measured instantaneous charge/discharge electric energy", "signed long", 4, "optional", "-", "-"))
obj.add_property(Property(0xD4, "Measured instantaneous charge/discharge current", "signed short", 2, "optional", "-", "-"))
obj.add_property(Property(0xD5, "Measured instantaneous charge/discharge voltage", "signed short", 2, "optional", "-", "-"))
obj.add_property(Property(0xD6, "Measured cumulative discharge electric energy", "unsigned long", 4, "optional", "-", "-"))
obj.add_property(Property(0xD7, "“Measured cumulative discharge electric energy” reset setting", "unsigned char", 1, "-", "optional", "-"))
obj.add_property(Property(0xD8, "Measured cumulative charge electric energy", "unsigned long", 4, "optional", "-", "-"))
obj.add_property(Property(0xD9, "“Measured cumulative charge electric energy” reset setting", "unsigned char", 1, "-", "optional", "-"))
obj.add_property(Property(0xDA, "Operation mode setting", "unsigned char", 1, "mandatory", "mandatory", "mandatory"))
obj.add_property(Property(0xDB, "System-interconn ected type", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xDC, "Minimum/maximum charging power (Independent)", "unsigned long ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xDD, "Minimum/maximum discharging power (Independent)", "unsigned long ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xDE, "Minimum/maxim um charging current (Independent)", "unsigned short ×2", 4, "optional", "-", "-"))
obj.add_property(Property(0xDF, "Minimum/maxim um discharging current (Independent)", "unsigned short ×2", 4, "optional", "-", "-"))
obj.add_property(Property(0xE0, "Charging/dischar ging amount setting 1", "signed long", 4, "optional", "optional", "-"))
obj.add_property(Property(0xE1, "Charging/dischar ging amount setting 2", "signed short", 2, "optional", "optional", "-"))
obj.add_property(Property(0xE2, "Remaining stored electricity 1", "unsigned long", 4, "mandatory", "-", "-"))
obj.add_property(Property(0xE3, "Remaining stored electricity 2", "unsigned short", 2, "mandatory", "-", "-"))
obj.add_property(Property(0xE4, "Remaining stored electricity 3", "unsigned char", 1, "mandatory", "-", "-"))
obj.add_property(Property(0xE5, "Battery state of health", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xE6, "Battery type", "unsigned char", 1, "mandatory", "-", "-"))
obj.add_property(Property(0xE7, "Charging amount setting 1", "unsigned long", 4, "optional", "optional", "-"))
obj.add_property(Property(0xE8, "Discharging amount setting 1", "unsigned long", 4, "optional", "optional", "-"))
obj.add_property(Property(0xE9, "Charging amount setting 2", "unsigned short", 2, "optional", "optional", "-"))
obj.add_property(Property(0xEA, "Discharging amount setting 2", "unsigned short", 2, "optional", "optional", "-"))
obj.add_property(Property(0xEB, "Charge electric energy setting", "unsigned long", 4, "optional", "optional", "-"))
obj.add_property(Property(0xEC, "Discharge electric energy setting", "unsigned long", 4, "optional", "optional", "-"))
obj.add_property(Property(0xED, "Charge current setting", "unsigned short", 2, "optional", "optional", "-"))
obj.add_property(Property(0xEE, "Discharge current setting", "unsigned short", 2, "optional", "optional", "-"))
obj.add_property(Property(0xEF, "Rated voltage (Independent)", "unsigned short", 2, "optional", "-", "-"))
__std_scsl_objects[(0x02, 0x7D)] = obj

# Electric vehicle (0x027E)
obj = Object("Electric vehicle", 0x02, 0x7E)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xC0, "V2H stored electricity 1", "unsigned long", 4, "mandatory", "-", "-"))
obj.add_property(Property(0xC1, "V2H stored electricity 2", "unsigned short", 2, "mandatory", "-", "-"))
obj.add_property(Property(0xC2, "V2H remaining available capacity 1", "unsigned long", 4, "mandatory", "-", "-"))
obj.add_property(Property(0xC3, "V2H remaining available capacity 2", "unsigned short", 2, "mandatory", "-", "-"))
obj.add_property(Property(0xC4, "V2H remaining available capacity 3", "unsigned char", 1, "mandatory", "-", "-"))
obj.add_property(Property(0xC5, "Rated charge capacity", "unsigned long", 4, "mandatory", "-", "-"))
obj.add_property(Property(0xC6, "Rated discharge capacity", "unsigned long", 4, "mandatory", "-", "-"))
obj.add_property(Property(0xC7, "Chargeable/discharge able status", "unsigned char", 1, "mandatory", "-", "mandatory"))
obj.add_property(Property(0xC8, "Minimum/maximum charge electric energy", "unsigned long ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xC9, "Minimum/maximum discharge electric energy", "unsigned long ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xCA, "Minimum/maximum charge current", "unsigned short ×2", 4, "optional", "-", "-"))
obj.add_property(Property(0xCB, "Minimum/maximum discharge current", "unsigned short ×2", 4, "optional", "-", "-"))
obj.add_property(Property(0xD0, "Used capacity 1", "unsigned long", 4, "mandatory", "-", "-"))
obj.add_property(Property(0xD1, "Used capacity 2", "unsigned short", 2, "mandatory", "-", "-"))
obj.add_property(Property(0xD2, "Rated voltage", "unsigned short", 2, "optional", "-", "-"))
obj.add_property(Property(0xD3, "Measured instantaneous charge/discharge electric energy", "signed long", 4, "optional", "-", "-"))
obj.add_property(Property(0xD4, "Measured instantaneous charge/discharge current", "signed short", 2, "optional", "-", "-"))
obj.add_property(Property(0xD5, "Measured instantaneous charge/discharge voltage", "signed short", 2, "optional", "-", "-"))
obj.add_property(Property(0xD6, "Measured cumulative discharge electric energy", "unsigned long", 4, "optional", "-", "-"))
obj.add_property(Property(0xD7, "Cumulative discharge electric energy reset setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xD8, "Measured cumulative charge electric energy", "unsigned long", 4, "optional", "-", "-"))
obj.add_property(Property(0xD9, "Cumulative charge electric energy reset setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xDA, "Operation mode setting", "unsigned char", 1, "mandatory", "mandatory", "mandatory"))
obj.add_property(Property(0xDB, "System-interconnecte d type", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xE2, "Remaining battery capacity1", "unsigned long", 4, "mandatory", "-", "-"))
obj.add_property(Property(0xE3, "Remaining battery capacity2", "unsigned short", 2, "mandatory", "-", "-"))
obj.add_property(Property(0xE4, "Remaining battery capacity3", "unsigned char", 1, "mandatory", "-", "-"))
obj.add_property(Property(0xE5, "Deterioration status", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xE7, "Charging amount setting 1", "unsigned long", 4, "optional", "optional", "-"))
obj.add_property(Property(0xE8, "Discharging amount setting 1", "unsigned long", 4, "optional", "optional", "-"))
obj.add_property(Property(0xE9, "Charging amount setting 2", "unsigned short", 2, "optional", "optional", "-"))
obj.add_property(Property(0xEA, "Discharging amount setting 2", "unsigned short", 2, "optional", "optional", "-"))
obj.add_property(Property(0xEB, "Charge electric energy setting", "unsigned long", 4, "optional", "optional", "-"))
obj.add_property(Property(0xEC, "Discharge electric energy setting", "unsigned long", 4, "optional", "optional", "-"))
obj.add_property(Property(0xED, "Charge current setting", "unsigned short", 2, "optional", "optional", "-"))
obj.add_property(Property(0xEE, "Discharge current setting", "unsigned short", 2, "optional", "optional", "-"))
__std_scsl_objects[(0x02, 0x7E)] = obj

# Engine cogeneration (0x027F)
obj = Object("Engine cogeneration", 0x02, 0x7F)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xC1, "Measured temperature of water in water heater", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xC2, "Rated power generation output", "unsigned short", 2, "optional", "-", "-"))
obj.add_property(Property(0xC3, "Heating value of hot water storage tank", "unsigned short", 2, "optional", "-", "-"))
obj.add_property(Property(0xC4, "Measured instantaneous power generation output", "unsigned short", 2, "mandatory", "-", "-"))
obj.add_property(Property(0xC5, "Measured cumulative power generation output", "unsigned long", 4, "mandatory", "-", "-"))
obj.add_property(Property(0xC6, "Cumulative power generation output reset setting", "unsigned char", 1, "-", "optional", "-"))
obj.add_property(Property(0xC7, "Measured instantaneous gas consumption", "unsigned short", 2, "optional", "-", "-"))
obj.add_property(Property(0xC8, "Measured cumulative gas consumption", "unsigned long", 4, "optional", "-", "-"))
obj.add_property(Property(0xC9, "Cumulative gas consumption reset setting", "unsigned char", 1, "-", "optional", "-"))
obj.add_property(Property(0xCA, "Power generation setting ", "unsigned char", 1, "-", "optional", "-"))
obj.add_property(Property(0xCB, "Power generation status", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xCC, "Measured in-house instantaneous power consumption", "unsigned short", 2, "optional", "-", "-"))
obj.add_property(Property(0xCD, "Measured in-house cumulative power consumption", "unsigned long", 4, "optional", "-", "-"))
obj.add_property(Property(0xCE, "In-house cumulative power consumption reset", "unsigned char", 1, "-", "optional", "-"))
obj.add_property(Property(0xD0, "System interconnected type", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xE1, "Measured remaining hot water amount", "unsigned short", 2, "optional", "-", "-"))
obj.add_property(Property(0xE2, "Tank capacity", "unsigned short", 2, "optional", "-", "-"))
__std_scsl_objects[(0x02, 0x7F)] = obj

# Electric energy meter (0x0280)
obj = Object("Electric energy meter", 0x02, 0x80)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xE0, "Integral electric energy measurement value", "unsigned long", 4, "mandatory", "-", "-"))
obj.add_property(Property(0xE2, "Integral electric energy unit", "unsigned char", 1, "mandatory", "-", "-"))
obj.add_property(Property(0xE3, "Integral electric energy measurement log 1", "unsigned long × 48", 192, "optional", "-", "-"))
obj.add_property(Property(0xE4, "Integral electric energy measurement log 2", "unsigned long ×48 ×45", 8640, "optional", "-", "-"))
__std_scsl_objects[(0x02, 0x80)] = obj

# Water flow meter (0x0281)
obj = Object("Water flow meter", 0x02, 0x81)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xD0, "Flowing water classification", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xD1, "Owner classification", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE0, "Measured cumulative amount of flowing water", "unsigned long", 4, "mandatory", "-", "-"))
obj.add_property(Property(0xE1, "Unit for measured cumulative amounts of flowing water", "unsigned char", 1, "mandatory", "-", "-"))
obj.add_property(Property(0xE2, "Historical data of measured cumulative amounts of flowing water", "unsigned long ×48", 192, "optional", "-", "-"))
obj.add_property(Property(0xE3, "Detection of abnormal value in metering data", "unsigned char", 1, "optional", "-", "mandatory"))
obj.add_property(Property(0xE4, "Security data information", "unsigned long", 4, "optional", "-", "-"))
obj.add_property(Property(0xE5, "ID number setting", "unsigned char", 6, "optional", "optional", "-"))
obj.add_property(Property(0xE6, "Verification expiration information", "unsigned char", 6, "optional", "optional", "-"))
__std_scsl_objects[(0x02, 0x81)] = obj

# Gas meter (0x0282)
obj = Object("Gas meter", 0x02, 0x82)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xE0, "Integral gas consumption measurement value", "unsigned long", 4, "mandatory", "-", "-"))
obj.add_property(Property(0xE2, "Integral gas consumption measurement log", "unsigned long × 48", 192, "optional", "-", "-"))
__std_scsl_objects[(0x02, 0x82)] = obj

# LP gas meter (0x0283)
obj = Object("LP gas meter", 0x02, 0x83)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xE0, "Integral gas consumption of metering data 1", "unsigned long", 4, "mandatory", "-", "-"))
obj.add_property(Property(0xE1, "Integral gas consumption of metering data 2", "unsigned long", 4, "mandatory", "-", "-"))
obj.add_property(Property(0xE2, "Error detection statusof metering data", "unsigned char", 1, "optional", "-", "mandatory"))
obj.add_property(Property(0xE3, "Security data 1", "unsigned long", 4, "optional", "-", "-"))
obj.add_property(Property(0xE4, "Security data 2", "unsigned long", 4, "optional", "-", "-"))
obj.add_property(Property(0xE5, "Center valve shut-off status", "unsigned char", 1, "optional", "-", "mandatory"))
obj.add_property(Property(0xE6, "Center valve shut-off recovery permission setting status", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xE7, "Emergency valve shut-off status", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xE8, "Shut-off valve open/close status", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xE9, "Residual volume control warning", "unsigned char", 1, "optional", "-", "mandatory"))
obj.add_property(Property(0xEA, "Set value of residual volume control warning level 1", "unsigned char × 3", 3, "optional", "optional", "-"))
obj.add_property(Property(0xEB, "Set value of residual volume control warning level 2", "unsigned char × 3", 3, "optional", "optional", "-"))
obj.add_property(Property(0xEC, "Set value of residual volume control warning level 3", "unsigned char ×3", 3, "optional", "optional", "-"))
obj.add_property(Property(0xED, "Slight leak timer value (gas flow rate continuation)", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xEE, "Slight leak timer value (without pressure increase)", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xEF, "Shut-off reason log", "unsigned char × 3", 3, "optional", "-", "-"))
obj.add_property(Property(0xD0, "Maximum value of supply pressure data", "unsigned short", 2, "optional", "-", "-"))
obj.add_property(Property(0xD1, "Minimum value of supply pressure data", "unsigned short", 2, "optional", "-", "-"))
obj.add_property(Property(0xD2, "Current value of supply pressure data", "unsigned short", 2, "optional", "-", "-"))
obj.add_property(Property(0xD3, "Maximum value of block pressure data", "unsigned short", 2, "optional", "-", "-"))
obj.add_property(Property(0xD4, "Minimum value of block pressure data", "unsigned short", 2, "optional", "-", "-"))
obj.add_property(Property(0xD5, "Current value of block pressure data", "unsigned short", 2, "optional", "-", "-"))
obj.add_property(Property(0xD6, "Number of block pressure/supply pressure error days:time", "unsigned char × 4", 4, "optional", "-", "-"))
obj.add_property(Property(0xD7, "Test call setting", "unsigned char", 1, "optional", "optional", "-"))
__std_scsl_objects[(0x02, 0x83)] = obj

# Distribution panel metering (0x0287)
obj = Object("Distribution panel metering", 0x02, 0x87)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Master rated capacity", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xB1, "Number of measurement channels (simplex)", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xB2, "Channel range specification for cumulative amount of electric power consumption measurement (simplex)", "unsigned char × 2", 2, "optional", "optional", "-"))
obj.add_property(Property(0xB3, "Measured cumulative amount of electric power consumption list (simplex)", "unsigned char + unsigned char + (unsigned long (Max) × 60)", 0, "optional", "-", "-"))
obj.add_property(Property(0xB4, "Channel range specification for instantaneous current measurement (simplex)", "unsigned char × 2", 2, "optional", "optional", "-"))
obj.add_property(Property(0xB5, "Measured instantaneous current list (simplex)", "unsigned char + unsigned char + (signed short × 2 (Max) × 60)", 0, "optional", "-", "-"))
obj.add_property(Property(0xB6, "Channel range specification for instantaneous power consumption measurement (simplex)", "unsigned char × 2", 2, "optional", "optional", "-"))
obj.add_property(Property(0xB7, "Measured instantaneous power consumption list (simplex)", "unsigned char + unsigned char + (signed long (Max) × 60)", 0, "optional", "-", "-"))
obj.add_property(Property(0xB8, "Number of measurement channels (duplex)", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xB9, "Channel range specification for cumulative amount of electric power consumption measurement (duplex)", "unsigned char × 2", 2, "optional", "optional", "-"))
obj.add_property(Property(0xBA, "Measured cumulative amount of electric power consumption list (duplex)", "unsigned char + unsigned char + (unsigned long + unsigned long (Max) × 30)", 0, "optional", "-", "-"))
obj.add_property(Property(0xBB, "Channel range specification for instantaneous current measurement (duplex)", "unsigned char × 2", 2, "optional", "optional", "-"))
obj.add_property(Property(0xBC, "Measured instantaneous current list (duplex)", "unsigned char + unsigned char + (signed short × 2 (Max) × 60)", 0, "optional", "-", "-"))
obj.add_property(Property(0xBD, "Channel range specification for instantaneous power consumption measurement (duplex)", "unsigned char × 2", 2, "optional", "optional", "-"))
obj.add_property(Property(0xBE, "Measured instantaneous power consumption list (duplex)", "unsigned char + unsigned char + (signed long (Max) × 60)", 0, "optional", "-", "-"))
obj.add_property(Property(0xC0, "Measured cumulative amount of electric energy (normal direction)", "unsigned long", 4, "mandatory", "-", "-"))
obj.add_property(Property(0xC1, "Measured cumulative amount of electric energy (reverse direction)", "unsigned long", 4, "mandatory", "-", "-"))
obj.add_property(Property(0xC2, "Unit for cumulative amounts of electric energy", "unsigned char", 1, "mandatory", "-", "-"))
obj.add_property(Property(0xC3, "Historical data of measured cumulative amounts of electric energy (normal direction)", "unsigned short +unsign ed long ×48", 194, "optional", "-", "-"))
obj.add_property(Property(0xC4, "Historical data of measured cumulative amounts of electric energy (reverse direction)", "unsigned short +unsign ed long ×48", 194, "optional", "-", "-"))
obj.add_property(Property(0xC5, "Day for which the historical data of measured cumulative amounts of electric energy is to be retrieved", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xC6, "Measured instantaneo us amount of electric energy", "signed long", 4, "optional", "-", "-"))
obj.add_property(Property(0xC7, "Measured instantaneous currents", "signed short ×2", 4, "optional", "-", "-"))
obj.add_property(Property(0xC8, "Measured instantaneous voltages", "unsigned short ×2", 4, "optional", "-", "-"))
obj.add_property(Property(0xD0, "Measurement channel 1", "unsigned long + signed short ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xD1, "Measurement channel 2", "unsigned long + signed short ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xD2, "Measurement channel 3", "unsigned long + signed short ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xD3, "Measurement channel 4", "unsigned long + signed short ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xD4, "Measurement channel 5", "unsigned long + signed short ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xD5, "Measurement channel 6", "unsigned long + signed short ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xD6, "Measurement channel 7", "unsigned long + signed short ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xD7, "Measurement channel 8", "unsigned long + signed short ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xD8, "Measurement channel 9", "unsigned long + signed short ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xD9, "Measurement channel 10", "unsigned long + signed short ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xDA, "Measurement channel 11", "unsigned long + signed short ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xDB, "Measurement channel 12", "unsigned long + signed short ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xDC, "Measurement channel 13", "unsigned long + signed short ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xDD, "Measurement channel 14", "unsigned long + signed short ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xDE, "Measurement channel 15", "unsigned long + signed short ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xDF, "Measurement channel 16", "unsigned long + signed short ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xE0, "Measurement channel 17", "unsigned long + signed short ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xE1, "Measurement channel 18", "unsigned long + signed short ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xE2, "Measurement channel 19", "unsigned long + signed short ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xE3, "Measurement channel 20", "unsigned long + signed short ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xE4, "Measurement channel 21", "unsigned long + signed short ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xE5, "Measurement channel 22", "unsigned long + signed short ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xE6, "Measurement channel 23", "unsigned long + signed short ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xE7, "Measurement channel 24", "unsigned long + signed short ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xE8, "Measurement channel 25", "unsigned long + signed short ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xE9, "Measurement channel 26", "unsigned long + signed short ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xEA, "Measurement channel 27", "unsigned long + signed short ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xEB, "Measurement channel 28", "unsigned long + signed short ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xEC, "Measurement channel 29", "unsigned long + signed short ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xED, "Measurement channel 30", "unsigned long + signed short ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xEE, "Measurement channel 31", "unsigned long + signed short ×2", 8, "optional", "-", "-"))
obj.add_property(Property(0xEF, "Measurement channel 32", "unsigned long + signed short ×2", 8, "optional", "-", "-"))
__std_scsl_objects[(0x02, 0x87)] = obj

# Smart electric energy meter (0x0288)
obj = Object("Smart electric energy meter", 0x02, 0x88)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xD0, "Electric energy meter classification", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xD1, "Owner classification", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xD2, "Phases and wires setting status", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xD3, "Composite transformation ratio", "unsigned long", 4, "optional", "-", "-"))
obj.add_property(Property(0xD4, "Multiplying factor for composite transformation ratio", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xD5, "Meter type certification number", "unsigned char × 10", 10, "optional", "-", "-"))
obj.add_property(Property(0xD6, "Year and month of inspection expiry", "unsigned char × 6", 6, "optional", "optional", "-"))
obj.add_property(Property(0xD7, "Number of effective digits for cumulative amounts of electric energy", "unsigned char", 1, "mandatory", "-", "-"))
obj.add_property(Property(0xE0, "Measured cumulative amount of electric energy (normal direction)", "unsigned long", 4, "mandatory", "-", "-"))
obj.add_property(Property(0xE1, "Unit for cumulative amounts of electric energy (normal and reverse directions)", "unsigned char", 1, "mandatory", "-", "-"))
obj.add_property(Property(0xE2, "Historical data of measured cumulative amounts of electric energy (normal direction)", "unsigned short + unsigned long ×48", 194, "optional", "-", "-"))
obj.add_property(Property(0xE3, "Measured cumulative amounts of electric energy (reverse direction)", "unsigned long", 4, "optional", "-", "-"))
obj.add_property(Property(0xE4, "Historical data of measured cumulative amounts of electric energy (reverse direction)", "unsigned short +unsigned long ×48", 194, "optional", "-", "-"))
obj.add_property(Property(0xE5, "Day for which the historical data of measured cumulative amounts of electric energy is to be retrieved", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE7, "Measured instantaneous electric energy", "signed long", 4, "optional", "-", "-"))
obj.add_property(Property(0xE8, "Measured instantaneous currents", "signed short ×2", 4, "optional", "-", "-"))
obj.add_property(Property(0xE9, "Measured instantaneous voltages", "unsigned short ×2", 4, "optional", "-", "-"))
obj.add_property(Property(0xEA, "Cumulative amounts of electric energy measured at fixed time (normal direction)", "unsigned char ×4 + unsigned char×3 + unsigned long ", 11, "mandatory", "-", "-"))
obj.add_property(Property(0xEB, "Cumulative amounts of electric energy measured at fixed time (reverse direction)", "unsigned char ×4 + unsigned char ×3 + unsigned long", 11, "optional", "-", "-"))
__std_scsl_objects[(0x02, 0x88)] = obj

# Smart gas meter (0x0289)
obj = Object("Smart gas meter", 0x02, 0x89)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xE0, "Gas meter classification setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE1, "Owner classification setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE2, "Measured cumulative gas consumption", "unsigned long", 4, "mandatory", "-", "-"))
obj.add_property(Property(0xE3, "Unit for measured cumulative gas consumption", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xE4, "Historical data of measured cumulative gas consumption", "unsigned short +unsigne d long ×48", 194, "optional", "-", "-"))
obj.add_property(Property(0xE5, "Day setting for which the historical data of measured cumulative gas consumption is to be retrieved", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE6, "Detection of abnormal value in metering data", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xE7, "Security data information", "unsigned char ×10", 10, "optional", "-", "-"))
obj.add_property(Property(0xE8, "Valve closure by the Center", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xE9, "Permission from the Center to reopen the valve closed by the Center", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xEA, "Emergency closure of shutoff valve", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xEB, "Shutoff valve status", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xEC, "Historical data of shutoff reasons", "unsigned char ×3", 3, "optional", "-", "-"))
obj.add_property(Property(0xED, "ID number setting", "unsigned char", 6, "optional", "optional", "-"))
obj.add_property(Property(0xEE, "Verification expiration setting", "unsigned char", 6, "optional", "optional", "-"))
obj.add_property(Property(0xD0, "Measured cumulative gas consumption information with date and time", "unsigne d char×4+ unsigne d char×3+ unsigne d long", 11, "mandatory", "-", "-"))
obj.add_property(Property(0xD1, "Historical information of cumulative gas consumption", "unsigne d char×4+ unsigne d char×3+ unsigne d long×24 +unsign ed long+un signed short", 109, "-", "-", "-"))
__std_scsl_objects[(0x02, 0x89)] = obj

# General lighting class (0x0290)
obj = Object("General lighting class", 0x02, 0x90)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "mandatory", "mandatory"))
obj.add_property(Property(0xB0, "Illuminance level", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB1, "Light color setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB2, "Illuminance level step setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB3, "Light color step setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB4, "Maximum specifiable values", "unsigned char ×2", 2, "optional", "-", "-"))
obj.add_property(Property(0xB5, "Maximum value of settable level for night lighting", "unsigned char ×2", 2, "optional", "-", "-"))
obj.add_property(Property(0xB6, "Lighting mode setting", "unsigned char", 1, "mandatory", "mandatory", "-"))
obj.add_property(Property(0xB7, "Illuminance level setting for main lighting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB8, "Illuminance level step setting for main lighting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB9, "Illuminance level setting for night lighting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xBA, "Illuminance level step setting for night lighting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xBB, "Light color setting for main lighting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xBC, "Light color level step setting for main lighting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xBD, "Light color setting for night lighting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xBE, "Light color level step setting for night lighting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xBF, "Lighting mode status in auto mode", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xC0, "RGB setting for color lighting", "unsigned char×3", 3, "optional", "optional", "-"))
obj.add_property(Property(0x90, "ON timer reservation setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0x91, "ON timer setting", "unsigned char ×2", 2, "optional", "optional", "-"))
obj.add_property(Property(0x94, "OFF timer reservation setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0x95, "OFF timer setting", "unsigned char ×2", 2, "optional", "optional", "-"))
__std_scsl_objects[(0x02, 0x90)] = obj

# Buzzer (0x02A0)
obj = Object("Buzzer", 0x02, 0xA0)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB1, "Sound generation setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE0, "Buzzer sound type", "unsigned char", 1, "optional", "optional", "-"))
__std_scsl_objects[(0x02, 0xA0)] = obj

# Electric hot water pot(electric thermos) (0x03B2)
obj = Object("Electric hot water pot(electric thermos)", 0x03, 0xB2)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Cover open/close status", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xB1, "No-water warning", "unsigned char", 1, "optional", "-", "mandatory"))
obj.add_property(Property(0xB2, "Boil-up setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE0, "Boil-up/warmer mode setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE1, "Set value of warmer temperature", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE2, "Hot water discharge status", "unsigned char", 1, "optional", "-", "mandatory"))
obj.add_property(Property(0xE3, "Lock status", "unsigned char", 1, "optional", "-", "-"))
__std_scsl_objects[(0x03, 0xB2)] = obj

# Refrigerator (0x03B7)
obj = Object("Refrigerator", 0x03, 0xB7)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Door open/close status", "unsigned char", 1, "mandatory", "-", "-"))
obj.add_property(Property(0xB1, "Door open warning", "unsigned char", 1, "optional", "-", "mandatory"))
obj.add_property(Property(0xB2, "Refrigerator compartment door status", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xB3, "Freezer compartment door status", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xB4, "Ice compartment door status", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xB5, "Vegetable compartment door status", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xB6, "Multi-refrigera- ting mode compartment door", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xE0, "Maximum allowable temperature setting level", "unsigned char × 8", 8, "optional", "-", "-"))
obj.add_property(Property(0xE2, "Refrigerator compartment temperature setting", "signed char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE3, "Freezer compartment temperature setting", "signed char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE4, "Ice temperature setting", "signed char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE5, "Vegetable compartment temperature setting", "signed char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE6, "Multi-refrigera- ting mode compartment temperature setting", "signed char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE9, "Refrigerator compartment temperature level setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xEA, "Freezer compartment temperature level setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xEB, "ice compartment temperature level setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xEC, "Vegetable compartment temperature level setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xED, "Multi-refrigera- ting mode compartment temperature level setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xD1, "Measured refrigerator compartment temperature", "signed char", 1, "optional", "-", "-"))
obj.add_property(Property(0xD2, "Measured freezer compartment temperature", "signed char", 1, "optional", "-", "-"))
obj.add_property(Property(0xD3, "Measured subzero-fresh compartment temperature", "signed char", 1, "optional", "-", "-"))
obj.add_property(Property(0xD4, "Measured vegetable compartment temperature", "signed char", 1, "optional", "-", "-"))
obj.add_property(Property(0xD5, "Measured multi-refrigeratin g mode compartment temperature", "signed char", 1, "optional", "-", "-"))
obj.add_property(Property(0xD8, "Compressor rotation speed", "unsigned char", 2, "optional", "-", "-"))
obj.add_property(Property(0xDA, "Measured electric current consumption", "unsigned char", 2, "optional", "-", "-"))
obj.add_property(Property(0xDC, "Rated power consumption", "unsigned char", 2, "optional", "-", "-"))
obj.add_property(Property(0xA0, "Quick freeze function setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xA1, "Quick refrigeration function setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xA4, "Icemaker setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xA5, "Icemaker operation status", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xA6, "Icemaker tank status", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xA8, "Refrigerator compartment humidification function setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xA9, "Vegetable compartment humidification function setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xAD, "Deodorization function setting", "unsigned char", 1, "optional", "optional", "-"))
__std_scsl_objects[(0x03, 0xB7)] = obj

# Combination microwave oven(Electronic oven) (0x03B8)
obj = Object("Combination microwave oven(Electronic oven)", 0x03, 0xB8)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Door open/close status", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xB1, "Heating status", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xB2, "Heating setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE0, "Heating mode setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE1, "Automatic heating setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE2, "Automatic heating level setting", "unsigned cha", 1, "optional", "optional", "-"))
obj.add_property(Property(0xD0, "Automatic heating menu setting", "unsigned cha", 1, "optional", "optional", "-"))
obj.add_property(Property(0xD1, "Oven mode setting", "unsigned cha", 1, "optional", "optional", "-"))
obj.add_property(Property(0xD5, "Oven preheating setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xD6, "Fermenting mode setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE3, "Chamber temperature setting", "signed short", 2, "optional", "optional", "-"))
obj.add_property(Property(0xE4, "Food temperature setting", "signed short", 2, "optional", "optional", "-"))
obj.add_property(Property(0xE5, "Heating time setting", "unsigned char ×3", 3, "optional", "optional", "-"))
obj.add_property(Property(0xE6, "Remaining heating time setting", "unsigned char ×3", 3, "optional", "optional", "-"))
obj.add_property(Property(0xE7, "Microwave heating power setting", "unsigned short", 2, "optional", "optional", "-"))
obj.add_property(Property(0xE8, "Prompt message setting", "unsigned char ×2 ×4", 8, "optional", "optional", "-"))
obj.add_property(Property(0xE9, "“Accessories to combination microwave oven” setting", "unsigned short", 2, "optional", "optional", "-"))
obj.add_property(Property(0xEA, "Display character string setting", "unsigned short ×20", 40, "-", "optional", "-"))
obj.add_property(Property(0xEB, "Two-stage microwave heating setting (duration)", "unsigned char ×3 ×2", 6, "optional", "optional", "-"))
obj.add_property(Property(0xEC, "Two-stage microwave heating setting (heating power)", "unsigned short ×2", 4, "optional", "optional", "-"))
__std_scsl_objects[(0x03, 0xB8)] = obj

# Cooking heater (0x03B9)
obj = Object("Cooking heater", 0x03, 0xB9)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB1, "Heating status", "unsigned char × 4", 4, "mandatory", "-", "-"))
obj.add_property(Property(0xB2, "Heating setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB3, "“All stop” setting", "unsigned char", 1, "-", "mandatory", "-"))
obj.add_property(Property(0xE7, "Heating power setting", "unsigned char × 4", 8, "optional", "optional", "-"))
obj.add_property(Property(0xE3, "Heating temperature setting", "unsigned char × 3", 3, "optional", "optional", "-"))
obj.add_property(Property(0xE0, "“Heating modes of stoves” setting", "unsigned char × 3", 3, "optional", "optional", "-"))
obj.add_property(Property(0x96, "Relative time settings of OFF timers", "unsigned char × 3 × 4", 12, "optional", "optional", "-"))
obj.add_property(Property(0xA1, "Child lock setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xA2, "Radiant heater lock setting", "unsigned char", 1, "optional", "optional", "-"))
__std_scsl_objects[(0x03, 0xB9)] = obj

# Rice cooker (0x03BB)
obj = Object("Rice cooker", 0x03, 0xBB)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Cover open/close status", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xB1, "Rice cooking status", "unsigned char", 1, "mandatory", "-", "-"))
obj.add_property(Property(0xB2, "Rice cooking control setting", "unsigned char", 1, "mandatory", "mandatory", "-"))
obj.add_property(Property(0xE1, "Warmer setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE5, "Inner pot removal status", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xE6, "Cover removal status", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0x90, "Rice cooking reservation setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0x91, "Set value of rice cooking reservation setting time", "unsigned char × 2", 2, "optional", "optional", "-"))
obj.add_property(Property(0x92, "Set value of rice cooking reservation setting relative time", "unsigned char × 2", 2, "optional", "optional", "-"))
__std_scsl_objects[(0x03, 0xBB)] = obj

# Washing machine (0x03C5)
obj = Object("Washing machine", 0x03, 0xC5)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Door/cover open/close status", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xB2, "Washing machine setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE1, "Current stage of washing cycle", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xE6, "Time remaining to complete washing cycle", "unsigned char × 3", 3, "optional", "-", "-"))
obj.add_property(Property(0x90, "ON timer reservation setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0x91, "ON timer setting", "unsigned char × 2", 2, "optional", "optional", "-"))
obj.add_property(Property(0x92, "Relative time-based ON timer setting", "unsigned char × 2", 2, "optional", "optional", "-"))
__std_scsl_objects[(0x03, 0xC5)] = obj

# Clothes dryer (0x03C6)
obj = Object("Clothes dryer", 0x03, 0xC6)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Door/cover open/close status", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xB2, "Drying setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE1, "Drying status", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xE6, "Remaining drying time", "unsigned char ×3", 3, "optional", "-", "-"))
obj.add_property(Property(0x90, "ON timer reservation setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0x91, "ON timer setting", "unsigned char ×2", 2, "optional", "optional", "-"))
obj.add_property(Property(0x92, "Relative time-based ON timer setting", "unsigned char ×2", 2, "optional", "optional", "-"))
__std_scsl_objects[(0x03, 0xC6)] = obj

# Washer and dryer (0x03D3)
obj = Object("Washer and dryer", 0x03, 0xD3)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xB0, "Door/cover open/close status", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xB2, "Washer and dryer setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xD0, "Washer and dryer cycle setting 1 (Note 1)", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xD1, "Washer and dryer cycle setting 2 (Note 1)", "unsig ned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xD2, "Drying cycle setting (Note1)", "unsig ned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xD3, "Washer and dryer cycle option list 1", "unsig ned char ×12 ", 12, "optional", "-", "-"))
obj.add_property(Property(0xD4, "Washer and dryer cycle option list 2", "unsig ned char ×4 ", 4, "optional", "-", "-"))
obj.add_property(Property(0xD5, "Washer and dryer cycle option list 3", "unsig ned char ×4 ", 4, "optional", "-", "-"))
obj.add_property(Property(0xD6, "Water flow rate setting", "unsig ned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xD7, "“Rotation speed for spin drying” setting", "unsig ned short", 2, "optional", "optional", "-"))
obj.add_property(Property(0xD8, "“Degree of drying” setting", "unsig ned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xDB, "Remaining washing time", "unsign ed char ×2", 2, "optional", "-", "-"))
obj.add_property(Property(0xDC, "Remaining drying time", "unsign ed char ×2", 2, "optional", "-", "-"))
obj.add_property(Property(0xDF, "Elapsed time on the ON timer", "unsign ed char ×2", 2, "optional", "-", "-"))
obj.add_property(Property(0xE1, "Presoaking time setting", "unsign ed char ×2", 2, "optional", "optional", "-"))
obj.add_property(Property(0xE2, "Current stage of washer and dryer cycle", "unsigned char", 1, "optional", "-", "-"))
obj.add_property(Property(0xE3, "Water volume setting 1", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE4, "Water volume setting 2", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE5, "Washing time setting", "unsigned char ×2", 2, "optional", "optional", "-"))
obj.add_property(Property(0xE6, "“Number of times of rinsing” setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE7, "Rinsing process setting", "unsigned char ×4", 4, "optional", "optional", "-"))
obj.add_property(Property(0xE8, "Spin drying time setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xE9, "Drying time setting", "unsigned char ×2", 2, "optional", "optional", "-"))
obj.add_property(Property(0xEA, "Warm water setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xEB, "Bathtub water recycle setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xEC, "Wrinkling minimization setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xED, "Time remaining to complete washer and dryer cycle", "unsigned char ×2", 2, "optional", "-", "-"))
obj.add_property(Property(0xEE, "Door/cover lock    setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xEF, "Washer and dryer cycle", "unsigned Char ×24", 24, "optional", "-", "-"))
obj.add_property(Property(0x90, "ON timer reservation setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0x91, "ON timer setting", "unsigned char ×2", 2, "optional", "optional", "-"))
obj.add_property(Property(0x92, "Relative time-based ON timer setting", "unsigned char ×2", 2, "optional", "optional", "-"))
__std_scsl_objects[(0x03, 0xD3)] = obj

# Weighing machine (0x0401)
obj = Object("Weighing machine", 0x04, 0x01)
obj.add_property(Property(0x80, "Operation status", "unsigned short", 1, "mandatory", "optional", "mandatory"))
obj.add_property(Property(0xE0, "Measured value of body weight", "unsigned short", 2, "mandatory", "-", "-"))
obj.add_property(Property(0xE1, "Measured value of body fat", "unsigned short", 2, "optional", "-", "-"))
__std_scsl_objects[(0x04, 0x01)] = obj

# Switch (supporting JEM-A / HA terminals) (0x05FD)
obj = Object("Switch (supporting JEM-A / HA terminals)", 0x05, 0xFD)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "mandatory", "mandatory"))
obj.add_property(Property(0xE0, "Connected device", "unsigned char", 12, "optional", "optional", "-"))
__std_scsl_objects[(0x05, 0xFD)] = obj

# Display (0x0601)
obj = Object("Display", 0x06, 0x01)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "mandatory", "mandatory"))
obj.add_property(Property(0xB0, "Display control setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB1, "Character string setting acceptance status", "unsigned char", 1, "mandatory", "-", "mandatory"))
obj.add_property(Property(0xB2, "Supported character codes", "unsigned char×2", 2, "mandatory", "-", "-"))
obj.add_property(Property(0xB3, "Character string to present to the user", "unsigned char× Max 247", 0, "optional", "mandatory", "-"))
obj.add_property(Property(0xB4, "Length of character string accepted", "unsigned char", 2, "mandatory", "-", "-"))
__std_scsl_objects[(0x06, 0x01)] = obj

# Television (0x0602)
obj = Object("Television", 0x06, 0x02)
obj.add_property(Property(0x80, "Operation status", "unsigned char", 1, "mandatory", "mandatory", "mandatory"))
obj.add_property(Property(0xB0, "Display control setting", "unsigned char", 1, "optional", "optional", "-"))
obj.add_property(Property(0xB1, "Character string setting acceptance status", "unsigned char", 1, "mandatory", "-", "mandatory"))
obj.add_property(Property(0xB2, "Supported character codes", "unsigned char× 2", 2, "mandatory", "-", "-"))
obj.add_property(Property(0xB3, "Character string to present to the user", "unsigned char× Max 247", 0, "optional", "mandatory", "-"))
obj.add_property(Property(0xB4, "Length of character string accepted", "unsigned char× 2", 2, "mandatory", "-", "-"))
__std_scsl_objects[(0x06, 0x02)] = obj
