"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LegendPosition = exports.Color = exports.Shading = exports.CustomWidget = exports.SingleValueWidget = exports.GraphWidget = exports.GraphWidgetView = exports.AlarmWidget = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const rendering_1 = require("./private/rendering");
const widget_1 = require("./widget");
/**
 * Display the metric associated with an alarm, including the alarm line
 */
class AlarmWidget extends widget_1.ConcreteWidget {
    constructor(props) {
        super(props.width || 6, props.height || 6);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cloudwatch_AlarmWidgetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AlarmWidget);
            }
            throw error;
        }
        this.props = props;
    }
    toJson() {
        return [{
                type: 'metric',
                width: this.width,
                height: this.height,
                x: this.x,
                y: this.y,
                properties: {
                    view: 'timeSeries',
                    title: this.props.title,
                    region: this.props.region || cdk.Aws.REGION,
                    annotations: {
                        alarms: [this.props.alarm.alarmArn],
                    },
                    yAxis: {
                        left: this.props.leftYAxis ?? undefined,
                    },
                },
            }];
    }
}
exports.AlarmWidget = AlarmWidget;
_a = JSII_RTTI_SYMBOL_1;
AlarmWidget[_a] = { fqn: "@aws-cdk/aws-cloudwatch.AlarmWidget", version: "1.183.0" };
/**
 * Types of view
 */
var GraphWidgetView;
(function (GraphWidgetView) {
    /**
     * Display as a line graph.
     */
    GraphWidgetView["TIME_SERIES"] = "timeSeries";
    /**
     * Display as a bar graph.
     */
    GraphWidgetView["BAR"] = "bar";
    /**
     * Display as a pie graph.
     */
    GraphWidgetView["PIE"] = "pie";
})(GraphWidgetView = exports.GraphWidgetView || (exports.GraphWidgetView = {}));
/**
 * A dashboard widget that displays metrics
 */
class GraphWidget extends widget_1.ConcreteWidget {
    constructor(props) {
        super(props.width || 6, props.height || 6);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cloudwatch_GraphWidgetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, GraphWidget);
            }
            throw error;
        }
        this.props = props;
        this.leftMetrics = props.left ?? [];
        this.rightMetrics = props.right ?? [];
        this.copyMetricWarnings(...this.leftMetrics, ...this.rightMetrics);
    }
    /**
     * Add another metric to the left Y axis of the GraphWidget
     *
     * @param metric the metric to add
     */
    addLeftMetric(metric) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cloudwatch_IMetric(metric);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addLeftMetric);
            }
            throw error;
        }
        this.leftMetrics.push(metric);
        this.copyMetricWarnings(metric);
    }
    /**
     * Add another metric to the right Y axis of the GraphWidget
     *
     * @param metric the metric to add
     */
    addRightMetric(metric) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cloudwatch_IMetric(metric);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addRightMetric);
            }
            throw error;
        }
        this.rightMetrics.push(metric);
        this.copyMetricWarnings(metric);
    }
    toJson() {
        const horizontalAnnotations = [
            ...(this.props.leftAnnotations || []).map(mapAnnotation('left')),
            ...(this.props.rightAnnotations || []).map(mapAnnotation('right')),
        ];
        const metrics = rendering_1.allMetricsGraphJson(this.leftMetrics, this.rightMetrics);
        return [{
                type: 'metric',
                width: this.width,
                height: this.height,
                x: this.x,
                y: this.y,
                properties: {
                    view: this.props.view ?? GraphWidgetView.TIME_SERIES,
                    title: this.props.title,
                    region: this.props.region || cdk.Aws.REGION,
                    stacked: this.props.stacked,
                    metrics: metrics.length > 0 ? metrics : undefined,
                    annotations: horizontalAnnotations.length > 0 ? { horizontal: horizontalAnnotations } : undefined,
                    yAxis: {
                        left: this.props.leftYAxis ?? undefined,
                        right: this.props.rightYAxis ?? undefined,
                    },
                    legend: this.props.legendPosition !== undefined ? { position: this.props.legendPosition } : undefined,
                    liveData: this.props.liveData,
                    setPeriodToTimeRange: this.props.setPeriodToTimeRange,
                    period: this.props.period?.toSeconds(),
                    stat: this.props.statistic,
                },
            }];
    }
}
exports.GraphWidget = GraphWidget;
_b = JSII_RTTI_SYMBOL_1;
GraphWidget[_b] = { fqn: "@aws-cdk/aws-cloudwatch.GraphWidget", version: "1.183.0" };
/**
 * A dashboard widget that displays the most recent value for every metric
 */
class SingleValueWidget extends widget_1.ConcreteWidget {
    constructor(props) {
        super(props.width || 6, props.height || 3);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cloudwatch_SingleValueWidgetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SingleValueWidget);
            }
            throw error;
        }
        this.props = props;
        this.copyMetricWarnings(...props.metrics);
    }
    toJson() {
        return [{
                type: 'metric',
                width: this.width,
                height: this.height,
                x: this.x,
                y: this.y,
                properties: {
                    view: 'singleValue',
                    title: this.props.title,
                    region: this.props.region || cdk.Aws.REGION,
                    metrics: rendering_1.allMetricsGraphJson(this.props.metrics, []),
                    setPeriodToTimeRange: this.props.setPeriodToTimeRange,
                    singleValueFullPrecision: this.props.fullPrecision,
                },
            }];
    }
}
exports.SingleValueWidget = SingleValueWidget;
_c = JSII_RTTI_SYMBOL_1;
SingleValueWidget[_c] = { fqn: "@aws-cdk/aws-cloudwatch.SingleValueWidget", version: "1.183.0" };
/**
 * A CustomWidget shows the result of a AWS lambda function
 */
class CustomWidget extends widget_1.ConcreteWidget {
    constructor(props) {
        super(props.width ?? 6, props.height ?? 6);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cloudwatch_CustomWidgetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CustomWidget);
            }
            throw error;
        }
        this.props = props;
    }
    toJson() {
        return [{
                type: 'custom',
                width: this.width,
                height: this.height,
                x: this.x,
                y: this.y,
                properties: {
                    endpoint: this.props.functionArn,
                    params: this.props.params,
                    title: this.props.title,
                    updateOn: {
                        refresh: this.props.updateOnRefresh ?? true,
                        resize: this.props.updateOnResize ?? true,
                        timeRange: this.props.updateOnTimeRangeChange ?? true,
                    },
                },
            }];
    }
}
exports.CustomWidget = CustomWidget;
_d = JSII_RTTI_SYMBOL_1;
CustomWidget[_d] = { fqn: "@aws-cdk/aws-cloudwatch.CustomWidget", version: "1.183.0" };
/**
 * Fill shading options that will be used with an annotation
 */
var Shading;
(function (Shading) {
    /**
     * Don't add shading
     */
    Shading["NONE"] = "none";
    /**
     * Add shading above the annotation
     */
    Shading["ABOVE"] = "above";
    /**
     * Add shading below the annotation
     */
    Shading["BELOW"] = "below";
})(Shading = exports.Shading || (exports.Shading = {}));
/**
 * A set of standard colours that can be used in annotations in a GraphWidget.
 */
class Color {
    constructor() { }
}
exports.Color = Color;
_e = JSII_RTTI_SYMBOL_1;
Color[_e] = { fqn: "@aws-cdk/aws-cloudwatch.Color", version: "1.183.0" };
/** blue - hex #1f77b4 */
Color.BLUE = '#1f77b4';
/** brown - hex #8c564b */
Color.BROWN = '#8c564b';
/** green - hex #2ca02c */
Color.GREEN = '#2ca02c';
/** grey - hex #7f7f7f */
Color.GREY = '#7f7f7f';
/** orange - hex #ff7f0e */
Color.ORANGE = '#ff7f0e';
/** pink - hex #e377c2 */
Color.PINK = '#e377c2';
/** purple - hex #9467bd */
Color.PURPLE = '#9467bd';
/** red - hex #d62728 */
Color.RED = '#d62728';
/**
 * The position of the legend on a GraphWidget.
 */
var LegendPosition;
(function (LegendPosition) {
    /**
     * Legend appears below the graph (default).
     */
    LegendPosition["BOTTOM"] = "bottom";
    /**
     * Add shading above the annotation
     */
    LegendPosition["RIGHT"] = "right";
    /**
     * Add shading below the annotation
     */
    LegendPosition["HIDDEN"] = "hidden";
})(LegendPosition = exports.LegendPosition || (exports.LegendPosition = {}));
function mapAnnotation(yAxis) {
    return (a) => {
        return { ...a, yAxis };
    };
}
//# sourceMappingURL=data:application/json;base64,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