#!/usr/bin/env python

"""The setup script."""

from setuptools import setup, find_packages

with open('README.rst') as readme_file:
    readme = readme_file.read()

with open('HISTORY.rst') as history_file:
    history = history_file.read()

requirements = [
    "discord.py",
]

test_requirements = ['pytest>=3', ]

setup(
    author="Amit Yanay",
    author_email='amityanay5@gmail.com',
    python_requires='>=3.6',
    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: GNU General Public License v3 (GPLv3)',
        'Natural Language :: English',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
    ],
    description="Advanced Database in discord",
    install_requires=requirements,
    license="GNU General Public License v3",
    include_package_data=True,
    keywords='discord_advdb',
    name='Discord-AdvDB',
    packages=find_packages(include=['discord_advdb', 'discord_advdb.*']),
    test_suite='tests',
    tests_require=test_requirements,
    url='https://github.com/CrAzyScreamx/Discord-AdvDB',
    version='0.1.0',
    zip_safe=False,
)
