/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.File;
import java.io.FileWriter;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.io.FilenameUtils;
import org.codehaus.plexus.util.FileUtils;
import org.jetbrains.annotations.NotNull;
import utils.ArtifactFileUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006J\u0006\u0010\f\u001a\u00020\u0006J\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006J\u0006\u0010\u0012\u001a\u00020\u0006J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0016J\u0006\u0010\u0018\u001a\u00020\u0016J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\u0006J\u0012\u0010\u001b\u001a\n \u001c*\u0004\u0018\u00010\u00060\u0006*\u00020\u0006J\f\u0010\u001d\u001a\u00020\u0006*\u00020\u0006H\u0007J\n\u0010\u001e\u001a\u00020\u0006*\u00020\u0006R \u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lutils/ArtifactFileUtils;", "", "()V", "conversion", "", "Lkotlin/Pair;", "", "ensureFolderExists", "", "dirString", "getBasenameOnly", "fileName", "getCertoraDir", "getFilesWithExtension", "path", "ext", "getNameFromPath", "name", "getResultFile", "getWriterForFile", "Ljava/io/FileWriter;", "overwrite", "", "append", "hasCertoraDir", "isSol", "isTAC", "asUnixPath", "kotlin.jvm.PlatformType", "normalizeEncodedStringToStringWithABIChars", "normalizeStringWithABICharsToEncodedFilename", "GeneralUtils"})
public final class ArtifactFileUtils {
    @NotNull
    public static final ArtifactFileUtils INSTANCE = new ArtifactFileUtils();
    @NotNull
    private static final List<Pair<String, String>> conversion;

    private ArtifactFileUtils() {
    }

    public final String asUnixPath(@NotNull String $this$asUnixPath) {
        Intrinsics.checkNotNullParameter($this$asUnixPath, "<this>");
        return FilenameUtils.separatorsToUnix($this$asUnixPath);
    }

    public final boolean hasCertoraDir() {
        return System.getenv().containsKey("CERTORA");
    }

    @NotNull
    public final String getCertoraDir() {
        String string2 = System.getenv("CERTORA");
        Intrinsics.checkNotNullExpressionValue(string2, "getenv(\"CERTORA\")");
        return string2;
    }

    @NotNull
    public final String getNameFromPath(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        String string2 = FileUtils.filename(name);
        Intrinsics.checkNotNullExpressionValue(string2, "filename(name)");
        return string2;
    }

    @NotNull
    public final String getResultFile() {
        return "Results.txt";
    }

    public final void ensureFolderExists(@NotNull String dirString) {
        boolean success;
        Intrinsics.checkNotNullParameter(dirString, "dirString");
        File dir = new File(dirString);
        if (!(dir.exists() || (success = dir.mkdirs()) || dir.exists())) {
            throw new Exception(Intrinsics.stringPlus("Failed to create directory ", dirString));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getFilesWithExtension(@NotNull String path, @NotNull String ext) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(ext, "ext");
        String[] lsResult = new File(path).list();
        Intrinsics.checkNotNullExpressionValue(lsResult, "lsResult");
        String[] $this$filter$iv = lsResult;
        boolean $i$f$filter = false;
        String[] stringArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var10_9 = $this$filterTo$iv$iv;
        int n = ((void)var10_9).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void fileName = element$iv$iv = var10_9[i];
            boolean bl = false;
            if (!ext.equals(FileUtils.extension((String)fileName))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List relevantResults = (List)destination$iv$iv;
        ArtifactFileUtilsKt.access$getLogger$p().info("For path " + path + " ls result is " + ArraysKt.asList(lsResult) + " and files matching extension " + ext + " are " + relevantResults);
        return relevantResults;
    }

    public final boolean isTAC(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        String string2 = FileUtils.extension(fileName);
        Intrinsics.checkNotNullExpressionValue(string2, "extension(fileName)");
        boolean bl = false;
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.String).toLowerCase()");
        return Intrinsics.areEqual(string3, "tac");
    }

    public final boolean isSol(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        String string2 = FileUtils.extension(fileName);
        Intrinsics.checkNotNullExpressionValue(string2, "extension(fileName)");
        boolean bl = false;
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.String).toLowerCase()");
        return Intrinsics.areEqual(string3, "sol");
    }

    @NotNull
    public final String getBasenameOnly(@NotNull String fileName) {
        String string2;
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        String separators = "/|\\\\";
        CharSequence charSequence = fileName;
        Regex regex = new Regex(separators);
        int n = 0;
        boolean bl = false;
        charSequence = CollectionsKt.last(regex.split(charSequence, n));
        boolean bl2 = false;
        n = 0;
        String filename = (String)charSequence;
        boolean bl3 = false;
        String basename = FileUtils.basename(filename);
        Intrinsics.checkNotNullExpressionValue(basename, "basename");
        if (StringsKt.last(basename) == '.') {
            String string3 = basename;
            int n2 = 0;
            int n3 = basename.length() - 1;
            boolean bl4 = false;
            String string4 = string3.substring(n2, n3);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string2 = basename;
        }
        String string5 = string2;
        Intrinsics.checkNotNullExpressionValue(string5, "fileName.split(Regex(sep\u2026          }\n            }");
        return string5;
    }

    @NotNull
    public final FileWriter getWriterForFile(@NotNull String fileName, boolean overwrite, boolean append) {
        String string2;
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        if (new File(fileName).exists() && !overwrite) {
            String string3 = FileUtils.dirname(fileName);
            boolean bl = false;
            boolean bl2 = false;
            String dir = string3;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue(dir, "dir");
            CharSequence charSequence = dir;
            boolean bl4 = false;
            String currentDir = !StringsKt.isBlank(charSequence) ? Intrinsics.stringPlus(dir, File.separator) : "";
            StringBuilder stringBuilder = new StringBuilder().append(currentDir).append(this.getBasenameOnly(fileName)).append('_');
            string3 = LocalDateTime.now().toString();
            Intrinsics.checkNotNullExpressionValue(string3, "now().toString()");
            string2 = stringBuilder.append(StringsKt.replace$default(string3, ':', '-', false, 4, null)).append('.').append((Object)FileUtils.extension(fileName)).toString();
        } else {
            string2 = fileName;
        }
        String finalFileName = string2;
        return new FileWriter(finalFileName, append);
    }

    public static /* synthetic */ FileWriter getWriterForFile$default(ArtifactFileUtils artifactFileUtils, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return artifactFileUtils.getWriterForFile(string2, bl, bl2);
    }

    @NotNull
    public final String normalizeStringWithABICharsToEncodedFilename(@NotNull String $this$normalizeStringWithABICharsToEncodedFilename) {
        Intrinsics.checkNotNullParameter($this$normalizeStringWithABICharsToEncodedFilename, "<this>");
        String filename = $this$normalizeStringWithABICharsToEncodedFilename;
        for (Pair<String, String> p : conversion) {
            filename = StringsKt.replace$default(filename, p.getFirst(), p.getSecond(), false, 4, null);
        }
        if (filename.length() > 165) {
            String string2 = filename;
            int n = 0;
            int n2 = 165;
            boolean bl = false;
            Object object = string2;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = ((String)object).substring(n, n2);
            Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            filename = string3;
        }
        return filename;
    }

    @Deprecated(message="Never use this function. DO NOT reintroduce any translation back to strings with ABI chars", level=DeprecationLevel.ERROR)
    @NotNull
    public final String normalizeEncodedStringToStringWithABIChars(@NotNull String $this$normalizeEncodedStringToStringWithABIChars) {
        Intrinsics.checkNotNullParameter($this$normalizeEncodedStringToStringWithABIChars, "<this>");
        String filename = $this$normalizeEncodedStringToStringWithABIChars;
        for (Pair<String, String> p : conversion) {
            filename = StringsKt.replace$default(filename, p.getSecond(), p.getFirst(), false, 4, null);
        }
        return filename;
    }

    static {
        Pair[] pairArray = new Pair[]{new Pair<String, String>("(", "LP"), new Pair<String, String>(")", "RP"), new Pair<String, String>(",", "C"), new Pair<String, String>("[", "LB"), new Pair<String, String>("]", "RB"), new Pair<String, String>("[]", "LBRB"), new Pair<String, String>("uint256", "U256"), new Pair<String, String>("address", "ADR"), new Pair<String, String>("bytes32", "B32")};
        conversion = CollectionsKt.listOf(pairArray);
    }
}

