/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spec.cvlast.CVLExpTag;
import spec.cvlast.CVLLocation;
import spec.cvlast.CVLScope;
import spec.cvlast.CVLType;
import utils.CertoraInternalErrorType;
import utils.CertoraInternalException;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000f"}, d2={"Lspec/cvlast/HasCvlExpTag;", "", "tag", "Lspec/cvlast/CVLExpTag;", "getTag", "()Lspec/cvlast/CVLExpTag;", "getCVLType", "Lspec/cvlast/CVLType;", "getLocOrEmpty", "Lspec/cvlast/CVLLocation;", "getScope", "Lspec/cvlast/CVLScope;", "getScopeOrNull", "hasCVLType", "", "Shared"})
public interface HasCvlExpTag {
    @NotNull
    public CVLExpTag getTag();

    public boolean hasCVLType();

    @NotNull
    public CVLType getCVLType();

    @NotNull
    public CVLScope getScope();

    @Nullable
    public CVLScope getScopeOrNull();

    @NotNull
    public CVLLocation getLocOrEmpty();

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static boolean hasCVLType(@NotNull HasCvlExpTag this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return this_.getTag().hasCVLType();
        }

        @NotNull
        public static CVLType getCVLType(@NotNull HasCvlExpTag this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            if (!this_.getTag().hasCVLType()) {
                throw new IllegalStateException(Intrinsics.stringPlus("no type present for ", this_));
            }
            CVLType cVLType = this_.getTag().getCVLType();
            Intrinsics.checkNotNull(cVLType);
            return cVLType;
        }

        @NotNull
        public static CVLScope getScope(@NotNull HasCvlExpTag this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            CVLScope cVLScope = this_.getTag().getScope();
            if (cVLScope == null) {
                throw new CertoraInternalException(CertoraInternalErrorType.CVL_AST, Intrinsics.stringPlus("no scope present for ", this_), null, 4, null);
            }
            return cVLScope;
        }

        @Nullable
        public static CVLScope getScopeOrNull(@NotNull HasCvlExpTag this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return this_.getTag().getScope();
        }

        @NotNull
        public static CVLLocation getLocOrEmpty(@NotNull HasCvlExpTag this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            CVLLocation cVLLocation = this_.getTag().getLoc();
            return cVLLocation == null ? (CVLLocation)new CVLLocation.Empty(null, 1, null) : cVLLocation;
        }
    }
}

