/*
 * Decompiled with CFR 0.152.
 */
package solver;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import solver.SolverConfig;
import solver.SolverInfo;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J5\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0015H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lsolver/YicesSolverInfo;", "Lsolver/SolverInfo;", "()V", "DEFAULT_YICES_COMMAND", "", "defaultCommand", "getDefaultCommand", "()Ljava/lang/String;", "commandForStdInMode", "", "customSolverExecutable", "timeout", "Ljava/time/Duration;", "incrementalMode", "", "getDefaultConfigs", "", "Lsolver/SolverConfig;", "memlimitBytes", "", "logicFeatures", "Lsolver/SolverConfig$LogicFeatures;", "(Ljava/time/Duration;Ljava/lang/Long;ZLsolver/SolverConfig$LogicFeatures;)Ljava/util/Set;", "getProcessTimeoutString", "getQueryTimeoutString", "supportsLogicFeatures", "features", "GeneralUtils"})
public final class YicesSolverInfo
extends SolverInfo {
    @NotNull
    public static final YicesSolverInfo INSTANCE = new YicesSolverInfo();
    @NotNull
    private static final String DEFAULT_YICES_COMMAND = "yices-smt2";

    private YicesSolverInfo() {
        super("Yices");
    }

    @Override
    @NotNull
    public List<String> getProcessTimeoutString(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        return CollectionsKt.listOf(Intrinsics.stringPlus("--timeout=", timeout.toSeconds()));
    }

    @Override
    @NotNull
    public List<String> getQueryTimeoutString(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        return CollectionsKt.listOf(Intrinsics.stringPlus("--timeout=", timeout.toSeconds()));
    }

    @Override
    @NotNull
    public List<String> commandForStdInMode(@Nullable String customSolverExecutable, @Nullable Duration timeout, boolean incrementalMode) {
        List<String> list2;
        List<String> list3;
        String string2 = customSolverExecutable;
        String[] stringArray = new String[]{string2 == null ? DEFAULT_YICES_COMMAND : string2, "--interactive"};
        Collection collection = CollectionsKt.listOf(stringArray);
        if (incrementalMode) {
            list3 = CollectionsKt.listOf("--incremental");
        } else {
            boolean bl = false;
            list3 = CollectionsKt.emptyList();
        }
        Collection collection2 = CollectionsKt.plus(collection, (Iterable)list3);
        if (timeout != null) {
            list2 = this.getQueryTimeoutString(timeout);
        } else {
            boolean bl = false;
            list2 = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus(collection2, (Iterable)list2);
    }

    @Override
    @NotNull
    public String getDefaultCommand() {
        return DEFAULT_YICES_COMMAND;
    }

    @Override
    @NotNull
    public Set<SolverConfig> getDefaultConfigs(@NotNull Duration timeout, @Nullable Long memlimitBytes, boolean incrementalMode, @NotNull SolverConfig.LogicFeatures logicFeatures) {
        SolverConfig solverConfig;
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        Intrinsics.checkNotNullParameter(logicFeatures, "logicFeatures");
        if (!logicFeatures.getUsesDatatypes()) {
            boolean bl = false;
            solverConfig = new SolverConfig(INSTANCE, timeout, memlimitBytes, incrementalMode, CollectionsKt.emptyList(), null, null, 96, null);
        } else {
            solverConfig = null;
        }
        return SetsKt.setOfNotNull(solverConfig);
    }

    @Override
    public boolean supportsLogicFeatures(@NotNull SolverConfig.LogicFeatures features) {
        Intrinsics.checkNotNullParameter(features, "features");
        return !features.getUsesDatatypes();
    }
}

