/*
 * Decompiled with CFR 0.152.
 */
package solver;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import solver.SolverConfig;
import solver.SolverInfo;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J+\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0014J5\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J+\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0014J+\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J+\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u0017H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006 "}, d2={"Lsolver/CVC5SolverInfo;", "Lsolver/SolverInfo;", "()V", "DEFAULT_CVC_COMMAND", "", "defaultCommand", "getDefaultCommand", "()Ljava/lang/String;", "commandForStdInMode", "", "customSolverExecutable", "timeout", "Ljava/time/Duration;", "incrementalMode", "", "getBitVectorConfigs", "", "Lsolver/SolverConfig;", "memlimitBytes", "", "(Ljava/time/Duration;Ljava/lang/Long;Z)Ljava/util/Set;", "getDefaultConfigs", "logicFeatures", "Lsolver/SolverConfig$LogicFeatures;", "(Ljava/time/Duration;Ljava/lang/Long;ZLsolver/SolverConfig$LogicFeatures;)Ljava/util/Set;", "getLinearConfigs", "getNonLinearConfigs", "getProcessTimeoutString", "getQuantifierConfigs", "getQueryTimeoutString", "supportsLogicFeatures", "features", "GeneralUtils"})
public final class CVC5SolverInfo
extends SolverInfo {
    @NotNull
    public static final CVC5SolverInfo INSTANCE = new CVC5SolverInfo();
    @NotNull
    private static final String DEFAULT_CVC_COMMAND = "cvc5";

    private CVC5SolverInfo() {
        super("CVC5");
    }

    @Override
    @NotNull
    public List<String> getProcessTimeoutString(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        return CollectionsKt.listOf(Intrinsics.stringPlus("--tlimit=", timeout.toMillis()));
    }

    @Override
    @NotNull
    public List<String> getQueryTimeoutString(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        return CollectionsKt.listOf(Intrinsics.stringPlus("--tlimit-per=", timeout.toMillis()));
    }

    @Override
    public boolean supportsLogicFeatures(@NotNull SolverConfig.LogicFeatures features) {
        Intrinsics.checkNotNullParameter(features, "features");
        return true;
    }

    @Override
    @NotNull
    public List<String> commandForStdInMode(@Nullable String customSolverExecutable, @Nullable Duration timeout, boolean incrementalMode) {
        List<String> list2;
        String string2 = customSolverExecutable;
        String[] stringArray = new String[]{string2 == null ? DEFAULT_CVC_COMMAND : string2, "--lang", "smt2"};
        Collection collection = CollectionsKt.plus((Collection)CollectionsKt.listOf(stringArray), (Iterable)(incrementalMode ? CollectionsKt.listOf("--incremental") : CollectionsKt.listOf("--no-incremental")));
        if (timeout != null) {
            list2 = this.getQueryTimeoutString(timeout);
        } else {
            boolean bl = false;
            list2 = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus(collection, (Iterable)list2);
    }

    @Override
    @NotNull
    public String getDefaultCommand() {
        return DEFAULT_CVC_COMMAND;
    }

    @NotNull
    public final Set<SolverConfig> getQuantifierConfigs(@NotNull Duration timeout, @Nullable Long memlimitBytes, boolean incrementalMode) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        return SetsKt.setOf(new SolverConfig(INSTANCE, timeout, memlimitBytes, incrementalMode, CollectionsKt.listOf("--full-saturate-quant"), null, null, 96, null));
    }

    @NotNull
    public final Set<SolverConfig> getLinearConfigs(@NotNull Duration timeout, @Nullable Long memlimitBytes, boolean incrementalMode) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        String[] stringArray = new String[]{"--decision=justification", "--decision=justification-old"};
        return SetsKt.setOf(new SolverConfig(INSTANCE, timeout, memlimitBytes, incrementalMode, CollectionsKt.listOf(stringArray), null, null, 96, null));
    }

    @NotNull
    public final Set<SolverConfig> getNonLinearConfigs(@NotNull Duration timeout, @Nullable Long memlimitBytes, boolean incrementalMode) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        String[] stringArray = new String[]{"--nl-ext-tplanes", "--decision=justification"};
        return SetsKt.setOf(new SolverConfig(INSTANCE, timeout, memlimitBytes, incrementalMode, CollectionsKt.listOf(stringArray), null, null, 96, null));
    }

    @NotNull
    public final Set<SolverConfig> getBitVectorConfigs(@NotNull Duration timeout, @Nullable Long memlimitBytes, boolean incrementalMode) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        String[] stringArray = new String[]{"--solve-bv-as-int=iand", "--iand-mode=bitwise", "--nl-ext-tplanes"};
        return SetsKt.setOf(new SolverConfig(INSTANCE, timeout, memlimitBytes, incrementalMode, CollectionsKt.listOf(stringArray), null, null, 96, null));
    }

    @Override
    @NotNull
    public Set<SolverConfig> getDefaultConfigs(@NotNull Duration timeout, @Nullable Long memlimitBytes, boolean incrementalMode, @NotNull SolverConfig.LogicFeatures logicFeatures) {
        Set<Object> set;
        Set<Object> set2;
        Set<Object> set3;
        Set<Object> set4;
        boolean bl;
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        Intrinsics.checkNotNullParameter(logicFeatures, "logicFeatures");
        SolverConfig.ArithmeticOperations arithmeticOperations = logicFeatures.getArithmeticOperations();
        if (arithmeticOperations != SolverConfig.ArithmeticOperations.BitVector) {
            bl = false;
            set4 = SetsKt.setOf(new SolverConfig(INSTANCE, timeout, memlimitBytes, incrementalMode, CollectionsKt.emptyList(), null, null, 96, null));
        } else {
            bl = false;
            set4 = SetsKt.emptySet();
        }
        if (arithmeticOperations == SolverConfig.ArithmeticOperations.BitVector) {
            set3 = this.getBitVectorConfigs(timeout, memlimitBytes, incrementalMode);
        } else {
            bl = false;
            set3 = SetsKt.emptySet();
        }
        Set set5 = SetsKt.plus(set4, (Iterable)set3);
        if (arithmeticOperations == SolverConfig.ArithmeticOperations.NonLinear) {
            set2 = this.getNonLinearConfigs(timeout, memlimitBytes, incrementalMode);
        } else {
            bl = false;
            set2 = SetsKt.emptySet();
        }
        Set set6 = SetsKt.plus(set5, (Iterable)set2);
        if (arithmeticOperations == SolverConfig.ArithmeticOperations.LinearOnly) {
            set = this.getLinearConfigs(timeout, memlimitBytes, incrementalMode);
        } else {
            bl = false;
            set = SetsKt.emptySet();
        }
        return SetsKt.plus(set6, (Iterable)set);
    }
}

