/*
 * Decompiled with CFR 0.152.
 */
package solver;

import java.time.Duration;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import solver.CVC5SolverInfo;
import solver.SolverConfig;
import solver.SolverInfo;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J+\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0013J5\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J+\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0013J+\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J+\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u0016H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lsolver/CVC4SolverInfo;", "Lsolver/SolverInfo;", "()V", "defaultCommand", "", "getDefaultCommand", "()Ljava/lang/String;", "commandForStdInMode", "", "customSolverExecutable", "timeout", "Ljava/time/Duration;", "incrementalMode", "", "getBitVectorConfigs", "", "Lsolver/SolverConfig;", "memlimitBytes", "", "(Ljava/time/Duration;Ljava/lang/Long;Z)Ljava/util/Set;", "getDefaultConfigs", "logicFeatures", "Lsolver/SolverConfig$LogicFeatures;", "(Ljava/time/Duration;Ljava/lang/Long;ZLsolver/SolverConfig$LogicFeatures;)Ljava/util/Set;", "getLinearConfigs", "getNonLinearConfigs", "getProcessTimeoutString", "getQuantifierConfigs", "getQueryTimeoutString", "supportsLogicFeatures", "features", "GeneralUtils"})
public final class CVC4SolverInfo
extends SolverInfo {
    @NotNull
    public static final CVC4SolverInfo INSTANCE = new CVC4SolverInfo();

    private CVC4SolverInfo() {
        super("CVC4");
    }

    @Override
    @NotNull
    public String getDefaultCommand() {
        return "cvc4";
    }

    @Override
    @NotNull
    public List<String> getProcessTimeoutString(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        return CVC5SolverInfo.INSTANCE.getProcessTimeoutString(timeout);
    }

    @Override
    @NotNull
    public List<String> getQueryTimeoutString(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        return CVC5SolverInfo.INSTANCE.getQueryTimeoutString(timeout);
    }

    @Override
    public boolean supportsLogicFeatures(@NotNull SolverConfig.LogicFeatures features) {
        Intrinsics.checkNotNullParameter(features, "features");
        return true;
    }

    @Override
    @NotNull
    public List<String> commandForStdInMode(@Nullable String customSolverExecutable, @Nullable Duration timeout, boolean incrementalMode) {
        String string2 = customSolverExecutable;
        return CVC5SolverInfo.INSTANCE.commandForStdInMode(string2 == null ? this.getDefaultCommand() : string2, timeout, incrementalMode);
    }

    @NotNull
    public final Set<SolverConfig> getQuantifierConfigs(@NotNull Duration timeout, @Nullable Long memlimitBytes, boolean incrementalMode) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        return SetsKt.setOf(new SolverConfig(INSTANCE, timeout, memlimitBytes, incrementalMode, CollectionsKt.listOf("--full-saturate-quant"), null, null, 96, null));
    }

    @NotNull
    public final Set<SolverConfig> getNonLinearConfigs(@NotNull Duration timeout, @Nullable Long memlimitBytes, boolean incrementalMode) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        String[] stringArray = new String[]{"--nl-ext-tplanes", "--decision=justification"};
        return SetsKt.setOf(new SolverConfig(INSTANCE, timeout, memlimitBytes, incrementalMode, CollectionsKt.listOf(stringArray), null, null, 96, null));
    }

    @NotNull
    public final Set<SolverConfig> getLinearConfigs(@NotNull Duration timeout, @Nullable Long memlimitBytes, boolean incrementalMode) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        return SetsKt.setOf(new SolverConfig(INSTANCE, timeout, memlimitBytes, incrementalMode, CollectionsKt.listOf("--decision=justification"), null, null, 96, null));
    }

    @NotNull
    public final Set<SolverConfig> getBitVectorConfigs(@NotNull Duration timeout, @Nullable Long memlimitBytes, boolean incrementalMode) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        boolean bl = false;
        return SetsKt.emptySet();
    }

    @Override
    @NotNull
    public Set<SolverConfig> getDefaultConfigs(@NotNull Duration timeout, @Nullable Long memlimitBytes, boolean incrementalMode, @NotNull SolverConfig.LogicFeatures logicFeatures) {
        Set<Object> set;
        Set<Object> set2;
        Set<Object> set3;
        Set<Object> set4;
        boolean bl;
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        Intrinsics.checkNotNullParameter(logicFeatures, "logicFeatures");
        SolverConfig.ArithmeticOperations arithmeticOperations = logicFeatures.getArithmeticOperations();
        if (arithmeticOperations != SolverConfig.ArithmeticOperations.BitVector) {
            bl = false;
            set4 = SetsKt.setOf(new SolverConfig(INSTANCE, timeout, memlimitBytes, incrementalMode, CollectionsKt.emptyList(), null, null, 96, null));
        } else {
            bl = false;
            set4 = SetsKt.emptySet();
        }
        if (arithmeticOperations == SolverConfig.ArithmeticOperations.BitVector) {
            set3 = this.getBitVectorConfigs(timeout, memlimitBytes, incrementalMode);
        } else {
            bl = false;
            set3 = SetsKt.emptySet();
        }
        Set set5 = SetsKt.plus(set4, (Iterable)set3);
        if (arithmeticOperations == SolverConfig.ArithmeticOperations.NonLinear) {
            set2 = this.getNonLinearConfigs(timeout, memlimitBytes, incrementalMode);
        } else {
            bl = false;
            set2 = SetsKt.emptySet();
        }
        Set set6 = SetsKt.plus(set5, (Iterable)set2);
        if (arithmeticOperations == SolverConfig.ArithmeticOperations.LinearOnly) {
            set = this.getLinearConfigs(timeout, memlimitBytes, incrementalMode);
        } else {
            bl = false;
            set = SetsKt.emptySet();
        }
        return SetsKt.plus(set6, (Iterable)set);
    }
}

