/*
 * Decompiled with CFR 0.152.
 */
package scene;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import log.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import scene.ContractUniverse;
import scene.IContractClass;
import scene.IScene;
import scene.ITACMethod;
import scene.MethodAttribute;
import spec.cvlast.SolidityContract;
import tac.ICoreTACProgram;
import tac.IStorageInfo;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\bf\u0018\u00002\u00020\u0001:\u0001=J\u0010\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003H&J\u0014\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000bH&J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH&J\u0016\u0010\u000e\u001a\u0004\u0018\u00010\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000bH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012H&J;\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\u00140\u00162\u0006\u0010\u0017\u001a\u0002H\u0014H\u0016\u00a2\u0006\u0002\u0010\u0018J7\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\u00140\u00162\u0006\u0010\u0017\u001a\u0002H\u0014H\u0016\u00a2\u0006\u0002\u0010\u0019JC\u0010\u001a\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\n\u0010\u001b\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\u001c\u001a\u00020\r2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u0002H\u00140\u00162\u0006\u0010\u0017\u001a\u0002H\u0014H\u0016\u00a2\u0006\u0002\u0010\u001eJ?\u0010\u001a\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\r2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u0002H\u00140\u00162\u0006\u0010\u0017\u001a\u0002H\u0014H\u0016\u00a2\u0006\u0002\u0010 J\u001c\u0010!\u001a\u00020\u001d2\n\u0010\u001b\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\u001c\u001a\u00020\rH\u0016J\u001c\u0010!\u001a\u00020\u001d2\n\u0010\u001b\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010!\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\rH\u0016J\u0018\u0010!\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#H\u0016J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010\u001c\u001a\u00020\rH\u0016J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00122\u0006\u0010\u001c\u001a\u00020\rH&J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\b0\u0012H&J\u0018\u0010'\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020)0(j\u0002`*H&J\u001c\u0010+\u001a\u00020,2\n\u0010\u001b\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\u001c\u001a\u00020\rH&J\u0018\u0010+\u001a\u00020,2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\rH&J*\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0018\u00101\u001a\u0014\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020302H&J*\u00104\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0018\u00101\u001a\u0014\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020.02H&J*\u00105\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0018\u00101\u001a\u0014\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020.02H&J$\u00106\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020.0\u0016H&JP\u00107\u001a\u0002H8\"\u0004\b\u0000\u0010\u0014\"\u0004\b\u0001\u001082\u0006\u00109\u001a\u0002H\u00142\u0014\u0010:\u001a\u0010\u0012\u0004\u0012\u0002H\u0014\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00162\u0006\u0010;\u001a\u0002002\u0014\u0010<\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u0001H80\u0016H\u0002R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006>"}, d2={"Lscene/IScene;", "", "forkInfo", "Lscene/IScene$ForkInfo;", "getForkInfo", "()Lscene/IScene$ForkInfo;", "fork", "getContract", "Lscene/IContractClass;", "s", "Lspec/cvlast/SolidityContract$Named;", "Lbridge/NamedContractIdentifier;", "a", "Ljava/math/BigInteger;", "getContractOrNull", "getContractUniverse", "Lscene/ContractUniverse;", "getContracts", "", "getFromContractOr", "T", "f", "Lkotlin/Function1;", "default", "(Lspec/cvlast/SolidityContract$Named;Lkotlin/jvm/functions/Function1;Ljava/lang/Object;)Ljava/lang/Object;", "(Ljava/math/BigInteger;Lkotlin/jvm/functions/Function1;Ljava/lang/Object;)Ljava/lang/Object;", "getFromMethodOr", "contractName", "sigHash", "Lscene/ITACMethod;", "(Lspec/cvlast/SolidityContract$Named;Ljava/math/BigInteger;Lkotlin/jvm/functions/Function1;Ljava/lang/Object;)Ljava/lang/Object;", "contractAddress", "(Ljava/math/BigInteger;Ljava/math/BigInteger;Lkotlin/jvm/functions/Function1;Ljava/lang/Object;)Ljava/lang/Object;", "getMethod", "methodAttribute", "Lscene/MethodAttribute$Unique;", "getMethodImplementors", "getMethods", "getPrecompiledContracts", "getStorageUniverse", "", "Ltac/IStorageInfo;", "Ltac/StorageUniverse;", "hasMethod", "", "mapContractMethods", "", "transformId", "", "p", "Lkotlin/Function2;", "Ltac/ICoreTACProgram;", "mapContractMethodsInPlace", "mapContractsInPlace", "mapScene", "thenGetContractProp", "R", "k", "getter", "msg", "tr", "ForkInfo", "Shared"})
public interface IScene {
    @NotNull
    public ForkInfo getForkInfo();

    @NotNull
    public IContractClass getContract(@NotNull SolidityContract.Named var1);

    @NotNull
    public IContractClass getContract(@NotNull BigInteger var1);

    public <T> T getFromContractOr(@NotNull SolidityContract.Named var1, @NotNull Function1<? super IContractClass, ? extends T> var2, T var3);

    public <T> T getFromContractOr(@NotNull BigInteger var1, @NotNull Function1<? super IContractClass, ? extends T> var2, T var3);

    @Nullable
    public IContractClass getContractOrNull(@NotNull SolidityContract.Named var1);

    @Nullable
    public IContractClass getContractOrNull(@NotNull BigInteger var1);

    @NotNull
    public ITACMethod getMethod(@NotNull BigInteger var1, @NotNull BigInteger var2);

    @NotNull
    public ITACMethod getMethod(@NotNull SolidityContract.Named var1, @NotNull BigInteger var2);

    @NotNull
    public ITACMethod getMethod(@NotNull SolidityContract.Named var1, @NotNull MethodAttribute.Unique var2);

    @NotNull
    public ITACMethod getMethod(@NotNull BigInteger var1, @NotNull MethodAttribute.Unique var2);

    public <T> T getFromMethodOr(@NotNull SolidityContract.Named var1, @NotNull BigInteger var2, @NotNull Function1<? super ITACMethod, ? extends T> var3, T var4);

    public <T> T getFromMethodOr(@NotNull BigInteger var1, @NotNull BigInteger var2, @NotNull Function1<? super ITACMethod, ? extends T> var3, T var4);

    @NotNull
    public List<ITACMethod> getMethods(@NotNull BigInteger var1);

    @NotNull
    public List<IContractClass> getMethodImplementors(@NotNull BigInteger var1);

    public boolean hasMethod(@NotNull BigInteger var1, @NotNull BigInteger var2);

    public boolean hasMethod(@NotNull SolidityContract.Named var1, @NotNull BigInteger var2);

    @NotNull
    public Map<BigInteger, IStorageInfo> getStorageUniverse();

    @NotNull
    public List<IContractClass> getContracts();

    public void mapContractMethodsInPlace(@NotNull String var1, @NotNull Function2<? super IScene, ? super ITACMethod, Unit> var2);

    public void mapContractMethods(@NotNull String var1, @NotNull Function2<? super IScene, ? super ITACMethod, ? extends ICoreTACProgram> var2);

    public void mapContractsInPlace(@NotNull String var1, @NotNull Function2<? super IScene, ? super IContractClass, Unit> var2);

    public void mapScene(@NotNull String var1, @NotNull Function1<? super IScene, Unit> var2);

    @NotNull
    public IScene fork(@NotNull ForkInfo var1);

    @NotNull
    public ContractUniverse getContractUniverse();

    @NotNull
    public List<IContractClass> getPrecompiledContracts();

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lscene/IScene$ForkInfo;", "", "stringer", "", "(Ljava/lang/String;ILjava/lang/String;)V", "toString", "BASE", "ASSERTION", "CVL", "Shared"})
    public static final class ForkInfo
    extends Enum<ForkInfo> {
        @NotNull
        private final String stringer;
        public static final /* enum */ ForkInfo BASE = new ForkInfo("base_scene");
        public static final /* enum */ ForkInfo ASSERTION = new ForkInfo("assertions_scene");
        public static final /* enum */ ForkInfo CVL = new ForkInfo("CVL_scene");
        private static final /* synthetic */ ForkInfo[] $VALUES;

        private ForkInfo(String stringer) {
            this.stringer = stringer;
        }

        @NotNull
        public String toString() {
            return this.stringer;
        }

        public static ForkInfo[] values() {
            return (ForkInfo[])$VALUES.clone();
        }

        public static ForkInfo valueOf(String value) {
            return Enum.valueOf(ForkInfo.class, value);
        }

        static {
            $VALUES = forkInfoArray = new ForkInfo[]{ForkInfo.BASE, ForkInfo.ASSERTION, ForkInfo.CVL};
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static <T> T getFromContractOr(@NotNull IScene this_, @NotNull SolidityContract.Named s, @NotNull Function1<? super IContractClass, ? extends T> f, T t2) {
            T t3;
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(s, "s");
            Intrinsics.checkNotNullParameter(f, "f");
            try {
                t3 = f.invoke(this_.getContract(s));
            }
            catch (Exception e) {
                Logger.Companion.alwaysWarn(Intrinsics.stringPlus("Failed to get contract ", s), e);
                t3 = t2;
            }
            return t3;
        }

        public static <T> T getFromContractOr(@NotNull IScene this_, @NotNull BigInteger a, @NotNull Function1<? super IContractClass, ? extends T> f, T t2) {
            T t3;
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(f, "f");
            try {
                t3 = f.invoke(this_.getContract(a));
            }
            catch (Exception e) {
                Logger.Companion.alwaysWarn(Intrinsics.stringPlus("Failed to get contract ", a), e);
                t3 = t2;
            }
            return t3;
        }

        @Nullable
        public static IContractClass getContractOrNull(@NotNull IScene this_, @NotNull SolidityContract.Named s) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(s, "s");
            return this_.getFromContractOr(s, (Function1)getContractOrNull.1.INSTANCE, null);
        }

        @Nullable
        public static IContractClass getContractOrNull(@NotNull IScene this_, @NotNull BigInteger a) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(a, "a");
            return this_.getFromContractOr(a, (Function1)getContractOrNull.2.INSTANCE, null);
        }

        @NotNull
        public static ITACMethod getMethod(@NotNull IScene this_, @NotNull BigInteger contractAddress, @NotNull BigInteger sigHash) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(contractAddress, "contractAddress");
            Intrinsics.checkNotNullParameter(sigHash, "sigHash");
            return (ITACMethod)DefaultImpls.thenGetContractProp(this_, contractAddress, (Function1)new Function1<BigInteger, IContractClass>((Object)this_){

                @Nullable
                public final IContractClass invoke(@NotNull BigInteger p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return ((IScene)this.receiver).getContractOrNull(p0);
                }
            }, Intrinsics.stringPlus("No method with hash ", sigHash.toString(16)), (Function1)new Function1<IContractClass, ITACMethod>(sigHash){
                final /* synthetic */ BigInteger $sigHash;
                {
                    this.$sigHash = $sigHash;
                    super(1);
                }

                @Nullable
                public final ITACMethod invoke(@NotNull IContractClass it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return it.getMethodBySigHash(this.$sigHash);
                }
            });
        }

        @NotNull
        public static ITACMethod getMethod(@NotNull IScene this_, @NotNull SolidityContract.Named contractName, @NotNull BigInteger sigHash) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(contractName, "contractName");
            Intrinsics.checkNotNullParameter(sigHash, "sigHash");
            return (ITACMethod)DefaultImpls.thenGetContractProp(this_, contractName, (Function1)new Function1<SolidityContract.Named, IContractClass>((Object)this_){

                @Nullable
                public final IContractClass invoke(@NotNull SolidityContract.Named p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return ((IScene)this.receiver).getContractOrNull(p0);
                }
            }, Intrinsics.stringPlus("No method with hash ", sigHash), (Function1)new Function1<IContractClass, ITACMethod>(sigHash){
                final /* synthetic */ BigInteger $sigHash;
                {
                    this.$sigHash = $sigHash;
                    super(1);
                }

                @Nullable
                public final ITACMethod invoke(@NotNull IContractClass it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return it.getMethodBySigHash(this.$sigHash);
                }
            });
        }

        @NotNull
        public static ITACMethod getMethod(@NotNull IScene this_, @NotNull SolidityContract.Named contractName, @NotNull MethodAttribute.Unique methodAttribute) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(contractName, "contractName");
            Intrinsics.checkNotNullParameter(methodAttribute, "methodAttribute");
            return (ITACMethod)DefaultImpls.thenGetContractProp(this_, contractName, (Function1)new Function1<SolidityContract.Named, IContractClass>((Object)this_){

                @Nullable
                public final IContractClass invoke(@NotNull SolidityContract.Named p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return ((IScene)this.receiver).getContractOrNull(p0);
                }
            }, Intrinsics.stringPlus("No method with attribute ", methodAttribute), (Function1)new Function1<IContractClass, ITACMethod>(methodAttribute){
                final /* synthetic */ MethodAttribute.Unique $methodAttribute;
                {
                    this.$methodAttribute = $methodAttribute;
                    super(1);
                }

                @Nullable
                public final ITACMethod invoke(@NotNull IContractClass it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return it.getMethodByUniqueAttribute(this.$methodAttribute);
                }
            });
        }

        @NotNull
        public static ITACMethod getMethod(@NotNull IScene this_, @NotNull BigInteger contractAddress, @NotNull MethodAttribute.Unique methodAttribute) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(contractAddress, "contractAddress");
            Intrinsics.checkNotNullParameter(methodAttribute, "methodAttribute");
            return (ITACMethod)DefaultImpls.thenGetContractProp(this_, contractAddress, (Function1)new Function1<BigInteger, IContractClass>((Object)this_){

                @Nullable
                public final IContractClass invoke(@NotNull BigInteger p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return ((IScene)this.receiver).getContractOrNull(p0);
                }
            }, Intrinsics.stringPlus("No method with attribute ", methodAttribute), (Function1)new Function1<IContractClass, ITACMethod>(methodAttribute){
                final /* synthetic */ MethodAttribute.Unique $methodAttribute;
                {
                    this.$methodAttribute = $methodAttribute;
                    super(1);
                }

                @Nullable
                public final ITACMethod invoke(@NotNull IContractClass it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return it.getMethodByUniqueAttribute(this.$methodAttribute);
                }
            });
        }

        private static <T, R> R thenGetContractProp(IScene this_, T k, Function1<? super T, ? extends IContractClass> getter, String msg, Function1<? super IContractClass, ? extends R> tr) {
            IContractClass iContractClass = getter.invoke(k);
            if (iContractClass == null) {
                String string2 = "No contract " + k + " in scene";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            IContractClass contr = iContractClass;
            if ((iContractClass = tr.invoke(contr)) == null) {
                String string3 = msg + " in contract " + contr.getName() + " in scene";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string3.toString());
            }
            return (R)iContractClass;
        }

        public static <T> T getFromMethodOr(@NotNull IScene this_, @NotNull SolidityContract.Named contractName, @NotNull BigInteger sigHash, @NotNull Function1<? super ITACMethod, ? extends T> f, T t2) {
            T t3;
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(contractName, "contractName");
            Intrinsics.checkNotNullParameter(sigHash, "sigHash");
            Intrinsics.checkNotNullParameter(f, "f");
            IContractClass iContractClass = this_.getContractOrNull(contractName);
            if (iContractClass == null) {
                t3 = t2;
            } else {
                ITACMethod iTACMethod = iContractClass.getMethodBySigHash(sigHash);
                if (iTACMethod == null) {
                    t3 = t2;
                } else {
                    ITACMethod iTACMethod2 = iTACMethod;
                    boolean bl = false;
                    boolean bl2 = false;
                    ITACMethod it = iTACMethod2;
                    boolean bl3 = false;
                    T t4 = f.invoke(it);
                    t3 = t4 == null ? t2 : t4;
                }
            }
            return t3;
        }

        public static <T> T getFromMethodOr(@NotNull IScene this_, @NotNull BigInteger contractAddress, @NotNull BigInteger sigHash, @NotNull Function1<? super ITACMethod, ? extends T> f, T t2) {
            T t3;
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(contractAddress, "contractAddress");
            Intrinsics.checkNotNullParameter(sigHash, "sigHash");
            Intrinsics.checkNotNullParameter(f, "f");
            IContractClass iContractClass = this_.getContractOrNull(contractAddress);
            if (iContractClass == null) {
                t3 = t2;
            } else {
                ITACMethod iTACMethod = iContractClass.getMethodBySigHash(sigHash);
                if (iTACMethod == null) {
                    t3 = t2;
                } else {
                    ITACMethod iTACMethod2 = iTACMethod;
                    boolean bl = false;
                    boolean bl2 = false;
                    ITACMethod it = iTACMethod2;
                    boolean bl3 = false;
                    T t4 = f.invoke(it);
                    t3 = t4 == null ? t2 : t4;
                }
            }
            return t3;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static List<IContractClass> getMethodImplementors(@NotNull IScene this_, @NotNull BigInteger sigHash) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(sigHash, "sigHash");
            Iterable $this$map$iv = this_.getMethods(sigHash);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ITACMethod iTACMethod = (ITACMethod)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                IContractClass iContractClass = it.getContainingContract();
                collection.add(iContractClass);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public static ContractUniverse getContractUniverse(@NotNull IScene this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return ContractUniverse.ETHEREUM;
        }
    }
}

