/*
 * Decompiled with CFR 0.152.
 */
package parallel;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import parallel.FinishingRaceJob;
import parallel.Parallel;
import parallel.ParallelKt;
import parallel.RaceFinish;
import parallel.RacerResult;
import parallel.Sem;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u00050\u00030\u0002B)\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u00070\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\b\u0010*\u001a\u00020+H\u0016J\u001b\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00028\u0000\u00a2\u0006\u0002\u0010/J\u0012\u00100\u001a\u00020'2\n\u00101\u001a\u00060\u0012j\u0002`\u0013J\u001b\u00102\u001a\u00020'2\u0006\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00028\u0000\u00a2\u0006\u0002\u0010/J\u000e\u00103\u001a\u00020'2\u0006\u0010-\u001a\u00020\u0004J\u000e\u00104\u001a\u00020'2\u0006\u0010-\u001a\u00020\u0004J\u001a\u00105\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00052\u0006\u00106\u001a\u000207H\u0016R\u001e\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00100\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\n\u0018\u00010\u0012j\u0004\u0018\u0001`\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u001b\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u00050\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u00068"}, d2={"Lparallel/FilteringFanOut;", "T", "Lparallel/Parallel;", "Lkotlin/Pair;", "", "", "thunks", "Lkotlin/Function0;", "Lparallel/RaceFinish;", "timeout", "Ljava/time/Duration;", "(Ljava/util/List;Ljava/time/Duration;)V", "deps", "getDeps", "()Ljava/util/List;", "deps_", "Lparallel/FinishingRaceJob;", "exceptionThrown", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getExceptionThrown", "()Ljava/lang/Exception;", "setExceptionThrown", "(Ljava/lang/Exception;)V", "lock", "Lparallel/Sem;", "numJobs", "result", "getResult", "()Lkotlin/Pair;", "results", "", "Lparallel/RacerResult;", "status", "getStatus", "()I", "setStatus", "(I)V", "dbgPrnt", "", "msg", "", "done", "", "registerDqf", "id", "res", "(ILjava/lang/Object;)V", "registerException", "e", "registerFull", "registerSkipped", "registerTimeoutFinish", "schedule", "ioPool", "Ljava/util/concurrent/ExecutorService;", "GeneralUtils"})
public final class FilteringFanOut<T>
extends Parallel<Pair<? extends Integer, ? extends List<? extends T>>> {
    @NotNull
    private final Sem lock;
    private int status;
    @Nullable
    private Exception exceptionThrown;
    private final int numJobs;
    @NotNull
    private final List<FinishingRaceJob<T>> deps_;
    @NotNull
    private final List<RacerResult<T>> results;

    /*
     * WARNING - void declaration
     */
    public FilteringFanOut(@NotNull List<? extends Function0<? extends RaceFinish<? extends T>>> thunks, @Nullable Duration timeout) {
        FinishingRaceJob finishingRaceJob;
        Collection collection;
        int n;
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter(thunks, "thunks");
        super(null);
        this.lock = new Sem(ParallelKt.access$getSemaphoreId$p().incrementAndGet());
        this.numJobs = thunks.size();
        Iterable iterable = thunks;
        FilteringFanOut filteringFanOut = this;
        boolean $i$f$mapIndexed = false;
        ArrayList arrayList = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void id;
            void thunk;
            n = index$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Function0 function0 = (Function0)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl2 = false;
            finishingRaceJob = new FinishingRaceJob(thunk, (int)(id + true), this, this.lock, timeout);
            collection.add(finishingRaceJob);
        }
        collection = (List)destination$iv$iv;
        filteringFanOut.deps_ = collection;
        int n3 = this.numJobs;
        filteringFanOut = this;
        boolean bl = false;
        arrayList = new ArrayList(n3);
        boolean bl3 = false;
        int n4 = 0;
        n4 = 0;
        int n5 = n3;
        while (n4 < n5) {
            int n6 = n4++;
            boolean bl4 = false;
            n = n6;
            collection = arrayList;
            boolean bl5 = false;
            finishingRaceJob = null;
            ((ArrayList)collection).add(finishingRaceJob);
        }
        collection = arrayList;
        filteringFanOut.results = collection;
    }

    public final int getStatus() {
        return this.status;
    }

    public final void setStatus(int n) {
        this.status = n;
    }

    @Nullable
    public final Exception getExceptionThrown() {
        return this.exceptionThrown;
    }

    public final void setExceptionThrown(@Nullable Exception exception) {
        this.exceptionThrown = exception;
    }

    @Override
    @NotNull
    public List<Parallel<?>> getDeps() {
        return this.deps_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean done() {
        Sem sem = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (sem) {
            boolean bl3 = false;
            bl2 = this.getStatus() != 0;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Pair<Integer, List<T>> getResult() {
        Pair<Integer, List<T>> pair;
        Sem sem = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (sem) {
            Collection<Object> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl3 = false;
            if (this.getExceptionThrown() != null) {
                Exception exception = this.getExceptionThrown();
                Intrinsics.checkNotNull(exception);
                throw exception;
            }
            boolean bl4 = this.getStatus() != 0;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string2 = "status indicates 'still running', but we're already querying the result";
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            Iterable iterable = this.results;
            Integer n = this.getStatus() - 1;
            boolean $i$f$map = false;
            void var7_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RacerResult racerResult = (RacerResult)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl8 = false;
                RacerResult.FromJob fromJob = it instanceof RacerResult.FromJob ? (RacerResult.FromJob)it : null;
                Object e = fromJob == null ? null : (Object)fromJob.getRes();
                collection.add(e);
            }
            collection = (List)destination$iv$iv;
            pair = TuplesKt.to(n, collection);
        }
        return pair;
    }

    public final void registerException(@NotNull Exception e) {
        Intrinsics.checkNotNullParameter(e, "e");
        if (this.exceptionThrown == null) {
            this.exceptionThrown = e;
        }
        this.status = -1;
        this.lock.notifyAll();
    }

    public final void registerSkipped(int id) {
        boolean bl = this.results.get(id - 1) == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Expected that a skipped job will never have started";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        bl = this.status > 0 || this.exceptionThrown != null;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string3 = "Can only skip jobs if we have a known winner (or a job propagated an exception)";
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        this.results.set(id - 1, RacerResult.Skipped.INSTANCE);
    }

    public final void registerTimeoutFinish(int id) {
        boolean bl = this.results.get(id - 1) == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "A timeout can only be triggered inside of a wait loop before a task has completed";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        this.results.set(id - 1, RacerResult.Timeout.INSTANCE);
    }

    public final void registerDqf(int id, T res2) {
        if (this.results.get(id - 1) instanceof RacerResult.Timeout) {
            return;
        }
        boolean bl = this.results.get(id - 1) == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "we already registered a result for id " + id + " (namely \"" + res2 + "\")";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        this.results.set(id - 1, new RacerResult.FromJob<T>(res2));
    }

    public final void registerFull(int id, T res2) {
        if (this.results.get(id - 1) instanceof RacerResult.Timeout) {
            return;
        }
        this.results.set(id - 1, new RacerResult.FromJob<T>(res2));
        boolean bl = this.status != -1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "can't have a winner when status is -1";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        if (this.status == 0) {
            this.status = id;
            this.lock.notifyAll();
        }
    }

    @Override
    @NotNull
    public List<Parallel<?>> schedule(@NotNull ExecutorService ioPool) {
        Intrinsics.checkNotNullParameter(ioPool, "ioPool");
        if (this.status == 0) {
            this.status = -1;
        }
        boolean bl = false;
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dbgPrnt(String msg) {
        Sem sem = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (sem) {
            boolean bl3 = false;
            String string2 = this.lock + " : " + msg + " (#jobs: " + this.numJobs + " status: " + this.getStatus() + "  results: " + this.results + ')';
            boolean bl4 = false;
            System.out.println((Object)string2);
            Unit unit = Unit.INSTANCE;
        }
    }
}

